/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.app.IActivityClientController;
import android.app.IRequestFinishCallback;
import android.app.PictureInPictureParams;
import android.content.ComponentName;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Singleton;
import android.view.RemoteAnimationDefinition;
import android.window.SizeConfigurationBuckets;
import com.android.internal.policy.IKeyguardDismissCallback;

public class ActivityClient {
    private static final Singleton<ActivityClient> sInstance = new Singleton<ActivityClient>(){

        @Override
        protected ActivityClient create() {
            return new ActivityClient();
        }
    };
    private static final ActivityClientControllerSingleton INTERFACE_SINGLETON = new ActivityClientControllerSingleton();

    private ActivityClient() {
    }

    public void activityIdle(IBinder token, Configuration config, boolean stopProfiling) {
        try {
            ActivityClient.getActivityClientController().activityIdle(token, config, stopProfiling);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityResumed(IBinder token, boolean handleSplashScreenExit) {
        try {
            ActivityClient.getActivityClientController().activityResumed(token, handleSplashScreenExit);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityTopResumedStateLost() {
        try {
            ActivityClient.getActivityClientController().activityTopResumedStateLost();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityPaused(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityPaused(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityStopped(IBinder token, Bundle state, PersistableBundle persistentState, CharSequence description) {
        try {
            ActivityClient.getActivityClientController().activityStopped(token, state, persistentState, description);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityDestroyed(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityDestroyed(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void activityRelaunched(IBinder token) {
        try {
            ActivityClient.getActivityClientController().activityRelaunched(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void reportSizeConfigurations(IBinder token, SizeConfigurationBuckets sizeConfigurations) {
        try {
            ActivityClient.getActivityClientController().reportSizeConfigurations(token, sizeConfigurations);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) {
        try {
            return ActivityClient.getActivityClientController().moveActivityTaskToBack(token, nonRoot);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean shouldUpRecreateTask(IBinder token, String destAffinity) {
        try {
            return ActivityClient.getActivityClientController().shouldUpRecreateTask(token, destAffinity);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean navigateUpTo(IBinder token, Intent destIntent, int resultCode, Intent resultData) {
        try {
            return ActivityClient.getActivityClientController().navigateUpTo(token, destIntent, resultCode, resultData);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean releaseActivityInstance(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().releaseActivityInstance(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean finishActivity(IBinder token, int resultCode, Intent resultData, int finishTask) {
        try {
            return ActivityClient.getActivityClientController().finishActivity(token, resultCode, resultData, finishTask);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean finishActivityAffinity(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().finishActivityAffinity(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void finishSubActivity(IBinder token, String resultWho, int requestCode) {
        try {
            ActivityClient.getActivityClientController().finishSubActivity(token, resultWho, requestCode);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public boolean isTopOfTask(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isTopOfTask(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean willActivityBeVisible(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().willActivityBeVisible(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getDisplayId(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getDisplayId(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getTaskForActivity(IBinder token, boolean onlyRoot) {
        try {
            return ActivityClient.getActivityClientController().getTaskForActivity(token, onlyRoot);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    ComponentName getCallingActivity(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getCallingActivity(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    String getCallingPackage(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getCallingPackage(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getLaunchedFromUid(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getLaunchedFromUid(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getLaunchedFromPackage(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getLaunchedFromPackage(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setRequestedOrientation(IBinder token, int requestedOrientation) {
        try {
            ActivityClient.getActivityClientController().setRequestedOrientation(token, requestedOrientation);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    int getRequestedOrientation(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().getRequestedOrientation(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean convertFromTranslucent(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().convertFromTranslucent(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean convertToTranslucent(IBinder token, Bundle options) {
        try {
            return ActivityClient.getActivityClientController().convertToTranslucent(token, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void reportActivityFullyDrawn(IBinder token, boolean restoredFromBundle) {
        try {
            ActivityClient.getActivityClientController().reportActivityFullyDrawn(token, restoredFromBundle);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    boolean isImmersive(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isImmersive(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setImmersive(IBinder token, boolean immersive) {
        try {
            ActivityClient.getActivityClientController().setImmersive(token, immersive);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    boolean enterPictureInPictureMode(IBinder token, PictureInPictureParams params) {
        try {
            return ActivityClient.getActivityClientController().enterPictureInPictureMode(token, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void setPictureInPictureParams(IBinder token, PictureInPictureParams params) {
        try {
            ActivityClient.getActivityClientController().setPictureInPictureParams(token, params);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void toggleFreeformWindowingMode(IBinder token) {
        try {
            ActivityClient.getActivityClientController().toggleFreeformWindowingMode(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void startLockTaskModeByToken(IBinder token) {
        try {
            ActivityClient.getActivityClientController().startLockTaskModeByToken(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void stopLockTaskModeByToken(IBinder token) {
        try {
            ActivityClient.getActivityClientController().stopLockTaskModeByToken(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void showLockTaskEscapeMessage(IBinder token) {
        try {
            ActivityClient.getActivityClientController().showLockTaskEscapeMessage(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setTaskDescription(IBinder token, ActivityManager.TaskDescription td) {
        try {
            ActivityClient.getActivityClientController().setTaskDescription(token, td);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    boolean showAssistFromActivity(IBinder token, Bundle args) {
        try {
            return ActivityClient.getActivityClientController().showAssistFromActivity(token, args);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    boolean isRootVoiceInteraction(IBinder token) {
        try {
            return ActivityClient.getActivityClientController().isRootVoiceInteraction(token);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void startLocalVoiceInteraction(IBinder callingActivity, Bundle options) {
        try {
            ActivityClient.getActivityClientController().startLocalVoiceInteraction(callingActivity, options);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void stopLocalVoiceInteraction(IBinder callingActivity) {
        try {
            ActivityClient.getActivityClientController().stopLocalVoiceInteraction(callingActivity);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setShowWhenLocked(IBinder token, boolean showWhenLocked) {
        try {
            ActivityClient.getActivityClientController().setShowWhenLocked(token, showWhenLocked);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setInheritShowWhenLocked(IBinder token, boolean inheritShowWhenLocked) {
        try {
            ActivityClient.getActivityClientController().setInheritShowWhenLocked(token, inheritShowWhenLocked);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setTurnScreenOn(IBinder token, boolean turnScreenOn) {
        try {
            ActivityClient.getActivityClientController().setTurnScreenOn(token, turnScreenOn);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    int setVrMode(IBinder token, boolean enabled, ComponentName packageName) {
        try {
            return ActivityClient.getActivityClientController().setVrMode(token, enabled, packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim) {
        try {
            ActivityClient.getActivityClientController().overridePendingTransition(token, packageName, enterAnim, exitAnim);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void setDisablePreviewScreenshots(IBinder token, boolean disable) {
        try {
            ActivityClient.getActivityClientController().setDisablePreviewScreenshots(token, disable);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void invalidateHomeTaskSnapshot(IBinder homeToken) {
        try {
            ActivityClient.getActivityClientController().invalidateHomeTaskSnapshot(homeToken);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void dismissKeyguard(IBinder token, IKeyguardDismissCallback callback2, CharSequence message) {
        try {
            ActivityClient.getActivityClientController().dismissKeyguard(token, callback2, message);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void registerRemoteAnimations(IBinder token, RemoteAnimationDefinition definition) {
        try {
            ActivityClient.getActivityClientController().registerRemoteAnimations(token, definition);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void unregisterRemoteAnimations(IBinder token) {
        try {
            ActivityClient.getActivityClientController().unregisterRemoteAnimations(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void onBackPressedOnTaskRoot(IBinder token, IRequestFinishCallback callback2) {
        try {
            ActivityClient.getActivityClientController().onBackPressedOnTaskRoot(token, callback2);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    void reportSplashScreenAttached(IBinder token) {
        try {
            ActivityClient.getActivityClientController().splashScreenAttached(token);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public static ActivityClient getInstance() {
        return sInstance.get();
    }

    public static IActivityClientController setActivityClientController(IActivityClientController activityClientController) {
        ActivityClient.INTERFACE_SINGLETON.mKnownInstance = activityClientController;
        return ActivityClient.INTERFACE_SINGLETON.mKnownInstance;
    }

    private static IActivityClientController getActivityClientController() {
        IActivityClientController controller = ActivityClient.INTERFACE_SINGLETON.mKnownInstance;
        return controller != null ? controller : (IActivityClientController)INTERFACE_SINGLETON.get();
    }

    private static class ActivityClientControllerSingleton
    extends Singleton<IActivityClientController> {
        IActivityClientController mKnownInstance;

        private ActivityClientControllerSingleton() {
        }

        @Override
        protected IActivityClientController create() {
            try {
                return ActivityTaskManager.getService().getActivityClientController();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }
}

