/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.KeyframeSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.compat.annotation.UnsupportedAppUsage;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayoutTransition {
    public static final int CHANGE_APPEARING = 0;
    public static final int CHANGE_DISAPPEARING = 1;
    public static final int APPEARING = 2;
    public static final int DISAPPEARING = 3;
    public static final int CHANGING = 4;
    private static final int FLAG_APPEARING = 1;
    private static final int FLAG_DISAPPEARING = 2;
    private static final int FLAG_CHANGE_APPEARING = 4;
    private static final int FLAG_CHANGE_DISAPPEARING = 8;
    private static final int FLAG_CHANGING = 16;
    private Animator mDisappearingAnim = null;
    private Animator mAppearingAnim = null;
    private Animator mChangingAppearingAnim = null;
    private Animator mChangingDisappearingAnim = null;
    private Animator mChangingAnim = null;
    private static ObjectAnimator defaultChange;
    private static ObjectAnimator defaultChangeIn;
    private static ObjectAnimator defaultChangeOut;
    private static ObjectAnimator defaultFadeIn;
    private static ObjectAnimator defaultFadeOut;
    private static long DEFAULT_DURATION;
    private long mChangingAppearingDuration = DEFAULT_DURATION;
    private long mChangingDisappearingDuration = DEFAULT_DURATION;
    private long mChangingDuration = DEFAULT_DURATION;
    private long mAppearingDuration = DEFAULT_DURATION;
    private long mDisappearingDuration = DEFAULT_DURATION;
    private long mAppearingDelay = DEFAULT_DURATION;
    private long mDisappearingDelay = 0L;
    private long mChangingAppearingDelay = 0L;
    private long mChangingDisappearingDelay = DEFAULT_DURATION;
    private long mChangingDelay = 0L;
    private long mChangingAppearingStagger = 0L;
    private long mChangingDisappearingStagger = 0L;
    private long mChangingStagger = 0L;
    private static TimeInterpolator ACCEL_DECEL_INTERPOLATOR;
    private static TimeInterpolator DECEL_INTERPOLATOR;
    private static TimeInterpolator sAppearingInterpolator;
    private static TimeInterpolator sDisappearingInterpolator;
    private static TimeInterpolator sChangingAppearingInterpolator;
    private static TimeInterpolator sChangingDisappearingInterpolator;
    private static TimeInterpolator sChangingInterpolator;
    private TimeInterpolator mAppearingInterpolator = sAppearingInterpolator;
    private TimeInterpolator mDisappearingInterpolator = sDisappearingInterpolator;
    private TimeInterpolator mChangingAppearingInterpolator = sChangingAppearingInterpolator;
    private TimeInterpolator mChangingDisappearingInterpolator = sChangingDisappearingInterpolator;
    private TimeInterpolator mChangingInterpolator = sChangingInterpolator;
    private final HashMap<View, Animator> pendingAnimations = new HashMap();
    private final LinkedHashMap<View, Animator> currentChangingAnimations = new LinkedHashMap();
    private final LinkedHashMap<View, Animator> currentAppearingAnimations = new LinkedHashMap();
    private final LinkedHashMap<View, Animator> currentDisappearingAnimations = new LinkedHashMap();
    private final HashMap<View, View.OnLayoutChangeListener> layoutChangeListenerMap = new HashMap();
    private long staggerDelay;
    private int mTransitionTypes = 15;
    private ArrayList<TransitionListener> mListeners;
    private boolean mAnimateParentHierarchy = true;

    public LayoutTransition() {
        if (defaultChangeIn == null) {
            PropertyValuesHolder pvhLeft = PropertyValuesHolder.ofInt("left", 0, 1);
            PropertyValuesHolder pvhTop = PropertyValuesHolder.ofInt("top", 0, 1);
            PropertyValuesHolder pvhRight = PropertyValuesHolder.ofInt("right", 0, 1);
            PropertyValuesHolder pvhBottom = PropertyValuesHolder.ofInt("bottom", 0, 1);
            PropertyValuesHolder pvhScrollX = PropertyValuesHolder.ofInt("scrollX", 0, 1);
            PropertyValuesHolder pvhScrollY = PropertyValuesHolder.ofInt("scrollY", 0, 1);
            defaultChangeIn = ObjectAnimator.ofPropertyValuesHolder(null, new PropertyValuesHolder[]{pvhLeft, pvhTop, pvhRight, pvhBottom, pvhScrollX, pvhScrollY});
            defaultChangeIn.setDuration(DEFAULT_DURATION);
            defaultChangeIn.setStartDelay(this.mChangingAppearingDelay);
            defaultChangeIn.setInterpolator(this.mChangingAppearingInterpolator);
            defaultChangeOut = defaultChangeIn.clone();
            defaultChangeOut.setStartDelay(this.mChangingDisappearingDelay);
            defaultChangeOut.setInterpolator(this.mChangingDisappearingInterpolator);
            defaultChange = defaultChangeIn.clone();
            defaultChange.setStartDelay(this.mChangingDelay);
            defaultChange.setInterpolator(this.mChangingInterpolator);
            defaultFadeIn = ObjectAnimator.ofFloat(null, "alpha", 0.0f, 1.0f);
            defaultFadeIn.setDuration(DEFAULT_DURATION);
            defaultFadeIn.setStartDelay(this.mAppearingDelay);
            defaultFadeIn.setInterpolator(this.mAppearingInterpolator);
            defaultFadeOut = ObjectAnimator.ofFloat(null, "alpha", 1.0f, 0.0f);
            defaultFadeOut.setDuration(DEFAULT_DURATION);
            defaultFadeOut.setStartDelay(this.mDisappearingDelay);
            defaultFadeOut.setInterpolator(this.mDisappearingInterpolator);
        }
        this.mChangingAppearingAnim = defaultChangeIn;
        this.mChangingDisappearingAnim = defaultChangeOut;
        this.mChangingAnim = defaultChange;
        this.mAppearingAnim = defaultFadeIn;
        this.mDisappearingAnim = defaultFadeOut;
    }

    public void setDuration(long duration) {
        this.mChangingAppearingDuration = duration;
        this.mChangingDisappearingDuration = duration;
        this.mChangingDuration = duration;
        this.mAppearingDuration = duration;
        this.mDisappearingDuration = duration;
    }

    public void enableTransitionType(int transitionType) {
        switch (transitionType) {
            case 2: {
                this.mTransitionTypes |= 1;
                break;
            }
            case 3: {
                this.mTransitionTypes |= 2;
                break;
            }
            case 0: {
                this.mTransitionTypes |= 4;
                break;
            }
            case 1: {
                this.mTransitionTypes |= 8;
                break;
            }
            case 4: {
                this.mTransitionTypes |= 0x10;
            }
        }
    }

    public void disableTransitionType(int transitionType) {
        switch (transitionType) {
            case 2: {
                this.mTransitionTypes &= 0xFFFFFFFE;
                break;
            }
            case 3: {
                this.mTransitionTypes &= 0xFFFFFFFD;
                break;
            }
            case 0: {
                this.mTransitionTypes &= 0xFFFFFFFB;
                break;
            }
            case 1: {
                this.mTransitionTypes &= 0xFFFFFFF7;
                break;
            }
            case 4: {
                this.mTransitionTypes &= 0xFFFFFFEF;
            }
        }
    }

    public boolean isTransitionTypeEnabled(int transitionType) {
        switch (transitionType) {
            case 2: {
                return (this.mTransitionTypes & 1) == 1;
            }
            case 3: {
                return (this.mTransitionTypes & 2) == 2;
            }
            case 0: {
                return (this.mTransitionTypes & 4) == 4;
            }
            case 1: {
                return (this.mTransitionTypes & 8) == 8;
            }
            case 4: {
                return (this.mTransitionTypes & 0x10) == 16;
            }
        }
        return false;
    }

    public void setStartDelay(int transitionType, long delay) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingDelay = delay;
                break;
            }
            case 1: {
                this.mChangingDisappearingDelay = delay;
                break;
            }
            case 4: {
                this.mChangingDelay = delay;
                break;
            }
            case 2: {
                this.mAppearingDelay = delay;
                break;
            }
            case 3: {
                this.mDisappearingDelay = delay;
            }
        }
    }

    public long getStartDelay(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingDelay;
            }
            case 1: {
                return this.mChangingDisappearingDelay;
            }
            case 4: {
                return this.mChangingDelay;
            }
            case 2: {
                return this.mAppearingDelay;
            }
            case 3: {
                return this.mDisappearingDelay;
            }
        }
        return 0L;
    }

    public void setDuration(int transitionType, long duration) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingDuration = duration;
                break;
            }
            case 1: {
                this.mChangingDisappearingDuration = duration;
                break;
            }
            case 4: {
                this.mChangingDuration = duration;
                break;
            }
            case 2: {
                this.mAppearingDuration = duration;
                break;
            }
            case 3: {
                this.mDisappearingDuration = duration;
            }
        }
    }

    public long getDuration(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingDuration;
            }
            case 1: {
                return this.mChangingDisappearingDuration;
            }
            case 4: {
                return this.mChangingDuration;
            }
            case 2: {
                return this.mAppearingDuration;
            }
            case 3: {
                return this.mDisappearingDuration;
            }
        }
        return 0L;
    }

    public void setStagger(int transitionType, long duration) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingStagger = duration;
                break;
            }
            case 1: {
                this.mChangingDisappearingStagger = duration;
                break;
            }
            case 4: {
                this.mChangingStagger = duration;
            }
        }
    }

    public long getStagger(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingStagger;
            }
            case 1: {
                return this.mChangingDisappearingStagger;
            }
            case 4: {
                return this.mChangingStagger;
            }
        }
        return 0L;
    }

    public void setInterpolator(int transitionType, TimeInterpolator interpolator2) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingInterpolator = interpolator2;
                break;
            }
            case 1: {
                this.mChangingDisappearingInterpolator = interpolator2;
                break;
            }
            case 4: {
                this.mChangingInterpolator = interpolator2;
                break;
            }
            case 2: {
                this.mAppearingInterpolator = interpolator2;
                break;
            }
            case 3: {
                this.mDisappearingInterpolator = interpolator2;
            }
        }
    }

    public TimeInterpolator getInterpolator(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingInterpolator;
            }
            case 1: {
                return this.mChangingDisappearingInterpolator;
            }
            case 4: {
                return this.mChangingInterpolator;
            }
            case 2: {
                return this.mAppearingInterpolator;
            }
            case 3: {
                return this.mDisappearingInterpolator;
            }
        }
        return null;
    }

    public void setAnimator(int transitionType, Animator animator2) {
        switch (transitionType) {
            case 0: {
                this.mChangingAppearingAnim = animator2;
                break;
            }
            case 1: {
                this.mChangingDisappearingAnim = animator2;
                break;
            }
            case 4: {
                this.mChangingAnim = animator2;
                break;
            }
            case 2: {
                this.mAppearingAnim = animator2;
                break;
            }
            case 3: {
                this.mDisappearingAnim = animator2;
            }
        }
    }

    public Animator getAnimator(int transitionType) {
        switch (transitionType) {
            case 0: {
                return this.mChangingAppearingAnim;
            }
            case 1: {
                return this.mChangingDisappearingAnim;
            }
            case 4: {
                return this.mChangingAnim;
            }
            case 2: {
                return this.mAppearingAnim;
            }
            case 3: {
                return this.mDisappearingAnim;
            }
        }
        return null;
    }

    private void runChangeTransition(ViewGroup parent, View newView, int changeReason) {
        long duration;
        Animator baseAnimator = null;
        ObjectAnimator parentAnimator = null;
        switch (changeReason) {
            case 2: {
                baseAnimator = this.mChangingAppearingAnim;
                duration = this.mChangingAppearingDuration;
                parentAnimator = defaultChangeIn;
                break;
            }
            case 3: {
                baseAnimator = this.mChangingDisappearingAnim;
                duration = this.mChangingDisappearingDuration;
                parentAnimator = defaultChangeOut;
                break;
            }
            case 4: {
                baseAnimator = this.mChangingAnim;
                duration = this.mChangingDuration;
                parentAnimator = defaultChange;
                break;
            }
            default: {
                duration = 0L;
            }
        }
        if (baseAnimator == null) {
            return;
        }
        this.staggerDelay = 0L;
        ViewTreeObserver observer = parent.getViewTreeObserver();
        if (!observer.isAlive()) {
            return;
        }
        int numChildren = parent.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            View child = parent.getChildAt(i);
            if (child == newView) continue;
            this.setupChangeAnimation(parent, changeReason, baseAnimator, duration, child);
        }
        if (this.mAnimateParentHierarchy) {
            ViewGroup tempParent = parent;
            while (tempParent != null) {
                ViewParent parentParent = tempParent.getParent();
                if (parentParent instanceof ViewGroup) {
                    this.setupChangeAnimation((ViewGroup)parentParent, changeReason, parentAnimator, duration, tempParent);
                    tempParent = (ViewGroup)parentParent;
                    continue;
                }
                tempParent = null;
            }
        }
        CleanupCallback callback2 = new CleanupCallback(this.layoutChangeListenerMap, parent);
        observer.addOnPreDrawListener(callback2);
        parent.addOnAttachStateChangeListener(callback2);
    }

    public void setAnimateParentHierarchy(boolean animateParentHierarchy) {
        this.mAnimateParentHierarchy = animateParentHierarchy;
    }

    private void setupChangeAnimation(final ViewGroup parent, final int changeReason, Animator baseAnimator, final long duration, final View child) {
        if (this.layoutChangeListenerMap.get(child) != null) {
            return;
        }
        if (child.getWidth() == 0 && child.getHeight() == 0) {
            return;
        }
        final Animator anim2 = baseAnimator.clone();
        anim2.setTarget(child);
        anim2.setupStartValues();
        Animator currentAnimation = this.pendingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
            this.pendingAnimations.remove(child);
        }
        this.pendingAnimations.put(child, anim2);
        ValueAnimator pendingAnimRemover = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(duration + 100L);
        pendingAnimRemover.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                LayoutTransition.this.pendingAnimations.remove(child);
            }
        });
        pendingAnimRemover.start();
        final View.OnLayoutChangeListener listener2 = new View.OnLayoutChangeListener(){

            @Override
            public void onLayoutChange(View v, int left, int top, int right2, int bottom2, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Animator pendingAnimation;
                anim2.setupEndValues();
                if (anim2 instanceof ValueAnimator) {
                    boolean valuesDiffer = false;
                    ValueAnimator valueAnim = (ValueAnimator)anim2;
                    PropertyValuesHolder[] oldValues = valueAnim.getValues();
                    for (int i = 0; i < oldValues.length; ++i) {
                        PropertyValuesHolder pvh = oldValues[i];
                        if (pvh.mKeyframes instanceof KeyframeSet) {
                            KeyframeSet keyframeSet = (KeyframeSet)pvh.mKeyframes;
                            if (keyframeSet.mFirstKeyframe != null && keyframeSet.mLastKeyframe != null && keyframeSet.mFirstKeyframe.getValue().equals(keyframeSet.mLastKeyframe.getValue())) continue;
                            valuesDiffer = true;
                            continue;
                        }
                        if (pvh.mKeyframes.getValue(0.0f).equals(pvh.mKeyframes.getValue(1.0f))) continue;
                        valuesDiffer = true;
                    }
                    if (!valuesDiffer) {
                        return;
                    }
                }
                long startDelay = 0L;
                switch (changeReason) {
                    case 2: {
                        startDelay = LayoutTransition.this.mChangingAppearingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.this.staggerDelay += LayoutTransition.this.mChangingAppearingStagger;
                        if (LayoutTransition.this.mChangingAppearingInterpolator == sChangingAppearingInterpolator) break;
                        anim2.setInterpolator(LayoutTransition.this.mChangingAppearingInterpolator);
                        break;
                    }
                    case 3: {
                        startDelay = LayoutTransition.this.mChangingDisappearingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.this.staggerDelay += LayoutTransition.this.mChangingDisappearingStagger;
                        if (LayoutTransition.this.mChangingDisappearingInterpolator == sChangingDisappearingInterpolator) break;
                        anim2.setInterpolator(LayoutTransition.this.mChangingDisappearingInterpolator);
                        break;
                    }
                    case 4: {
                        startDelay = LayoutTransition.this.mChangingDelay + LayoutTransition.this.staggerDelay;
                        LayoutTransition.this.staggerDelay += LayoutTransition.this.mChangingStagger;
                        if (LayoutTransition.this.mChangingInterpolator == sChangingInterpolator) break;
                        anim2.setInterpolator(LayoutTransition.this.mChangingInterpolator);
                    }
                }
                anim2.setStartDelay(startDelay);
                anim2.setDuration(duration);
                Animator prevAnimation = (Animator)LayoutTransition.this.currentChangingAnimations.get(child);
                if (prevAnimation != null) {
                    prevAnimation.cancel();
                }
                if ((pendingAnimation = (Animator)LayoutTransition.this.pendingAnimations.get(child)) != null) {
                    LayoutTransition.this.pendingAnimations.remove(child);
                }
                LayoutTransition.this.currentChangingAnimations.put(child, anim2);
                parent.requestTransitionStart(LayoutTransition.this);
                child.removeOnLayoutChangeListener(this);
                LayoutTransition.this.layoutChangeListenerMap.remove(child);
            }
        };
        anim2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationStart(Animator animator2) {
                if (LayoutTransition.this.hasListeners()) {
                    ArrayList listeners = (ArrayList)LayoutTransition.this.mListeners.clone();
                    for (TransitionListener listener22 : listeners) {
                        listener22.startTransition(LayoutTransition.this, parent, child, changeReason == 2 ? 0 : (changeReason == 3 ? 1 : 4));
                    }
                }
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
                child.removeOnLayoutChangeListener(listener2);
                LayoutTransition.this.layoutChangeListenerMap.remove(child);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                LayoutTransition.this.currentChangingAnimations.remove(child);
                if (LayoutTransition.this.hasListeners()) {
                    ArrayList listeners = (ArrayList)LayoutTransition.this.mListeners.clone();
                    for (TransitionListener listener22 : listeners) {
                        listener22.endTransition(LayoutTransition.this, parent, child, changeReason == 2 ? 0 : (changeReason == 3 ? 1 : 4));
                    }
                }
            }
        });
        child.addOnLayoutChangeListener(listener2);
        this.layoutChangeListenerMap.put(child, listener2);
    }

    public void startChangingAnimations() {
        LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
        for (Animator anim2 : currentAnimCopy.values()) {
            if (anim2 instanceof ObjectAnimator) {
                ((ObjectAnimator)anim2).setCurrentPlayTime(0L);
            }
            anim2.start();
        }
    }

    public void endChangingAnimations() {
        LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
        for (Animator anim2 : currentAnimCopy.values()) {
            anim2.start();
            anim2.end();
        }
        this.currentChangingAnimations.clear();
    }

    public boolean isChangingLayout() {
        return this.currentChangingAnimations.size() > 0;
    }

    public boolean isRunning() {
        return this.currentChangingAnimations.size() > 0 || this.currentAppearingAnimations.size() > 0 || this.currentDisappearingAnimations.size() > 0;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public void cancel() {
        LinkedHashMap currentAnimCopy;
        if (this.currentChangingAnimations.size() > 0) {
            currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
            for (Animator anim2 : currentAnimCopy.values()) {
                anim2.cancel();
            }
            this.currentChangingAnimations.clear();
        }
        if (this.currentAppearingAnimations.size() > 0) {
            currentAnimCopy = (LinkedHashMap)this.currentAppearingAnimations.clone();
            for (Animator anim2 : currentAnimCopy.values()) {
                anim2.end();
            }
            this.currentAppearingAnimations.clear();
        }
        if (this.currentDisappearingAnimations.size() > 0) {
            currentAnimCopy = (LinkedHashMap)this.currentDisappearingAnimations.clone();
            for (Animator anim2 : currentAnimCopy.values()) {
                anim2.end();
            }
            this.currentDisappearingAnimations.clear();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public void cancel(int transitionType) {
        switch (transitionType) {
            case 0: 
            case 1: 
            case 4: {
                if (this.currentChangingAnimations.size() <= 0) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentChangingAnimations.clone();
                for (Animator anim2 : currentAnimCopy.values()) {
                    anim2.cancel();
                }
                this.currentChangingAnimations.clear();
                break;
            }
            case 2: {
                if (this.currentAppearingAnimations.size() <= 0) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentAppearingAnimations.clone();
                for (Animator anim3 : currentAnimCopy.values()) {
                    anim3.end();
                }
                this.currentAppearingAnimations.clear();
                break;
            }
            case 3: {
                if (this.currentDisappearingAnimations.size() <= 0) break;
                LinkedHashMap currentAnimCopy = (LinkedHashMap)this.currentDisappearingAnimations.clone();
                for (Animator anim4 : currentAnimCopy.values()) {
                    anim4.end();
                }
                this.currentDisappearingAnimations.clear();
            }
        }
    }

    private void runAppearingTransition(final ViewGroup parent, final View child) {
        Animator currentAnimation = this.currentDisappearingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
        }
        if (this.mAppearingAnim == null) {
            if (this.hasListeners()) {
                ArrayList listeners = (ArrayList)this.mListeners.clone();
                for (TransitionListener listener2 : listeners) {
                    listener2.endTransition(this, parent, child, 2);
                }
            }
            return;
        }
        Animator anim2 = this.mAppearingAnim.clone();
        anim2.setTarget(child);
        anim2.setStartDelay(this.mAppearingDelay);
        anim2.setDuration(this.mAppearingDuration);
        if (this.mAppearingInterpolator != sAppearingInterpolator) {
            anim2.setInterpolator(this.mAppearingInterpolator);
        }
        if (anim2 instanceof ObjectAnimator) {
            ((ObjectAnimator)anim2).setCurrentPlayTime(0L);
        }
        anim2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator anim2) {
                LayoutTransition.this.currentAppearingAnimations.remove(child);
                if (LayoutTransition.this.hasListeners()) {
                    ArrayList listeners = (ArrayList)LayoutTransition.this.mListeners.clone();
                    for (TransitionListener listener2 : listeners) {
                        listener2.endTransition(LayoutTransition.this, parent, child, 2);
                    }
                }
            }
        });
        this.currentAppearingAnimations.put(child, anim2);
        anim2.start();
    }

    private void runDisappearingTransition(final ViewGroup parent, final View child) {
        Animator currentAnimation = this.currentAppearingAnimations.get(child);
        if (currentAnimation != null) {
            currentAnimation.cancel();
        }
        if (this.mDisappearingAnim == null) {
            if (this.hasListeners()) {
                ArrayList listeners = (ArrayList)this.mListeners.clone();
                for (TransitionListener listener2 : listeners) {
                    listener2.endTransition(this, parent, child, 3);
                }
            }
            return;
        }
        Animator anim2 = this.mDisappearingAnim.clone();
        anim2.setStartDelay(this.mDisappearingDelay);
        anim2.setDuration(this.mDisappearingDuration);
        if (this.mDisappearingInterpolator != sDisappearingInterpolator) {
            anim2.setInterpolator(this.mDisappearingInterpolator);
        }
        anim2.setTarget(child);
        final float preAnimAlpha = child.getAlpha();
        anim2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator anim2) {
                LayoutTransition.this.currentDisappearingAnimations.remove(child);
                child.setAlpha(preAnimAlpha);
                if (LayoutTransition.this.hasListeners()) {
                    ArrayList listeners = (ArrayList)LayoutTransition.this.mListeners.clone();
                    for (TransitionListener listener2 : listeners) {
                        listener2.endTransition(LayoutTransition.this, parent, child, 3);
                    }
                }
            }
        });
        if (anim2 instanceof ObjectAnimator) {
            ((ObjectAnimator)anim2).setCurrentPlayTime(0L);
        }
        this.currentDisappearingAnimations.put(child, anim2);
        anim2.start();
    }

    private void addChild(ViewGroup parent, View child, boolean changesLayout) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 1) == 1) {
            this.cancel(3);
        }
        if (changesLayout && (this.mTransitionTypes & 4) == 4) {
            this.cancel(0);
            this.cancel(4);
        }
        if (this.hasListeners() && (this.mTransitionTypes & 1) == 1) {
            ArrayList listeners = (ArrayList)this.mListeners.clone();
            for (TransitionListener listener2 : listeners) {
                listener2.startTransition(this, parent, child, 2);
            }
        }
        if (changesLayout && (this.mTransitionTypes & 4) == 4) {
            this.runChangeTransition(parent, child, 2);
        }
        if ((this.mTransitionTypes & 1) == 1) {
            this.runAppearingTransition(parent, child);
        }
    }

    private boolean hasListeners() {
        return this.mListeners != null && this.mListeners.size() > 0;
    }

    public void layoutChange(ViewGroup parent) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 0x10) == 16 && !this.isRunning()) {
            this.runChangeTransition(parent, null, 4);
        }
    }

    public void addChild(ViewGroup parent, View child) {
        this.addChild(parent, child, true);
    }

    @Deprecated
    public void showChild(ViewGroup parent, View child) {
        this.addChild(parent, child, true);
    }

    public void showChild(ViewGroup parent, View child, int oldVisibility) {
        this.addChild(parent, child, oldVisibility == 8);
    }

    private void removeChild(ViewGroup parent, View child, boolean changesLayout) {
        if (parent.getWindowVisibility() != 0) {
            return;
        }
        if ((this.mTransitionTypes & 2) == 2) {
            this.cancel(2);
        }
        if (changesLayout && (this.mTransitionTypes & 8) == 8) {
            this.cancel(1);
            this.cancel(4);
        }
        if (this.hasListeners() && (this.mTransitionTypes & 2) == 2) {
            ArrayList listeners = (ArrayList)this.mListeners.clone();
            for (TransitionListener listener2 : listeners) {
                listener2.startTransition(this, parent, child, 3);
            }
        }
        if (changesLayout && (this.mTransitionTypes & 8) == 8) {
            this.runChangeTransition(parent, child, 3);
        }
        if ((this.mTransitionTypes & 2) == 2) {
            this.runDisappearingTransition(parent, child);
        }
    }

    public void removeChild(ViewGroup parent, View child) {
        this.removeChild(parent, child, true);
    }

    @Deprecated
    public void hideChild(ViewGroup parent, View child) {
        this.removeChild(parent, child, true);
    }

    public void hideChild(ViewGroup parent, View child, int newVisibility) {
        this.removeChild(parent, child, newVisibility == 8);
    }

    public void addTransitionListener(TransitionListener listener2) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener2);
    }

    public void removeTransitionListener(TransitionListener listener2) {
        if (this.mListeners == null) {
            return;
        }
        this.mListeners.remove(listener2);
    }

    public List<TransitionListener> getTransitionListeners() {
        return this.mListeners;
    }

    static {
        DEFAULT_DURATION = 300L;
        ACCEL_DECEL_INTERPOLATOR = new AccelerateDecelerateInterpolator();
        DECEL_INTERPOLATOR = new DecelerateInterpolator();
        sAppearingInterpolator = ACCEL_DECEL_INTERPOLATOR;
        sDisappearingInterpolator = ACCEL_DECEL_INTERPOLATOR;
        sChangingAppearingInterpolator = DECEL_INTERPOLATOR;
        sChangingDisappearingInterpolator = DECEL_INTERPOLATOR;
        sChangingInterpolator = DECEL_INTERPOLATOR;
    }

    private static class CleanupCallback
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        final Map<View, View.OnLayoutChangeListener> layoutChangeListenerMap;
        final ViewGroup parent;

        CleanupCallback(Map<View, View.OnLayoutChangeListener> listenerMap, ViewGroup parent) {
            this.layoutChangeListenerMap = listenerMap;
            this.parent = parent;
        }

        private void cleanup() {
            this.parent.getViewTreeObserver().removeOnPreDrawListener(this);
            this.parent.removeOnAttachStateChangeListener(this);
            int count = this.layoutChangeListenerMap.size();
            if (count > 0) {
                Set<View> views = this.layoutChangeListenerMap.keySet();
                for (View view : views) {
                    View.OnLayoutChangeListener listener2 = this.layoutChangeListenerMap.get(view);
                    view.removeOnLayoutChangeListener(listener2);
                }
                this.layoutChangeListenerMap.clear();
            }
        }

        @Override
        public void onViewAttachedToWindow(View v) {
        }

        @Override
        public void onViewDetachedFromWindow(View v) {
            this.cleanup();
        }

        @Override
        public boolean onPreDraw() {
            this.cleanup();
            return true;
        }
    }

    public static interface TransitionListener {
        public void startTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);

        public void endTransition(LayoutTransition var1, ViewGroup var2, View var3, int var4);
    }
}

