/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.ActivityThread;
import android.app.Application;
import android.os.Looper;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class AnimatorSet
extends Animator
implements AnimationHandler.AnimationFrameCallback {
    private static final String TAG = "AnimatorSet";
    private ArrayList<Node> mPlayingSet = new ArrayList();
    private ArrayMap<Animator, Node> mNodeMap = new ArrayMap();
    private ArrayList<AnimationEvent> mEvents = new ArrayList();
    private ArrayList<Node> mNodes = new ArrayList();
    private boolean mDependencyDirty = false;
    private boolean mStarted = false;
    private long mStartDelay = 0L;
    private ValueAnimator mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(0L);
    private Node mRootNode = new Node(this.mDelayAnim);
    private long mDuration = -1L;
    private TimeInterpolator mInterpolator = null;
    private long mTotalDuration = 0L;
    private final boolean mShouldIgnoreEndWithoutStart;
    private final boolean mShouldResetValuesAtStart;
    private final boolean mEndCanBeCalled;
    public long mLastFrameTime = -1L;
    private long mFirstFrame = -1L;
    private int mLastEventId = -1;
    private boolean mReversing = false;
    private boolean mSelfPulse = true;
    private SeekState mSeekState = new SeekState();
    private boolean mChildrenInitialized = false;
    private long mPauseTime = -1L;
    private AnimatorListenerAdapter mAnimationEndListener = new AnimatorListenerAdapter(){

        @Override
        public void onAnimationEnd(Animator animation) {
            if (AnimatorSet.this.mNodeMap.get(animation) == null) {
                throw new AndroidRuntimeException("Error: animation ended is not in the node map");
            }
            ((Node)((AnimatorSet)AnimatorSet.this).mNodeMap.get((Object)animation)).mEnded = true;
        }
    };

    public AnimatorSet() {
        boolean isPreO;
        this.mNodeMap.put(this.mDelayAnim, this.mRootNode);
        this.mNodes.add(this.mRootNode);
        Application app = ActivityThread.currentApplication();
        if (app == null || app.getApplicationInfo() == null) {
            this.mShouldIgnoreEndWithoutStart = true;
            isPreO = true;
        } else {
            this.mShouldIgnoreEndWithoutStart = app.getApplicationInfo().targetSdkVersion < 24;
            isPreO = app.getApplicationInfo().targetSdkVersion < 26;
        }
        this.mShouldResetValuesAtStart = !isPreO;
        this.mEndCanBeCalled = !isPreO;
    }

    public void playTogether(Animator ... items) {
        if (items != null) {
            Builder builder2 = this.play(items[0]);
            for (int i = 1; i < items.length; ++i) {
                builder2.with(items[i]);
            }
        }
    }

    public void playTogether(Collection<Animator> items) {
        if (items != null && items.size() > 0) {
            Builder builder2 = null;
            for (Animator anim2 : items) {
                if (builder2 == null) {
                    builder2 = this.play(anim2);
                    continue;
                }
                builder2.with(anim2);
            }
        }
    }

    public void playSequentially(Animator ... items) {
        if (items != null) {
            if (items.length == 1) {
                this.play(items[0]);
            } else {
                for (int i = 0; i < items.length - 1; ++i) {
                    this.play(items[i]).before(items[i + 1]);
                }
            }
        }
    }

    public void playSequentially(List<Animator> items) {
        if (items != null && items.size() > 0) {
            if (items.size() == 1) {
                this.play(items.get(0));
            } else {
                for (int i = 0; i < items.size() - 1; ++i) {
                    this.play(items.get(i)).before(items.get(i + 1));
                }
            }
        }
    }

    public ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> childList = new ArrayList<Animator>();
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            childList.add(node.mAnimation);
        }
        return childList;
    }

    @Override
    public void setTarget(Object target) {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            Animator animation = node.mAnimation;
            if (animation instanceof AnimatorSet) {
                ((AnimatorSet)animation).setTarget(target);
                continue;
            }
            if (!(animation instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animation).setTarget(target);
        }
    }

    @Override
    public int getChangingConfigurations() {
        int conf = super.getChangingConfigurations();
        int nodeCount = this.mNodes.size();
        for (int i = 0; i < nodeCount; ++i) {
            conf |= this.mNodes.get((int)i).mAnimation.getChangingConfigurations();
        }
        return conf;
    }

    @Override
    public void setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public Builder play(Animator anim2) {
        if (anim2 != null) {
            return new Builder(anim2);
        }
        return null;
    }

    @Override
    public void cancel() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (this.isStarted()) {
            ArrayList tmpListeners = null;
            if (this.mListeners != null) {
                tmpListeners = (ArrayList)this.mListeners.clone();
                int size = tmpListeners.size();
                for (int i = 0; i < size; ++i) {
                    ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationCancel(this);
                }
            }
            ArrayList<Node> playingSet = new ArrayList<Node>(this.mPlayingSet);
            int setSize = playingSet.size();
            for (int i = 0; i < setSize; ++i) {
                playingSet.get((int)i).mAnimation.cancel();
            }
            this.mPlayingSet.clear();
            this.endAnimation();
        }
    }

    private void forceToEnd() {
        if (this.mEndCanBeCalled) {
            this.end();
            return;
        }
        if (this.mReversing) {
            this.handleAnimationEvents(this.mLastEventId, 0, this.getTotalDuration());
        } else {
            long zeroScalePlayTime = this.getTotalDuration();
            if (zeroScalePlayTime == -1L) {
                zeroScalePlayTime = Integer.MAX_VALUE;
            }
            this.handleAnimationEvents(this.mLastEventId, this.mEvents.size() - 1, zeroScalePlayTime);
        }
        this.mPlayingSet.clear();
        this.endAnimation();
    }

    @Override
    public void end() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        if (this.mShouldIgnoreEndWithoutStart && !this.isStarted()) {
            return;
        }
        if (this.isStarted()) {
            if (this.mReversing) {
                int n = this.mLastEventId = this.mLastEventId == -1 ? this.mEvents.size() : this.mLastEventId;
                while (this.mLastEventId > 0) {
                    --this.mLastEventId;
                    AnimationEvent event = this.mEvents.get(this.mLastEventId);
                    Animator anim2 = event.mNode.mAnimation;
                    if (this.mNodeMap.get((Object)anim2).mEnded) continue;
                    if (event.mEvent == 2) {
                        anim2.reverse();
                        continue;
                    }
                    if (event.mEvent != 1 || !anim2.isStarted()) continue;
                    anim2.end();
                }
            } else {
                while (this.mLastEventId < this.mEvents.size() - 1) {
                    ++this.mLastEventId;
                    AnimationEvent event = this.mEvents.get(this.mLastEventId);
                    Animator anim3 = event.mNode.mAnimation;
                    if (this.mNodeMap.get((Object)anim3).mEnded) continue;
                    if (event.mEvent == 0) {
                        anim3.start();
                        continue;
                    }
                    if (event.mEvent != 2 || !anim3.isStarted()) continue;
                    anim3.end();
                }
            }
            this.mPlayingSet.clear();
        }
        this.endAnimation();
    }

    @Override
    public boolean isRunning() {
        if (this.mStartDelay == 0L) {
            return this.mStarted;
        }
        return this.mLastFrameTime > 0L;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long startDelay) {
        long delta;
        if (startDelay < 0L) {
            Log.w(TAG, "Start delay should always be non-negative");
            startDelay = 0L;
        }
        if ((delta = startDelay - this.mStartDelay) == 0L) {
            return;
        }
        this.mStartDelay = startDelay;
        if (!this.mDependencyDirty) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                if (node == this.mRootNode) {
                    node.mEndTime = this.mStartDelay;
                    continue;
                }
                node.mStartTime = node.mStartTime == -1L ? -1L : node.mStartTime + delta;
                node.mEndTime = node.mEndTime == -1L ? -1L : node.mEndTime + delta;
            }
            if (this.mTotalDuration != -1L) {
                this.mTotalDuration += delta;
            }
        }
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public AnimatorSet setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        this.mDependencyDirty = true;
        this.mDuration = duration;
        return this;
    }

    @Override
    public void setupStartValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupStartValues();
        }
    }

    @Override
    public void setupEndValues() {
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            if (node == this.mRootNode) continue;
            node.mAnimation.setupEndValues();
        }
    }

    @Override
    public void pause() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        boolean previouslyPaused = this.mPaused;
        super.pause();
        if (!previouslyPaused && this.mPaused) {
            this.mPauseTime = -1L;
        }
    }

    @Override
    public void resume() {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        boolean previouslyPaused = this.mPaused;
        super.resume();
        if (previouslyPaused && !this.mPaused && this.mPauseTime >= 0L) {
            this.addAnimationCallback(0L);
        }
    }

    @Override
    public void start() {
        this.start(false, true);
    }

    @Override
    void startWithoutPulsing(boolean inReverse) {
        this.start(inReverse, false);
    }

    private void initAnimation() {
        if (this.mInterpolator != null) {
            for (int i = 0; i < this.mNodes.size(); ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.setInterpolator(this.mInterpolator);
            }
        }
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
    }

    private void start(boolean inReverse, boolean selfPulse) {
        if (Looper.myLooper() == null) {
            throw new AndroidRuntimeException("Animators may only be run on Looper threads");
        }
        this.mStarted = true;
        this.mSelfPulse = selfPulse;
        this.mPaused = false;
        this.mPauseTime = -1L;
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            node.mEnded = false;
            node.mAnimation.setAllowRunningAsynchronously(false);
        }
        this.initAnimation();
        if (inReverse && !this.canReverse()) {
            throw new UnsupportedOperationException("Cannot reverse infinite AnimatorSet");
        }
        this.mReversing = inReverse;
        boolean isEmptySet = AnimatorSet.isEmptySet(this);
        if (!isEmptySet) {
            this.startAnimation();
        }
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationStart(this, inReverse);
            }
        }
        if (isEmptySet) {
            this.end();
        }
    }

    private static boolean isEmptySet(AnimatorSet set) {
        if (set.getStartDelay() > 0L) {
            return false;
        }
        for (int i = 0; i < set.getChildAnimations().size(); ++i) {
            Animator anim2 = set.getChildAnimations().get(i);
            if (!(anim2 instanceof AnimatorSet)) {
                return false;
            }
            if (AnimatorSet.isEmptySet((AnimatorSet)anim2)) continue;
            return false;
        }
        return true;
    }

    private void updateAnimatorsDuration() {
        if (this.mDuration >= 0L) {
            int size = this.mNodes.size();
            for (int i = 0; i < size; ++i) {
                Node node = this.mNodes.get(i);
                node.mAnimation.setDuration(this.mDuration);
            }
        }
        this.mDelayAnim.setDuration(this.mStartDelay);
    }

    @Override
    void skipToEndValue(boolean inReverse) {
        if (!this.isInitialized()) {
            throw new UnsupportedOperationException("Children must be initialized.");
        }
        this.initAnimation();
        if (inReverse) {
            for (int i = this.mEvents.size() - 1; i >= 0; --i) {
                if (this.mEvents.get((int)i).mEvent != 1) continue;
                this.mEvents.get((int)i).mNode.mAnimation.skipToEndValue(true);
            }
        } else {
            for (int i = 0; i < this.mEvents.size(); ++i) {
                if (this.mEvents.get((int)i).mEvent != 2) continue;
                this.mEvents.get((int)i).mNode.mAnimation.skipToEndValue(false);
            }
        }
    }

    @Override
    void animateBasedOnPlayTime(long currentPlayTime, long lastPlayTime, boolean inReverse) {
        AnimationEvent event;
        int i;
        if (currentPlayTime < 0L || lastPlayTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should never be negative.");
        }
        if (inReverse) {
            if (this.getTotalDuration() == -1L) {
                throw new UnsupportedOperationException("Cannot reverse AnimatorSet with infinite duration");
            }
            long duration = this.getTotalDuration() - this.mStartDelay;
            currentPlayTime = Math.min(currentPlayTime, duration);
            currentPlayTime = duration - currentPlayTime;
            lastPlayTime = duration - lastPlayTime;
            inReverse = false;
        }
        ArrayList<Node> unfinishedNodes = new ArrayList<Node>();
        for (i = 0; i < this.mEvents.size() && (event = this.mEvents.get(i)).getTime() <= currentPlayTime && event.getTime() != -1L; ++i) {
            if (event.mEvent == 1 && (event.mNode.mEndTime == -1L || event.mNode.mEndTime > currentPlayTime)) {
                unfinishedNodes.add(event.mNode);
            }
            if (event.mEvent != 2) continue;
            event.mNode.mAnimation.skipToEndValue(false);
        }
        for (i = 0; i < unfinishedNodes.size(); ++i) {
            Node node = (Node)unfinishedNodes.get(i);
            long playTime = this.getPlayTimeForNode(currentPlayTime, node, inReverse);
            if (!inReverse) {
                playTime -= node.mAnimation.getStartDelay();
            }
            node.mAnimation.animateBasedOnPlayTime(playTime, lastPlayTime, inReverse);
        }
        for (i = 0; i < this.mEvents.size(); ++i) {
            event = this.mEvents.get(i);
            if (event.getTime() <= currentPlayTime || event.mEvent != 1) continue;
            event.mNode.mAnimation.skipToEndValue(true);
        }
    }

    @Override
    boolean isInitialized() {
        if (this.mChildrenInitialized) {
            return true;
        }
        boolean allInitialized = true;
        for (int i = 0; i < this.mNodes.size(); ++i) {
            if (this.mNodes.get((int)i).mAnimation.isInitialized()) continue;
            allInitialized = false;
            break;
        }
        this.mChildrenInitialized = allInitialized;
        return this.mChildrenInitialized;
    }

    private void skipToStartValue(boolean inReverse) {
        this.skipToEndValue(!inReverse);
    }

    public void setCurrentPlayTime(long playTime) {
        if (this.mReversing && this.getTotalDuration() == -1L) {
            throw new UnsupportedOperationException("Error: Cannot seek in reverse in an infinite AnimatorSet");
        }
        if (this.getTotalDuration() != -1L && playTime > this.getTotalDuration() - this.mStartDelay || playTime < 0L) {
            throw new UnsupportedOperationException("Error: Play time should always be in between0 and duration.");
        }
        this.initAnimation();
        if (!this.isStarted() || this.isPaused()) {
            if (this.mReversing) {
                throw new UnsupportedOperationException("Error: Something went wrong. mReversing should not be set when AnimatorSet is not started.");
            }
            if (!this.mSeekState.isActive()) {
                this.findLatestEventIdForTime(0L);
                this.initChildren();
                this.mSeekState.setPlayTime(0L, this.mReversing);
            }
            this.animateBasedOnPlayTime(playTime, 0L, this.mReversing);
            this.mSeekState.setPlayTime(playTime, this.mReversing);
        } else {
            this.mSeekState.setPlayTime(playTime, this.mReversing);
        }
    }

    public long getCurrentPlayTime() {
        if (this.mSeekState.isActive()) {
            return this.mSeekState.getPlayTime();
        }
        if (this.mLastFrameTime == -1L) {
            return 0L;
        }
        float durationScale = ValueAnimator.getDurationScale();
        float f = durationScale = durationScale == 0.0f ? 1.0f : durationScale;
        if (this.mReversing) {
            return (long)((float)(this.mLastFrameTime - this.mFirstFrame) / durationScale);
        }
        return (long)((float)(this.mLastFrameTime - this.mFirstFrame - this.mStartDelay) / durationScale);
    }

    private void initChildren() {
        if (!this.isInitialized()) {
            this.mChildrenInitialized = true;
            this.skipToEndValue(false);
        }
    }

    @Override
    public boolean doAnimationFrame(long frameTime) {
        int i;
        float durationScale = ValueAnimator.getDurationScale();
        if (durationScale == 0.0f) {
            this.forceToEnd();
            return true;
        }
        if (this.mFirstFrame < 0L) {
            this.mFirstFrame = frameTime;
        }
        if (this.mPaused) {
            this.mPauseTime = frameTime;
            this.removeAnimationCallback();
            return false;
        }
        if (this.mPauseTime > 0L) {
            this.mFirstFrame += frameTime - this.mPauseTime;
            this.mPauseTime = -1L;
        }
        if (this.mSeekState.isActive()) {
            this.mSeekState.updateSeekDirection(this.mReversing);
            this.mFirstFrame = this.mReversing ? (long)((float)frameTime - (float)this.mSeekState.getPlayTime() * durationScale) : (long)((float)frameTime - (float)(this.mSeekState.getPlayTime() + this.mStartDelay) * durationScale);
            this.mSeekState.reset();
        }
        if (!this.mReversing && (float)frameTime < (float)this.mFirstFrame + (float)this.mStartDelay * durationScale) {
            return false;
        }
        long unscaledPlayTime = (long)((float)(frameTime - this.mFirstFrame) / durationScale);
        this.mLastFrameTime = frameTime;
        int latestId = this.findLatestEventIdForTime(unscaledPlayTime);
        int startId = this.mLastEventId;
        this.handleAnimationEvents(startId, latestId, unscaledPlayTime);
        this.mLastEventId = latestId;
        for (i = 0; i < this.mPlayingSet.size(); ++i) {
            Node node = this.mPlayingSet.get(i);
            if (node.mEnded) continue;
            this.pulseFrame(node, this.getPlayTimeForNode(unscaledPlayTime, node));
        }
        for (i = this.mPlayingSet.size() - 1; i >= 0; --i) {
            if (!this.mPlayingSet.get((int)i).mEnded) continue;
            this.mPlayingSet.remove(i);
        }
        boolean finished = false;
        if (this.mReversing) {
            if (this.mPlayingSet.size() == 1 && this.mPlayingSet.get(0) == this.mRootNode) {
                finished = true;
            } else if (this.mPlayingSet.isEmpty() && this.mLastEventId < 3) {
                finished = true;
            }
        } else {
            boolean bl = finished = this.mPlayingSet.isEmpty() && this.mLastEventId == this.mEvents.size() - 1;
        }
        if (finished) {
            this.endAnimation();
            return true;
        }
        return false;
    }

    @Override
    public void commitAnimationFrame(long frameTime) {
    }

    @Override
    boolean pulseAnimationFrame(long frameTime) {
        return this.doAnimationFrame(frameTime);
    }

    private void handleAnimationEvents(int startId, int latestId, long playTime) {
        if (this.mReversing) {
            startId = startId == -1 ? this.mEvents.size() : startId;
            for (int i = startId - 1; i >= latestId; --i) {
                AnimationEvent event = this.mEvents.get(i);
                Node node = event.mNode;
                if (event.mEvent == 2) {
                    if (node.mAnimation.isStarted()) {
                        node.mAnimation.cancel();
                    }
                    node.mEnded = false;
                    this.mPlayingSet.add(event.mNode);
                    node.mAnimation.startWithoutPulsing(true);
                    this.pulseFrame(node, 0L);
                    continue;
                }
                if (event.mEvent != 1 || node.mEnded) continue;
                this.pulseFrame(node, this.getPlayTimeForNode(playTime, node));
            }
        } else {
            for (int i = startId + 1; i <= latestId; ++i) {
                AnimationEvent event = this.mEvents.get(i);
                Node node = event.mNode;
                if (event.mEvent == 0) {
                    this.mPlayingSet.add(event.mNode);
                    if (node.mAnimation.isStarted()) {
                        node.mAnimation.cancel();
                    }
                    node.mEnded = false;
                    node.mAnimation.startWithoutPulsing(false);
                    this.pulseFrame(node, 0L);
                    continue;
                }
                if (event.mEvent != 2 || node.mEnded) continue;
                this.pulseFrame(node, this.getPlayTimeForNode(playTime, node));
            }
        }
    }

    private void pulseFrame(Node node, long animPlayTime) {
        if (!node.mEnded) {
            float durationScale = ValueAnimator.getDurationScale();
            durationScale = durationScale == 0.0f ? 1.0f : durationScale;
            node.mEnded = node.mAnimation.pulseAnimationFrame((long)((float)animPlayTime * durationScale));
        }
    }

    private long getPlayTimeForNode(long overallPlayTime, Node node) {
        return this.getPlayTimeForNode(overallPlayTime, node, this.mReversing);
    }

    private long getPlayTimeForNode(long overallPlayTime, Node node, boolean inReverse) {
        if (inReverse) {
            overallPlayTime = this.getTotalDuration() - overallPlayTime;
            return node.mEndTime - overallPlayTime;
        }
        return overallPlayTime - node.mStartTime;
    }

    private void startAnimation() {
        this.addAnimationEndListener();
        this.addAnimationCallback(0L);
        if (this.mSeekState.getPlayTimeNormalized() == 0L && this.mReversing) {
            this.mSeekState.reset();
        }
        if (this.mShouldResetValuesAtStart) {
            if (this.isInitialized()) {
                this.skipToEndValue(!this.mReversing);
            } else if (this.mReversing) {
                this.initChildren();
                this.skipToEndValue(!this.mReversing);
            } else {
                for (int i = this.mEvents.size() - 1; i >= 0; --i) {
                    Animator anim2;
                    if (this.mEvents.get((int)i).mEvent != 1 || !(anim2 = this.mEvents.get((int)i).mNode.mAnimation).isInitialized()) continue;
                    anim2.skipToEndValue(true);
                }
            }
        }
        if (this.mReversing || this.mStartDelay == 0L || this.mSeekState.isActive()) {
            long playTime;
            if (this.mSeekState.isActive()) {
                this.mSeekState.updateSeekDirection(this.mReversing);
                playTime = this.mSeekState.getPlayTime();
            } else {
                playTime = 0L;
            }
            int toId = this.findLatestEventIdForTime(playTime);
            this.handleAnimationEvents(-1, toId, playTime);
            for (int i = this.mPlayingSet.size() - 1; i >= 0; --i) {
                if (!this.mPlayingSet.get((int)i).mEnded) continue;
                this.mPlayingSet.remove(i);
            }
            this.mLastEventId = toId;
        }
    }

    private void addAnimationEndListener() {
        for (int i = 1; i < this.mNodes.size(); ++i) {
            this.mNodes.get((int)i).mAnimation.addListener(this.mAnimationEndListener);
        }
    }

    private void removeAnimationEndListener() {
        for (int i = 1; i < this.mNodes.size(); ++i) {
            this.mNodes.get((int)i).mAnimation.removeListener(this.mAnimationEndListener);
        }
    }

    private int findLatestEventIdForTime(long currentPlayTime) {
        int size = this.mEvents.size();
        int latestId = this.mLastEventId;
        if (this.mReversing) {
            currentPlayTime = this.getTotalDuration() - currentPlayTime;
            this.mLastEventId = this.mLastEventId == -1 ? size : this.mLastEventId;
            for (int j = this.mLastEventId - 1; j >= 0; --j) {
                AnimationEvent event = this.mEvents.get(j);
                if (event.getTime() < currentPlayTime) continue;
                latestId = j;
            }
        } else {
            for (int i = this.mLastEventId + 1; i < size; ++i) {
                AnimationEvent event = this.mEvents.get(i);
                if (event.getTime() == -1L || event.getTime() > currentPlayTime) continue;
                latestId = i;
            }
        }
        return latestId;
    }

    private void endAnimation() {
        this.mStarted = false;
        this.mLastFrameTime = -1L;
        this.mFirstFrame = -1L;
        this.mLastEventId = -1;
        this.mPaused = false;
        this.mPauseTime = -1L;
        this.mSeekState.reset();
        this.mPlayingSet.clear();
        this.removeAnimationCallback();
        if (this.mListeners != null) {
            ArrayList tmpListeners = (ArrayList)this.mListeners.clone();
            int numListeners = tmpListeners.size();
            for (int i = 0; i < numListeners; ++i) {
                ((Animator.AnimatorListener)tmpListeners.get(i)).onAnimationEnd(this, this.mReversing);
            }
        }
        this.removeAnimationEndListener();
        this.mSelfPulse = true;
        this.mReversing = false;
    }

    private void removeAnimationCallback() {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.removeCallback(this);
    }

    private void addAnimationCallback(long delay) {
        if (!this.mSelfPulse) {
            return;
        }
        AnimationHandler handler = AnimationHandler.getInstance();
        handler.addAnimationFrameCallback(this, delay);
    }

    @Override
    public AnimatorSet clone() {
        Node nodeClone;
        Node node;
        final AnimatorSet anim2 = (AnimatorSet)super.clone();
        int nodeCount = this.mNodes.size();
        anim2.mStarted = false;
        anim2.mLastFrameTime = -1L;
        anim2.mFirstFrame = -1L;
        anim2.mLastEventId = -1;
        anim2.mPaused = false;
        anim2.mPauseTime = -1L;
        anim2.mSeekState = new SeekState();
        anim2.mSelfPulse = true;
        anim2.mPlayingSet = new ArrayList();
        anim2.mNodeMap = new ArrayMap();
        anim2.mNodes = new ArrayList(nodeCount);
        anim2.mEvents = new ArrayList();
        anim2.mAnimationEndListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                if (anim2.mNodeMap.get(animation) == null) {
                    throw new AndroidRuntimeException("Error: animation ended is not in the node map");
                }
                ((Node)((AnimatorSet)anim2).mNodeMap.get((Object)animation)).mEnded = true;
            }
        };
        anim2.mReversing = false;
        anim2.mDependencyDirty = true;
        HashMap<Node, Node> clonesMap = new HashMap<Node, Node>(nodeCount);
        for (int n = 0; n < nodeCount; ++n) {
            node = this.mNodes.get(n);
            nodeClone = node.clone();
            nodeClone.mAnimation.removeListener(this.mAnimationEndListener);
            clonesMap.put(node, nodeClone);
            anim2.mNodes.add(nodeClone);
            anim2.mNodeMap.put(nodeClone.mAnimation, nodeClone);
        }
        anim2.mRootNode = (Node)clonesMap.get(this.mRootNode);
        anim2.mDelayAnim = (ValueAnimator)anim2.mRootNode.mAnimation;
        for (int i = 0; i < nodeCount; ++i) {
            int j;
            node = this.mNodes.get(i);
            nodeClone = (Node)clonesMap.get(node);
            nodeClone.mLatestParent = node.mLatestParent == null ? null : (Node)clonesMap.get(node.mLatestParent);
            int size = node.mChildNodes == null ? 0 : node.mChildNodes.size();
            for (j = 0; j < size; ++j) {
                nodeClone.mChildNodes.set(j, (Node)clonesMap.get(node.mChildNodes.get(j)));
            }
            size = node.mSiblings == null ? 0 : node.mSiblings.size();
            for (j = 0; j < size; ++j) {
                nodeClone.mSiblings.set(j, (Node)clonesMap.get(node.mSiblings.get(j)));
            }
            size = node.mParents == null ? 0 : node.mParents.size();
            for (j = 0; j < size; ++j) {
                nodeClone.mParents.set(j, (Node)clonesMap.get(node.mParents.get(j)));
            }
        }
        return anim2;
    }

    @Override
    public boolean canReverse() {
        return this.getTotalDuration() != -1L;
    }

    @Override
    public void reverse() {
        this.start(true, true);
    }

    public String toString() {
        String returnVal = "AnimatorSet@" + Integer.toHexString(this.hashCode()) + "{";
        int size = this.mNodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = this.mNodes.get(i);
            returnVal = returnVal + "\n    " + node.mAnimation.toString();
        }
        return returnVal + "\n}";
    }

    private void printChildCount() {
        ArrayList<Node> list = new ArrayList<Node>(this.mNodes.size());
        list.add(this.mRootNode);
        Log.d(TAG, "Current tree: ");
        int index = 0;
        while (index < list.size()) {
            int listSize = list.size();
            StringBuilder builder2 = new StringBuilder();
            while (index < listSize) {
                Node node = (Node)list.get(index);
                int num = 0;
                if (node.mChildNodes != null) {
                    for (int i = 0; i < node.mChildNodes.size(); ++i) {
                        Node child = node.mChildNodes.get(i);
                        if (child.mLatestParent != node) continue;
                        ++num;
                        list.add(child);
                    }
                }
                builder2.append(" ");
                builder2.append(num);
                ++index;
            }
            Log.d(TAG, builder2.toString());
        }
    }

    private void createDependencyGraph() {
        Node node;
        int i;
        if (!this.mDependencyDirty) {
            boolean durationChanged = false;
            for (i = 0; i < this.mNodes.size(); ++i) {
                Animator anim2 = this.mNodes.get((int)i).mAnimation;
                if (this.mNodes.get((int)i).mTotalDuration == anim2.getTotalDuration()) continue;
                durationChanged = true;
                break;
            }
            if (!durationChanged) {
                return;
            }
        }
        this.mDependencyDirty = false;
        int size = this.mNodes.size();
        for (i = 0; i < size; ++i) {
            this.mNodes.get((int)i).mParentsAdded = false;
        }
        for (i = 0; i < size; ++i) {
            int j;
            node = this.mNodes.get(i);
            if (node.mParentsAdded) continue;
            node.mParentsAdded = true;
            if (node.mSiblings == null) continue;
            this.findSiblings(node, node.mSiblings);
            node.mSiblings.remove(node);
            int siblingSize = node.mSiblings.size();
            for (j = 0; j < siblingSize; ++j) {
                node.addParents(node.mSiblings.get((int)j).mParents);
            }
            for (j = 0; j < siblingSize; ++j) {
                Node sibling = node.mSiblings.get(j);
                sibling.addParents(node.mParents);
                sibling.mParentsAdded = true;
            }
        }
        for (i = 0; i < size; ++i) {
            node = this.mNodes.get(i);
            if (node == this.mRootNode || node.mParents != null) continue;
            node.addParent(this.mRootNode);
        }
        ArrayList<Node> visited = new ArrayList<Node>(this.mNodes.size());
        this.mRootNode.mStartTime = 0L;
        this.mRootNode.mEndTime = this.mDelayAnim.getDuration();
        this.updatePlayTime(this.mRootNode, visited);
        this.sortAnimationEvents();
        this.mTotalDuration = this.mEvents.get(this.mEvents.size() - 1).getTime();
    }

    private void sortAnimationEvents() {
        this.mEvents.clear();
        for (int i = 1; i < this.mNodes.size(); ++i) {
            Node node = this.mNodes.get(i);
            this.mEvents.add(new AnimationEvent(node, 0));
            this.mEvents.add(new AnimationEvent(node, 1));
            this.mEvents.add(new AnimationEvent(node, 2));
        }
        this.mEvents.sort(new Comparator<AnimationEvent>(){

            @Override
            public int compare(AnimationEvent e1, AnimationEvent e2) {
                long t2;
                long t1 = e1.getTime();
                if (t1 == (t2 = e2.getTime())) {
                    if (e2.mEvent + e1.mEvent == 1) {
                        return e1.mEvent - e2.mEvent;
                    }
                    return e2.mEvent - e1.mEvent;
                }
                if (t2 == -1L) {
                    return -1;
                }
                if (t1 == -1L) {
                    return 1;
                }
                return (int)(t1 - t2);
            }
        });
        int eventSize = this.mEvents.size();
        int i = 0;
        while (i < eventSize) {
            AnimationEvent event = this.mEvents.get(i);
            if (event.mEvent == 2) {
                boolean needToSwapStart;
                if (event.mNode.mStartTime == event.mNode.mEndTime) {
                    needToSwapStart = true;
                } else if (event.mNode.mEndTime == event.mNode.mStartTime + event.mNode.mAnimation.getStartDelay()) {
                    needToSwapStart = false;
                } else {
                    ++i;
                    continue;
                }
                int startEventId = eventSize;
                int startDelayEndId = eventSize;
                for (int j = i + 1; j < eventSize && (startEventId >= eventSize || startDelayEndId >= eventSize); ++j) {
                    if (this.mEvents.get((int)j).mNode != event.mNode) continue;
                    if (this.mEvents.get((int)j).mEvent == 0) {
                        startEventId = j;
                        continue;
                    }
                    if (this.mEvents.get((int)j).mEvent != 1) continue;
                    startDelayEndId = j;
                }
                if (needToSwapStart && startEventId == this.mEvents.size()) {
                    throw new UnsupportedOperationException("Something went wrong, no start isfound after stop for an animation that has the same start and endtime.");
                }
                if (startDelayEndId == this.mEvents.size()) {
                    throw new UnsupportedOperationException("Something went wrong, no startdelay end is found after stop for an animation");
                }
                if (needToSwapStart) {
                    AnimationEvent startEvent = this.mEvents.remove(startEventId);
                    this.mEvents.add(i, startEvent);
                    ++i;
                }
                AnimationEvent startDelayEndEvent = this.mEvents.remove(startDelayEndId);
                this.mEvents.add(i, startDelayEndEvent);
                i += 2;
                continue;
            }
            ++i;
        }
        if (!this.mEvents.isEmpty() && this.mEvents.get((int)0).mEvent != 0) {
            throw new UnsupportedOperationException("Sorting went bad, the start event should always be at index 0");
        }
        this.mEvents.add(0, new AnimationEvent(this.mRootNode, 0));
        this.mEvents.add(1, new AnimationEvent(this.mRootNode, 1));
        this.mEvents.add(2, new AnimationEvent(this.mRootNode, 2));
        if (this.mEvents.get((int)(this.mEvents.size() - 1)).mEvent == 0 || this.mEvents.get((int)(this.mEvents.size() - 1)).mEvent == 1) {
            throw new UnsupportedOperationException("Something went wrong, the last event is not an end event");
        }
    }

    private void updatePlayTime(Node parent, ArrayList<Node> visited) {
        if (parent.mChildNodes == null) {
            if (parent == this.mRootNode) {
                for (int i = 0; i < this.mNodes.size(); ++i) {
                    Node node = this.mNodes.get(i);
                    if (node == this.mRootNode) continue;
                    node.mStartTime = -1L;
                    node.mEndTime = -1L;
                }
            }
            return;
        }
        visited.add(parent);
        int childrenSize = parent.mChildNodes.size();
        for (int i = 0; i < childrenSize; ++i) {
            Node child = parent.mChildNodes.get(i);
            child.mTotalDuration = child.mAnimation.getTotalDuration();
            int index = visited.indexOf(child);
            if (index >= 0) {
                for (int j = index; j < visited.size(); ++j) {
                    visited.get((int)j).mLatestParent = null;
                    visited.get((int)j).mStartTime = -1L;
                    visited.get((int)j).mEndTime = -1L;
                }
                child.mStartTime = -1L;
                child.mEndTime = -1L;
                child.mLatestParent = null;
                Log.w(TAG, "Cycle found in AnimatorSet: " + this);
                continue;
            }
            if (child.mStartTime != -1L) {
                if (parent.mEndTime == -1L) {
                    child.mLatestParent = parent;
                    child.mStartTime = -1L;
                    child.mEndTime = -1L;
                } else {
                    if (parent.mEndTime >= child.mStartTime) {
                        child.mLatestParent = parent;
                        child.mStartTime = parent.mEndTime;
                    }
                    child.mEndTime = child.mTotalDuration == -1L ? -1L : child.mStartTime + child.mTotalDuration;
                }
            }
            this.updatePlayTime(child, visited);
        }
        visited.remove(parent);
    }

    private void findSiblings(Node node, ArrayList<Node> siblings) {
        if (!siblings.contains(node)) {
            siblings.add(node);
            if (node.mSiblings == null) {
                return;
            }
            for (int i = 0; i < node.mSiblings.size(); ++i) {
                this.findSiblings(node.mSiblings.get(i), siblings);
            }
        }
    }

    public boolean shouldPlayTogether() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mRootNode.mChildNodes == null || this.mRootNode.mChildNodes.size() == this.mNodes.size() - 1;
    }

    @Override
    public long getTotalDuration() {
        this.updateAnimatorsDuration();
        this.createDependencyGraph();
        return this.mTotalDuration;
    }

    private Node getNodeForAnimation(Animator anim2) {
        Node node = this.mNodeMap.get(anim2);
        if (node == null) {
            node = new Node(anim2);
            this.mNodeMap.put(anim2, node);
            this.mNodes.add(node);
        }
        return node;
    }

    public class Builder {
        private Node mCurrentNode;

        Builder(Animator anim2) {
            AnimatorSet.this.mDependencyDirty = true;
            this.mCurrentNode = AnimatorSet.this.getNodeForAnimation(anim2);
        }

        public Builder with(Animator anim2) {
            Node node = AnimatorSet.this.getNodeForAnimation(anim2);
            this.mCurrentNode.addSibling(node);
            return this;
        }

        public Builder before(Animator anim2) {
            Node node = AnimatorSet.this.getNodeForAnimation(anim2);
            this.mCurrentNode.addChild(node);
            return this;
        }

        public Builder after(Animator anim2) {
            Node node = AnimatorSet.this.getNodeForAnimation(anim2);
            this.mCurrentNode.addParent(node);
            return this;
        }

        public Builder after(long delay) {
            ValueAnimator anim2 = ValueAnimator.ofFloat(0.0f, 1.0f);
            anim2.setDuration(delay);
            this.after(anim2);
            return this;
        }
    }

    private class SeekState {
        private long mPlayTime = -1L;
        private boolean mSeekingInReverse = false;

        private SeekState() {
        }

        void reset() {
            this.mPlayTime = -1L;
            this.mSeekingInReverse = false;
        }

        void setPlayTime(long playTime, boolean inReverse) {
            if (AnimatorSet.this.getTotalDuration() != -1L) {
                this.mPlayTime = Math.min(playTime, AnimatorSet.this.getTotalDuration() - AnimatorSet.this.mStartDelay);
            }
            this.mPlayTime = Math.max(0L, this.mPlayTime);
            this.mSeekingInReverse = inReverse;
        }

        void updateSeekDirection(boolean inReverse) {
            if (inReverse && AnimatorSet.this.getTotalDuration() == -1L) {
                throw new UnsupportedOperationException("Error: Cannot reverse infinite animator set");
            }
            if (this.mPlayTime >= 0L && inReverse != this.mSeekingInReverse) {
                this.mPlayTime = AnimatorSet.this.getTotalDuration() - AnimatorSet.this.mStartDelay - this.mPlayTime;
                this.mSeekingInReverse = inReverse;
            }
        }

        long getPlayTime() {
            return this.mPlayTime;
        }

        long getPlayTimeNormalized() {
            if (AnimatorSet.this.mReversing) {
                return AnimatorSet.this.getTotalDuration() - AnimatorSet.this.mStartDelay - this.mPlayTime;
            }
            return this.mPlayTime;
        }

        boolean isActive() {
            return this.mPlayTime != -1L;
        }
    }

    private static class AnimationEvent {
        static final int ANIMATION_START = 0;
        static final int ANIMATION_DELAY_ENDED = 1;
        static final int ANIMATION_END = 2;
        final Node mNode;
        final int mEvent;

        AnimationEvent(Node node, int event) {
            this.mNode = node;
            this.mEvent = event;
        }

        long getTime() {
            if (this.mEvent == 0) {
                return this.mNode.mStartTime;
            }
            if (this.mEvent == 1) {
                return this.mNode.mStartTime == -1L ? -1L : this.mNode.mStartTime + this.mNode.mAnimation.getStartDelay();
            }
            return this.mNode.mEndTime;
        }

        public String toString() {
            String eventStr = this.mEvent == 0 ? "start" : (this.mEvent == 1 ? "delay ended" : "end");
            return eventStr + " " + this.mNode.mAnimation.toString();
        }
    }

    private static class Node
    implements Cloneable {
        Animator mAnimation;
        ArrayList<Node> mChildNodes = null;
        boolean mEnded = false;
        ArrayList<Node> mSiblings;
        ArrayList<Node> mParents;
        Node mLatestParent = null;
        boolean mParentsAdded = false;
        long mStartTime = 0L;
        long mEndTime = 0L;
        long mTotalDuration = 0L;

        public Node(Animator animation) {
            this.mAnimation = animation;
        }

        public Node clone() {
            try {
                Node node = (Node)super.clone();
                node.mAnimation = this.mAnimation.clone();
                if (this.mChildNodes != null) {
                    node.mChildNodes = new ArrayList<Node>(this.mChildNodes);
                }
                if (this.mSiblings != null) {
                    node.mSiblings = new ArrayList<Node>(this.mSiblings);
                }
                if (this.mParents != null) {
                    node.mParents = new ArrayList<Node>(this.mParents);
                }
                node.mEnded = false;
                return node;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }

        void addChild(Node node) {
            if (this.mChildNodes == null) {
                this.mChildNodes = new ArrayList();
            }
            if (!this.mChildNodes.contains(node)) {
                this.mChildNodes.add(node);
                node.addParent(this);
            }
        }

        public void addSibling(Node node) {
            if (this.mSiblings == null) {
                this.mSiblings = new ArrayList();
            }
            if (!this.mSiblings.contains(node)) {
                this.mSiblings.add(node);
                node.addSibling(this);
            }
        }

        public void addParent(Node node) {
            if (this.mParents == null) {
                this.mParents = new ArrayList();
            }
            if (!this.mParents.contains(node)) {
                this.mParents.add(node);
                node.addChild(this);
            }
        }

        public void addParents(ArrayList<Node> parents) {
            if (parents == null) {
                return;
            }
            int size = parents.size();
            for (int i = 0; i < size; ++i) {
                this.addParent(parents.get(i));
            }
        }
    }
}

