/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ArgbEvaluator;
import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.Keyframes;
import android.animation.ObjectAnimator;
import android.animation.PathKeyframes;
import android.animation.PropertyValuesHolder;
import android.animation.StateListAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ConfigurationBoundResourceCache;
import android.content.res.ConstantState;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.util.AttributeSet;
import android.util.Log;
import android.util.PathParser;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import android.view.InflateException;
import android.view.animation.AnimationUtils;
import android.view.animation.BaseInterpolator;
import android.view.animation.Interpolator;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimatorInflater {
    private static final String TAG = "AnimatorInflater";
    private static final int TOGETHER = 0;
    private static final int SEQUENTIALLY = 1;
    private static final int VALUE_TYPE_FLOAT = 0;
    private static final int VALUE_TYPE_INT = 1;
    private static final int VALUE_TYPE_PATH = 2;
    private static final int VALUE_TYPE_COLOR = 3;
    private static final int VALUE_TYPE_UNDEFINED = 4;
    private static final boolean DBG_ANIMATOR_INFLATER = false;
    private static final TypedValue sTmpTypedValue = new TypedValue();

    public static Animator loadAnimator(Context context, int id2) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(context.getResources(), context.getTheme(), id2);
    }

    public static Animator loadAnimator(Resources resources, Resources.Theme theme, int id2) throws Resources.NotFoundException {
        return AnimatorInflater.loadAnimator(resources, theme, id2, 1.0f);
    }

    public static Animator loadAnimator(Resources resources, Resources.Theme theme, int id2, float pathErrorScale) throws Resources.NotFoundException {
        ConfigurationBoundResourceCache<Animator> animatorCache = resources.getAnimatorCache();
        Animator animator2 = animatorCache.getInstance(id2, resources, theme);
        if (animator2 != null) {
            return animator2;
        }
        try (XmlResourceParser parser = null;){
            Object constantState;
            parser = resources.getAnimation(id2);
            animator2 = AnimatorInflater.createAnimatorFromXml(resources, theme, parser, pathErrorScale);
            if (animator2 != null) {
                animator2.appendChangingConfigurations(AnimatorInflater.getChangingConfigs(resources, id2));
                constantState = animator2.createConstantState();
                if (constantState != null) {
                    animatorCache.put((long)id2, theme, constantState);
                    animator2 = (Animator)((ConstantState)constantState).newInstance(resources, theme);
                }
            }
            constantState = animator2;
            return constantState;
        }
    }

    public static StateListAnimator loadStateListAnimator(Context context, int id2) throws Resources.NotFoundException {
        Resources.Theme theme;
        Resources resources = context.getResources();
        ConfigurationBoundResourceCache<StateListAnimator> cache = resources.getStateListAnimatorCache();
        StateListAnimator animator2 = cache.getInstance(id2, resources, theme = context.getTheme());
        if (animator2 != null) {
            return animator2;
        }
        try (XmlResourceParser parser = null;){
            Object constantState;
            parser = resources.getAnimation(id2);
            animator2 = AnimatorInflater.createStateListAnimatorFromXml(context, parser, Xml.asAttributeSet(parser));
            if (animator2 != null) {
                animator2.appendChangingConfigurations(AnimatorInflater.getChangingConfigs(resources, id2));
                constantState = animator2.createConstantState();
                if (constantState != null) {
                    cache.put((long)id2, theme, constantState);
                    animator2 = (StateListAnimator)((ConstantState)constantState).newInstance(resources, theme);
                }
            }
            constantState = animator2;
            return constantState;
        }
    }

    private static StateListAnimator createStateListAnimatorFromXml(Context context, XmlPullParser parser, AttributeSet attributeSet) throws IOException, XmlPullParserException {
        StateListAnimator stateListAnimator = new StateListAnimator();
        while (true) {
            int type = parser.next();
            switch (type) {
                case 1: 
                case 3: {
                    return stateListAnimator;
                }
                case 2: {
                    Animator animator2 = null;
                    if (!"item".equals(parser.getName())) break;
                    int attributeCount = parser.getAttributeCount();
                    int[] states = new int[attributeCount];
                    int stateIndex = 0;
                    for (int i = 0; i < attributeCount; ++i) {
                        int attrName = attributeSet.getAttributeNameResource(i);
                        if (attrName == 16843213) {
                            int animId = attributeSet.getAttributeResourceValue(i, 0);
                            animator2 = AnimatorInflater.loadAnimator(context, animId);
                            continue;
                        }
                        states[stateIndex++] = attributeSet.getAttributeBooleanValue(i, false) ? attrName : -attrName;
                    }
                    if (animator2 == null) {
                        animator2 = AnimatorInflater.createAnimatorFromXml(context.getResources(), context.getTheme(), parser, 1.0f);
                    }
                    if (animator2 == null) {
                        throw new Resources.NotFoundException("animation state item must have a valid animation");
                    }
                    stateListAnimator.addState(StateSet.trimStateSet(states, stateIndex), animator2);
                }
            }
        }
    }

    private static PropertyValuesHolder getPVH(TypedArray styledAttributes, int valueType, int valueFromId, int valueToId, String propertyName) {
        int toType;
        TypedValue tvFrom = styledAttributes.peekValue(valueFromId);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = styledAttributes.peekValue(valueToId);
        boolean hasTo = tvTo != null;
        int n = toType = hasTo ? tvTo.type : 0;
        if (valueType == 4) {
            valueType = hasFrom && AnimatorInflater.isColorType(fromType) || hasTo && AnimatorInflater.isColorType(toType) ? 3 : 0;
        }
        boolean getFloats = valueType == 0;
        PropertyValuesHolder returnValue = null;
        if (valueType == 2) {
            PathParser.PathData nodesTo;
            String fromString = styledAttributes.getString(valueFromId);
            String toString2 = styledAttributes.getString(valueToId);
            PathParser.PathData nodesFrom = fromString == null ? null : new PathParser.PathData(fromString);
            PathParser.PathData pathData = nodesTo = toString2 == null ? null : new PathParser.PathData(toString2);
            if (nodesFrom != null || nodesTo != null) {
                if (nodesFrom != null) {
                    PathDataEvaluator evaluator = new PathDataEvaluator();
                    if (nodesTo != null) {
                        if (!PathParser.canMorph(nodesFrom, nodesTo)) {
                            throw new InflateException(" Can't morph from " + fromString + " to " + toString2);
                        }
                        returnValue = PropertyValuesHolder.ofObject(propertyName, (TypeEvaluator)evaluator, nodesFrom, nodesTo);
                    } else {
                        returnValue = PropertyValuesHolder.ofObject(propertyName, (TypeEvaluator)evaluator, nodesFrom);
                    }
                } else if (nodesTo != null) {
                    PathDataEvaluator evaluator = new PathDataEvaluator();
                    returnValue = PropertyValuesHolder.ofObject(propertyName, (TypeEvaluator)evaluator, nodesTo);
                }
            }
        } else {
            ArgbEvaluator evaluator = null;
            if (valueType == 3) {
                evaluator = ArgbEvaluator.getInstance();
            }
            if (getFloats) {
                if (hasFrom) {
                    float valueFrom = fromType == 5 ? styledAttributes.getDimension(valueFromId, 0.0f) : styledAttributes.getFloat(valueFromId, 0.0f);
                    if (hasTo) {
                        float valueTo = toType == 5 ? styledAttributes.getDimension(valueToId, 0.0f) : styledAttributes.getFloat(valueToId, 0.0f);
                        returnValue = PropertyValuesHolder.ofFloat(propertyName, valueFrom, valueTo);
                    } else {
                        returnValue = PropertyValuesHolder.ofFloat(propertyName, valueFrom);
                    }
                } else {
                    float valueTo = toType == 5 ? styledAttributes.getDimension(valueToId, 0.0f) : styledAttributes.getFloat(valueToId, 0.0f);
                    returnValue = PropertyValuesHolder.ofFloat(propertyName, valueTo);
                }
            } else if (hasFrom) {
                int valueFrom = fromType == 5 ? (int)styledAttributes.getDimension(valueFromId, 0.0f) : (AnimatorInflater.isColorType(fromType) ? styledAttributes.getColor(valueFromId, 0) : styledAttributes.getInt(valueFromId, 0));
                if (hasTo) {
                    int valueTo = toType == 5 ? (int)styledAttributes.getDimension(valueToId, 0.0f) : (AnimatorInflater.isColorType(toType) ? styledAttributes.getColor(valueToId, 0) : styledAttributes.getInt(valueToId, 0));
                    returnValue = PropertyValuesHolder.ofInt(propertyName, valueFrom, valueTo);
                } else {
                    returnValue = PropertyValuesHolder.ofInt(propertyName, valueFrom);
                }
            } else if (hasTo) {
                int valueTo = toType == 5 ? (int)styledAttributes.getDimension(valueToId, 0.0f) : (AnimatorInflater.isColorType(toType) ? styledAttributes.getColor(valueToId, 0) : styledAttributes.getInt(valueToId, 0));
                returnValue = PropertyValuesHolder.ofInt(propertyName, valueTo);
            }
            if (returnValue != null && evaluator != null) {
                returnValue.setEvaluator(evaluator);
            }
        }
        return returnValue;
    }

    private static void parseAnimatorFromTypeArray(ValueAnimator anim2, TypedArray arrayAnimator, TypedArray arrayObjectAnimator, float pixelSize) {
        PropertyValuesHolder pvh;
        long duration = arrayAnimator.getInt(1, 300);
        long startDelay = arrayAnimator.getInt(2, 0);
        int valueType = arrayAnimator.getInt(7, 4);
        if (valueType == 4) {
            valueType = AnimatorInflater.inferValueTypeFromValues(arrayAnimator, 5, 6);
        }
        if ((pvh = AnimatorInflater.getPVH(arrayAnimator, valueType, 5, 6, "")) != null) {
            anim2.setValues(pvh);
        }
        anim2.setDuration(duration);
        anim2.setStartDelay(startDelay);
        if (arrayAnimator.hasValue(3)) {
            anim2.setRepeatCount(arrayAnimator.getInt(3, 0));
        }
        if (arrayAnimator.hasValue(4)) {
            anim2.setRepeatMode(arrayAnimator.getInt(4, 1));
        }
        if (arrayObjectAnimator != null) {
            AnimatorInflater.setupObjectAnimator(anim2, arrayObjectAnimator, valueType, pixelSize);
        }
    }

    private static TypeEvaluator setupAnimatorForPath(ValueAnimator anim2, TypedArray arrayAnimator) {
        PathParser.PathData pathDataTo;
        PathDataEvaluator evaluator = null;
        String fromString = arrayAnimator.getString(5);
        String toString2 = arrayAnimator.getString(6);
        PathParser.PathData pathDataFrom = fromString == null ? null : new PathParser.PathData(fromString);
        PathParser.PathData pathData = pathDataTo = toString2 == null ? null : new PathParser.PathData(toString2);
        if (pathDataFrom != null) {
            if (pathDataTo != null) {
                anim2.setObjectValues(pathDataFrom, pathDataTo);
                if (!PathParser.canMorph(pathDataFrom, pathDataTo)) {
                    throw new InflateException(arrayAnimator.getPositionDescription() + " Can't morph from " + fromString + " to " + toString2);
                }
            } else {
                anim2.setObjectValues(pathDataFrom);
            }
            evaluator = new PathDataEvaluator();
        } else if (pathDataTo != null) {
            anim2.setObjectValues(pathDataTo);
            evaluator = new PathDataEvaluator();
        }
        return evaluator;
    }

    private static void setupObjectAnimator(ValueAnimator anim2, TypedArray arrayObjectAnimator, int valueType, float pixelSize) {
        ObjectAnimator oa = (ObjectAnimator)anim2;
        String pathData = arrayObjectAnimator.getString(1);
        if (pathData != null) {
            Keyframes yKeyframes;
            Keyframes xKeyframes;
            String propertyXName = arrayObjectAnimator.getString(2);
            String propertyYName = arrayObjectAnimator.getString(3);
            if (valueType == 2 || valueType == 4) {
                valueType = 0;
            }
            if (propertyXName == null && propertyYName == null) {
                throw new InflateException(arrayObjectAnimator.getPositionDescription() + " propertyXName or propertyYName is needed for PathData");
            }
            Path path = PathParser.createPathFromPathData(pathData);
            float error = 0.5f * pixelSize;
            PathKeyframes keyframeSet = KeyframeSet.ofPath(path, error);
            if (valueType == 0) {
                xKeyframes = keyframeSet.createXFloatKeyframes();
                yKeyframes = keyframeSet.createYFloatKeyframes();
            } else {
                xKeyframes = keyframeSet.createXIntKeyframes();
                yKeyframes = keyframeSet.createYIntKeyframes();
            }
            PropertyValuesHolder x = null;
            PropertyValuesHolder y = null;
            if (propertyXName != null) {
                x = PropertyValuesHolder.ofKeyframes(propertyXName, xKeyframes);
            }
            if (propertyYName != null) {
                y = PropertyValuesHolder.ofKeyframes(propertyYName, yKeyframes);
            }
            if (x == null) {
                oa.setValues(y);
            } else if (y == null) {
                oa.setValues(x);
            } else {
                oa.setValues(x, y);
            }
        } else {
            String propertyName = arrayObjectAnimator.getString(0);
            oa.setPropertyName(propertyName);
        }
    }

    private static void setupValues(ValueAnimator anim2, TypedArray arrayAnimator, boolean getFloats, boolean hasFrom, int fromType, boolean hasTo, int toType) {
        int valueFromIndex = 5;
        int valueToIndex = 6;
        if (getFloats) {
            if (hasFrom) {
                float valueFrom = fromType == 5 ? arrayAnimator.getDimension(valueFromIndex, 0.0f) : arrayAnimator.getFloat(valueFromIndex, 0.0f);
                if (hasTo) {
                    float valueTo = toType == 5 ? arrayAnimator.getDimension(valueToIndex, 0.0f) : arrayAnimator.getFloat(valueToIndex, 0.0f);
                    anim2.setFloatValues(valueFrom, valueTo);
                } else {
                    anim2.setFloatValues(valueFrom);
                }
            } else {
                float valueTo = toType == 5 ? arrayAnimator.getDimension(valueToIndex, 0.0f) : arrayAnimator.getFloat(valueToIndex, 0.0f);
                anim2.setFloatValues(valueTo);
            }
        } else if (hasFrom) {
            int valueFrom = fromType == 5 ? (int)arrayAnimator.getDimension(valueFromIndex, 0.0f) : (AnimatorInflater.isColorType(fromType) ? arrayAnimator.getColor(valueFromIndex, 0) : arrayAnimator.getInt(valueFromIndex, 0));
            if (hasTo) {
                int valueTo = toType == 5 ? (int)arrayAnimator.getDimension(valueToIndex, 0.0f) : (AnimatorInflater.isColorType(toType) ? arrayAnimator.getColor(valueToIndex, 0) : arrayAnimator.getInt(valueToIndex, 0));
                anim2.setIntValues(valueFrom, valueTo);
            } else {
                anim2.setIntValues(valueFrom);
            }
        } else if (hasTo) {
            int valueTo = toType == 5 ? (int)arrayAnimator.getDimension(valueToIndex, 0.0f) : (AnimatorInflater.isColorType(toType) ? arrayAnimator.getColor(valueToIndex, 0) : arrayAnimator.getInt(valueToIndex, 0));
            anim2.setIntValues(valueTo);
        }
    }

    private static Animator createAnimatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser, float pixelSize) throws XmlPullParserException, IOException {
        return AnimatorInflater.createAnimatorFromXml(res, theme, parser, Xml.asAttributeSet(parser), null, 0, pixelSize);
    }

    private static Animator createAnimatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser, AttributeSet attrs, AnimatorSet parent, int sequenceOrdering, float pixelSize) throws XmlPullParserException, IOException {
        int type;
        Animator anim2 = null;
        ArrayList<Animator> childAnims = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            boolean gotValues = false;
            if (name.equals("objectAnimator")) {
                anim2 = AnimatorInflater.loadObjectAnimator(res, theme, attrs, pixelSize);
            } else if (name.equals("animator")) {
                anim2 = AnimatorInflater.loadAnimator(res, theme, attrs, null, pixelSize);
            } else if (name.equals("set")) {
                anim2 = new AnimatorSet();
                TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.AnimatorSet, 0, 0) : res.obtainAttributes(attrs, R.styleable.AnimatorSet);
                anim2.appendChangingConfigurations(a.getChangingConfigurations());
                int ordering = a.getInt(0, 0);
                AnimatorInflater.createAnimatorFromXml(res, theme, parser, attrs, (AnimatorSet)anim2, ordering, pixelSize);
                a.recycle();
            } else if (name.equals("propertyValuesHolder")) {
                PropertyValuesHolder[] values2 = AnimatorInflater.loadValues(res, theme, parser, Xml.asAttributeSet(parser));
                if (values2 != null && anim2 != null && anim2 instanceof ValueAnimator) {
                    ((ValueAnimator)anim2).setValues(values2);
                }
                gotValues = true;
            } else {
                throw new RuntimeException("Unknown animator name: " + parser.getName());
            }
            if (parent == null || gotValues) continue;
            if (childAnims == null) {
                childAnims = new ArrayList<Animator>();
            }
            childAnims.add(anim2);
        }
        if (parent != null && childAnims != null) {
            Animator[] animsArray = new Animator[childAnims.size()];
            int index = 0;
            for (Animator a : childAnims) {
                animsArray[index++] = a;
            }
            if (sequenceOrdering == 0) {
                parent.playTogether(animsArray);
            } else {
                parent.playSequentially(animsArray);
            }
        }
        return anim2;
    }

    private static PropertyValuesHolder[] loadValues(Resources res, Resources.Theme theme, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        ArrayList<PropertyValuesHolder> values2 = null;
        while ((type = parser.getEventType()) != 3 && type != 1) {
            if (type != 2) {
                parser.next();
                continue;
            }
            String name = parser.getName();
            if (name.equals("propertyValuesHolder")) {
                int valueType;
                TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.PropertyValuesHolder, 0, 0) : res.obtainAttributes(attrs, R.styleable.PropertyValuesHolder);
                String propertyName = a.getString(3);
                PropertyValuesHolder pvh = AnimatorInflater.loadPvh(res, theme, parser, propertyName, valueType = a.getInt(2, 4));
                if (pvh == null) {
                    pvh = AnimatorInflater.getPVH(a, valueType, 0, 1, propertyName);
                }
                if (pvh != null) {
                    if (values2 == null) {
                        values2 = new ArrayList<PropertyValuesHolder>();
                    }
                    values2.add(pvh);
                }
                a.recycle();
            }
            parser.next();
        }
        PropertyValuesHolder[] valuesArray = null;
        if (values2 != null) {
            int count = values2.size();
            valuesArray = new PropertyValuesHolder[count];
            for (int i = 0; i < count; ++i) {
                valuesArray[i] = (PropertyValuesHolder)values2.get(i);
            }
        }
        return valuesArray;
    }

    private static int inferValueTypeOfKeyframe(Resources res, Resources.Theme theme, AttributeSet attrs) {
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.Keyframe, 0, 0) : res.obtainAttributes(attrs, R.styleable.Keyframe);
        TypedValue keyframeValue = a.peekValue(0);
        boolean hasValue = keyframeValue != null;
        int valueType = hasValue && AnimatorInflater.isColorType(keyframeValue.type) ? 3 : 0;
        a.recycle();
        return valueType;
    }

    private static int inferValueTypeFromValues(TypedArray styledAttributes, int valueFromId, int valueToId) {
        TypedValue tvFrom = styledAttributes.peekValue(valueFromId);
        boolean hasFrom = tvFrom != null;
        int fromType = hasFrom ? tvFrom.type : 0;
        TypedValue tvTo = styledAttributes.peekValue(valueToId);
        boolean hasTo = tvTo != null;
        int toType = hasTo ? tvTo.type : 0;
        int valueType = hasFrom && AnimatorInflater.isColorType(fromType) || hasTo && AnimatorInflater.isColorType(toType) ? 3 : 0;
        return valueType;
    }

    private static void dumpKeyframes(Object[] keyframes, String header) {
        if (keyframes == null || keyframes.length == 0) {
            return;
        }
        Log.d(TAG, header);
        int count = keyframes.length;
        for (int i = 0; i < count; ++i) {
            Keyframe keyframe = (Keyframe)keyframes[i];
            Log.d(TAG, "Keyframe " + i + ": fraction " + (keyframe.getFraction() < 0.0f ? "null" : Float.valueOf(keyframe.getFraction())) + ", , value : " + (keyframe.hasValue() ? keyframe.getValue() : "null"));
        }
    }

    private static PropertyValuesHolder loadPvh(Resources res, Resources.Theme theme, XmlPullParser parser, String propertyName, int valueType) throws XmlPullParserException, IOException {
        int count;
        int type;
        PropertyValuesHolder value2 = null;
        ArrayList<Keyframe> keyframes = null;
        while ((type = parser.next()) != 3 && type != 1) {
            Keyframe keyframe;
            String name = parser.getName();
            if (!name.equals("keyframe")) continue;
            if (valueType == 4) {
                valueType = AnimatorInflater.inferValueTypeOfKeyframe(res, theme, Xml.asAttributeSet(parser));
            }
            if ((keyframe = AnimatorInflater.loadKeyframe(res, theme, Xml.asAttributeSet(parser), valueType)) != null) {
                if (keyframes == null) {
                    keyframes = new ArrayList<Keyframe>();
                }
                keyframes.add(keyframe);
            }
            parser.next();
        }
        if (keyframes != null && (count = keyframes.size()) > 0) {
            float startFraction;
            Keyframe firstKeyframe = (Keyframe)keyframes.get(0);
            Keyframe lastKeyframe = (Keyframe)keyframes.get(count - 1);
            float endFraction = lastKeyframe.getFraction();
            if (endFraction < 1.0f) {
                if (endFraction < 0.0f) {
                    lastKeyframe.setFraction(1.0f);
                } else {
                    keyframes.add(keyframes.size(), AnimatorInflater.createNewKeyframe(lastKeyframe, 1.0f));
                    ++count;
                }
            }
            if ((startFraction = firstKeyframe.getFraction()) != 0.0f) {
                if (startFraction < 0.0f) {
                    firstKeyframe.setFraction(0.0f);
                } else {
                    keyframes.add(0, AnimatorInflater.createNewKeyframe(firstKeyframe, 0.0f));
                    ++count;
                }
            }
            Keyframe[] keyframeArray = new Keyframe[count];
            keyframes.toArray(keyframeArray);
            for (int i = 0; i < count; ++i) {
                Keyframe keyframe = keyframeArray[i];
                if (!(keyframe.getFraction() < 0.0f)) continue;
                if (i == 0) {
                    keyframe.setFraction(0.0f);
                    continue;
                }
                if (i == count - 1) {
                    keyframe.setFraction(1.0f);
                    continue;
                }
                int startIndex = i;
                int endIndex = i;
                int j = startIndex + 1;
                while (j < count - 1 && !(keyframeArray[j].getFraction() >= 0.0f)) {
                    endIndex = j++;
                }
                float gap = keyframeArray[endIndex + 1].getFraction() - keyframeArray[startIndex - 1].getFraction();
                AnimatorInflater.distributeKeyframes(keyframeArray, gap, startIndex, endIndex);
            }
            value2 = PropertyValuesHolder.ofKeyframe(propertyName, keyframeArray);
            if (valueType == 3) {
                value2.setEvaluator(ArgbEvaluator.getInstance());
            }
        }
        return value2;
    }

    private static Keyframe createNewKeyframe(Keyframe sampleKeyframe, float fraction2) {
        return sampleKeyframe.getType() == Float.TYPE ? Keyframe.ofFloat(fraction2) : (sampleKeyframe.getType() == Integer.TYPE ? Keyframe.ofInt(fraction2) : Keyframe.ofObject(fraction2));
    }

    private static void distributeKeyframes(Keyframe[] keyframes, float gap, int startIndex, int endIndex) {
        int count = endIndex - startIndex + 2;
        float increment = gap / (float)count;
        for (int i = startIndex; i <= endIndex; ++i) {
            keyframes[i].setFraction(keyframes[i - 1].getFraction() + increment);
        }
    }

    private static Keyframe loadKeyframe(Resources res, Resources.Theme theme, AttributeSet attrs, int valueType) throws XmlPullParserException, IOException {
        boolean hasValue;
        TypedArray a = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.Keyframe, 0, 0) : res.obtainAttributes(attrs, R.styleable.Keyframe);
        Keyframe keyframe = null;
        float fraction2 = a.getFloat(3, -1.0f);
        TypedValue keyframeValue = a.peekValue(0);
        boolean bl = hasValue = keyframeValue != null;
        if (valueType == 4) {
            valueType = hasValue && AnimatorInflater.isColorType(keyframeValue.type) ? 3 : 0;
        }
        if (hasValue) {
            switch (valueType) {
                case 0: {
                    float value2 = a.getFloat(0, 0.0f);
                    keyframe = Keyframe.ofFloat(fraction2, value2);
                    break;
                }
                case 1: 
                case 3: {
                    int intValue = a.getInt(0, 0);
                    keyframe = Keyframe.ofInt(fraction2, intValue);
                }
            }
        } else {
            keyframe = valueType == 0 ? Keyframe.ofFloat(fraction2) : Keyframe.ofInt(fraction2);
        }
        int resID = a.getResourceId(1, 0);
        if (resID > 0) {
            Interpolator interpolator2 = AnimationUtils.loadInterpolator(res, theme, resID);
            keyframe.setInterpolator(interpolator2);
        }
        a.recycle();
        return keyframe;
    }

    private static ObjectAnimator loadObjectAnimator(Resources res, Resources.Theme theme, AttributeSet attrs, float pathErrorScale) throws Resources.NotFoundException {
        ObjectAnimator anim2 = new ObjectAnimator();
        AnimatorInflater.loadAnimator(res, theme, attrs, anim2, pathErrorScale);
        return anim2;
    }

    private static ValueAnimator loadAnimator(Resources res, Resources.Theme theme, AttributeSet attrs, ValueAnimator anim2, float pathErrorScale) throws Resources.NotFoundException {
        TypedArray arrayAnimator = null;
        TypedArray arrayObjectAnimator = null;
        arrayAnimator = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.Animator, 0, 0) : res.obtainAttributes(attrs, R.styleable.Animator);
        if (anim2 != null) {
            arrayObjectAnimator = theme != null ? theme.obtainStyledAttributes(attrs, R.styleable.PropertyAnimator, 0, 0) : res.obtainAttributes(attrs, R.styleable.PropertyAnimator);
            anim2.appendChangingConfigurations(arrayObjectAnimator.getChangingConfigurations());
        }
        if (anim2 == null) {
            anim2 = new ValueAnimator();
        }
        anim2.appendChangingConfigurations(arrayAnimator.getChangingConfigurations());
        AnimatorInflater.parseAnimatorFromTypeArray(anim2, arrayAnimator, arrayObjectAnimator, pathErrorScale);
        int resID = arrayAnimator.getResourceId(0, 0);
        if (resID > 0) {
            Interpolator interpolator2 = AnimationUtils.loadInterpolator(res, theme, resID);
            if (interpolator2 instanceof BaseInterpolator) {
                anim2.appendChangingConfigurations(((BaseInterpolator)interpolator2).getChangingConfiguration());
            }
            anim2.setInterpolator(interpolator2);
        }
        arrayAnimator.recycle();
        if (arrayObjectAnimator != null) {
            arrayObjectAnimator.recycle();
        }
        return anim2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getChangingConfigs(Resources resources, int id2) {
        TypedValue typedValue = sTmpTypedValue;
        synchronized (typedValue) {
            resources.getValue(id2, sTmpTypedValue, true);
            return AnimatorInflater.sTmpTypedValue.changingConfigurations;
        }
    }

    private static boolean isColorType(int type) {
        return type >= 28 && type <= 31;
    }

    private static class PathDataEvaluator
    implements TypeEvaluator<PathParser.PathData> {
        private final PathParser.PathData mPathData = new PathParser.PathData();

        private PathDataEvaluator() {
        }

        @Override
        public PathParser.PathData evaluate(float fraction2, PathParser.PathData startPathData, PathParser.PathData endPathData) {
            if (!PathParser.interpolatePathData(this.mPathData, startPathData, endPathData, fraction2)) {
                throw new IllegalArgumentException("Can't interpolate between two incompatible pathData");
            }
            return this.mPathData;
        }
    }
}

