/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.io.usethesource.capsule.util;

public final class BitmapUtils {
    private static final boolean USE_SELF_WRITTEN_POPULATION_COUNT = false;
    private static final boolean USE_SELF_WRITTEN_POPULATION_COUNT_CHECK = false;

    public static final long filter00(long bitmap) {
        return (bitmap & 0x5555555555555555L ^ 0x5555555555555555L) & (bitmap >> 1 & 0x5555555555555555L ^ 0x5555555555555555L);
    }

    public static final long filter01(long bitmap) {
        return bitmap & 0x5555555555555555L & (bitmap >> 1 & 0x5555555555555555L ^ 0x5555555555555555L);
    }

    public static final long filter10(long bitmap) {
        return (bitmap & 0x5555555555555555L ^ 0x5555555555555555L) & (bitmap >> 1 & 0x5555555555555555L);
    }

    public static final long filter11(long bitmap) {
        return bitmap & 0x5555555555555555L & (bitmap >> 1 & 0x5555555555555555L);
    }

    public static final long filter(long bitmap, int pattern) {
        switch (pattern) {
            case 0: {
                return BitmapUtils.filter00(bitmap);
            }
            case 1: {
                return BitmapUtils.filter01(bitmap);
            }
            case 2: {
                return BitmapUtils.filter10(bitmap);
            }
            case 3: {
                return BitmapUtils.filter11(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    public static final int index(long bitmap, int pattern, long bitpos) {
        return Long.bitCount(BitmapUtils.filter(bitmap, pattern) & bitpos - 1L);
    }

    public static final int index01(long bitmap, long bitpos) {
        long filteredBitmap = BitmapUtils.filter01(bitmap);
        int index = Long.bitCount(filteredBitmap & bitpos - 1L);
        return index;
    }

    public static final int index10(long bitmap, long bitpos) {
        long filteredBitmap = BitmapUtils.filter10(bitmap);
        int index = Long.bitCount(filteredBitmap & bitpos - 1L);
        return index;
    }

    public static final int index11(long bitmap, long bitpos) {
        long filteredBitmap = BitmapUtils.filter11(bitmap);
        int index = Long.bitCount(filteredBitmap & bitpos - 1L);
        return index;
    }

    public static final long populationCountPattern00(long v) {
        long c = (v & 0x5555555555555555L ^ 0x5555555555555555L) & (v >> 1 & 0x5555555555555555L ^ 0x5555555555555555L);
        c = (c & 0x3333333333333333L) + (c >> 2 & 0x3333333333333333L);
        c = (c & 0xF0F0F0F0F0F0F0FL) + (c >> 4 & 0xF0F0F0F0F0F0F0FL);
        c = (c & 0xFF00FF00FF00FFL) + (c >> 8 & 0xFF00FF00FF00FFL);
        c = (c & 0xFFFF0000FFFFL) + (c >> 16 & 0xFFFF0000FFFFL);
        return c;
    }

    public static final long populationCountPattern01(long v) {
        long c = v & 0x5555555555555555L & (v >> 1 & 0x5555555555555555L ^ 0x5555555555555555L);
        c = (c & 0x3333333333333333L) + (c >> 2 & 0x3333333333333333L);
        c = (c & 0xF0F0F0F0F0F0F0FL) + (c >> 4 & 0xF0F0F0F0F0F0F0FL);
        c = (c & 0xFF00FF00FF00FFL) + (c >> 8 & 0xFF00FF00FF00FFL);
        c = (c & 0xFFFF0000FFFFL) + (c >> 16 & 0xFFFF0000FFFFL);
        return c;
    }

    public static final long populationCountPattern10(long v) {
        long c = (v & 0x5555555555555555L ^ 0x5555555555555555L) & (v >> 1 & 0x5555555555555555L);
        c = (c & 0x3333333333333333L) + (c >> 2 & 0x3333333333333333L);
        c = (c & 0xF0F0F0F0F0F0F0FL) + (c >> 4 & 0xF0F0F0F0F0F0F0FL);
        c = (c & 0xFF00FF00FF00FFL) + (c >> 8 & 0xFF00FF00FF00FFL);
        c = (c & 0xFFFF0000FFFFL) + (c >> 16 & 0xFFFF0000FFFFL);
        return c;
    }

    public static final long populationCountPattern11(long v) {
        long c = v & 0x5555555555555555L & (v >> 1 & 0x5555555555555555L);
        c = (c & 0x3333333333333333L) + (c >> 2 & 0x3333333333333333L);
        c = (c & 0xF0F0F0F0F0F0F0FL) + (c >> 4 & 0xF0F0F0F0F0F0F0FL);
        c = (c & 0xFF00FF00FF00FFL) + (c >> 8 & 0xFF00FF00FF00FFL);
        c = (c & 0xFFFF0000FFFFL) + (c >> 16 & 0xFFFF0000FFFFL);
        return c;
    }

    public static boolean isBitInBitmap(byte bitmap, byte bitpos) {
        return bitmap != 0 && (bitmap == -1 || (bitmap & bitpos) != 0);
    }

    public static boolean isBitInBitmap(int bitmap, int bitpos) {
        return bitmap != 0 && (bitmap == -1 || (bitmap & bitpos) != 0);
    }
}

