/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.io.usethesource.capsule.core;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.impldep.io.usethesource.capsule.Map;
import org.gradle.internal.impldep.io.usethesource.capsule.core.trie.ArrayView;
import org.gradle.internal.impldep.io.usethesource.capsule.core.trie.MapNode;
import org.gradle.internal.impldep.io.usethesource.capsule.core.trie.MapNodeResult;
import org.gradle.internal.impldep.io.usethesource.capsule.util.EqualityComparator;
import org.gradle.internal.impldep.io.usethesource.capsule.util.collection.AbstractSpecialisedImmutableMap;

public class PersistentTrieMap<K, V>
implements Map.Immutable<K, V>,
Serializable {
    private static final long serialVersionUID = 42L;
    private static final CompactMapNode EMPTY_NODE = new BitmapIndexedMapNode(null, 0, 0, new Object[0]);
    private static final PersistentTrieMap EMPTY_MAP = new PersistentTrieMap(EMPTY_NODE, 0, 0);
    private static final boolean DEBUG = false;
    private final AbstractMapNode<K, V> rootNode;
    private final int cachedHashCode;
    private final int cachedSize;

    PersistentTrieMap(AbstractMapNode<K, V> rootNode, int cachedHashCode, int cachedSize) {
        this.rootNode = rootNode;
        this.cachedHashCode = cachedHashCode;
        this.cachedSize = cachedSize;
    }

    public static final <K, V> Map.Immutable<K, V> of() {
        return EMPTY_MAP;
    }

    public static final <K, V> Map.Immutable<K, V> of(Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Length of argument list is uneven: no key/value pairs.");
        }
        Map.Immutable<Object, Object> result = EMPTY_MAP;
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Object key = keyValuePairs[i];
            Object val = keyValuePairs[i + 1];
            result = result.__put(key, val);
        }
        return result;
    }

    public static final <K, V> Map.Transient<K, V> transientOf() {
        return EMPTY_MAP.asTransient();
    }

    public static final <K, V> Map.Transient<K, V> transientOf(Object ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Length of argument list is uneven: no key/value pairs.");
        }
        Map.Transient<Object, Object> result = EMPTY_MAP.asTransient();
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            Object key = keyValuePairs[i];
            Object val = keyValuePairs[i + 1];
            result.__put(key, val);
        }
        return result;
    }

    private boolean checkHashCodeAndSize(int targetHash, int targetSize) {
        int hash = 0;
        int size = 0;
        Iterator<Map.Entry<K, V>> it = this.entryIterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            K key = entry.getKey();
            V val = entry.getValue();
            hash += key.hashCode() ^ val.hashCode();
            ++size;
        }
        return hash == targetHash && size == targetSize;
    }

    public static final int transformHashCode(int hash) {
        return hash;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.containsKeyEquivalent(o, Object::equals);
    }

    @Override
    public boolean containsKeyEquivalent(Object o, EqualityComparator<Object> cmp) {
        try {
            Object key = o;
            return this.rootNode.containsKey(key, PersistentTrieMap.transformHashCode(key.hashCode()), 0, cmp);
        }
        catch (ClassCastException unused) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object o) {
        return this.containsValueEquivalent(o, Object::equals);
    }

    @Override
    public boolean containsValueEquivalent(Object o, EqualityComparator<Object> cmp) {
        Iterator<V> iterator = this.valueIterator();
        while (iterator.hasNext()) {
            if (!cmp.equals(iterator.next(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object o) {
        return this.getEquivalent(o, Object::equals);
    }

    @Override
    public V getEquivalent(Object o, EqualityComparator<Object> cmp) {
        try {
            Object key = o;
            Optional result = this.rootNode.findByKey(key, PersistentTrieMap.transformHashCode(key.hashCode()), 0, cmp);
            if (result.isPresent()) {
                return result.get();
            }
            return null;
        }
        catch (ClassCastException unused) {
            return null;
        }
    }

    @Override
    public Map.Immutable<K, V> __put(K key, V val) {
        return this.__putEquivalent(key, val, Object::equals);
    }

    @Override
    public Map.Immutable<K, V> __putEquivalent(K key, V val, EqualityComparator<Object> cmp) {
        int keyHash = key.hashCode();
        MapNodeResult details = MapNodeResult.unchanged();
        AbstractMapNode newRootNode = (AbstractMapNode)this.rootNode.updated(null, key, val, PersistentTrieMap.transformHashCode(keyHash), 0, details, cmp);
        if (details.isModified()) {
            if (details.hasReplacedValue()) {
                int valHashOld = details.getReplacedValue().hashCode();
                int valHashNew = val.hashCode();
                return new PersistentTrieMap<K, V>(newRootNode, this.cachedHashCode + (keyHash ^ valHashNew) - (keyHash ^ valHashOld), this.cachedSize);
            }
            int valHash = val.hashCode();
            return new PersistentTrieMap<K, V>(newRootNode, this.cachedHashCode + (keyHash ^ valHash), this.cachedSize + 1);
        }
        return this;
    }

    @Override
    public Map.Immutable<K, V> __putAll(Map<? extends K, ? extends V> map) {
        return this.__putAllEquivalent(map, Object::equals);
    }

    @Override
    public Map.Immutable<K, V> __putAllEquivalent(Map<? extends K, ? extends V> map, EqualityComparator<Object> cmp) {
        Map.Transient<? extends K, ? extends V> tmpTransient = this.asTransient();
        tmpTransient.__putAllEquivalent(map, cmp);
        return tmpTransient.freeze();
    }

    @Override
    public Map.Immutable<K, V> __remove(K key) {
        return this.__removeEquivalent(key, Object::equals);
    }

    @Override
    public Map.Immutable<K, V> __removeEquivalent(K key, EqualityComparator<Object> cmp) {
        int keyHash = key.hashCode();
        MapNodeResult details = MapNodeResult.unchanged();
        AbstractMapNode newRootNode = (AbstractMapNode)this.rootNode.removed(null, key, PersistentTrieMap.transformHashCode(keyHash), 0, details, cmp);
        if (details.isModified()) {
            assert (details.hasReplacedValue());
            int valHash = details.getReplacedValue().hashCode();
            return new PersistentTrieMap<K, V>(newRootNode, this.cachedHashCode - (keyHash ^ valHash), this.cachedSize - 1);
        }
        return this;
    }

    @Override
    public V put(K key, V val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.cachedSize;
    }

    @Override
    public boolean isEmpty() {
        return this.cachedSize == 0;
    }

    @Override
    public Iterator<K> keyIterator() {
        return new MapKeyIterator<K, V>(this.rootNode);
    }

    @Override
    public Iterator<V> valueIterator() {
        return new MapValueIterator<K, V>(this.rootNode);
    }

    @Override
    public Iterator<Map.Entry<K, V>> entryIterator() {
        return new MapEntryIterator<K, V>(this.rootNode);
    }

    @Override
    public Set<K> keySet() {
        AbstractSet keySet = null;
        if (keySet == null) {
            keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return PersistentTrieMap.this.keyIterator();
                }

                @Override
                public int size() {
                    return PersistentTrieMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return PersistentTrieMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    PersistentTrieMap.this.clear();
                }

                @Override
                public boolean contains(Object k) {
                    return PersistentTrieMap.this.containsKey(k);
                }
            };
        }
        return keySet;
    }

    @Override
    public Collection<V> values() {
        AbstractCollection values = null;
        if (values == null) {
            values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return PersistentTrieMap.this.valueIterator();
                }

                @Override
                public int size() {
                    return PersistentTrieMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return PersistentTrieMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    PersistentTrieMap.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return PersistentTrieMap.this.containsValue(v);
                }
            };
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        AbstractSet entrySet = null;
        if (entrySet == null) {
            entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private final Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = PersistentTrieMap.this.entryIterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            return this.i.next();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return PersistentTrieMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return PersistentTrieMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    PersistentTrieMap.this.clear();
                }

                @Override
                public boolean contains(Object k) {
                    return PersistentTrieMap.this.containsKey(k);
                }
            };
        }
        return entrySet;
    }

    @Override
    public boolean equals(Object other) {
        return this.equivalent(other, Object::equals);
    }

    @Override
    public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof PersistentTrieMap) {
            PersistentTrieMap that = (PersistentTrieMap)other;
            if (this.cachedSize != that.cachedSize) {
                return false;
            }
            if (this.cachedHashCode != that.cachedHashCode) {
                return false;
            }
            return this.rootNode.equivalent(that.rootNode, cmp);
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (this.size() != that.size()) {
                return false;
            }
            for (Map.Entry entry : that.entrySet()) {
                try {
                    Object key = entry.getKey();
                    Optional result = this.rootNode.findByKey(key, PersistentTrieMap.transformHashCode(key.hashCode()), 0, cmp);
                    if (!result.isPresent()) {
                        return false;
                    }
                    Object val = entry.getValue();
                    if (cmp.equals(result.get(), val)) continue;
                    return false;
                }
                catch (ClassCastException unused) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.cachedHashCode;
    }

    public String toString() {
        String body = this.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).reduce((o1, o2) -> String.join((CharSequence)", ", o1, o2)).orElse("");
        return String.format("{%s}", body);
    }

    @Override
    public boolean isTransientSupported() {
        return true;
    }

    @Override
    public Map.Transient<K, V> asTransient() {
        return new TransientTrieMap(this);
    }

    protected AbstractMapNode<K, V> getRootNode() {
        return this.rootNode;
    }

    protected Iterator<AbstractMapNode<K, V>> nodeIterator() {
        return new TrieMapNodeIterator<K, V>(this.rootNode);
    }

    protected int getNodeCount() {
        Iterator<AbstractMapNode<K, V>> it = this.nodeIterator();
        int sumNodes = 0;
        while (it.hasNext()) {
            ++sumNodes;
            it.next();
        }
        return sumNodes;
    }

    protected int[][] arityCombinationsHistogram() {
        Iterator<AbstractMapNode<K, V>> it = this.nodeIterator();
        int[][] sumArityCombinations = new int[33][33];
        while (it.hasNext()) {
            AbstractMapNode<K, V> node = it.next();
            int[] nArray = sumArityCombinations[node.payloadArity()];
            int n = node.nodeArity();
            nArray[n] = nArray[n] + 1;
        }
        return sumArityCombinations;
    }

    protected int[] arityHistogram() {
        int[][] sumArityCombinations = this.arityCombinationsHistogram();
        int[] sumArity = new int[33];
        int maxArity = 32;
        for (int j = 0; j <= 32; ++j) {
            int maxRestArity = 32 - j;
            for (int k = 0; k <= maxRestArity - j; ++k) {
                int n = j + k;
                sumArity[n] = sumArity[n] + sumArityCombinations[j][k];
            }
        }
        return sumArity;
    }

    public void printStatistics() {
        int i;
        int[][] sumArityCombinations = this.arityCombinationsHistogram();
        int[] sumArity = this.arityHistogram();
        int sumNodes = this.getNodeCount();
        int[] cumsumArity = new int[33];
        int cumsum = 0;
        for (i = 0; i < 33; ++i) {
            cumsumArity[i] = cumsum += sumArity[i];
        }
        float threshhold = 0.01f;
        for (i = 0; i < 33; ++i) {
            float arityPercentage = (float)sumArity[i] / (float)sumNodes;
            float cumsumArityPercentage = (float)cumsumArity[i] / (float)sumNodes;
            if (arityPercentage == 0.0f || !(arityPercentage >= 0.01f)) continue;
            StringBuilder bldr = new StringBuilder();
            int max = i;
            for (int j = 0; j <= max; ++j) {
                for (int k = max - j; k <= max - j; ++k) {
                    float arityCombinationsPercentage = (float)sumArityCombinations[j][k] / (float)sumNodes;
                    if (arityCombinationsPercentage == 0.0f || !(arityCombinationsPercentage >= 0.01f)) continue;
                    bldr.append(String.format("%d/%d: %s, ", j, k, new DecimalFormat("0.00%").format(arityCombinationsPercentage)));
                }
            }
            String detailPercentages = bldr.toString();
            System.out.println(String.format("%2d: %s\t[cumsum = %s]\t%s", i, new DecimalFormat("0.00%").format(arityPercentage), new DecimalFormat("0.00%").format(cumsumArityPercentage), detailPercentages));
        }
    }

    static final class TransientTrieMap<K, V>
    implements Map.Transient<K, V> {
        private final AtomicReference<Thread> mutator = new AtomicReference<Thread>(Thread.currentThread());
        private AbstractMapNode<K, V> rootNode;
        private int cachedHashCode;
        private int cachedSize;

        TransientTrieMap(PersistentTrieMap<K, V> trieMap) {
            this.rootNode = ((PersistentTrieMap)trieMap).rootNode;
            this.cachedHashCode = ((PersistentTrieMap)trieMap).cachedHashCode;
            this.cachedSize = ((PersistentTrieMap)trieMap).cachedSize;
        }

        private boolean checkHashCodeAndSize(int targetHash, int targetSize) {
            int hash = 0;
            int size = 0;
            Iterator<Map.Entry<K, V>> it = this.entryIterator();
            while (it.hasNext()) {
                Map.Entry<K, V> entry = it.next();
                K key = entry.getKey();
                V val = entry.getValue();
                hash += key.hashCode() ^ val.hashCode();
                ++size;
            }
            return hash == targetHash && size == targetSize;
        }

        @Override
        public V put(K key, V val) {
            return this.__put(key, val);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.containsKeyEquivalent(o, Object::equals);
        }

        @Override
        public boolean containsKeyEquivalent(Object o, EqualityComparator<Object> cmp) {
            try {
                Object key = o;
                return this.rootNode.containsKey(key, PersistentTrieMap.transformHashCode(key.hashCode()), 0, cmp);
            }
            catch (ClassCastException unused) {
                return false;
            }
        }

        @Override
        public boolean containsValue(Object o) {
            return this.containsValueEquivalent(o, Object::equals);
        }

        @Override
        public boolean containsValueEquivalent(Object o, EqualityComparator<Object> cmp) {
            Iterator<V> iterator = this.valueIterator();
            while (iterator.hasNext()) {
                if (!cmp.equals(iterator.next(), o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public V get(Object o) {
            return this.getEquivalent(o, Object::equals);
        }

        @Override
        public V getEquivalent(Object o, EqualityComparator<Object> cmp) {
            try {
                Object key = o;
                Optional result = this.rootNode.findByKey(key, PersistentTrieMap.transformHashCode(key.hashCode()), 0, cmp);
                if (result.isPresent()) {
                    return result.get();
                }
                return null;
            }
            catch (ClassCastException unused) {
                return null;
            }
        }

        @Override
        public V __put(K key, V val) {
            return this.__putEquivalent(key, val, Object::equals);
        }

        @Override
        public V __putEquivalent(K key, V val, EqualityComparator<Object> cmp) {
            if (this.mutator.get() == null) {
                throw new IllegalStateException("Transient already frozen.");
            }
            int keyHash = key.hashCode();
            MapNodeResult details = MapNodeResult.unchanged();
            AbstractMapNode newRootNode = (AbstractMapNode)this.rootNode.updated(this.mutator, key, val, PersistentTrieMap.transformHashCode(keyHash), 0, details, cmp);
            if (details.isModified()) {
                if (details.hasReplacedValue()) {
                    Object old = details.getReplacedValue();
                    int valHashOld = old.hashCode();
                    int valHashNew = val.hashCode();
                    this.rootNode = newRootNode;
                    this.cachedHashCode = this.cachedHashCode + (keyHash ^ valHashNew) - (keyHash ^ valHashOld);
                    return details.getReplacedValue();
                }
                int valHashNew = val.hashCode();
                this.rootNode = newRootNode;
                this.cachedHashCode += keyHash ^ valHashNew;
                ++this.cachedSize;
                return null;
            }
            return null;
        }

        @Override
        public boolean __putAll(Map<? extends K, ? extends V> map) {
            return this.__putAllEquivalent(map, Object::equals);
        }

        @Override
        public boolean __putAllEquivalent(Map<? extends K, ? extends V> map, EqualityComparator<Object> cmp) {
            boolean modified = false;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                boolean isPresent = this.containsKeyEquivalent(entry.getKey(), cmp);
                V replaced = this.__putEquivalent(entry.getKey(), entry.getValue(), cmp);
                if (isPresent && replaced == null) continue;
                modified = true;
            }
            return modified;
        }

        @Override
        public V __remove(K key) {
            return this.__removeEquivalent(key, Object::equals);
        }

        @Override
        public V __removeEquivalent(K key, EqualityComparator<Object> cmp) {
            if (this.mutator.get() == null) {
                throw new IllegalStateException("Transient already frozen.");
            }
            int keyHash = key.hashCode();
            MapNodeResult details = MapNodeResult.unchanged();
            AbstractMapNode newRootNode = (AbstractMapNode)this.rootNode.removed(this.mutator, key, PersistentTrieMap.transformHashCode(keyHash), 0, details, cmp);
            if (details.isModified()) {
                assert (details.hasReplacedValue());
                int valHash = details.getReplacedValue().hashCode();
                this.rootNode = newRootNode;
                this.cachedHashCode -= keyHash ^ valHash;
                --this.cachedSize;
                return details.getReplacedValue();
            }
            return null;
        }

        @Override
        public int size() {
            return this.cachedSize;
        }

        @Override
        public boolean isEmpty() {
            return this.cachedSize == 0;
        }

        @Override
        public Iterator<K> keyIterator() {
            return new TransientMapKeyIterator(this);
        }

        @Override
        public Iterator<V> valueIterator() {
            return new TransientMapValueIterator(this);
        }

        @Override
        public Iterator<Map.Entry<K, V>> entryIterator() {
            return new TransientMapEntryIterator(this);
        }

        @Override
        public Set<K> keySet() {
            AbstractSet keySet = null;
            if (keySet == null) {
                keySet = new AbstractSet<K>(){

                    @Override
                    public Iterator<K> iterator() {
                        return this.keyIterator();
                    }

                    @Override
                    public int size() {
                        return this.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return this.isEmpty();
                    }

                    @Override
                    public void clear() {
                        this.clear();
                    }

                    @Override
                    public boolean contains(Object k) {
                        return this.containsKey(k);
                    }
                };
            }
            return keySet;
        }

        @Override
        public Collection<V> values() {
            AbstractCollection values = null;
            if (values == null) {
                values = new AbstractCollection<V>(){

                    @Override
                    public Iterator<V> iterator() {
                        return this.valueIterator();
                    }

                    @Override
                    public int size() {
                        return this.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return this.isEmpty();
                    }

                    @Override
                    public void clear() {
                        this.clear();
                    }

                    @Override
                    public boolean contains(Object v) {
                        return this.containsValue(v);
                    }
                };
            }
            return values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            AbstractSet entrySet = null;
            if (entrySet == null) {
                entrySet = new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return new Iterator<Map.Entry<K, V>>(){
                            private final Iterator<Map.Entry<K, V>> i;
                            {
                                this.i = this.entryIterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.i.hasNext();
                            }

                            @Override
                            public Map.Entry<K, V> next() {
                                return this.i.next();
                            }

                            @Override
                            public void remove() {
                                this.i.remove();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return this.size();
                    }

                    @Override
                    public boolean isEmpty() {
                        return this.isEmpty();
                    }

                    @Override
                    public void clear() {
                        this.clear();
                    }

                    @Override
                    public boolean contains(Object k) {
                        return this.containsKey(k);
                    }
                };
            }
            return entrySet;
        }

        @Override
        public boolean equals(Object other) {
            return this.equivalent(other, Object::equals);
        }

        @Override
        public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (other instanceof TransientTrieMap) {
                TransientTrieMap that = (TransientTrieMap)other;
                if (this.cachedSize != that.cachedSize) {
                    return false;
                }
                if (this.cachedHashCode != that.cachedHashCode) {
                    return false;
                }
                return this.rootNode.equivalent(that.rootNode, cmp);
            }
            if (other instanceof Map) {
                Map that = (Map)other;
                if (this.size() != that.size()) {
                    return false;
                }
                for (Map.Entry entry : that.entrySet()) {
                    try {
                        Object key = entry.getKey();
                        Optional result = this.rootNode.findByKey(key, PersistentTrieMap.transformHashCode(key.hashCode()), 0, cmp);
                        if (!result.isPresent()) {
                            return false;
                        }
                        Object val = entry.getValue();
                        if (cmp.equals(result.get(), val)) continue;
                        return false;
                    }
                    catch (ClassCastException unused) {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.cachedHashCode;
        }

        @Override
        public Map.Immutable<K, V> freeze() {
            if (this.mutator.get() == null) {
                throw new IllegalStateException("Transient already frozen.");
            }
            this.mutator.set(null);
            return new PersistentTrieMap<K, V>(this.rootNode, this.cachedHashCode, this.cachedSize);
        }

        public static class TransientMapEntryIterator<K, V>
        extends MapEntryIterator<K, V> {
            final TransientTrieMap<K, V> collection;

            public TransientMapEntryIterator(TransientTrieMap<K, V> collection) {
                super(((TransientTrieMap)collection).rootNode);
                this.collection = collection;
            }

            @Override
            public Map.Entry<K, V> next() {
                return super.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        public static class TransientMapValueIterator<K, V>
        extends MapValueIterator<K, V> {
            final TransientTrieMap<K, V> collection;

            public TransientMapValueIterator(TransientTrieMap<K, V> collection) {
                super(((TransientTrieMap)collection).rootNode);
                this.collection = collection;
            }

            @Override
            public V next() {
                return super.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        public static class TransientMapKeyIterator<K, V>
        extends MapKeyIterator<K, V> {
            final TransientTrieMap<K, V> collection;
            K lastKey;

            public TransientMapKeyIterator(TransientTrieMap<K, V> collection) {
                super(((TransientTrieMap)collection).rootNode);
                this.collection = collection;
            }

            @Override
            public K next() {
                this.lastKey = super.next();
                return this.lastKey;
            }

            @Override
            public void remove() {
                this.collection.__remove(this.lastKey);
            }
        }
    }

    private static class TrieMapNodeIterator<K, V>
    implements Iterator<AbstractMapNode<K, V>> {
        final Deque<Iterator<? extends AbstractMapNode<K, V>>> nodeIteratorStack = new ArrayDeque<Iterator<? extends AbstractMapNode<K, V>>>();

        TrieMapNodeIterator(AbstractMapNode<K, V> rootNode) {
            this.nodeIteratorStack.push(Collections.singleton(rootNode).iterator());
        }

        @Override
        public boolean hasNext() {
            while (!this.nodeIteratorStack.isEmpty()) {
                if (this.nodeIteratorStack.peek().hasNext()) {
                    return true;
                }
                this.nodeIteratorStack.pop();
            }
            return false;
        }

        @Override
        public AbstractMapNode<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AbstractMapNode<K, V> innerNode = this.nodeIteratorStack.peek().next();
            if (innerNode.hasNodes()) {
                this.nodeIteratorStack.push(innerNode.nodeIterator());
            }
            return innerNode;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static class MapEntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        MapEntryIterator(AbstractMapNode<K, V> rootNode) {
            super(rootNode);
        }

        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentValueNode.getKeyValueEntry(this.currentValueCursor++);
        }
    }

    protected static class MapValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<V> {
        MapValueIterator(AbstractMapNode<K, V> rootNode) {
            super(rootNode);
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentValueNode.getValue(this.currentValueCursor++);
        }
    }

    protected static class MapKeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements Iterator<K> {
        MapKeyIterator(AbstractMapNode<K, V> rootNode) {
            super(rootNode);
        }

        @Override
        public K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentValueNode.getKey(this.currentValueCursor++);
        }
    }

    private static abstract class AbstractMapIterator<K, V> {
        private static final int MAX_DEPTH = 7;
        protected int currentValueCursor;
        protected int currentValueLength;
        protected AbstractMapNode<K, V> currentValueNode;
        private int currentStackLevel = -1;
        private final int[] nodeCursorsAndLengths = new int[14];
        AbstractMapNode<K, V>[] nodes = new AbstractMapNode[7];

        AbstractMapIterator(AbstractMapNode<K, V> rootNode) {
            if (rootNode.hasNodes()) {
                this.currentStackLevel = 0;
                this.nodes[0] = rootNode;
                this.nodeCursorsAndLengths[0] = 0;
                this.nodeCursorsAndLengths[1] = rootNode.nodeArity();
            }
            if (rootNode.hasPayload()) {
                this.currentValueNode = rootNode;
                this.currentValueCursor = 0;
                this.currentValueLength = rootNode.payloadArity();
            }
        }

        private boolean searchNextValueNode() {
            while (this.currentStackLevel >= 0) {
                int currentCursorIndex = this.currentStackLevel * 2;
                int nodeCursor = this.nodeCursorsAndLengths[currentCursorIndex];
                int currentLengthIndex = currentCursorIndex + 1;
                int nodeLength = this.nodeCursorsAndLengths[currentLengthIndex];
                if (nodeCursor < nodeLength) {
                    AbstractMapNode<K, V> nextNode = this.nodes[this.currentStackLevel].getNode(nodeCursor);
                    int n = currentCursorIndex;
                    this.nodeCursorsAndLengths[n] = this.nodeCursorsAndLengths[n] + 1;
                    if (nextNode.hasNodes()) {
                        int nextStackLevel = ++this.currentStackLevel;
                        int nextCursorIndex = nextStackLevel * 2;
                        int nextLengthIndex = nextCursorIndex + 1;
                        this.nodes[nextStackLevel] = nextNode;
                        this.nodeCursorsAndLengths[nextCursorIndex] = 0;
                        this.nodeCursorsAndLengths[nextLengthIndex] = nextNode.nodeArity();
                    }
                    if (!nextNode.hasPayload()) continue;
                    this.currentValueNode = nextNode;
                    this.currentValueCursor = 0;
                    this.currentValueLength = nextNode.payloadArity();
                    return true;
                }
                --this.currentStackLevel;
            }
            return false;
        }

        public boolean hasNext() {
            if (this.currentValueCursor < this.currentValueLength) {
                return true;
            }
            return this.searchNextValueNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class HashCollisionMapNode<K, V>
    extends CompactMapNode<K, V> {
        private final K[] keys;
        private final V[] vals;
        private final int hash;

        HashCollisionMapNode(int hash, K[] keys, V[] vals) {
            this.keys = keys;
            this.vals = vals;
            this.hash = hash;
            assert (this.payloadArity() >= 2);
        }

        @Override
        public ArrayView<AbstractMapNode<K, V>> nodeArray() {
            return ArrayView.empty();
        }

        @Override
        public boolean containsKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            if (this.hash == keyHash) {
                for (K k : this.keys) {
                    if (!cmp.equals(k, key)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Optional<V> findByKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            for (int i = 0; i < this.keys.length; ++i) {
                K _key = this.keys[i];
                if (!cmp.equals(key, _key)) continue;
                V val = this.vals[i];
                return Optional.of(val);
            }
            return Optional.empty();
        }

        @Override
        public AbstractMapNode<K, V> updated(AtomicReference<Thread> mutator, K key, V val, int keyHash, int shift, MapNodeResult<K, V> details, EqualityComparator<Object> cmp) {
            assert (this.hash == keyHash);
            for (int idx = 0; idx < this.keys.length; ++idx) {
                if (!cmp.equals(this.keys[idx], key)) continue;
                V currentVal = this.vals[idx];
                if (cmp.equals(currentVal, val)) {
                    return this;
                }
                V[] src = this.vals;
                Object[] dst = new Object[src.length];
                System.arraycopy(src, 0, dst, 0, src.length);
                dst[idx + 0] = val;
                HashCollisionMapNode<K, Object> thisNew = new HashCollisionMapNode<K, Object>(this.hash, this.keys, dst);
                details.updated(currentVal);
                return thisNew;
            }
            Object[] keysNew = new Object[this.keys.length + 1];
            System.arraycopy(this.keys, 0, keysNew, 0, this.keys.length);
            keysNew[this.keys.length + 0] = key;
            System.arraycopy(this.keys, this.keys.length, keysNew, this.keys.length + 1, this.keys.length - this.keys.length);
            Object[] valsNew = new Object[this.vals.length + 1];
            System.arraycopy(this.vals, 0, valsNew, 0, this.vals.length);
            valsNew[this.vals.length + 0] = val;
            System.arraycopy(this.vals, this.vals.length, valsNew, this.vals.length + 1, this.vals.length - this.vals.length);
            details.modified();
            return new HashCollisionMapNode<Object, Object>(keyHash, keysNew, valsNew);
        }

        @Override
        public AbstractMapNode<K, V> removed(AtomicReference<Thread> mutator, K key, int keyHash, int shift, MapNodeResult<K, V> details, EqualityComparator<Object> cmp) {
            for (int idx = 0; idx < this.keys.length; ++idx) {
                if (!cmp.equals(this.keys[idx], key)) continue;
                V currentVal = this.vals[idx];
                details.updated(currentVal);
                if (this.arity() == 1) {
                    return HashCollisionMapNode.nodeOf(mutator);
                }
                if (this.arity() == 2) {
                    K theOtherKey = idx == 0 ? this.keys[1] : this.keys[0];
                    V theOtherVal = idx == 0 ? this.vals[1] : this.vals[0];
                    return CompactMapNode.nodeOf(mutator).updated((AtomicReference)mutator, (Object)theOtherKey, (Object)theOtherVal, keyHash, 0, (MapNodeResult)details, (EqualityComparator)cmp);
                }
                Object[] keysNew = new Object[this.keys.length - 1];
                System.arraycopy(this.keys, 0, keysNew, 0, idx);
                System.arraycopy(this.keys, idx + 1, keysNew, idx, this.keys.length - idx - 1);
                Object[] valsNew = new Object[this.vals.length - 1];
                System.arraycopy(this.vals, 0, valsNew, 0, idx);
                System.arraycopy(this.vals, idx + 1, valsNew, idx, this.vals.length - idx - 1);
                return new HashCollisionMapNode<Object, Object>(keyHash, keysNew, valsNew);
            }
            return this;
        }

        @Override
        boolean hasPayload() {
            return true;
        }

        @Override
        int payloadArity() {
            return this.keys.length;
        }

        @Override
        boolean hasNodes() {
            return false;
        }

        @Override
        int nodeArity() {
            return 0;
        }

        @Override
        int arity() {
            return this.payloadArity();
        }

        @Override
        public byte sizePredicate() {
            return 2;
        }

        @Override
        K getKey(int index) {
            return this.keys[index];
        }

        @Override
        V getValue(int index) {
            return this.vals[index];
        }

        @Override
        Map.Entry<K, V> getKeyValueEntry(int index) {
            return AbstractSpecialisedImmutableMap.entryOf(this.keys[index], this.vals[index]);
        }

        @Override
        public CompactMapNode<K, V> getNode(int index) {
            throw new IllegalStateException("Is leaf node.");
        }

        @Override
        Object getSlot(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean hasSlots() {
            throw new UnsupportedOperationException();
        }

        @Override
        int slotArity() {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            int prime = 31;
            int result = 0;
            result = 31 * result + this.hash;
            result = 31 * result + Arrays.hashCode(this.keys);
            result = 31 * result + Arrays.hashCode(this.vals);
            return result;
        }

        public boolean equals(Object other) {
            return this.equivalent(other, Object::equals);
        }

        @Override
        public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
            if (null == other) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            HashCollisionMapNode that = (HashCollisionMapNode)other;
            if (this.hash != that.hash) {
                return false;
            }
            if (this.arity() != that.arity()) {
                return false;
            }
            block0: for (int i = 0; i < that.payloadArity(); ++i) {
                K otherKey = that.getKey(i);
                V otherVal = that.getValue(i);
                for (int j = 0; j < this.keys.length; ++j) {
                    K key = this.keys[j];
                    V val = this.vals[j];
                    if (cmp.equals(key, otherKey) && cmp.equals(val, otherVal)) continue block0;
                }
                return false;
            }
            return true;
        }

        @Override
        CompactMapNode<K, V> copyAndSetValue(AtomicReference<Thread> mutator, int bitpos, V val) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactMapNode<K, V> copyAndInsertValue(AtomicReference<Thread> mutator, int bitpos, K key, V val) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactMapNode<K, V> copyAndRemoveValue(AtomicReference<Thread> mutator, int bitpos) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactMapNode<K, V> copyAndSetNode(AtomicReference<Thread> mutator, int bitpos, AbstractMapNode<K, V> node) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactMapNode<K, V> copyAndMigrateFromInlineToNode(AtomicReference<Thread> mutator, int bitpos, AbstractMapNode<K, V> node) {
            throw new UnsupportedOperationException();
        }

        @Override
        CompactMapNode<K, V> copyAndMigrateFromNodeToInline(AtomicReference<Thread> mutator, int bitpos, AbstractMapNode<K, V> node) {
            throw new UnsupportedOperationException();
        }

        @Override
        int nodeMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        int dataMap() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class BitmapIndexedMapNode<K, V>
    extends CompactMixedMapNode<K, V> {
        final transient AtomicReference<Thread> mutator;
        final Object[] nodes;

        private BitmapIndexedMapNode(AtomicReference<Thread> mutator, int nodeMap, int dataMap, Object[] nodes) {
            super(mutator, nodeMap, dataMap);
            this.mutator = mutator;
            this.nodes = nodes;
        }

        @Override
        public ArrayView<AbstractMapNode<K, V>> nodeArray() {
            return new ArrayView<AbstractMapNode<K, V>>(){

                @Override
                public int size() {
                    return this.nodeArity();
                }

                @Override
                public AbstractMapNode<K, V> get(int index) {
                    return this.getNode(index);
                }

                @Override
                public void set(int index, AbstractMapNode<K, V> item) {
                    nodes[nodes.length - 1 - index] = item;
                }

                @Override
                public void set(int index, AbstractMapNode<K, V> item, AtomicReference<?> writeCapabilityToken) {
                    if (!AbstractMapNode.isAllowedToEdit(mutator, writeCapabilityToken)) {
                        throw new IllegalStateException();
                    }
                    nodes[nodes.length - 1 - index] = item;
                }
            };
        }

        @Override
        K getKey(int index) {
            return (K)this.nodes[2 * index];
        }

        @Override
        V getValue(int index) {
            return (V)this.nodes[2 * index + 1];
        }

        @Override
        Map.Entry<K, V> getKeyValueEntry(int index) {
            return AbstractSpecialisedImmutableMap.entryOf(this.nodes[2 * index], this.nodes[2 * index + 1]);
        }

        @Override
        CompactMapNode<K, V> getNode(int index) {
            return (CompactMapNode)this.nodes[this.nodes.length - 1 - index];
        }

        @Override
        boolean hasPayload() {
            return this.dataMap() != 0;
        }

        @Override
        int payloadArity() {
            return Integer.bitCount(this.dataMap());
        }

        @Override
        boolean hasNodes() {
            return this.nodeMap() != 0;
        }

        @Override
        int nodeArity() {
            return Integer.bitCount(this.nodeMap());
        }

        @Override
        Object getSlot(int index) {
            return this.nodes[index];
        }

        @Override
        boolean hasSlots() {
            return this.nodes.length != 0;
        }

        @Override
        int slotArity() {
            return this.nodes.length;
        }

        public int hashCode() {
            int prime = 31;
            int result = 0;
            result = 31 * result + this.nodeMap();
            result = 31 * result + this.dataMap();
            result = 31 * result + Arrays.hashCode(this.nodes);
            return result;
        }

        public boolean equals(Object other) {
            return this.equivalent(other, Object::equals);
        }

        @Override
        public boolean equivalent(Object other, EqualityComparator<Object> cmp) {
            if (null == other) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            BitmapIndexedMapNode that = (BitmapIndexedMapNode)other;
            if (this.nodeMap() != that.nodeMap()) {
                return false;
            }
            if (this.dataMap() != that.dataMap()) {
                return false;
            }
            return this.deepContentEquality(this.nodes, that.nodes, 2 * this.payloadArity(), this.slotArity(), cmp);
        }

        private final boolean deepContentEquality(Object[] a1, Object[] a2, int splitAt, int length, EqualityComparator<Object> cmp) {
            Object o2;
            Object o1;
            int i;
            if (a1 == a2) {
                return true;
            }
            for (i = 0; i < splitAt; ++i) {
                o1 = a1[i];
                o2 = a2[i];
                if (EqualityComparator.equals(o1, o2, cmp::equals)) continue;
                return false;
            }
            for (i = splitAt; i < length; ++i) {
                o1 = (AbstractMapNode)a1[i];
                o2 = (AbstractMapNode)a2[i];
                if (EqualityComparator.equals(o1, o2, (a, b) -> a.equivalent(b, cmp))) continue;
                return false;
            }
            return true;
        }

        @Override
        public byte sizePredicate() {
            if (this.nodeArity() == 0) {
                switch (this.payloadArity()) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                }
                return 2;
            }
            return 2;
        }

        @Override
        CompactMapNode<K, V> copyAndSetValue(AtomicReference<Thread> mutator, int bitpos, V val) {
            int idx = 2 * this.dataIndex(bitpos) + 1;
            if (BitmapIndexedMapNode.isAllowedToEdit(this.mutator, mutator)) {
                this.nodes[idx] = val;
                return this;
            }
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length];
            System.arraycopy(src, 0, dst, 0, src.length);
            dst[idx + 0] = val;
            return BitmapIndexedMapNode.nodeOf(mutator, this.nodeMap(), this.dataMap(), dst);
        }

        @Override
        CompactMapNode<K, V> copyAndSetNode(AtomicReference<Thread> mutator, int bitpos, AbstractMapNode<K, V> node) {
            int idx = this.nodes.length - 1 - this.nodeIndex(bitpos);
            if (BitmapIndexedMapNode.isAllowedToEdit(this.mutator, mutator)) {
                this.nodes[idx] = node;
                return this;
            }
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length];
            System.arraycopy(src, 0, dst, 0, src.length);
            dst[idx + 0] = node;
            return BitmapIndexedMapNode.nodeOf(mutator, this.nodeMap(), this.dataMap(), dst);
        }

        @Override
        CompactMapNode<K, V> copyAndInsertValue(AtomicReference<Thread> mutator, int bitpos, K key, V val) {
            int idx = 2 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length + 2];
            System.arraycopy(src, 0, dst, 0, idx);
            dst[idx + 0] = key;
            dst[idx + 1] = val;
            System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
            return BitmapIndexedMapNode.nodeOf(mutator, this.nodeMap(), this.dataMap() | bitpos, dst);
        }

        @Override
        CompactMapNode<K, V> copyAndRemoveValue(AtomicReference<Thread> mutator, int bitpos) {
            int idx = 2 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 2];
            System.arraycopy(src, 0, dst, 0, idx);
            System.arraycopy(src, idx + 2, dst, idx, src.length - idx - 2);
            return BitmapIndexedMapNode.nodeOf(mutator, this.nodeMap(), this.dataMap() ^ bitpos, dst);
        }

        @Override
        CompactMapNode<K, V> copyAndMigrateFromInlineToNode(AtomicReference<Thread> mutator, int bitpos, AbstractMapNode<K, V> node) {
            int idxOld = 2 * this.dataIndex(bitpos);
            int idxNew = this.nodes.length - 2 - this.nodeIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 2 + 1];
            assert (idxOld <= idxNew);
            System.arraycopy(src, 0, dst, 0, idxOld);
            System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
            dst[idxNew + 0] = node;
            System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
            return BitmapIndexedMapNode.nodeOf(mutator, this.nodeMap() | bitpos, this.dataMap() ^ bitpos, dst);
        }

        @Override
        CompactMapNode<K, V> copyAndMigrateFromNodeToInline(AtomicReference<Thread> mutator, int bitpos, AbstractMapNode<K, V> node) {
            int idxOld = this.nodes.length - 1 - this.nodeIndex(bitpos);
            int idxNew = 2 * this.dataIndex(bitpos);
            Object[] src = this.nodes;
            Object[] dst = new Object[src.length - 1 + 2];
            assert (idxOld >= idxNew);
            System.arraycopy(src, 0, dst, 0, idxNew);
            dst[idxNew + 0] = node.getKey(0);
            dst[idxNew + 1] = node.getValue(0);
            System.arraycopy(src, idxNew, dst, idxNew + 2, idxOld - idxNew);
            System.arraycopy(src, idxOld + 1, dst, idxOld + 2, src.length - idxOld - 1);
            return BitmapIndexedMapNode.nodeOf(mutator, this.nodeMap() ^ bitpos, this.dataMap() | bitpos, dst);
        }
    }

    protected static abstract class CompactMixedMapNode<K, V>
    extends CompactMapNode<K, V> {
        private final int nodeMap;
        private final int dataMap;

        CompactMixedMapNode(AtomicReference<Thread> mutator, int nodeMap, int dataMap) {
            this.nodeMap = nodeMap;
            this.dataMap = dataMap;
        }

        @Override
        public int nodeMap() {
            return this.nodeMap;
        }

        @Override
        public int dataMap() {
            return this.dataMap;
        }
    }

    protected static abstract class CompactMapNode<K, V>
    extends AbstractMapNode<K, V> {
        static final int HASH_CODE_LENGTH = 32;
        static final int BIT_PARTITION_SIZE = 5;
        static final int BIT_PARTITION_MASK = 31;

        protected CompactMapNode() {
        }

        static final int mask(int keyHash, int shift) {
            return keyHash >>> shift & 0x1F;
        }

        static final int bitpos(int mask) {
            return 1 << mask;
        }

        abstract int nodeMap();

        abstract int dataMap();

        @Override
        abstract CompactMapNode<K, V> getNode(int var1);

        boolean nodeInvariant() {
            boolean inv3;
            boolean inv2;
            boolean inv1;
            boolean bl = inv1 = this.size() - this.payloadArity() >= 2 * (this.arity() - this.payloadArity());
            boolean bl2 = this.arity() == 0 ? this.sizePredicate() == 0 : (inv2 = true);
            boolean bl3 = this.arity() == 1 && this.payloadArity() == 1 ? this.sizePredicate() == 1 : (inv3 = true);
            boolean inv4 = this.arity() >= 2 ? this.sizePredicate() == 2 : true;
            boolean inv5 = this.nodeArity() >= 0 && this.payloadArity() >= 0 && this.payloadArity() + this.nodeArity() == this.arity();
            return inv1 && inv2 && inv3 && inv4 && inv5;
        }

        abstract CompactMapNode<K, V> copyAndSetValue(AtomicReference<Thread> var1, int var2, V var3);

        abstract CompactMapNode<K, V> copyAndInsertValue(AtomicReference<Thread> var1, int var2, K var3, V var4);

        abstract CompactMapNode<K, V> copyAndRemoveValue(AtomicReference<Thread> var1, int var2);

        abstract CompactMapNode<K, V> copyAndSetNode(AtomicReference<Thread> var1, int var2, AbstractMapNode<K, V> var3);

        abstract CompactMapNode<K, V> copyAndMigrateFromInlineToNode(AtomicReference<Thread> var1, int var2, AbstractMapNode<K, V> var3);

        abstract CompactMapNode<K, V> copyAndMigrateFromNodeToInline(AtomicReference<Thread> var1, int var2, AbstractMapNode<K, V> var3);

        static final <K, V> CompactMapNode<K, V> mergeTwoKeyValPairs(K key0, V val0, int keyHash0, K key1, V val1, int keyHash1, int shift) {
            int mask1;
            assert (!key0.equals(key1));
            if (shift >= 32) {
                return new HashCollisionMapNode<Object, Object>(keyHash0, new Object[]{key0, key1}, new Object[]{val0, val1});
            }
            int mask0 = CompactMapNode.mask(keyHash0, shift);
            if (mask0 != (mask1 = CompactMapNode.mask(keyHash1, shift))) {
                int dataMap = CompactMapNode.bitpos(mask0) | CompactMapNode.bitpos(mask1);
                if (mask0 < mask1) {
                    return CompactMapNode.nodeOf(null, 0, dataMap, new Object[]{key0, val0, key1, val1});
                }
                return CompactMapNode.nodeOf(null, 0, dataMap, new Object[]{key1, val1, key0, val0});
            }
            CompactMapNode<K, V> node = CompactMapNode.mergeTwoKeyValPairs(key0, val0, keyHash0, key1, val1, keyHash1, shift + 5);
            int nodeMap = CompactMapNode.bitpos(mask0);
            return CompactMapNode.nodeOf(null, nodeMap, 0, new Object[]{node});
        }

        static final <K, V> CompactMapNode<K, V> nodeOf(AtomicReference<Thread> mutator, int nodeMap, int dataMap, Object[] nodes) {
            return new BitmapIndexedMapNode(mutator, nodeMap, dataMap, nodes);
        }

        static final <K, V> CompactMapNode<K, V> nodeOf(AtomicReference<Thread> mutator) {
            return EMPTY_NODE;
        }

        static final <K, V> CompactMapNode<K, V> nodeOf(AtomicReference<Thread> mutator, int nodeMap, int dataMap, K key, V val) {
            assert (nodeMap == 0);
            return CompactMapNode.nodeOf(mutator, 0, dataMap, new Object[]{key, val});
        }

        static final int index(int bitmap, int bitpos) {
            return Integer.bitCount(bitmap & bitpos - 1);
        }

        static final int index(int bitmap, int mask, int bitpos) {
            return bitmap == -1 ? mask : CompactMapNode.index(bitmap, bitpos);
        }

        int dataIndex(int bitpos) {
            return Integer.bitCount(this.dataMap() & bitpos - 1);
        }

        int nodeIndex(int bitpos) {
            return Integer.bitCount(this.nodeMap() & bitpos - 1);
        }

        CompactMapNode<K, V> nodeAt(int bitpos) {
            return this.getNode(this.nodeIndex(bitpos));
        }

        @Override
        public boolean containsKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            int mask = CompactMapNode.mask(keyHash, shift);
            int bitpos = CompactMapNode.bitpos(mask);
            int dataMap = this.dataMap();
            if ((dataMap & bitpos) != 0) {
                int index = CompactMapNode.index(dataMap, mask, bitpos);
                return cmp.equals(this.getKey(index), key);
            }
            int nodeMap = this.nodeMap();
            if ((nodeMap & bitpos) != 0) {
                int index = CompactMapNode.index(nodeMap, mask, bitpos);
                return ((CompactMapNode)this.getNode(index)).containsKey(key, keyHash, shift + 5, cmp);
            }
            return false;
        }

        @Override
        public Optional<V> findByKey(K key, int keyHash, int shift, EqualityComparator<Object> cmp) {
            int mask = CompactMapNode.mask(keyHash, shift);
            int bitpos = CompactMapNode.bitpos(mask);
            if ((this.dataMap() & bitpos) != 0) {
                int index = this.dataIndex(bitpos);
                if (cmp.equals(this.getKey(index), key)) {
                    Object result = this.getValue(index);
                    return Optional.of(result);
                }
                return Optional.empty();
            }
            if ((this.nodeMap() & bitpos) != 0) {
                CompactMapNode<K, V> subNode = this.nodeAt(bitpos);
                return subNode.findByKey(key, keyHash, shift + 5, cmp);
            }
            return Optional.empty();
        }

        @Override
        public AbstractMapNode<K, V> updated(AtomicReference<Thread> mutator, K key, V val, int keyHash, int shift, MapNodeResult<K, V> details, EqualityComparator<Object> cmp) {
            int mask = CompactMapNode.mask(keyHash, shift);
            int bitpos = CompactMapNode.bitpos(mask);
            if ((this.dataMap() & bitpos) != 0) {
                int dataIndex = this.dataIndex(bitpos);
                Object currentKey = this.getKey(dataIndex);
                if (cmp.equals(currentKey, key)) {
                    Object currentVal = this.getValue(dataIndex);
                    details.updated(currentVal);
                    return this.copyAndSetValue(mutator, bitpos, val);
                }
                Object currentVal = this.getValue(dataIndex);
                CompactMapNode subNodeNew = CompactMapNode.mergeTwoKeyValPairs(currentKey, currentVal, PersistentTrieMap.transformHashCode(currentKey.hashCode()), key, val, keyHash, shift + 5);
                details.modified();
                return this.copyAndMigrateFromInlineToNode(mutator, bitpos, subNodeNew);
            }
            if ((this.nodeMap() & bitpos) != 0) {
                CompactMapNode<K, V> subNode = this.nodeAt(bitpos);
                AbstractMapNode subNodeNew = (AbstractMapNode)subNode.updated(mutator, key, val, keyHash, shift + 5, details, cmp);
                if (details.isModified()) {
                    return this.copyAndSetNode(mutator, bitpos, subNodeNew);
                }
                return this;
            }
            details.modified();
            return this.copyAndInsertValue(mutator, bitpos, key, val);
        }

        @Override
        public AbstractMapNode<K, V> removed(AtomicReference<Thread> mutator, K key, int keyHash, int shift, MapNodeResult<K, V> details, EqualityComparator<Object> cmp) {
            int mask = CompactMapNode.mask(keyHash, shift);
            int bitpos = CompactMapNode.bitpos(mask);
            if ((this.dataMap() & bitpos) != 0) {
                int dataIndex = this.dataIndex(bitpos);
                if (cmp.equals(this.getKey(dataIndex), key)) {
                    Object currentVal = this.getValue(dataIndex);
                    details.updated(currentVal);
                    if (this.payloadArity() == 2 && this.nodeArity() == 0) {
                        int newDataMap;
                        int n = newDataMap = shift == 0 ? this.dataMap() ^ bitpos : CompactMapNode.bitpos(CompactMapNode.mask(keyHash, 0));
                        if (dataIndex == 0) {
                            return CompactMapNode.nodeOf(mutator, 0, newDataMap, this.getKey(1), this.getValue(1));
                        }
                        return CompactMapNode.nodeOf(mutator, 0, newDataMap, this.getKey(0), this.getValue(0));
                    }
                    return this.copyAndRemoveValue(mutator, bitpos);
                }
                return this;
            }
            if ((this.nodeMap() & bitpos) != 0) {
                CompactMapNode subNode = this.nodeAt(bitpos);
                AbstractMapNode subNodeNew = (AbstractMapNode)subNode.removed(mutator, key, keyHash, shift + 5, details, cmp);
                if (!details.isModified()) {
                    return this;
                }
                switch (subNodeNew.sizePredicate()) {
                    case 0: {
                        throw new IllegalStateException("Sub-node must have at least one element.");
                    }
                    case 1: {
                        if (this.payloadArity() == 0 && this.nodeArity() == 1) {
                            return subNodeNew;
                        }
                        return this.copyAndMigrateFromNodeToInline(mutator, bitpos, subNodeNew);
                    }
                }
                return this.copyAndSetNode(mutator, bitpos, subNodeNew);
            }
            return this;
        }

        static byte recoverMask(int map, byte i_th) {
            assert (1 <= i_th && i_th <= 32);
            byte cnt1 = 0;
            for (byte mask = 0; mask < 32; mask = (byte)((byte)(mask + 1))) {
                if ((map & 1) == 1 && (cnt1 = (byte)(cnt1 + 1)) == i_th) {
                    return mask;
                }
                map >>= 1;
            }
            assert (cnt1 != i_th);
            throw new RuntimeException("Called with invalid arguments.");
        }

        public String toString() {
            byte pos;
            int i;
            StringBuilder bldr = new StringBuilder();
            bldr.append('[');
            for (i = 0; i < this.payloadArity(); i = (int)((byte)(i + 1))) {
                pos = CompactMapNode.recoverMask(this.dataMap(), (byte)(i + 1));
                bldr.append(String.format("@%d<#%d,#%d>", pos, Objects.hashCode(this.getKey(i)), Objects.hashCode(this.getValue(i))));
                if (i + 1 == this.payloadArity()) continue;
                bldr.append(", ");
            }
            if (this.payloadArity() > 0 && this.nodeArity() > 0) {
                bldr.append(", ");
            }
            for (i = 0; i < this.nodeArity(); i = (int)((byte)(i + 1))) {
                pos = CompactMapNode.recoverMask(this.nodeMap(), (byte)(i + 1));
                bldr.append(String.format("@%d: %s", pos, this.getNode(i)));
                if (i + 1 == this.nodeArity()) continue;
                bldr.append(", ");
            }
            bldr.append(']');
            return bldr.toString();
        }
    }

    protected static abstract class AbstractMapNode<K, V>
    implements MapNode<K, V, AbstractMapNode<K, V>>,
    Serializable {
        private static final long serialVersionUID = 42L;
        static final int TUPLE_LENGTH = 2;

        protected AbstractMapNode() {
        }

        static final <T> boolean isAllowedToEdit(AtomicReference<?> x, AtomicReference<?> y) {
            return x != null && y != null && (x == y || x.get() == y.get());
        }

        @Override
        public <T> ArrayView<T> dataArray(int category, int component) {
            if (category == 0) {
                switch (component) {
                    case 0: {
                        return this.categoryArrayView0();
                    }
                    case 1: {
                        return this.categoryArrayView1();
                    }
                }
            }
            throw new IllegalArgumentException("Category %i component %i is not supported.");
        }

        private <T> ArrayView<T> categoryArrayView0() {
            return new ArrayView<T>(){

                @Override
                public int size() {
                    return this.payloadArity();
                }

                @Override
                public T get(int index) {
                    return this.getKey(index);
                }
            };
        }

        private <T> ArrayView<T> categoryArrayView1() {
            return new ArrayView<T>(){

                @Override
                public int size() {
                    return this.payloadArity();
                }

                @Override
                public T get(int index) {
                    return this.getValue(index);
                }
            };
        }

        public abstract ArrayView<AbstractMapNode<K, V>> nodeArray();

        abstract boolean hasNodes();

        abstract int nodeArity();

        abstract AbstractMapNode<K, V> getNode(int var1);

        @Deprecated
        Iterator<? extends AbstractMapNode<K, V>> nodeIterator() {
            return new Iterator<AbstractMapNode<K, V>>(){
                int nextIndex = 0;
                final int nodeArity = this.nodeArity();

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AbstractMapNode<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.getNode(this.nextIndex++);
                }

                @Override
                public boolean hasNext() {
                    return this.nextIndex < this.nodeArity;
                }
            };
        }

        abstract boolean hasPayload();

        abstract int payloadArity();

        abstract K getKey(int var1);

        abstract V getValue(int var1);

        abstract Map.Entry<K, V> getKeyValueEntry(int var1);

        @Deprecated
        abstract boolean hasSlots();

        abstract int slotArity();

        abstract Object getSlot(int var1);

        int arity() {
            return this.payloadArity() + this.nodeArity();
        }

        int size() {
            MapKeyIterator it = new MapKeyIterator(this);
            int size = 0;
            while (it.hasNext()) {
                ++size;
                it.next();
            }
            return size;
        }
    }
}

