/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.ByteArrayHolder;
import com.google.archivepatcher.generator.DefaultDeflateCompressionDiviner;
import com.google.archivepatcher.generator.MinimalZipArchive;
import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.generator.PreDiffPlan;
import com.google.archivepatcher.generator.PreDiffPlanner;
import com.google.archivepatcher.generator.RecommendationModifier;
import com.google.archivepatcher.shared.JreDeflateParameters;
import com.google.archivepatcher.shared.TypedRange;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PreDiffExecutor {
    private final File originalOldFile;
    private final File originalNewFile;
    private final File deltaFriendlyOldFile;
    private final File deltaFriendlyNewFile;
    private final List<RecommendationModifier> recommendationModifiers;

    private PreDiffExecutor(File originalOldFile, File originalNewFile, File deltaFriendlyOldFile, File deltaFriendlyNewFile, List<RecommendationModifier> recommendationModifiers) {
        this.originalOldFile = originalOldFile;
        this.originalNewFile = originalNewFile;
        this.deltaFriendlyOldFile = deltaFriendlyOldFile;
        this.deltaFriendlyNewFile = deltaFriendlyNewFile;
        this.recommendationModifiers = recommendationModifiers;
    }

    public PreDiffPlan prepareForDiffing() throws IOException {
        PreDiffPlan preDiffPlan = this.generatePreDiffPlan();
        List<TypedRange<JreDeflateParameters>> deltaFriendlyNewFileRecompressionPlan = null;
        if (this.deltaFriendlyOldFile != null) {
            deltaFriendlyNewFileRecompressionPlan = Collections.unmodifiableList(this.generateDeltaFriendlyFiles(preDiffPlan));
        }
        return new PreDiffPlan(preDiffPlan.getQualifiedRecommendations(), preDiffPlan.getOldFileUncompressionPlan(), preDiffPlan.getNewFileUncompressionPlan(), deltaFriendlyNewFileRecompressionPlan);
    }

    /*
     * Exception decompiling
     */
    private List<TypedRange<JreDeflateParameters>> generateDeltaFriendlyFiles(PreDiffPlan preDiffPlan) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreDiffPlan generatePreDiffPlan() throws IOException {
        HashMap<ByteArrayHolder, MinimalZipEntry> originalOldArchiveZipEntriesByPath = new HashMap<ByteArrayHolder, MinimalZipEntry>();
        HashMap<ByteArrayHolder, MinimalZipEntry> originalNewArchiveZipEntriesByPath = new HashMap<ByteArrayHolder, MinimalZipEntry>();
        HashMap<ByteArrayHolder, JreDeflateParameters> originalNewArchiveJreDeflateParametersByPath = new HashMap<ByteArrayHolder, JreDeflateParameters>();
        for (MinimalZipEntry minimalZipEntry : MinimalZipArchive.listEntries(this.originalOldFile)) {
            ByteArrayHolder key = new ByteArrayHolder(minimalZipEntry.getFileNameBytes());
            originalOldArchiveZipEntriesByPath.put(key, minimalZipEntry);
        }
        DefaultDeflateCompressionDiviner diviner = new DefaultDeflateCompressionDiviner();
        for (DefaultDeflateCompressionDiviner.DivinationResult divinationResult : diviner.divineDeflateParameters(this.originalNewFile)) {
            ByteArrayHolder key = new ByteArrayHolder(divinationResult.minimalZipEntry.getFileNameBytes());
            originalNewArchiveZipEntriesByPath.put(key, divinationResult.minimalZipEntry);
            originalNewArchiveJreDeflateParametersByPath.put(key, divinationResult.divinedParameters);
        }
        PreDiffPlanner preDiffPlanner = new PreDiffPlanner(this.originalOldFile, originalOldArchiveZipEntriesByPath, this.originalNewFile, originalNewArchiveZipEntriesByPath, originalNewArchiveJreDeflateParametersByPath, this.recommendationModifiers.toArray(new RecommendationModifier[0]));
        return preDiffPlanner.generatePreDiffPlan();
    }

    public static final class Builder {
        private File originalOldFile;
        private File originalNewFile;
        private File deltaFriendlyOldFile;
        private File deltaFriendlyNewFile;
        private List<RecommendationModifier> recommendationModifiers = new ArrayList<RecommendationModifier>();

        public Builder readingOriginalFiles(File originalOldFile, File originalNewFile) {
            if (originalOldFile == null || originalNewFile == null) {
                throw new IllegalStateException("do not set nul original input files");
            }
            this.originalOldFile = originalOldFile;
            this.originalNewFile = originalNewFile;
            return this;
        }

        public Builder writingDeltaFriendlyFiles(File deltaFriendlyOldFile, File deltaFriendlyNewFile) {
            if (deltaFriendlyOldFile == null || deltaFriendlyNewFile == null) {
                throw new IllegalStateException("do not set null delta-friendly files");
            }
            this.deltaFriendlyOldFile = deltaFriendlyOldFile;
            this.deltaFriendlyNewFile = deltaFriendlyNewFile;
            return this;
        }

        public Builder withRecommendationModifier(RecommendationModifier recommendationModifier) {
            if (recommendationModifier == null) {
                throw new IllegalArgumentException("recommendationModifier cannot be null");
            }
            this.recommendationModifiers.add(recommendationModifier);
            return this;
        }

        public PreDiffExecutor build() {
            if (this.originalOldFile == null) {
                throw new IllegalStateException("original input files cannot be null");
            }
            return new PreDiffExecutor(this.originalOldFile, this.originalNewFile, this.deltaFriendlyOldFile, this.deltaFriendlyNewFile, this.recommendationModifiers);
        }
    }
}

