/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.instrumentation.AbstractTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.SaveHook;
import com.intellij.rt.coverage.instrumentation.SaveLabelsMethodNode;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Opcodes;
import org.jetbrains.coverage.org.objectweb.asm.tree.MethodNode;

public class LineEnumerator
extends MethodVisitor
implements Opcodes {
    private final AbstractTracingInstrumenter myInstrumenter;
    private final int myAccess;
    private final String myMethodName;
    private final String myDescriptor;
    private final MethodNode myMethodNode = (MethodNode)this.mv;
    protected int myCurrentLine;
    private boolean myHasExecutableLines = false;
    private final MethodVisitor myWriterMethodVisitor;
    protected final BranchDataContainer myBranchData;

    public LineEnumerator(AbstractTracingInstrumenter instrumenter, BranchDataContainer branchData, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(589824, new SaveLabelsMethodNode(access, name, desc, signature, exceptions));
        this.myInstrumenter = instrumenter;
        this.myWriterMethodVisitor = mv;
        this.myAccess = access;
        this.myMethodName = name;
        this.myDescriptor = desc;
        this.myBranchData = branchData;
    }

    protected void onNewJump(Label originalLabel, Label trueLabel, Label falseLabel) {
    }

    protected void onNewSwitch(SwitchLabels original, SwitchLabels replacement) {
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.myWriterMethodVisitor != SaveHook.EMPTY_METHOD_VISITOR) {
            this.myMethodNode.accept(this.myInstrumenter.createTouchCounter(this.myWriterMethodVisitor, this.myBranchData, this, this.myAccess, this.myMethodName, this.myDescriptor, this.getClassName()));
        }
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.myCurrentLine = line;
        this.myHasExecutableLines = true;
        LineData lineData = this.myInstrumenter.getOrCreateLineData(this.myCurrentLine, this.myMethodName, this.myDescriptor);
        this.myBranchData.addLine(lineData);
    }

    public void visitJumpInsn(int opcode, Label label) {
        LineData lineData;
        if (!this.myHasExecutableLines) {
            super.visitJumpInsn(opcode, label);
            return;
        }
        boolean jumpInstrumented = false;
        if (opcode != 167 && opcode != 168 && !"<clinit>".equals(this.myMethodName) && (lineData = this.myInstrumenter.getLineData(this.myCurrentLine)) != null) {
            int currentJump = lineData.jumpsCount();
            Label trueLabel = new Label();
            Label falseLabel = new Label();
            this.myBranchData.addJump(lineData, currentJump, trueLabel, falseLabel);
            this.onNewJump(label, trueLabel, falseLabel);
            jumpInstrumented = true;
            super.visitJumpInsn(opcode, trueLabel);
            super.visitJumpInsn(167, falseLabel);
            super.visitLabel(trueLabel);
            super.visitJumpInsn(167, label);
            super.visitLabel(falseLabel);
        }
        if (!jumpInstrumented) {
            super.visitJumpInsn(opcode, label);
        }
    }

    private SwitchLabels replaceLabels(SwitchLabels original) {
        int i;
        Label beforeSwitchLabel = new Label();
        Label newDefaultLabel = new Label();
        Label[] newLabels = new Label[original.getLabels().length];
        for (i = 0; i < original.getLabels().length; ++i) {
            newLabels[i] = new Label();
        }
        super.visitJumpInsn(167, beforeSwitchLabel);
        for (i = 0; i < newLabels.length; ++i) {
            super.visitLabel(newLabels[i]);
            super.visitJumpInsn(167, original.getLabels()[i]);
        }
        super.visitLabel(newDefaultLabel);
        super.visitJumpInsn(167, original.getDefault());
        super.visitLabel(beforeSwitchLabel);
        return new SwitchLabels(newDefaultLabel, newLabels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (!this.myHasExecutableLines) {
            super.visitLookupSwitchInsn(dflt, keys, labels);
            return;
        }
        SwitchLabels switchLabels = new SwitchLabels(dflt, labels);
        LineData lineData = this.myInstrumenter.getLineData(this.myCurrentLine);
        if (lineData != null) {
            SwitchLabels replacement = this.replaceLabels(switchLabels);
            int switchIndex = lineData.switchesCount();
            this.myBranchData.addLookupSwitch(lineData, switchIndex, replacement.getDefault(), keys, replacement.getLabels());
            this.onNewSwitch(switchLabels, replacement);
            switchLabels = replacement;
        }
        super.visitLookupSwitchInsn(switchLabels.getDefault(), keys, switchLabels.getLabels());
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (!this.myHasExecutableLines) {
            super.visitTableSwitchInsn(min, max, dflt, labels);
            return;
        }
        SwitchLabels switchLabels = new SwitchLabels(dflt, labels);
        LineData lineData = this.myInstrumenter.getLineData(this.myCurrentLine);
        if (lineData != null) {
            SwitchLabels replacement = this.replaceLabels(switchLabels);
            int switchIndex = lineData.switchesCount();
            this.myBranchData.addTableSwitch(lineData, switchIndex, min, max, replacement.getDefault(), replacement.getLabels());
            this.onNewSwitch(switchLabels, replacement);
            switchLabels = replacement;
        }
        super.visitTableSwitchInsn(min, max, switchLabels.getDefault(), switchLabels.getLabels());
    }

    public boolean hasExecutableLines() {
        return this.myHasExecutableLines;
    }

    public String getClassName() {
        return this.myInstrumenter.getClassName();
    }

    public MethodVisitor getWV() {
        return this.myWriterMethodVisitor;
    }

    public String getMethodName() {
        return this.myMethodName;
    }

    public String getDescriptor() {
        return this.myDescriptor;
    }

    public Instrumenter getInstrumenter() {
        return this.myInstrumenter;
    }

    public BranchDataContainer getBranchData() {
        return this.myBranchData;
    }

    protected static class SwitchLabels {
        private final Label myDefault;
        private final Label[] myLabels;

        private SwitchLabels(Label dflt, Label[] labels) {
            this.myDefault = dflt;
            this.myLabels = labels;
        }

        public Label getDefault() {
            return this.myDefault;
        }

        public Label[] getLabels() {
            return this.myLabels;
        }
    }
}

