/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.instrumentation.AbstractTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.data.Jump;
import com.intellij.rt.coverage.instrumentation.data.Switch;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class InstructionsEnumerator
extends LineEnumerator {
    private final Map<Label, Jump> myOriginalLabelToJump = new HashMap<Label, Jump>();
    private final Map<Label, Switch> myOriginalLabelToSwitch = new HashMap<Label, Switch>();
    private Jump myLastJump;
    private Label myLastLabel;
    private int myInstructionCounter;

    public InstructionsEnumerator(AbstractTracingInstrumenter instrumenter, BranchDataContainer branchData, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(instrumenter, branchData, mv, access, name, desc, signature, exceptions);
    }

    private void saveInstructionsToOwner() {
        LineData lineData = this.myBranchData.getContext().getLineData(this.myCurrentLine);
        if (this.myInstructionCounter > 0 && lineData != null) {
            boolean applied;
            block10: {
                Jump jump = this.myLastJump != null ? this.myLastJump : (this.myLastLabel == null ? null : this.myOriginalLabelToJump.get(this.myLastLabel));
                Switch aSwitch = this.myLastLabel == null ? null : this.myOriginalLabelToSwitch.get(this.myLastLabel);
                applied = false;
                if (jump != null) {
                    int jumpId = jump.getId();
                    for (int index = 0; index < lineData.jumpsCount(); ++index) {
                        JumpData jumpData = lineData.getJumpData(index);
                        if (jumpData.getId(true) == jumpId) {
                            this.myBranchData.addInstructions(jumpId, this.myInstructionCounter);
                            applied = true;
                        } else {
                            if (jumpData.getId(false) != jumpId) continue;
                            this.myBranchData.addInstructions(jumpId, this.myInstructionCounter);
                            applied = true;
                        }
                        break;
                    }
                } else if (aSwitch != null) {
                    int switchId = aSwitch.getId();
                    for (int index = 0; index < lineData.switchesCount(); ++index) {
                        SwitchData switchData = lineData.getSwitchData(index);
                        for (int i = -1; i < switchData.getKeys().length; ++i) {
                            if (switchData.getId(i) != switchId) continue;
                            this.myBranchData.addInstructions(switchId, this.myInstructionCounter);
                            applied = true;
                            break block10;
                        }
                    }
                }
            }
            if (!applied) {
                this.myBranchData.addInstructions(lineData.getId(), this.myInstructionCounter);
            }
        }
        this.myLastLabel = null;
        this.myLastJump = null;
        this.myInstructionCounter = 0;
    }

    protected void onNewJump(Label originalLabel, Label trueLabel, Label falseLabel) {
        this.myLastJump = this.myBranchData.getJump(falseLabel);
        this.myOriginalLabelToJump.put(originalLabel, this.myBranchData.getJump(trueLabel));
    }

    protected void onNewSwitch(LineEnumerator.SwitchLabels original, LineEnumerator.SwitchLabels replacement) {
        this.myOriginalLabelToSwitch.put(original.getDefault(), this.myBranchData.getSwitch(replacement.getDefault()));
        for (int i = 0; i < original.getLabels().length; ++i) {
            this.myOriginalLabelToSwitch.put(original.getLabels()[i], this.myBranchData.getSwitch(replacement.getLabels()[i]));
        }
    }

    public void visitEnd() {
        this.saveInstructionsToOwner();
        super.visitEnd();
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.saveInstructionsToOwner();
        this.myLastLabel = this.myOriginalLabelToJump.containsKey(label) || this.myOriginalLabelToSwitch.containsKey(label) ? label : null;
    }

    public void visitJumpInsn(int opcode, Label label) {
        ++this.myInstructionCounter;
        this.saveInstructionsToOwner();
        super.visitJumpInsn(opcode, label);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        ++this.myInstructionCounter;
        this.saveInstructionsToOwner();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        ++this.myInstructionCounter;
        this.saveInstructionsToOwner();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        ++this.myInstructionCounter;
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
        ++this.myInstructionCounter;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        ++this.myInstructionCounter;
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        ++this.myInstructionCounter;
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        ++this.myInstructionCounter;
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        ++this.myInstructionCounter;
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        ++this.myInstructionCounter;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        ++this.myInstructionCounter;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (172 <= opcode && opcode <= 177) {
            return;
        }
        ++this.myInstructionCounter;
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        ++this.myInstructionCounter;
    }
}

