/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.util;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBuiltinTypeClassExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrImmediateTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.ListArgument;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.UnknownArgument;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a%\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010\u0007\u001a\u0016\u0010\b\u001a\u00020\t*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\n\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\n\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\n\u001a\n\u0010\u0012\u001a\u00020\f*\u00020\n\u001a\n\u0010\u0013\u001a\u00020\f*\u00020\n\u001a\f\u0010\u0014\u001a\u00020\f*\u00020\u0004H\u0002\u001a!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0003*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0017"}, d2={"tupleType", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrImmediateTupleType;", "expressions", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "context", "Lcom/intellij/psi/PsiElement;", "([Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/plugins/groovy/lang/psi/impl/GrImmediateTupleType;", "advancedResolve", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;", "rhs", "", "getArgumentListArgument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "getArrayClassType", "Lcom/intellij/psi/PsiType;", "getSimpleArrayAccessType", "isClassLiteral", "isSimpleArrayAccess", "isSingleCharLiteral", "multiResolve", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrIndexProperty;Z)[Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "intellij.groovy.psi"})
@JvmName(name="GroovyIndexPropertyUtil")
public final class GroovyIndexPropertyUtil {
    public static final boolean isSimpleArrayAccess(@NotNull GrIndexProperty $this$isSimpleArrayAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$isSimpleArrayAccess, (String)"$this$isSimpleArrayAccess");
        return GroovyIndexPropertyUtil.getSimpleArrayAccessType($this$isSimpleArrayAccess) != null;
    }

    @Nullable
    public static final PsiType getSimpleArrayAccessType(@NotNull GrIndexProperty $this$getSimpleArrayAccessType) {
        Intrinsics.checkNotNullParameter((Object)$this$getSimpleArrayAccessType, (String)"$this$getSimpleArrayAccessType");
        GrExpression grExpression = $this$getSimpleArrayAccessType.getInvokedExpression();
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"invokedExpression");
        PsiType psiType = grExpression.getType();
        if (!(psiType instanceof PsiArrayType)) {
            psiType = null;
        }
        PsiArrayType psiArrayType = (PsiArrayType)psiType;
        if (psiArrayType == null) {
            return null;
        }
        PsiArrayType thisType = psiArrayType;
        GrArgumentList grArgumentList = $this$getSimpleArrayAccessType.getArgumentList();
        Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"argumentList");
        Object[] objectArray = grArgumentList.getAllArguments();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"argumentList.allArguments");
        Object object = ArraysKt.singleOrNull((Object[])objectArray);
        if (!(object instanceof GrExpression)) {
            object = null;
        }
        GrExpression grExpression2 = (GrExpression)object;
        if (grExpression2 == null) {
            return null;
        }
        GrExpression argument = grExpression2;
        if (TypesUtil.isAssignableByMethodCallConversion((PsiType)PsiType.INT, argument.getType(), $this$getSimpleArrayAccessType) || GroovyIndexPropertyUtil.isSingleCharLiteral(argument)) {
            return thisType.getComponentType();
        }
        return null;
    }

    private static final boolean isSingleCharLiteral(GrExpression $this$isSingleCharLiteral) {
        if (!($this$isSingleCharLiteral instanceof GrLiteral)) {
            return false;
        }
        Object object = ((GrLiteral)$this$isSingleCharLiteral).getValue();
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string == null) {
            return false;
        }
        String value = string;
        return value.length() == 1;
    }

    public static final boolean isClassLiteral(@NotNull GrIndexProperty $this$isClassLiteral) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassLiteral, (String)"$this$isClassLiteral");
        GrExpression invoked = $this$isClassLiteral;
        while (true) {
            GroovyPsiElement[] groovyPsiElementArray;
            GrExpression grExpression;
            if ((grExpression = invoked) instanceof GrBuiltinTypeClassExpression) {
                return true;
            }
            if (grExpression instanceof GrReferenceExpression) {
                return ((GrReferenceExpression)invoked).resolve() instanceof PsiClass;
            }
            if (!(grExpression instanceof GrIndexProperty)) break;
            GrArgumentList grArgumentList = ((GrIndexProperty)invoked).getArgumentList();
            Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"invoked.argumentList");
            Intrinsics.checkNotNullExpressionValue((Object)grArgumentList.getAllArguments(), (String)"invoked.argumentList.allArguments");
            if (!(groovyPsiElementArray.length == 0)) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)((GrIndexProperty)invoked).getInvokedExpression(), (String)"invoked.invokedExpression");
        }
        return false;
    }

    @Nullable
    public static final PsiType getArrayClassType(@NotNull GrIndexProperty $this$getArrayClassType) {
        Intrinsics.checkNotNullParameter((Object)$this$getArrayClassType, (String)"$this$getArrayClassType");
        PsiType psiType = ResolveUtil.getClassReferenceFromExpression($this$getArrayClassType);
        if (psiType == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getClassReferenceFromExp\u2026sion(this) ?: return null");
        PsiType arrayTypeBase = psiType;
        return TypesUtil.createJavaLangClassType(arrayTypeBase, $this$getArrayClassType);
    }

    /*
     * WARNING - void declaration
     */
    private static final GrImmediateTupleType tupleType(GrExpression[] expressions, PsiElement context) {
        void $this$mapTo$iv$iv;
        GrExpression[] $this$map$iv = expressions;
        boolean $i$f$map = false;
        GrExpression[] grExpressionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiType psiType = it.getType();
            collection.add(psiType);
        }
        List types = (List)destination$iv$iv;
        return new GrImmediateTupleType(types, JavaPsiFacade.getInstance((Project)context.getProject()), context.getResolveScope());
    }

    @NotNull
    public static final Argument getArgumentListArgument(@NotNull GrIndexProperty $this$getArgumentListArgument) {
        Intrinsics.checkNotNullParameter((Object)$this$getArgumentListArgument, (String)"$this$getArgumentListArgument");
        GrArgumentList grArgumentList = $this$getArgumentListArgument.getArgumentList();
        Intrinsics.checkNotNullExpressionValue((Object)grArgumentList, (String)"argumentList");
        GrArgumentList argList = grArgumentList;
        GrNamedArgument[] grNamedArgumentArray = argList.getNamedArguments();
        Intrinsics.checkNotNullExpressionValue((Object)grNamedArgumentArray, (String)"argList.namedArguments");
        GrNamedArgument[] grNamedArgumentArray2 = grNamedArgumentArray;
        if (!(grNamedArgumentArray2.length == 0)) {
            return UnknownArgument.INSTANCE;
        }
        Object[] expressions = argList.getExpressionArguments();
        Intrinsics.checkNotNullExpressionValue((Object)expressions, (String)"expressions");
        GrExpression singleExpression = (GrExpression)ArraysKt.singleOrNull((Object[])expressions);
        if (singleExpression != null) {
            return new ExpressionArgument(singleExpression);
        }
        return new ListArgument(ArraysKt.toList((Object[])expressions), $this$getArgumentListArgument);
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult[] multiResolve(@NotNull GrIndexProperty $this$multiResolve, boolean rhs) {
        Intrinsics.checkNotNullParameter((Object)$this$multiResolve, (String)"$this$multiResolve");
        Object object = rhs ? $this$multiResolve.getRValueReference() : $this$multiResolve.getLValueReference();
        if (object == null || (object = object.multiResolve(false)) == null) {
            object = GroovyResolveResult.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)GroovyResolveResult.EMPTY_ARRAY, (String)"GroovyResolveResult.EMPTY_ARRAY");
        }
        return object;
    }

    public static /* synthetic */ GroovyResolveResult[] multiResolve$default(GrIndexProperty grIndexProperty, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return GroovyIndexPropertyUtil.multiResolve(grIndexProperty, bl);
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult[] multiResolve(@NotNull GrIndexProperty $this$multiResolve) {
        return GroovyIndexPropertyUtil.multiResolve$default($this$multiResolve, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult advancedResolve(@NotNull GrIndexProperty $this$advancedResolve, boolean rhs) {
        Intrinsics.checkNotNullParameter((Object)$this$advancedResolve, (String)"$this$advancedResolve");
        GroovyResolveResult groovyResolveResult = PsiImplUtil.extractUniqueResult(GroovyIndexPropertyUtil.multiResolve($this$advancedResolve, rhs));
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"PsiImplUtil.extractUniqueResult(multiResolve(rhs))");
        return groovyResolveResult;
    }

    public static /* synthetic */ GroovyResolveResult advancedResolve$default(GrIndexProperty grIndexProperty, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return GroovyIndexPropertyUtil.advancedResolve(grIndexProperty, bl);
    }

    @JvmOverloads
    @NotNull
    public static final GroovyResolveResult advancedResolve(@NotNull GrIndexProperty $this$advancedResolve) {
        return GroovyIndexPropertyUtil.advancedResolve$default($this$advancedResolve, false, 1, null);
    }
}

