/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightAnnotation;
import org.jetbrains.plugins.groovy.lang.resolve.imports.GroovyImports;
import org.jetbrains.plugins.groovy.transformations.immutable.GrImmutableUtils;

public final class GrAnnotationCollector {
    public static GrAnnotation @NotNull [] getResolvedAnnotations(@NotNull GrModifierList modifierList) {
        GrAnnotation[] rawAnnotations;
        if (modifierList == null) {
            GrAnnotationCollector.$$$reportNull$$$0(0);
        }
        if (!GrAnnotationCollector.mayHaveAnnotationCollector(rawAnnotations = modifierList.getRawAnnotations())) {
            if (rawAnnotations == null) {
                GrAnnotationCollector.$$$reportNull$$$0(1);
            }
            return rawAnnotations;
        }
        ArrayList<GrAnnotation> result2 = new ArrayList<GrAnnotation>();
        for (GrAnnotation annotation : rawAnnotations) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector(annotation);
            if (annotationCollector != null) {
                if (GrAnnotationCollector.collectCompileDynamic(result2, annotation)) continue;
                GrAnnotationCollector.collectAnnotations(result2, annotation, annotationCollector);
                continue;
            }
            if (GrAnnotationCollector.collectHardcoded(result2, annotation)) continue;
            result2.add(annotation);
        }
        GrAnnotation[] grAnnotationArray = result2.toArray(GrAnnotation.EMPTY_ARRAY);
        if (grAnnotationArray == null) {
            GrAnnotationCollector.$$$reportNull$$$0(2);
        }
        return grAnnotationArray;
    }

    @NotNull
    public static Set<String> collectAnnotations(@NotNull List<? super GrAnnotation> list, @NotNull GrAnnotation alias, @NotNull PsiAnnotation annotationCollector) {
        if (list == null) {
            GrAnnotationCollector.$$$reportNull$$$0(3);
        }
        if (alias == null) {
            GrAnnotationCollector.$$$reportNull$$$0(4);
        }
        if (annotationCollector == null) {
            GrAnnotationCollector.$$$reportNull$$$0(5);
        }
        PsiModifierList modifierList = (PsiModifierList)annotationCollector.getParent();
        LinkedHashMap<String, Map<String, PsiNameValuePair>> annotations2 = new LinkedHashMap<String, Map<String, PsiNameValuePair>>();
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(annotationCollector, annotations2);
        GrAnnotationCollector.collectAliasedAnnotationsFromAnnotationCollectorAnnotations(modifierList, annotations2);
        PsiManager manager = alias.getManager();
        GrAnnotationNameValuePair[] attributes = alias.getParameterList().getAttributes();
        LinkedHashSet<String> allUsedAttrs = new LinkedHashSet<String>();
        for (Map.Entry entry : annotations2.entrySet()) {
            PsiClass resolved;
            String qname = (String)entry.getKey();
            if (qname.equals(alias.getQualifiedName()) || (resolved = JavaPsiFacade.getInstance((Project)alias.getProject()).findClass(qname, alias.getResolveScope())) == null) continue;
            GrLightAnnotation annotation = new GrLightAnnotation(manager, alias.getLanguage(), qname, (PsiModifierList)alias.getParent());
            LinkedHashSet<String> usedAttrs = new LinkedHashSet<String>();
            for (GrAnnotationNameValuePair attr : attributes) {
                String name;
                String string = name = attr.getName() != null ? attr.getName() : "value";
                if (resolved.findMethodsByName(name, false).length <= 0) continue;
                annotation.addAttribute(attr);
                allUsedAttrs.add(name);
                usedAttrs.add(name);
            }
            Map defaults = (Map)entry.getValue();
            for (Map.Entry defa : defaults.entrySet()) {
                if (usedAttrs.contains(defa.getKey())) continue;
                annotation.addAttribute((PsiNameValuePair)defa.getValue());
            }
            list.add(annotation);
        }
        LinkedHashSet<String> linkedHashSet = allUsedAttrs;
        if (linkedHashSet == null) {
            GrAnnotationCollector.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorAnnotations(@NotNull PsiModifierList modifierList, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations2) {
        PsiAnnotation[] rawAnnotations;
        if (modifierList == null) {
            GrAnnotationCollector.$$$reportNull$$$0(7);
        }
        if (annotations2 == null) {
            GrAnnotationCollector.$$$reportNull$$$0(8);
        }
        for (PsiAnnotation annotation : rawAnnotations = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
            PsiNameValuePair[] attributes;
            String qname = annotation.getQualifiedName();
            if (qname == null || qname.equals("groovy.transform.AnnotationCollector") || qname.startsWith("java.lang.annotation")) continue;
            for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                Map<String, PsiNameValuePair> map2 = annotations2.get(qname);
                if (map2 == null) {
                    map2 = new LinkedHashMap<String, PsiNameValuePair>();
                    annotations2.put(qname, map2);
                }
                map2.put(pair.getName() != null ? pair.getName() : "value", pair);
            }
            if (attributes.length != 0 || annotations2.containsKey(qname)) continue;
            annotations2.put(qname, new LinkedHashMap());
        }
    }

    private static void collectAliasedAnnotationsFromAnnotationCollectorValueAttribute(@NotNull PsiAnnotation annotationCollector, @NotNull Map<String, Map<String, PsiNameValuePair>> annotations2) {
        PsiAnnotationMemberValue annotationsFromValue;
        if (annotationCollector == null) {
            GrAnnotationCollector.$$$reportNull$$$0(9);
        }
        if (annotations2 == null) {
            GrAnnotationCollector.$$$reportNull$$$0(10);
        }
        if ((annotationsFromValue = annotationCollector.findAttributeValue("value")) instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue member : ((GrAnnotationArrayInitializer)annotationsFromValue).getInitializers()) {
                PsiElement resolved;
                if (!(member instanceof GrReferenceExpression) || !((resolved = ((GrReferenceExpression)member).resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
                annotations2.put(((PsiClass)resolved).getQualifiedName(), new LinkedHashMap());
            }
        }
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@Nullable PsiClass clazz) {
        PsiModifierList modifierList;
        if (clazz != null && (modifierList = clazz.getModifierList()) != null) {
            PsiAnnotation[] annotations2;
            for (PsiAnnotation annotation : annotations2 = modifierList instanceof GrModifierList ? ((GrModifierList)modifierList).getRawAnnotations() : modifierList.getAnnotations()) {
                if (!"groovy.transform.AnnotationCollector".equals(annotation.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    @Nullable
    public static PsiAnnotation findAnnotationCollector(@NotNull GrAnnotation annotation) {
        if (annotation == null) {
            GrAnnotationCollector.$$$reportNull$$$0(11);
        }
        if (!GrAnnotationCollector.mayHaveAnnotationCollector(annotation)) {
            return null;
        }
        PsiElement resolved = annotation.getClassReference().resolve();
        if (resolved instanceof ClsClassImpl) {
            return GrAnnotationCollector.findAnnotationCollector(((ClsClassImpl)resolved).getSourceMirrorClass());
        }
        if (resolved instanceof PsiClass) {
            return GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
        }
        return null;
    }

    private static boolean mayHaveAnnotationCollector(GrAnnotation @NotNull [] rawAnnotations) {
        if (rawAnnotations == null) {
            GrAnnotationCollector.$$$reportNull$$$0(12);
        }
        for (GrAnnotation annotation : rawAnnotations) {
            if (!GrAnnotationCollector.mayHaveAnnotationCollector(annotation)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean mayHaveAnnotationCollector(@NotNull GrAnnotation annotation) {
        if (annotation == null) {
            GrAnnotationCollector.$$$reportNull$$$0(13);
        }
        String shortName = annotation.getShortName();
        Set<String> allNames = GrAnnotationCollector.allCollectorNames(annotation.getProject());
        if (allNames.contains(shortName)) return true;
        if (!ContainerUtil.exists(GroovyImports.getAliasedShortNames(annotation, shortName), allNames::contains)) return false;
        return true;
    }

    private static Set<String> allCollectorNames(@NotNull Project project) {
        if (project == null) {
            GrAnnotationCollector.$$$reportNull$$$0(14);
        }
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashSet result2 = new HashSet();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            for (PsiClass collector : JavaPsiFacade.getInstance((Project)project).findClasses("groovy.transform.AnnotationCollector", scope)) {
                AnnotatedElementsSearch.searchPsiClasses((PsiClass)collector, (SearchScope)scope).forEach(aClass -> {
                    ContainerUtil.addIfNotNull((Collection)result2, (Object)aClass.getName());
                    return true;
                });
            }
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static boolean collectHardcoded(@NotNull List<? super GrAnnotation> list, @NotNull GrAnnotation alias) {
        String fqn;
        if (list == null) {
            GrAnnotationCollector.$$$reportNull$$$0(15);
        }
        if (alias == null) {
            GrAnnotationCollector.$$$reportNull$$$0(16);
        }
        if ("groovy.transform.Immutable".equals(fqn = alias.getQualifiedName())) {
            GrImmutableUtils.collectImmutableAnnotations(alias, list);
            return true;
        }
        return GrAnnotationCollector.collectCompileDynamic(list, alias);
    }

    private static boolean collectCompileDynamic(@NotNull List<? super GrAnnotation> list, @NotNull GrAnnotation alias) {
        if (list == null) {
            GrAnnotationCollector.$$$reportNull$$$0(17);
        }
        if (alias == null) {
            GrAnnotationCollector.$$$reportNull$$$0(18);
        }
        if ("groovy.transform.CompileDynamic".equals(alias.getQualifiedName())) {
            PsiAnnotationOwner owner = alias.getOwner();
            if (owner != null) {
                GrLightAnnotation annotation = new GrLightAnnotation(owner, alias, "groovy.transform.CompileStatic", Collections.singletonMap("value", "TypeCheckingMode.SKIP"));
                list.add(annotation);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector";
                break;
            }
            case 3: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 4: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationCollector";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawAnnotations";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrAnnotationCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedAnnotations";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectAnnotations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectAliasedAnnotationsFromAnnotationCollectorAnnotations";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectAliasedAnnotationsFromAnnotationCollectorValueAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationCollector";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mayHaveAnnotationCollector";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "allCollectorNames";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectHardcoded";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectCompileDynamic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

