/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrMapType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public final class GrMapTypeFromNamedArgs
extends GrMapType {
    @NotNull
    private final LinkedHashMap<String, GrExpression> myStringEntries;
    @NotNull
    private final List<Couple<GrExpression>> myOtherEntries;
    private final NotNullLazyValue<List<Couple<PsiType>>> myTypesOfOtherEntries;
    private final NotNullLazyValue<LinkedHashMap<String, PsiType>> myTypesOfStringEntries;

    public GrMapTypeFromNamedArgs(@NotNull PsiElement context, GrNamedArgument @NotNull [] namedArgs) {
        if (context == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(0);
        }
        if (namedArgs == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(1);
        }
        this(JavaPsiFacade.getInstance((Project)context.getProject()), context.getResolveScope(), namedArgs);
    }

    public GrMapTypeFromNamedArgs(@NotNull JavaPsiFacade facade, @NotNull GlobalSearchScope scope, GrNamedArgument @NotNull [] namedArgs) {
        if (facade == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(3);
        }
        if (namedArgs == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(4);
        }
        super(facade, scope);
        this.myStringEntries = new LinkedHashMap();
        this.myOtherEntries = new ArrayList<Couple<GrExpression>>();
        for (GrNamedArgument namedArg : namedArgs) {
            GrArgumentLabel label = namedArg.getLabel();
            GrExpression expression = namedArg.getExpression();
            if (label == null || expression == null) continue;
            String name = label.getName();
            if (name != null) {
                this.myStringEntries.put(name, expression);
                continue;
            }
            GrExpression labelExpression = label.getExpression();
            if (labelExpression == null) continue;
            this.myOtherEntries.add((Couple<GrExpression>)Couple.of((Object)labelExpression, (Object)expression));
        }
        this.myTypesOfOtherEntries = NotNullLazyValue.volatileLazy(() -> ContainerUtil.map(this.myOtherEntries, pair -> Couple.of((Object)this.inferTypePreventingRecursion((GrExpression)pair.first), (Object)this.inferTypePreventingRecursion((GrExpression)pair.second))));
        this.myTypesOfStringEntries = NotNullLazyValue.volatileLazy(() -> {
            LinkedHashMap<String, PsiType> result2 = new LinkedHashMap<String, PsiType>();
            for (Map.Entry<String, GrExpression> entry : this.myStringEntries.entrySet()) {
                result2.put(entry.getKey(), this.inferTypePreventingRecursion(entry.getValue()));
            }
            return result2;
        });
    }

    @Override
    @Nullable
    public PsiType getTypeByStringKey(String key) {
        GrExpression expression = this.myStringEntries.get(key);
        return expression != null ? this.inferTypePreventingRecursion(expression) : null;
    }

    @Override
    @NotNull
    public Set<String> getStringKeys() {
        Set<String> set = this.myStringEntries.keySet();
        if (set == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    public boolean isEmpty() {
        return this.myStringEntries.isEmpty() && this.myOtherEntries.isEmpty();
    }

    @Nullable
    private PsiType inferTypePreventingRecursion(GrExpression expression) {
        return (PsiType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, () -> TypesUtil.boxPrimitiveType(expression.getType(), expression.getManager(), this.myScope));
    }

    @Override
    @NotNull
    protected List<Couple<PsiType>> getOtherEntries() {
        List list = (List)this.myTypesOfOtherEntries.getValue();
        if (list == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    @NotNull
    protected LinkedHashMap<String, PsiType> getStringEntries() {
        LinkedHashMap linkedHashMap = (LinkedHashMap)this.myTypesOfStringEntries.getValue();
        if (linkedHashMap == null) {
            GrMapTypeFromNamedArgs.$$$reportNull$$$0(7);
        }
        return linkedHashMap;
    }

    public boolean isValid() {
        for (GrExpression grExpression : this.myStringEntries.values()) {
            if (grExpression.isValid()) continue;
            return false;
        }
        for (Couple couple : this.myOtherEntries) {
            if (!((GrExpression)couple.first).isValid()) {
                return false;
            }
            if (((GrExpression)couple.second).isValid()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GrMapTypeFromNamedArgs args = (GrMapTypeFromNamedArgs)((Object)o);
        if (!this.myStringEntries.equals(args.myStringEntries)) {
            return false;
        }
        return this.myOtherEntries.equals(args.myOtherEntries);
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myStringEntries.hashCode();
        result2 = 31 * result2 + this.myOtherEntries.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/impl/GrMapTypeFromNamedArgs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringKeys";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherEntries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

