/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GrExpressionList;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.VariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.VariableDescriptorFactory;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

public class InstanceOfInstruction
extends InstructionImpl
implements MixinTypeInstruction {
    private final ConditionInstruction myCondition;
    private final Map<VariableDescriptor, Integer> myVariableIndex;

    public InstanceOfInstruction(@NotNull GroovyPsiElement assertion, ConditionInstruction cond, Map<VariableDescriptor, Integer> index) {
        if (assertion == null) {
            InstanceOfInstruction.$$$reportNull$$$0(0);
        }
        super(assertion);
        this.myCondition = cond;
        this.myVariableIndex = index;
    }

    @Override
    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = Objects.requireNonNull(super.getElement());
        if (psiElement == null) {
            InstanceOfInstruction.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @Override
    @NotNull
    protected String getElementPresentation() {
        String string = "instanceof: " + this.getElement().getText();
        if (string == null) {
            InstanceOfInstruction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private Pair<GrExpression, PsiType> getInstanceof() {
        GrSwitchElement switchElement;
        GrExpression condition;
        PsiElement element = this.getElement();
        if (element instanceof GrInstanceOfExpression) {
            GrExpression qualifier;
            GrExpression operand = ((GrInstanceOfExpression)element).getOperand();
            GrTypeElement typeElement = ((GrInstanceOfExpression)element).getTypeElement();
            if (operand instanceof GrReferenceExpression && ((qualifier = (GrExpression)((GrReferenceExpression)operand).getQualifier()) == null || PsiImplUtilKt.isThisRef(qualifier)) && typeElement != null) {
                return Pair.create((Object)((GrInstanceOfExpression)element).getOperand(), (Object)typeElement.getType());
            }
        } else if (element instanceof GrBinaryExpression && ControlFlowBuilderUtil.isInstanceOfBinary((GrBinaryExpression)element)) {
            GrExpression left = ((GrBinaryExpression)element).getLeftOperand();
            GrExpression right = ((GrBinaryExpression)element).getRightOperand();
            if (right == null) {
                return null;
            }
            GroovyResolveResult result2 = ((GrReferenceExpression)right).advancedResolve();
            PsiElement resolved = result2.getElement();
            if (resolved instanceof PsiClass) {
                PsiClassType type2 = JavaPsiFacade.getElementFactory((Project)element.getProject()).createType((PsiClass)resolved, result2.getSubstitutor());
                return new Pair((Object)left, (Object)type2);
            }
        } else if (element instanceof GrBinaryExpression) {
            GrExpression left = ((GrBinaryExpression)element).getLeftOperand();
            GrExpression right = ((GrBinaryExpression)element).getRightOperand();
            if (PsiUtilKt.isNullLiteral(right)) {
                return Pair.create((Object)left, (Object)PsiType.NULL);
            }
            if (right != null && PsiUtilKt.isNullLiteral(left)) {
                return Pair.create((Object)right, (Object)PsiType.NULL);
            }
        } else if (element instanceof GrExpressionList && element.getParent() instanceof GrCaseSection && element.getParent().getParent() instanceof GrSwitchElement && (condition = (switchElement = (GrSwitchElement)element.getParent().getParent()).getCondition()) instanceof GrReferenceExpression) {
            List<GrExpression> expressions = PsiUtil.getAllPatternsForCaseSection((GrCaseSection)element.getParent());
            List patternClasses = ContainerUtil.mapNotNull(expressions, expr -> {
                PsiElement resolved;
                if (expr instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)expr).resolve()) instanceof PsiClass) {
                    return (PsiClass)resolved;
                }
                return null;
            });
            if (patternClasses.size() != expressions.size()) {
                return null;
            }
            List classTypes = ContainerUtil.map((Collection)patternClasses, InferenceKt::type);
            PsiType commonType = TypesUtil.getLeastUpperBoundNullable(classTypes, element.getManager());
            return Pair.create((Object)((GrReferenceExpression)condition), (Object)commonType);
        }
        return null;
    }

    @Override
    @Nullable
    public PsiType inferMixinType() {
        Pair<GrExpression, PsiType> instanceOf = this.getInstanceof();
        if (instanceOf == null) {
            return null;
        }
        return (PsiType)instanceOf.getSecond();
    }

    @Override
    @Nullable
    public ReadWriteVariableInstruction getInstructionToMixin(Instruction[] flow) {
        Pair<GrExpression, PsiType> instanceOf = this.getInstanceof();
        if (instanceOf == null) {
            return null;
        }
        Instruction instruction = ControlFlowUtils.findInstruction((PsiElement)instanceOf.getFirst(), flow);
        if (instruction instanceof ReadWriteVariableInstruction) {
            return (ReadWriteVariableInstruction)instruction;
        }
        return null;
    }

    @Override
    public int getVariableDescriptor() {
        Pair<GrExpression, PsiType> instanceOf = this.getInstanceof();
        if (instanceOf == null || !(instanceOf.first instanceof GrReferenceExpression)) {
            return 0;
        }
        VariableDescriptor descriptor = VariableDescriptorFactory.createDescriptor((GrReferenceExpression)instanceOf.first);
        if (descriptor == null) {
            return 0;
        }
        Integer descr = this.myVariableIndex.get(descriptor);
        return descr == null ? 0 : descr;
    }

    @Override
    @Nullable
    public ConditionInstruction getConditionInstruction() {
        return this.myCondition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertion";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/InstanceOfInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/controlFlow/InstanceOfInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

