/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor;

import com.intellij.lang.Language;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/groovy/editor/GroovyBreadcrumbsInfoProvider;", "Lcom/intellij/ui/breadcrumbs/BreadcrumbsProvider;", "()V", "acceptElement", "", "e", "Lcom/intellij/psi/PsiElement;", "getElementInfo", "", "getElementTooltip", "getLanguages", "", "Lcom/intellij/lang/Language;", "()[Lcom/intellij/lang/Language;", "intellij.groovy"})
public final class GroovyBreadcrumbsInfoProvider
implements BreadcrumbsProvider {
    @NotNull
    public Language[] getLanguages() {
        return new Language[]{GroovyLanguage.INSTANCE};
    }

    public boolean acceptElement(@NotNull PsiElement e) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement = e;
        if (psiElement instanceof GrVariableDeclaration) {
            Object[] objectArray = ((GrVariableDeclaration)e).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.variables");
            bl = ArraysKt.singleOrNull((Object[])objectArray) instanceof GrField;
        } else {
            bl = psiElement instanceof GrField ? e instanceof GrEnumConstant : (psiElement instanceof GrFunctionalExpression ? true : (psiElement instanceof GrMember ? ((GrMember)e).getName() != null : false));
        }
        return bl;
    }

    @NotNull
    public String getElementInfo(@NotNull PsiElement e) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        PsiElement psiElement = e;
        if (psiElement instanceof GrVariableDeclaration) {
            Object[] objectArray = ((GrVariableDeclaration)e).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.variables");
            Object object2 = ArraysKt.single((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"e.variables.single()");
            String string = ((GrVariable)object2).getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.variables.single().name");
        } else if (psiElement instanceof GrFunctionalExpression) {
            Object object3;
            PsiElement psiElement2 = ((GrFunctionalExpression)e).getParent();
            if (!(psiElement2 instanceof GrMethodCall)) {
                psiElement2 = null;
            }
            GrMethodCall grMethodCall = (GrMethodCall)psiElement2;
            GrExpression grExpression = grMethodCall != null ? grMethodCall.getInvokedExpression() : null;
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            if ((object3 = (GrReferenceExpression)grExpression) == null || (object3 = object3.getReferenceName()) == null) {
                object3 = "";
            }
            object = (String)object3 + "{}";
        } else if (psiElement instanceof GrAnonymousClassDefinition) {
            GrCodeReferenceElement grCodeReferenceElement = ((GrAnonymousClassDefinition)e).getBaseClassReferenceGroovy();
            Intrinsics.checkNotNullExpressionValue((Object)grCodeReferenceElement, (String)"e.baseClassReferenceGroovy");
            object = "new " + grCodeReferenceElement.getReferenceName();
        } else if (psiElement instanceof GrMethod) {
            object = ((GrMethod)e).getName() + "()";
        } else if (psiElement instanceof GrMember) {
            String string = ((GrMember)e).getName();
            Intrinsics.checkNotNull((Object)string);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.name!!");
        } else {
            throw (Throwable)new RuntimeException();
        }
        return object;
    }

    @NotNull
    public String getElementTooltip(@NotNull PsiElement e) {
        PsiElement psiElement;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof GrVariableDeclaration) {
            Object[] objectArray = ((GrVariableDeclaration)e).getVariables();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.variables");
            psiElement2 = (PsiElement)ArraysKt.single((Object[])objectArray);
        } else {
            psiElement2 = e;
        }
        PsiElement it = psiElement = psiElement2;
        boolean bl = false;
        String string = ElementDescriptionUtil.getElementDescription((PsiElement)it, (ElementDescriptionLocation)((ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(if (e is GrVariableDecl\u2026tion(it, WITH_PARENT)\n  }");
        return string;
    }
}

