/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/groovy/annotator/intentions/ReplaceDotFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "oldDot", "Lcom/intellij/psi/tree/IElementType;", "newDot", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/psi/tree/IElementType;)V", "myName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getMyName", "()Ljava/lang/String;", "getOldDot", "()Lcom/intellij/psi/tree/IElementType;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "intellij.groovy.psi"})
public final class ReplaceDotFix
implements LocalQuickFix {
    @NotNull
    private final IElementType oldDot;
    private final IElementType newDot;

    private final String getMyName() {
        String string = GroovyBundle.message("intention.family.name.replace.something.with", this.oldDot, this.newDot);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GroovyBundle.message(\"in\u2026ng.with\", oldDot, newDot)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getMyName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null || (psiElement = psiElement.getNode()) == null) {
            return;
        }
        PsiElement oldNode = psiElement;
        LeafElement leafElement = ASTFactory.leaf((IElementType)this.newDot, (CharSequence)this.newDot.toString());
        Intrinsics.checkNotNullExpressionValue((Object)leafElement, (String)"ASTFactory.leaf(newDot, newDot.toString())");
        LeafElement newNode = leafElement;
        CodeEditUtil.setNodeGenerated((ASTNode)((ASTNode)newNode), (boolean)true);
        oldNode.getTreeParent().replaceChild((ASTNode)oldNode, (ASTNode)newNode);
    }

    @NotNull
    public final IElementType getOldDot() {
        return this.oldDot;
    }

    public ReplaceDotFix(@NotNull IElementType oldDot, @NotNull IElementType newDot) {
        Intrinsics.checkNotNullParameter((Object)oldDot, (String)"oldDot");
        Intrinsics.checkNotNullParameter((Object)newDot, (String)"newDot");
        this.oldDot = oldDot;
        this.newDot = newDot;
    }
}

