/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.lang.java.beans.PropertyKind;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.ProcessorWithHints;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.text.StringKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrMethodWrapper;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleSetterAsMethodContributor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/NonCodeMembersContributor;", "()V", "processDynamicElements", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "aClass", "Lcom/intellij/psi/PsiClass;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "place", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "SetterAsMethodProcessor", "intellij.gradle.java"})
public final class GradleSetterAsMethodContributor
extends NonCodeMembersContributor {
    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        String string;
        Intrinsics.checkNotNullParameter((Object)qualifierType, (String)"qualifierType");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (aClass == null) {
            return;
        }
        if (!ResolveUtilKt.shouldProcessMethods((PsiScopeProcessor)processor)) {
            return;
        }
        if (!UtilKt.isGradleScript(place.getContainingFile())) {
            return;
        }
        String string2 = ResolveUtilKt.getName((PsiScopeProcessor)processor, (ResolveState)state);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = "set" + StringsKt.capitalize((String)it);
        } else {
            string = null;
        }
        String setterName = string;
        aClass.processDeclarations((PsiScopeProcessor)new SetterAsMethodProcessor(setterName, processor), state, null, place);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleSetterAsMethodContributor$SetterAsMethodProcessor;", "Lcom/intellij/psi/scope/ProcessorWithHints;", "setterName", "", "delegate", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "(Ljava/lang/String;Lcom/intellij/psi/scope/PsiScopeProcessor;)V", "execute", "", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "extractPropertyName", "method", "Lcom/intellij/psi/PsiMethod;", "intellij.gradle.java"})
    private static final class SetterAsMethodProcessor
    extends ProcessorWithHints {
        private final PsiScopeProcessor delegate;

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            PsiElement psiElement = element;
            if (!(psiElement instanceof PsiMethod)) {
                psiElement = null;
            }
            PsiMethod psiMethod = (PsiMethod)psiElement;
            if (psiMethod == null) {
                return true;
            }
            PsiMethod method = psiMethod;
            String string = this.extractPropertyName(method);
            if (string == null) {
                return true;
            }
            String propertyName = string;
            return this.delegate.execute((PsiElement)GrMethodWrapper.wrap((PsiMethod)method, (String)propertyName), state);
        }

        private final String extractPropertyName(PsiMethod method) {
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            String methodName = string;
            String string2 = PropertyKind.SETTER.prefix;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"PropertyKind.SETTER.prefix");
            if (!StringsKt.startsWith$default((String)methodName, (String)string2, (boolean)false, (int)2, null)) {
                return null;
            }
            String string3 = PropertyKind.SETTER.prefix;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PropertyKind.SETTER.prefix");
            return StringKt.nullize$default((String)StringsKt.decapitalize((String)StringsKt.removePrefix((String)methodName, (CharSequence)string3)), (boolean)false, (int)1, null);
        }

        public SetterAsMethodProcessor(final @Nullable String setterName, @NotNull PsiScopeProcessor delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            if (setterName != null) {
                this.hint(NameHint.KEY, new NameHint(){

                    @Nullable
                    public final String getName(@NotNull ResolveState it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return setterName;
                    }
                });
            }
            this.hint(ElementClassHint.KEY, 2.INSTANCE);
        }
    }
}

