/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.task.GradleTaskResultListener;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleProjectOutputsUpdater;", "Lorg/jetbrains/plugins/gradle/service/task/GradleTaskResultListener;", "()V", "onSuccess", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "projectPath", "", "Companion", "intellij.gradle.java"})
public final class GradleProjectOutputsUpdater
implements GradleTaskResultListener {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void onSuccess(@NotNull ExternalSystemTaskId id, @NotNull String projectPath) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable list$iv$iv;
        DataNode it;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        if (!Registry.is((String)"gradle.refresh.project.outputs")) {
            return;
        }
        Project ideaProject = id.findProject();
        if (ideaProject == null) {
            LOG.warn("Project path [" + projectPath + "] does not belong to any open Gradle projects");
            return;
        }
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(ideaProject);
        DataNode dataNode = ExternalSystemApiUtil.findProjectNode((Project)ideaProject, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
        if (dataNode == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"ExternalSystemApiUtil.fi\u2026D, projectPath) ?: return");
        DataNode projectNode = dataNode;
        Collection collection = ExternalSystemApiUtil.findAll((DataNode)projectNode, (Key)ProjectKeys.MODULE);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.fi\u2026Node, ProjectKeys.MODULE)");
        Collection moduleNodes = collection;
        Iterable $this$flatMap$iv = moduleNodes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (DataNode)element$iv$iv;
            boolean bl = false;
            Collection collection2 = ExternalSystemApiUtil.findAll((DataNode)it, (Key)GradleSourceSetData.KEY);
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"ExternalSystemApiUtil.fi\u2026 GradleSourceSetData.KEY)");
            list$iv$iv = CollectionsKt.plus((Collection)collection2, (Object)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (DataNode)item$iv$iv;
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            DataNode dataNode2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode2, (String)"it");
            ModuleData moduleData = (ModuleData)dataNode2.getData();
            collection3.add(moduleData);
        }
        $this$map$iv = CollectionsKt.filterIsInstance((Iterable)((List)destination$iv$iv), ModuleData.class);
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Module module;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ModuleData it2 = (ModuleData)element$iv$iv;
            boolean bl2 = false;
            if (modelsProvider.findIdeModule(it2) == null) continue;
            Module it$iv$iv = module;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List affectedModules = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = affectedModules;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Module[] moduleArray = thisCollection$iv.toArray(new Module[0]);
        if (moduleArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray = CompilerPaths.getOutputPaths((Module[])moduleArray);
        HashSet hashSet = ContainerUtil.newHashSet((Object[])Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"ContainerUtil.newHashSet\u2026dModules.toTypedArray()))");
        HashSet affectedRoots = hashSet;
        CompilerUtil.refreshOutputRoots((Collection)affectedRoots);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleProjectOutputsUpdater.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/service/GradleProjectOutputsUpdater$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

