/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerListener;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPickerModel;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.SaturationBrightnessComponentKt;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.SaturationBrightnessImageProducer;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.UtilsKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0018\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0014J\u001a\u0010(\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J(\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0010\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u000200H\u0002R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u00061"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/SaturationBrightnessComponent;", "Ljavax/swing/JComponent;", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerListener;", "myModel", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;", "(Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPickerModel;)V", "<set-?>", "", "alpha", "getAlpha", "()I", "", "brightness", "getBrightness", "()F", "hue", "getHue", "knobInnerRadius", "knobOuterRadius", "knobX", "knobY", "saturation", "getSaturation", "colorChanged", "", "color", "Ljava/awt/Color;", "source", "", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "handleMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "commit", "", "paintComponent", "g", "Ljava/awt/Graphics;", "pickingColorChanged", "setHSBAValue", "h", "s", "b", "a", "setKnobPosition", "hsbArray", "", "intellij.android.adt.ui"})
public final class SaturationBrightnessComponent
extends JComponent
implements ColorPickerListener {
    private final int knobOuterRadius;
    private final int knobInnerRadius;
    private float brightness;
    private float hue;
    private float saturation;
    private int alpha;
    private int knobX;
    private int knobY;
    private final ColorPickerModel myModel;

    public final float getBrightness() {
        return this.brightness;
    }

    public final float getHue() {
        return this.hue;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    private final void handleMouseEvent(MouseEvent e, boolean commit) {
        this.knobX = Math.max(0, Math.min(e.getX(), this.getSize().width));
        this.knobY = Math.max(0, Math.min(e.getY(), this.getSize().height));
        float saturation = (float)this.knobX / (float)this.getSize().width;
        float brightness = 1.0f - (float)this.knobY / (float)this.getSize().height;
        int argb = UtilsKt.ahsbToArgb(this.alpha, this.hue, saturation, brightness);
        ((Function2)(commit ? new Function2<Color, Object, Unit>(this.myModel){

            public final void invoke(@NotNull Color p1, @Nullable Object p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((ColorPickerModel)this.receiver).setColor(p1, p2);
            }
        } : new Function2<Color, Object, Unit>(this.myModel){

            public final void invoke(@NotNull Color p1, @Nullable Object p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((ColorPickerModel)this.receiver).setPickingColor(p1, p2);
            }
        })).invoke((Object)new Color(argb, true), (Object)this);
        this.repaint();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size((int)300, (int)150);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"JBUI.size(COLOR_PICKER_WIDTH, 150)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)150, (int)140);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"JBUI.size(150, 140)");
        return (Dimension)jBDimension;
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Image image = this.createImage(new SaturationBrightnessImageProducer(this.getSize().width, this.getSize().height, this.hue));
        g.setColor(UIUtil.getPanelBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(image, 0, 0, null);
        g.setColor(SaturationBrightnessComponentKt.access$getKNOB_COLOR$p());
        g.drawOval(this.knobX - this.knobOuterRadius, this.knobY - this.knobOuterRadius, this.knobOuterRadius * 2, this.knobOuterRadius * 2);
        g.drawOval(this.knobX - this.knobInnerRadius, this.knobY - this.knobInnerRadius, this.knobInnerRadius * 2, this.knobInnerRadius * 2);
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (Intrinsics.areEqual((Object)source, (Object)this)) {
            return;
        }
        float[] hsbValues = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.setHSBAValue(hsbValues[0], hsbValues[1], hsbValues[2], color.getAlpha());
        Intrinsics.checkNotNullExpressionValue((Object)hsbValues, (String)"hsbValues");
        this.setKnobPosition(hsbValues);
        this.repaint();
    }

    private final void setHSBAValue(float h, float s, float b, int a) {
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        this.alpha = a;
    }

    private final void setKnobPosition(float[] hsbArray) {
        this.knobX = (int)(hsbArray[1] * (float)this.getSize().width);
        this.knobY = (int)((1.0f - hsbArray[2]) * (float)this.getSize().height);
    }

    @Override
    public void pickingColorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.colorChanged(color, source);
    }

    public SaturationBrightnessComponent(@NotNull ColorPickerModel myModel) {
        Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
        this.myModel = myModel;
        this.knobOuterRadius = JBUI.scale((int)4);
        this.knobInnerRadius = JBUI.scale((int)3);
        this.brightness = 1.0f;
        this.hue = 1.0f;
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ SaturationBrightnessComponent this$0;

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e, false);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e, false);
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e, true);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseListener(mouseAdapter2);
        this.addMouseMotionListener(mouseAdapter2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.setKnobPosition(myModel.getHsb());
            }
        });
        this.myModel.addListener(this);
    }

    public static final /* synthetic */ void access$handleMouseEvent(SaturationBrightnessComponent $this, MouseEvent e, boolean commit) {
        $this.handleMouseEvent(e, commit);
    }
}

