/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.treegrid;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeGrid<T>
extends Box {
    private final Map<Object, JComponent> mySectionToComponent;
    private final List<JList<T>> myLists;
    private final List<HideableDecorator> myHideables;
    private final KeyListener myKeyListener;
    private final FocusListener myFocusListener;
    private final MouseListener myMouseListener;
    private final ListSelectionListener myListSelectionListener;
    private AbstractTreeStructure myModel;
    private boolean myFiltered;
    private boolean myExpandFiltered;
    private int myLastMidX;

    public TreeGrid(@NotNull AbstractTreeStructure model2) {
        if (model2 == null) {
            TreeGrid.$$$reportNull$$$0(0);
        }
        this();
        this.setModelWithSectionHeaders(model2);
    }

    public TreeGrid() {
        super(1);
        this.myLastMidX = -1;
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.mySectionToComponent = new IdentityHashMap<Object, JComponent>();
        this.myLists = new ArrayList<JList<T>>();
        this.myHideables = new ArrayList<HideableDecorator>();
        this.myKeyListener = new MyKeyListener();
        this.myFocusListener = new MyFocusListener();
        this.myMouseListener = new MyMouseListener();
        this.myListSelectionListener = new MyListSelectionListener();
        this.addListSelectionListener(event -> {
            JList sourceList;
            if (event.getValueIsAdjusting()) {
                return;
            }
            Object source = event.getSource();
            if (source instanceof JList && (sourceList = (JList)source).getSelectedIndex() > -1) {
                for (JList<T> list : this.myLists) {
                    if (list == sourceList) continue;
                    list.clearSelection();
                }
            }
        });
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.setBackground(UIUtil.getListBackground());
        this.setOpaque(true);
    }

    public void setModel(@NotNull AbstractTreeStructure model2) {
        if (model2 == null) {
            TreeGrid.$$$reportNull$$$0(1);
        }
        this.setModel(model2, false);
    }

    public void setModelWithSectionHeaders(@NotNull AbstractTreeStructure model2) {
        if (model2 == null) {
            TreeGrid.$$$reportNull$$$0(2);
        }
        this.setModel(model2, true);
    }

    @Nullable
    public AbstractTreeStructure getModel() {
        return this.myModel;
    }

    private void setModel(@NotNull AbstractTreeStructure model2, boolean showSectionHeaders) {
        if (model2 == null) {
            TreeGrid.$$$reportNull$$$0(3);
        }
        this.myModel = model2;
        Object root = model2.getRootElement();
        Object[] sections = model2.getChildElements(root);
        this.mySectionToComponent.clear();
        this.myLists.clear();
        this.myHideables.clear();
        this.removeAll();
        this.setAutoscrolls(false);
        for (final Object section : sections) {
            String name = section.toString();
            FilteringListModel listModel = new FilteringListModel((ListModel)new AbstractListModel(){

                @Override
                public int getSize() {
                    return TreeGrid.this.myModel.getChildElements(section).length;
                }

                @Override
                public Object getElementAt(int index) {
                    return TreeGrid.this.myModel.getChildElements(section)[index];
                }
            });
            listModel.refilter();
            JBList list = new JBList((ListModel)listModel);
            list.setAutoscrolls(false);
            list.setSelectionMode(0);
            list.setVisibleRowCount(-1);
            list.setName(name);
            list.addKeyListener(this.myKeyListener);
            list.addFocusListener(this.myFocusListener);
            list.addMouseListener(this.myMouseListener);
            list.addListSelectionListener(this.myListSelectionListener);
            this.myLists.add((JList<T>)list);
            if (showSectionHeaders) {
                JPanel panel2 = new JPanel(new BorderLayout()){

                    @Override
                    public Dimension getMaximumSize() {
                        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
                    }
                };
                HideableDecorator hidyPanel = new HideableDecorator(panel2, name, false);
                this.myHideables.add(hidyPanel);
                hidyPanel.setContentComponent((JComponent)list);
                this.add(panel2);
                this.mySectionToComponent.put(section, panel2);
                continue;
            }
            if (this.getComponentCount() > 0) {
                this.add(new JSeparator());
            }
            list.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
            this.add((Component)list);
            this.mySectionToComponent.put(section, (JComponent)list);
        }
    }

    public void setVisibleSection(@Nullable Object section) {
        JComponent visible = section != null ? this.mySectionToComponent.get(section) : null;
        for (Component component : this.getComponents()) {
            component.setVisible(visible == null);
        }
        if (visible != null) {
            visible.setVisible(true);
        }
    }

    @Override
    public void setTransferHandler(@Nullable TransferHandler handler2) {
        for (JList<T> list : this.myLists) {
            list.setTransferHandler(handler2);
            if (GraphicsEnvironment.isHeadless()) continue;
            list.setDragEnabled(handler2 != null);
        }
    }

    public void addListSelectionListener(@NotNull ListSelectionListener lsl) {
        if (lsl == null) {
            TreeGrid.$$$reportNull$$$0(4);
        }
        this.listenerList.add(ListSelectionListener.class, lsl);
    }

    public void setCellRenderer(@NotNull ListCellRenderer<T> cellRenderer) {
        if (cellRenderer == null) {
            TreeGrid.$$$reportNull$$$0(5);
        }
        for (JList<T> list : this.myLists) {
            list.setCellRenderer(cellRenderer);
        }
    }

    public void setFixedCellWidth(int width) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellWidth(width);
        }
    }

    public void setFixedCellHeight(int height) {
        for (JList<T> list : this.myLists) {
            list.setFixedCellHeight(height);
        }
    }

    public void expandAll() {
        for (HideableDecorator hidyPanel : this.myHideables) {
            hidyPanel.setOn(true);
        }
    }

    public void setSectionExpanded(int index, boolean isExpanded) {
        if (index < 0 || index >= this.myHideables.size()) {
            return;
        }
        this.myHideables.get(index).setOn(isExpanded);
    }

    @VisibleForTesting
    @Nullable
    public JList<T> getSelectedList() {
        for (JList<T> list : this.myLists) {
            if (list.getSelectedIndex() <= -1) continue;
            return list;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        JComponent component = this.getFocusRecipient();
        if (component != null) {
            component.requestFocus();
        }
    }

    @Nullable
    public JComponent getFocusRecipient() {
        JList<T> firstVisible = null;
        for (JList<T> list : this.myLists) {
            if (!list.isVisible()) continue;
            if (list.getSelectedIndex() != -1) {
                return list;
            }
            if (firstVisible != null || list.getModel().getSize() <= 0) continue;
            firstVisible = list;
        }
        if (firstVisible != null) {
            this.setSelectedElement(firstVisible.getModel().getElementAt(0));
        }
        return firstVisible;
    }

    @Nullable
    public T getSelectedElement() {
        JList<T> list = this.getSelectedList();
        return list != null ? (T)list.getSelectedValue() : null;
    }

    @Nullable
    public T getSelectedVisibleElement() {
        JList<T> list = this.getSelectedList();
        return list != null && list.isVisible() ? (T)list.getSelectedValue() : null;
    }

    public void setSelectedElement(@Nullable T selectedElement) {
        for (JList<T> list : this.myLists) {
            if (selectedElement == null) {
                list.clearSelection();
                continue;
            }
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                if (list.getModel().getElementAt(i) != selectedElement) continue;
                list.setSelectedIndex(i);
                this.ensureIndexVisible(list, i);
                return;
            }
        }
    }

    private void ensureIndexVisible(@NotNull JList<T> list, int index) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Rectangle cellBounds = list.getCellBounds(index, index);
            if (cellBounds != null) {
                Rectangle rectangle = SwingUtilities.convertRectangle(list, cellBounds, this);
                this.scrollRectToVisible(rectangle);
            }
        }, ModalityState.any());
    }

    public void setLayoutOrientation(int mode) {
        for (JList<T> list : this.myLists) {
            list.setLayoutOrientation(mode);
        }
    }

    public void setFilter(@Nullable Condition<T> condition2) {
        this.myFiltered = condition2 != null;
        for (int i = 0; i < this.myLists.size(); ++i) {
            JList<T> list = this.myLists.get(i);
            ((FilteringListModel)list.getModel()).setFilter(condition2);
            if (!this.myFiltered || !this.myExpandFiltered) continue;
            boolean containsFilteredElement = list.getModel().getSize() > 0;
            this.setSectionExpanded(i, containsFilteredElement);
        }
    }

    public boolean isFiltered() {
        return this.myFiltered;
    }

    public void setExpandFiltered(boolean expandFiltered) {
        this.myExpandFiltered = expandFiltered;
    }

    public void expandOnly(int index) {
        for (int i = 0; i < this.myHideables.size(); ++i) {
            boolean isFirst = i == index;
            this.myHideables.get(i).setOn(isFirst);
        }
    }

    public void selectIfUnique() {
        T single = this.findSingleItem();
        if (single != null) {
            this.setSelectedElement(single);
        }
    }

    public int getFilterMatchCount() {
        if (!this.isFiltered()) {
            return -1;
        }
        int count = 0;
        for (JList<T> list : this.myLists) {
            ListModel<T> model2 = list.getModel();
            count += model2.getSize();
        }
        return count;
    }

    @Nullable
    private T findSingleItem() {
        T singleMatch = null;
        boolean found = false;
        for (JList<T> list : this.myLists) {
            ListModel<T> model2 = list.getModel();
            int size = model2.getSize();
            if (size == 1) {
                if (found) {
                    return null;
                }
                found = true;
                singleMatch = model2.getElementAt(0);
                continue;
            }
            if (size <= 1) continue;
            return null;
        }
        return singleMatch;
    }

    public void selectFirst() {
        for (JList<T> list : this.myLists) {
            ListModel<T> model2 = list.getModel();
            int size = model2.getSize();
            if (size <= 0) continue;
            T item = model2.getElementAt(0);
            this.setSelectedElement(item);
            list.requestFocus();
            this.ensureIndexVisible(list, 0);
            return;
        }
    }

    @VisibleForTesting
    @NotNull
    public List<JList<T>> getLists() {
        List<JList<T>> list = this.myLists;
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    protected void processComponentKeyEvent(@NotNull KeyEvent event) {
        if (event == null) {
            TreeGrid.$$$reportNull$$$0(8);
        }
        if (event.getID() != 401) {
            return;
        }
        Object source = event.getSource();
        if (!(source instanceof JList)) {
            return;
        }
        JList list = (JList)source;
        boolean consumed = false;
        switch (event.getKeyCode()) {
            case 40: {
                consumed = this.handleKeyDown(list);
                break;
            }
            case 38: {
                consumed = this.handleKeyUp(list);
                break;
            }
            case 37: {
                this.myLastMidX = -1;
                consumed = this.handleKeyLeft(list);
                break;
            }
            case 39: {
                this.myLastMidX = -1;
                consumed = this.handleKeyRight(list);
            }
        }
        if (consumed) {
            event.consume();
        }
    }

    private boolean handleKeyDown(@NotNull JList<T> list) {
        int selectedIndex;
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(9);
        }
        if ((selectedIndex = list.getSelectedIndex()) < 0) {
            return false;
        }
        if (this.myLastMidX < 0) {
            this.myLastMidX = this.midX(list, selectedIndex);
        }
        if (!this.isLastRow(list, selectedIndex)) {
            int nextLineStart = this.findNextListStart(list, selectedIndex);
            int newSelectedItem = this.findBestMatchFromLeft(list, this.myLastMidX, nextLineStart);
            this.selectNewItem(list, newSelectedItem, list);
            return true;
        }
        for (int listIndex = this.myLists.indexOf(list) + 1; listIndex != 0 && listIndex < this.myLists.size(); ++listIndex) {
            JList<T> nextList = this.myLists.get(listIndex);
            int itemCount = nextList.getModel().getSize();
            if (itemCount <= 0 || !nextList.isVisible()) continue;
            int newSelectedItem = this.findBestMatchFromLeft(nextList, this.myLastMidX, 0);
            this.selectNewItem(nextList, newSelectedItem, list);
            return true;
        }
        return false;
    }

    private boolean handleKeyUp(@NotNull JList<T> list) {
        int selectedIndex;
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(10);
        }
        if ((selectedIndex = list.getSelectedIndex()) < 0) {
            return false;
        }
        if (this.myLastMidX < 0) {
            this.myLastMidX = this.midX(list, selectedIndex);
        }
        if (!this.isFirstRow(list, selectedIndex)) {
            int prevLineEnd = this.findPrevListEnd(list, selectedIndex);
            int newSelectedItem = this.findBestMatchFromRight(list, this.myLastMidX, prevLineEnd);
            this.selectNewItem(list, newSelectedItem, list);
            return true;
        }
        for (int listIndex = this.myLists.indexOf(list) - 1; listIndex >= 0; --listIndex) {
            JList<T> prevList = this.myLists.get(listIndex);
            int itemCount = prevList.getModel().getSize();
            if (itemCount <= 0 || !prevList.isVisible()) continue;
            int newSelectedItem = this.findBestMatchFromRight(prevList, this.myLastMidX, itemCount - 1);
            this.selectNewItem(prevList, newSelectedItem, list);
            return true;
        }
        return false;
    }

    private boolean handleKeyRight(@NotNull JList<T> list) {
        int selectedIndex;
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(11);
        }
        if ((selectedIndex = list.getSelectedIndex()) < 0) {
            return false;
        }
        if (selectedIndex < list.getModel().getSize() - 1) {
            this.selectNewItem(list, selectedIndex + 1, list);
            return true;
        }
        for (int listIndex = this.myLists.indexOf(list) + 1; listIndex != 0 && listIndex < this.myLists.size(); ++listIndex) {
            JList<T> nextList = this.myLists.get(listIndex);
            int itemCount = nextList.getModel().getSize();
            if (itemCount <= 0 || !nextList.isVisible()) continue;
            this.selectNewItem(nextList, 0, list);
            return true;
        }
        return false;
    }

    private boolean handleKeyLeft(@NotNull JList<T> list) {
        int selectedIndex;
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(12);
        }
        if ((selectedIndex = list.getSelectedIndex()) < 0) {
            return false;
        }
        if (selectedIndex > 0) {
            this.selectNewItem(list, selectedIndex - 1, list);
            return true;
        }
        for (int listIndex = this.myLists.indexOf(list) - 1; listIndex >= 0; --listIndex) {
            JList<T> prevList = this.myLists.get(listIndex);
            int itemCount = prevList.getModel().getSize();
            if (itemCount <= 0 || !prevList.isVisible()) continue;
            this.selectNewItem(prevList, itemCount - 1, list);
            return true;
        }
        return false;
    }

    private int midX(@NotNull JList<T> list, int index) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(13);
        }
        Rectangle bounds = list.getCellBounds(index, index);
        return bounds.x + bounds.width / 2;
    }

    private boolean isFirstRow(@NotNull JList<T> list, int index) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(14);
        }
        Rectangle bounds = list.getCellBounds(index, index);
        Rectangle firstBounds = list.getCellBounds(0, 0);
        return TreeGrid.verticalOverlap(bounds, firstBounds);
    }

    private boolean isLastRow(@NotNull JList<T> list, int index) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(15);
        }
        int last = list.getModel().getSize() - 1;
        Rectangle bounds = list.getCellBounds(index, index);
        Rectangle lastBounds = list.getCellBounds(last, last);
        return TreeGrid.verticalOverlap(bounds, lastBounds);
    }

    private static boolean verticalOverlap(@NotNull Rectangle bounds1, @NotNull Rectangle bounds2) {
        if (bounds1 == null) {
            TreeGrid.$$$reportNull$$$0(16);
        }
        if (bounds2 == null) {
            TreeGrid.$$$reportNull$$$0(17);
        }
        return bounds1.y < bounds2.y + bounds2.height && bounds1.y + bounds1.height > bounds2.y;
    }

    private int findPrevListEnd(@NotNull JList<T> list, int index) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(18);
        }
        Rectangle bounds = list.getCellBounds(index, index);
        int prevIndex = index;
        Rectangle prevBounds = bounds;
        while (index > 0 && TreeGrid.verticalOverlap(bounds, prevBounds)) {
            prevBounds = list.getCellBounds(--prevIndex, prevIndex);
        }
        return prevIndex;
    }

    private int findNextListStart(@NotNull JList<T> list, int index) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(19);
        }
        int count = list.getModel().getSize();
        Rectangle bounds = list.getCellBounds(index, index);
        int nextIndex = index;
        Rectangle nextBounds = bounds;
        while (index < count && TreeGrid.verticalOverlap(bounds, nextBounds)) {
            nextBounds = list.getCellBounds(++nextIndex, nextIndex);
        }
        return nextIndex;
    }

    private int findBestMatchFromLeft(@NotNull JList<T> list, int x, int startIndex) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(20);
        }
        int bestIndex = startIndex;
        int count = list.getModel().getSize();
        Rectangle bounds = list.getCellBounds(startIndex, startIndex);
        int y = bounds.y + bounds.height / 2;
        while (bestIndex < count && bounds.y < y && bounds.x + bounds.width < x) {
            bounds = list.getCellBounds(++bestIndex, bestIndex);
        }
        return bestIndex < count ? bestIndex : count - 1;
    }

    private int findBestMatchFromRight(@NotNull JList<T> list, int x, int startIndex) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(21);
        }
        int bestIndex = startIndex;
        Rectangle bounds = list.getCellBounds(bestIndex, bestIndex);
        int y = bounds.y + bounds.height / 2;
        while (bestIndex > 0 && bounds.y + bounds.height > y && bounds.x > x) {
            bounds = list.getCellBounds(--bestIndex, bestIndex);
        }
        return bestIndex;
    }

    private void selectNewItem(@NotNull JList<T> list, int index, @NotNull JList<T> prevList) {
        if (list == null) {
            TreeGrid.$$$reportNull$$$0(22);
        }
        if (prevList == null) {
            TreeGrid.$$$reportNull$$$0(23);
        }
        prevList.clearSelection();
        list.setSelectedIndex(index);
        this.ensureIndexVisible(list, index);
        list.requestFocus();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lsl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellRenderer";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/treegrid/TreeGrid";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds2";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/treegrid/TreeGrid";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setModel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModelWithSectionHeaders";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListSelectionListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCellRenderer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureIndexVisible";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processComponentKeyEvent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyDown";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyUp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyRight";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleKeyLeft";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "midX";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFirstRow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isLastRow";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "verticalOverlap";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findPrevListEnd";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findNextListStart";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findBestMatchFromLeft";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findBestMatchFromRight";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectNewItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFocusTraversalPolicy
    extends FocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return null;
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return null;
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return TreeGrid.this.getSelectedList();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return TreeGrid.this.getSelectedList();
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return TreeGrid.this.getSelectedList();
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(@NotNull ListSelectionEvent event) {
            if (event == null) {
                MyListSelectionListener.$$$reportNull$$$0(0);
            }
            for (ListSelectionListener listener2 : (ListSelectionListener[])TreeGrid.this.listenerList.getListeners(ListSelectionListener.class)) {
                listener2.valueChanged(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/adtui/treegrid/TreeGrid$MyListSelectionListener", "valueChanged"));
        }
    }

    private class MyMouseListener
    implements MouseListener {
        private MyMouseListener() {
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            if (event == null) {
                MyMouseListener.$$$reportNull$$$0(0);
            }
            TreeGrid.this.processMouseEvent(event);
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                MyMouseListener.$$$reportNull$$$0(1);
            }
            TreeGrid.this.processMouseEvent(event);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                MyMouseListener.$$$reportNull$$$0(2);
            }
            TreeGrid.this.processMouseEvent(event);
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            if (event == null) {
                MyMouseListener.$$$reportNull$$$0(3);
            }
            TreeGrid.this.processMouseEvent(event);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            if (event == null) {
                MyMouseListener.$$$reportNull$$$0(4);
            }
            TreeGrid.this.processMouseEvent(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/adtui/treegrid/TreeGrid$MyMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyFocusListener
    implements FocusListener {
        private MyFocusListener() {
        }

        @Override
        public void focusGained(@NotNull FocusEvent event) {
            Component opposite;
            if (event == null) {
                MyFocusListener.$$$reportNull$$$0(0);
            }
            if ((opposite = event.getOppositeComponent()) == null || !SwingUtilities.isDescendingFrom(opposite, TreeGrid.this)) {
                TreeGrid.this.processFocusEvent(event);
            }
        }

        @Override
        public void focusLost(@NotNull FocusEvent event) {
            Component opposite;
            if (event == null) {
                MyFocusListener.$$$reportNull$$$0(1);
            }
            if ((opposite = event.getOppositeComponent()) == null || !SwingUtilities.isDescendingFrom(opposite, TreeGrid.this)) {
                TreeGrid.this.processFocusEvent(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/adtui/treegrid/TreeGrid$MyFocusListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusGained";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "focusLost";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (event == null) {
                MyKeyListener.$$$reportNull$$$0(0);
            }
            TreeGrid.this.processKeyEvent(event);
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            if (event == null) {
                MyKeyListener.$$$reportNull$$$0(1);
            }
            TreeGrid.this.processKeyEvent(event);
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            if (event == null) {
                MyKeyListener.$$$reportNull$$$0(2);
            }
            TreeGrid.this.processKeyEvent(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/adtui/treegrid/TreeGrid$MyKeyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyPressed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyTyped";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "keyReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

