/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.formatter;

import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;

public class EnergyAxisFormatter
extends BaseAxisFormatter {
    public static final String[] LABELS = new String[]{"Light", "Medium", "Heavy"};
    public static final int DEFAULT_MAJOR_INTERVAL = 200;
    public static final EnergyAxisFormatter DEFAULT = new EnergyAxisFormatter(0, LABELS.length, 1);
    public static final EnergyAxisFormatter LEGEND_FORMATTER = new EnergyAxisFormatter(0, LABELS.length, 1){

        @Override
        @NotNull
        public String getFormattedString(double globalRange, double value, boolean includeUnit) {
            if (value < (double)(200 * LABELS.length)) {
                String string = super.getFormattedString(globalRange, value, includeUnit);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = LABELS[LABELS.length - 1];
            if (string == null) {
                1.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/formatter/EnergyAxisFormatter$1", "getFormattedString"));
        }
    };

    private EnergyAxisFormatter(int maxMinorTicks, int maxMajorTicks, int switchThreshold) {
        super(maxMinorTicks, maxMajorTicks, switchThreshold);
    }

    @Override
    @NotNull
    public String getFormattedString(double globalRange, double value, boolean includeUnit) {
        double previousMarkerValue;
        int index = (int)Math.ceil(value / 200.0);
        if (index <= 0) {
            return "None";
        }
        if (index <= LABELS.length) {
            String string = LABELS[index - 1];
            if (string == null) {
                EnergyAxisFormatter.$$$reportNull$$$0(0);
            }
            return string;
        }
        long majorInterval = this.getMajorInterval(globalRange);
        double d = previousMarkerValue = value % (double)majorInterval != 0.0 ? value - value % (double)majorInterval : value - (double)majorInterval;
        if (previousMarkerValue <= (double)(200 * (LABELS.length - 1))) {
            String string = LABELS[LABELS.length - 1];
            if (string == null) {
                EnergyAxisFormatter.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @Override
    public long getMajorInterval(double range) {
        int numTicks = (int)(range / 200.0);
        if (numTicks < 1) {
            return (long)range;
        }
        if (numTicks <= LABELS.length) {
            return 200L;
        }
        int largestMarkerValue = LABELS.length * 200;
        for (numTicks = LABELS.length - 1; numTicks > 1; --numTicks) {
            long interval = largestMarkerValue / numTicks;
            if (!(range < (double)((long)largestMarkerValue + interval))) continue;
            return interval;
        }
        return largestMarkerValue;
    }

    @Override
    protected int getNumUnits() {
        return LABELS.length;
    }

    @Override
    @NotNull
    protected String getUnit(int index) {
        return index < LABELS.length ? LABELS[index] : "";
    }

    @Override
    protected int getUnitBase(int index) {
        return 1;
    }

    @Override
    protected int getUnitMultiplier(int index) {
        return 1;
    }

    @Override
    protected int getUnitMinimalInterval(int index) {
        return 1;
    }

    @Override
    @NotNull
    protected IntList getUnitBaseFactors(int index) {
        return new IntArrayList(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/formatter/EnergyAxisFormatter", "getFormattedString"));
    }
}

