/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model.filter;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class FilterResult {
    private final int myMatchCount;
    private final int myTotalCount;
    private final boolean myIsFilterEnabled;
    public static final FilterResult EMPTY_RESULT = new FilterResult(0, 0, false);

    public FilterResult(int matchCount, int totalCount, boolean isFilterEnabled) {
        assert (matchCount >= 0);
        this.myMatchCount = matchCount;
        this.myTotalCount = totalCount;
        this.myIsFilterEnabled = isFilterEnabled;
    }

    public int getMatchCount() {
        return this.myMatchCount;
    }

    public int getTotalCount() {
        return this.myTotalCount;
    }

    public boolean isFilterEnabled() {
        return this.myIsFilterEnabled;
    }

    public FilterResult combine(@NotNull FilterResult anotherResult) {
        if (anotherResult == null) {
            FilterResult.$$$reportNull$$$0(0);
        }
        return new FilterResult(this.getMatchCount() + anotherResult.getMatchCount(), this.getTotalCount() + anotherResult.getTotalCount(), this.isFilterEnabled() || anotherResult.isFilterEnabled());
    }

    public boolean equals(Object object) {
        if (object instanceof FilterResult) {
            FilterResult result = (FilterResult)object;
            if (this.myIsFilterEnabled) {
                return result.myIsFilterEnabled && result.myMatchCount == this.myMatchCount && result.myTotalCount == this.myTotalCount;
            }
            return !result.myIsFilterEnabled;
        }
        return false;
    }

    public int hashCode() {
        return this.myIsFilterEnabled ? Objects.hash(this.myMatchCount, this.myTotalCount) : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anotherResult", "com/android/tools/adtui/model/filter/FilterResult", "combine"));
    }
}

