/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class InstructionsRenderer {
    private int myRowHeight;
    private HorizontalAlignment myAlignment;
    @NotNull
    private final List<RenderInstruction> myInstructions;
    @NotNull
    private final Dimension mySize;
    @NotNull
    private final Map<Integer, Integer> myPerRowWidthMap;

    public InstructionsRenderer(@NotNull List<RenderInstruction> instructions, @NotNull HorizontalAlignment alignment) {
        if (instructions == null) {
            InstructionsRenderer.$$$reportNull$$$0(0);
        }
        if (alignment == null) {
            InstructionsRenderer.$$$reportNull$$$0(1);
        }
        this.myRowHeight = 0;
        this.myPerRowWidthMap = new HashMap<Integer, Integer>();
        this.myInstructions = instructions;
        this.myAlignment = alignment;
        for (RenderInstruction instruction : instructions) {
            this.myRowHeight = Math.max(instruction.getSize().height, this.myRowHeight);
        }
        int width = 0;
        int height = 0;
        Point cursor = new Point();
        for (RenderInstruction instruction : instructions) {
            instruction.moveCursor(this, cursor);
            width = Math.max(cursor.x, width);
            height = Math.max(cursor.y + this.myRowHeight, height);
            if (this.myPerRowWidthMap.containsKey(cursor.y) && this.myPerRowWidthMap.get(cursor.y) >= cursor.x) continue;
            this.myPerRowWidthMap.put(cursor.y, cursor.x);
        }
        this.mySize = new Dimension(width, height);
    }

    public int getRowHeight() {
        return this.myRowHeight;
    }

    @NotNull
    public Dimension getRenderSize() {
        Dimension dimension = this.mySize;
        if (dimension == null) {
            InstructionsRenderer.$$$reportNull$$$0(2);
        }
        return dimension;
    }

    @NotNull
    List<RenderInstruction> getInstructions() {
        List<RenderInstruction> list = this.myInstructions;
        if (list == null) {
            InstructionsRenderer.$$$reportNull$$$0(3);
        }
        return list;
    }

    public int getStartX(int y) {
        if (!this.myPerRowWidthMap.containsKey(y)) {
            return 0;
        }
        int rowWidth = this.myPerRowWidthMap.get(y);
        switch (this.myAlignment) {
            case CENTER: {
                return (this.mySize.width - rowWidth) / 2;
            }
            case RIGHT: {
                return this.mySize.width - rowWidth;
            }
        }
        return 0;
    }

    public void draw(@NotNull JComponent component, @NotNull Graphics2D g2d) {
        if (component == null) {
            InstructionsRenderer.$$$reportNull$$$0(4);
        }
        if (g2d == null) {
            InstructionsRenderer.$$$reportNull$$$0(5);
        }
        Point cursor = new Point(this.getStartX(0), 0);
        for (RenderInstruction instruction : this.myInstructions) {
            Rectangle bounds = instruction.getBounds(this, cursor);
            instruction.render(component, g2d, bounds);
            instruction.moveCursor(this, cursor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/instructions/InstructionsRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2d";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/instructions/InstructionsRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderSize";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum HorizontalAlignment {
        CENTER(0),
        LEFT(2),
        RIGHT(4);

        private int myAlignment;

        private HorizontalAlignment(int alignment) {
            this.myAlignment = alignment;
        }

        int getAlignment() {
            return this.myAlignment;
        }
    }
}

