/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.android.ninepatch.NinePatch;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.Gray;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceArtPainter {
    @NotNull
    private static final DeviceArtPainter ourInstance = new DeviceArtPainter();
    @Nullable
    private static volatile String ourSystemPath;
    @NotNull
    private Map<Device, DeviceData> myDeviceData = new HashMap<Device, DeviceData>();
    @Nullable
    private List<DeviceArtDescriptor> myDescriptors;

    private DeviceArtPainter() {
    }

    @NotNull
    public static DeviceArtPainter getInstance() {
        DeviceArtPainter deviceArtPainter = ourInstance;
        if (deviceArtPainter == null) {
            DeviceArtPainter.$$$reportNull$$$0(0);
        }
        return deviceArtPainter;
    }

    public boolean hasDeviceFrame(@Nullable Device device) {
        DeviceData deviceData = this.getDeviceData(device);
        if (deviceData == null) {
            return false;
        }
        return !deviceData.getDescriptor().isStretchable();
    }

    @Nullable
    private DeviceData getDeviceData(@Nullable Device device) {
        if (device == null) {
            return null;
        }
        DeviceData data = this.myDeviceData.get(device);
        if (data == null) {
            DeviceArtDescriptor spec = this.findDescriptor(device);
            data = new DeviceData(device, spec);
            this.myDeviceData.put(device, data);
        }
        return data;
    }

    @NotNull
    private DeviceArtDescriptor findDescriptor(@NotNull Device device) {
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(1);
        }
        String id = device.getId();
        String name = device.getDisplayName();
        DeviceArtDescriptor descriptor = this.findDescriptor(id = id.equals("3.7in WVGA (Nexus One)") ? "nexus_one" : (id.equals("4in WVGA (Nexus S)") ? "nexus_s" : (id.equals("4.65in 720p (Galaxy Nexus)") ? "galaxy_nexus" : id.replace(' ', '_'))), name);
        if (descriptor == null) {
            boolean isTablet = DeviceArtPainter.isTablet(device);
            descriptor = this.findDescriptor(isTablet ? "tablet" : "phone", null);
            assert (descriptor != null);
        }
        DeviceArtDescriptor deviceArtDescriptor = descriptor;
        if (deviceArtDescriptor == null) {
            DeviceArtPainter.$$$reportNull$$$0(2);
        }
        return deviceArtDescriptor;
    }

    public static boolean isTablet(@NotNull Device device) {
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(3);
        }
        boolean isTablet = false;
        if (device.getId().contains("Tablet")) {
            isTablet = true;
        } else {
            Screen screen = device.getDefaultHardware().getScreen();
            if (screen != null && screen.getDiagonalLength() >= 7.0 && !device.getDefaultHardware().getScreen().isFoldable()) {
                isTablet = true;
            }
        }
        return isTablet;
    }

    @Nullable
    private DeviceArtDescriptor findDescriptor(@NotNull String id, @Nullable String name) {
        if (id == null) {
            DeviceArtPainter.$$$reportNull$$$0(4);
        }
        for (DeviceArtDescriptor descriptor : this.getDescriptors()) {
            if (!id.equalsIgnoreCase(descriptor.getId()) && (name == null || !name.equalsIgnoreCase(descriptor.getName()))) continue;
            return descriptor;
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    List<DeviceArtDescriptor> getDescriptors() {
        if (this.myDescriptors == null) {
            this.myDescriptors = DeviceArtDescriptor.getDescriptors(null);
        }
        List<DeviceArtDescriptor> list = this.myDescriptors;
        if (list == null) {
            DeviceArtPainter.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void paintFrame(@NotNull Graphics g, @NotNull Device device, @NotNull ScreenOrientation orientation, boolean showEffects, int x1, int y1, int height) {
        DeviceData data;
        if (g == null) {
            DeviceArtPainter.$$$reportNull$$$0(6);
        }
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(7);
        }
        if (orientation == null) {
            DeviceArtPainter.$$$reportNull$$$0(8);
        }
        if ((data = this.getDeviceData(device)) == null || height == 0) {
            return;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        BufferedImage image = frame.getImage(showEffects);
        if (image != null) {
            double scale = (double)height / (double)frame.getScreenHeight();
            int dx1 = (int)((double)x1 - scale * (double)frame.getScreenX());
            int dy1 = (int)((double)y1 - scale * (double)frame.getScreenY());
            int dx2 = dx1 + (int)(scale * (double)image.getWidth());
            int dy2 = dy1 + (int)(scale * (double)image.getHeight());
            g.drawImage(image, dx1, dy1, dx2, dy2, 0, 0, image.getWidth(), image.getHeight(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createFrame(BufferedImage image, DeviceArtDescriptor descriptor, boolean addShadow, boolean addReflection) {
        ScreenOrientation orientation;
        double imgAspectRatio = (double)image.getWidth() / (double)image.getHeight();
        ScreenOrientation screenOrientation = orientation = imgAspectRatio >= 0.99999 ? ScreenOrientation.LANDSCAPE : ScreenOrientation.PORTRAIT;
        if (!descriptor.canFrameImage(image, orientation)) {
            return image;
        }
        File shadow = descriptor.getDropShadow(orientation);
        File background = descriptor.getFrame(orientation);
        File reflection = descriptor.getReflectionOverlay(orientation);
        Graphics g2d = null;
        try {
            File maskFile;
            double scale;
            BufferedImage bg = ImageIO.read(background);
            Dimension screen = descriptor.getScreenSize(orientation);
            Dimension frameSize = descriptor.getFrameSize(orientation);
            Point screenPos = descriptor.getScreenPos(orientation);
            boolean stretchable = descriptor.isStretchable();
            if (stretchable) {
                assert (screen != null);
                assert (frameSize != null);
                int newWidth = image.getWidth() + frameSize.width - screen.width;
                int newHeight = image.getHeight() + frameSize.height - screen.height;
                bg = DeviceArtPainter.stretchImage(bg, newWidth, newHeight);
            } else if (screen.width < image.getWidth() && Math.abs((scale = (double)screen.width / (double)image.getWidth()) - 1.0) > 1.0E-5) {
                image = ImageUtils.scale(image, scale, scale);
            }
            g2d = bg.createGraphics();
            if (addShadow && shadow != null) {
                BufferedImage shadowImage = ImageIO.read(shadow);
                if (stretchable) {
                    shadowImage = DeviceArtPainter.stretchImage(shadowImage, bg.getWidth(), bg.getHeight());
                }
                g2d.drawImage(shadowImage, 0, 0, null, null);
            }
            if ((maskFile = descriptor.getMask(orientation)) != null) {
                BufferedImage mask = ImageIO.read(maskFile);
                Graphics2D maskG2d = mask.createGraphics();
                maskG2d.setComposite(AlphaComposite.getInstance(5));
                maskG2d.drawImage((Image)image, screenPos.x, screenPos.y, null);
                maskG2d.dispose();
                g2d.drawImage(mask, 0, 0, null);
            } else {
                g2d.drawImage(image, screenPos.x, screenPos.y, null);
            }
            if (addReflection && reflection != null) {
                BufferedImage reflectionImage = ImageIO.read(reflection);
                if (stretchable) {
                    reflectionImage = DeviceArtPainter.stretchImage(reflectionImage, bg.getWidth(), bg.getHeight());
                }
                g2d.drawImage(reflectionImage, 0, 0, null, null);
            }
            BufferedImage bufferedImage = bg;
            return bufferedImage;
        }
        catch (IOException e) {
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            if (g2d != null) {
                g2d.dispose();
            }
        }
    }

    @Nullable
    private static Shape getClip(@Nullable Device device, int x, int y, int width, int height) {
        boolean round;
        boolean bl = round = device != null && device.isScreenRound();
        if (round) {
            int slop = 3;
            return new Ellipse2D.Double(x - slop, y - slop, width + 2 * slop, height + 2 * slop);
        }
        return null;
    }

    public static void paintClipped(@NotNull Graphics2D g, @NotNull BufferedImage image, @Nullable Device device, int x, int y, boolean withRetina) {
        if (g == null) {
            DeviceArtPainter.$$$reportNull$$$0(9);
        }
        if (image == null) {
            DeviceArtPainter.$$$reportNull$$$0(10);
        }
        Shape prevClip = null;
        Shape clip = DeviceArtPainter.getClip(device, x, y, image.getWidth(), image.getHeight());
        if (clip != null) {
            prevClip = g.getClip();
            g.setClip(clip);
        }
        if (withRetina) {
            StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)y, null);
        } else {
            g.drawImage((Image)image, x, y, null);
        }
        if (clip != null) {
            g.setClip(prevClip);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public BufferedImage createFrame(@NotNull BufferedImage image, @NotNull Device device, @NotNull ScreenOrientation orientation, boolean showEffects, double scale, @Nullable Rectangle rectangle) {
        if (image == null) {
            DeviceArtPainter.$$$reportNull$$$0(11);
        }
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(12);
        }
        if (orientation == null) {
            DeviceArtPainter.$$$reportNull$$$0(13);
        }
        BufferedImage scaledImage = ImageUtils.scale(image, scale, scale, 0, 0);
        DeviceData data = this.getDeviceData(device);
        int scaledHeight = (int)(scale * (double)image.getHeight());
        if (data == null || scaledHeight == 0) {
            BufferedImage bufferedImage = scaledImage;
            if (bufferedImage == null) {
                DeviceArtPainter.$$$reportNull$$$0(14);
            }
            return bufferedImage;
        }
        scale = (double)(scaledHeight - 1) / (double)image.getHeight();
        int scaledWidth = (int)((double)image.getWidth() * scale);
        boolean portrait = orientation != ScreenOrientation.LANDSCAPE;
        FrameData frame = portrait ? data.getPortraitData(scaledHeight) : data.getLandscapeData(scaledHeight);
        BufferedImage frameImage = frame.getImage(showEffects);
        if (frameImage != null) {
            void outViewRectangle;
            int framedWidth = (int)((double)image.getWidth() * scale * (double)frame.getFrameWidth() / (double)frame.getScreenWidth());
            int framedHeight = (int)((double)image.getHeight() * scale * (double)frame.getFrameHeight() / (double)frame.getScreenHeight());
            if (framedWidth <= 0 || framedHeight <= 0) {
                BufferedImage bufferedImage = scaledImage;
                if (bufferedImage == null) {
                    DeviceArtPainter.$$$reportNull$$$0(15);
                }
                return bufferedImage;
            }
            double downScale = (double)framedHeight / (double)frame.getFrameHeight();
            int screenX = (int)(downScale * (double)frame.getScreenX());
            int screenY = (int)(downScale * (double)frame.getScreenY());
            BufferedImage result = new BufferedImage(framedWidth, framedHeight, 2);
            Graphics2D g = result.createGraphics();
            g.setColor(Gray.TRANSPARENT);
            g.fillRect(0, 0, result.getWidth(), result.getHeight());
            DeviceArtPainter.paintClipped(g, scaledImage, device, screenX, screenY, false);
            BufferedImage scaledFrameImage = ImageUtils.scale(frameImage, downScale, downScale, 0, 0);
            g.drawImage((Image)scaledFrameImage, 0, 0, null);
            g.dispose();
            if (outViewRectangle != null) {
                outViewRectangle.x = screenX;
                outViewRectangle.y = screenY;
                outViewRectangle.width = scaledWidth;
                outViewRectangle.height = scaledHeight;
            }
            BufferedImage bufferedImage = result;
            if (bufferedImage == null) {
                DeviceArtPainter.$$$reportNull$$$0(16);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = scaledImage;
        if (bufferedImage == null) {
            DeviceArtPainter.$$$reportNull$$$0(17);
        }
        return bufferedImage;
    }

    @Nullable
    public Rectangle computeBounds(int imageWidth, int imageHeight, @NotNull Device device, @NotNull ScreenOrientation orientation, double scale) {
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(18);
        }
        if (orientation == null) {
            DeviceArtPainter.$$$reportNull$$$0(19);
        }
        DeviceData data = this.getDeviceData(device);
        int scaledHeight = (int)(scale * (double)imageHeight);
        if (data == null || scaledHeight == 0) {
            return null;
        }
        scale = (double)(scaledHeight - 1) / (double)imageHeight;
        int scaledWidth = (int)((double)imageWidth * scale);
        boolean portrait = orientation != ScreenOrientation.LANDSCAPE;
        FrameData frame = portrait ? data.getPortraitData(scaledHeight) : data.getLandscapeData(scaledHeight);
        int framedWidth = (int)((double)imageWidth * scale * (double)frame.getFrameWidth() / (double)frame.getScreenWidth());
        int framedHeight = (int)((double)imageHeight * scale * (double)frame.getFrameHeight() / (double)frame.getScreenHeight());
        if (framedWidth <= 0 || framedHeight <= 0) {
            return null;
        }
        double downScale = (double)framedHeight / (double)frame.getFrameHeight();
        int screenX = (int)(downScale * (double)frame.getScreenX());
        int screenY = (int)(downScale * (double)frame.getScreenY());
        return new Rectangle(screenX, screenY, scaledWidth, scaledHeight);
    }

    @NotNull
    private static BufferedImage stretchImage(BufferedImage image, int width, int height) {
        BufferedImage composite = new BufferedImage(width, height, 2);
        Graphics2D g = composite.createGraphics();
        g.setColor(Gray.TRANSPARENT);
        g.fillRect(0, 0, composite.getWidth(), composite.getHeight());
        NinePatch ninePatch = NinePatch.load((BufferedImage)image, (boolean)true, (boolean)false);
        assert (ninePatch != null);
        ninePatch.draw(g, 0, 0, width, height);
        g.dispose();
        BufferedImage bufferedImage = composite;
        if (bufferedImage == null) {
            DeviceArtPainter.$$$reportNull$$$0(20);
        }
        return bufferedImage;
    }

    @Nullable
    public Point getScreenPosition(@NotNull Device device, @NotNull ScreenOrientation orientation, int screenHeight) {
        DeviceData data;
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(21);
        }
        if (orientation == null) {
            DeviceArtPainter.$$$reportNull$$$0(22);
        }
        if ((data = this.getDeviceData(device)) == null) {
            return null;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        int screenX = frame.getScreenX();
        int screenY = frame.getScreenY();
        double scale = (double)screenHeight / (double)frame.getScreenHeight();
        screenX = (int)((double)screenX * scale);
        screenY = (int)((double)screenY * scale);
        return new Point(screenX, screenY);
    }

    public double getFrameMaxOverhead(@NotNull Device device, @NotNull ScreenOrientation orientation) {
        DeviceData data;
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(23);
        }
        if (orientation == null) {
            DeviceArtPainter.$$$reportNull$$$0(24);
        }
        if ((data = this.getDeviceData(device)) == null) {
            return 1.0;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        return Math.max((double)frame.getFrameWidth() / (double)frame.getScreenWidth(), (double)frame.getFrameHeight() / (double)frame.getScreenHeight());
    }

    public double getFrameWidthOverhead(@NotNull Device device, @NotNull ScreenOrientation orientation) {
        DeviceData data;
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(25);
        }
        if (orientation == null) {
            DeviceArtPainter.$$$reportNull$$$0(26);
        }
        if ((data = this.getDeviceData(device)) == null) {
            return 1.0;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        return (double)frame.getFrameHeight() / (double)frame.getScreenHeight();
    }

    public double getFrameHeightOverhead(@NotNull Device device, @NotNull ScreenOrientation orientation) {
        DeviceData data;
        if (device == null) {
            DeviceArtPainter.$$$reportNull$$$0(27);
        }
        if (orientation == null) {
            DeviceArtPainter.$$$reportNull$$$0(28);
        }
        if ((data = this.getDeviceData(device)) == null) {
            return 1.0;
        }
        FrameData frame = data.getFrameData(orientation, Integer.MAX_VALUE);
        return (double)frame.getFrameWidth() / (double)frame.getScreenWidth();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/device/DeviceArtPainter";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 12: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 8: 
            case 13: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orientation";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/device/DeviceArtPainter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findDescriptor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrame";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "stretchImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTablet";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "paintFrame";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "paintClipped";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFrame";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeBounds";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getScreenPosition";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFrameMaxOverhead";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFrameWidthOverhead";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getFrameHeightOverhead";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class FrameData {
        @NotNull
        private final DeviceData myDeviceData;
        @NotNull
        private final ScreenOrientation myOrientation;
        private final int myX;
        private final int myY;
        private final int myWidth;
        private final int myHeight;
        private final int myCropX1;
        private final int myCropY1;
        private final int myCropX2;
        private final int myCropY2;
        private int myFrameWidth;
        private int myFrameHeight;
        private final FrameData myDouble;
        @NotNull
        private SoftReference<BufferedImage> myPlainImage;
        @NotNull
        private SoftReference<BufferedImage> myEffectsImage;

        private boolean isPortrait() {
            return this.myOrientation == ScreenOrientation.PORTRAIT;
        }

        private FrameData(@NotNull DeviceData deviceData, @NotNull ScreenOrientation orientation) {
            if (deviceData == null) {
                FrameData.$$$reportNull$$$0(0);
            }
            if (orientation == null) {
                FrameData.$$$reportNull$$$0(1);
            }
            this.myPlainImage = new SoftReference(null);
            this.myEffectsImage = new SoftReference(null);
            this.myDeviceData = deviceData;
            this.myOrientation = orientation;
            this.myDouble = null;
            DeviceArtDescriptor descriptor = deviceData.getDescriptor();
            if (!this.isStretchable()) {
                Dimension fullSize = descriptor.getFrameSize(this.myOrientation);
                int frameWidth = fullSize.width;
                int frameHeight = fullSize.height;
                Rectangle crop = descriptor.getCrop(this.myOrientation);
                if (crop != null) {
                    this.myCropX1 = crop.x;
                    this.myCropY1 = crop.y;
                    this.myCropX2 = crop.x + crop.width;
                    this.myCropY2 = crop.y + crop.height;
                    frameWidth = crop.width;
                    frameHeight = crop.height;
                } else {
                    this.myCropX1 = 0;
                    this.myCropY1 = 0;
                    this.myCropX2 = frameWidth;
                    this.myCropY2 = frameHeight;
                }
                this.myFrameWidth = frameWidth;
                this.myFrameHeight = frameHeight;
                Point screenPos = descriptor.getScreenPos(this.myOrientation);
                this.myX = screenPos.x - this.myCropX1;
                this.myY = screenPos.y - this.myCropY1;
                Dimension screenSize = descriptor.getScreenSize(this.myOrientation);
                this.myWidth = screenSize.width;
                this.myHeight = screenSize.height;
            } else {
                Device device = this.myDeviceData.getDevice();
                Dimension screenSize = device.getScreenSize(this.myOrientation);
                Dimension screen = descriptor.getScreenSize(this.myOrientation);
                Dimension frameSize = descriptor.getFrameSize(this.myOrientation);
                Point screenPos = descriptor.getScreenPos(this.myOrientation);
                assert (screenSize != null);
                assert (screen != null);
                assert (frameSize != null);
                this.myX = screenPos.x;
                this.myY = screenPos.y;
                this.myWidth = screenSize.width;
                this.myHeight = screenSize.height;
                this.myFrameWidth = this.myWidth + frameSize.width - screen.width;
                this.myFrameHeight = this.myHeight + frameSize.height - screen.height;
                this.myCropX1 = 0;
                this.myCropY1 = 0;
                this.myCropX2 = this.myFrameWidth;
                this.myCropY2 = this.myFrameHeight;
            }
        }

        private FrameData(@NotNull DeviceData deviceData, @NotNull FrameData large) {
            if (deviceData == null) {
                FrameData.$$$reportNull$$$0(2);
            }
            if (large == null) {
                FrameData.$$$reportNull$$$0(3);
            }
            this.myPlainImage = new SoftReference(null);
            this.myEffectsImage = new SoftReference(null);
            this.myDeviceData = deviceData;
            this.myDouble = large;
            this.myOrientation = large.myOrientation;
            this.myX = large.myX / 2;
            this.myY = large.myY / 2;
            this.myWidth = large.myWidth / 2;
            this.myHeight = large.myHeight / 2;
            this.myFrameWidth = large.myFrameWidth / 2;
            this.myFrameHeight = large.myFrameHeight / 2;
            this.myCropX1 = 0;
            this.myCropY1 = 0;
            this.myCropX2 = this.myFrameWidth;
            this.myCropY2 = this.myFrameHeight;
        }

        public int getScreenX() {
            return this.myX;
        }

        public int getScreenY() {
            return this.myY;
        }

        public int getScreenWidth() {
            return this.myWidth;
        }

        public int getScreenHeight() {
            return this.myHeight;
        }

        public int getFrameWidth() {
            return this.myFrameWidth;
        }

        public int getFrameHeight() {
            return this.myFrameHeight;
        }

        @Nullable
        private BufferedImage getImage(@Nullable File file) {
            if (file == null) {
                return null;
            }
            assert (this.myDouble == null);
            if (file.exists()) {
                try {
                    return ImageIO.read(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static File getThumbnailCacheDir() {
            String path = ourSystemPath != null ? ourSystemPath : (ourSystemPath = FileUtil.toCanonicalPath((String)PathManager.getSystemPath()));
            return new File(path, "android-devices" + File.separator + "v4");
        }

        @NotNull
        private File getCacheFile(boolean showEffects) {
            StringBuilder sb = new StringBuilder(20);
            DeviceArtDescriptor descriptor = this.myDeviceData.getDescriptor();
            sb.append(descriptor.getId());
            if (this.isStretchable()) {
                sb.append('-');
                sb.append(Integer.toString(this.myWidth));
                sb.append('x');
                sb.append(Integer.toString(this.myHeight));
            }
            sb.append('-');
            sb.append(this.isPortrait() ? "port" : "land");
            if (this.myDouble != null) {
                sb.append("-thumb");
            }
            if (showEffects) {
                sb.append("-effects");
            }
            sb.append(".png");
            return new File(FrameData.getThumbnailCacheDir(), sb.toString());
        }

        private boolean isStretchable() {
            DeviceArtDescriptor descriptor = this.myDeviceData.getDescriptor();
            return descriptor.isStretchable();
        }

        @Nullable
        private BufferedImage getCachedImage(boolean showEffects) {
            File file = this.getCacheFile(showEffects);
            if (file.exists()) {
                try {
                    return ImageIO.read(file);
                }
                catch (IOException iOException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return null;
        }

        private void putCachedImage(boolean showEffects, @NotNull BufferedImage image) {
            block5: {
                boolean deleted;
                boolean ok;
                File dir;
                if (image == null) {
                    FrameData.$$$reportNull$$$0(4);
                }
                if (!(dir = FrameData.getThumbnailCacheDir()).exists() && !(ok = dir.mkdirs())) {
                    return;
                }
                File file = this.getCacheFile(showEffects);
                if (file.exists() && !(deleted = file.delete())) {
                    return;
                }
                try {
                    ImageIO.write((RenderedImage)image, "PNG", file);
                }
                catch (IOException e) {
                    if (!file.exists()) break block5;
                    file.delete();
                }
            }
        }

        @Nullable
        public BufferedImage getImage(boolean showEffects) {
            BufferedImage image;
            BufferedImage bufferedImage = image = showEffects ? (BufferedImage)this.myEffectsImage.get() : (BufferedImage)this.myPlainImage.get();
            if (image != null) {
                return image;
            }
            image = this.getCachedImage(showEffects);
            if (image == null && (image = this.computeImage(showEffects, this.myCropX1, this.myCropY1, this.myCropX2, this.myCropY2)) != null) {
                this.putCachedImage(showEffects, image);
            }
            if (image != null) {
                if (showEffects) {
                    this.myEffectsImage = new SoftReference((Object)image);
                } else {
                    this.myPlainImage = new SoftReference((Object)image);
                }
            }
            return image;
        }

        @VisibleForTesting
        @Nullable
        BufferedImage computeImage(boolean showEffects, int cropX1, int cropY1, int cropX2, int cropY2) {
            BufferedImage glare;
            DeviceArtDescriptor descriptor;
            BufferedImage background;
            if (this.myDouble != null) {
                BufferedImage source = this.myDouble.getImage(showEffects);
                if (source != null) {
                    int sourceWidth = source.getWidth();
                    int sourceHeight = source.getHeight();
                    int destWidth = sourceWidth / 2;
                    int destHeight = sourceHeight / 2;
                    BufferedImage dest = new BufferedImage(destWidth, destHeight, 2);
                    Graphics2D g = dest.createGraphics();
                    g.setComposite(AlphaComposite.Src);
                    g.setColor(new Color(0, true));
                    g.fillRect(0, 0, destWidth, destHeight);
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.drawImage(source, 0, 0, destWidth, destHeight, 0, 0, sourceWidth, sourceHeight, null);
                    g.dispose();
                    return dest;
                }
                assert (false);
            }
            if ((background = this.getImage((descriptor = this.myDeviceData.getDescriptor()).getFrame(this.myOrientation))) == null) {
                return null;
            }
            boolean stretchable = this.isStretchable();
            if (stretchable) {
                background = DeviceArtPainter.stretchImage(background, this.myFrameWidth, this.myFrameHeight);
            }
            BufferedImage composite = new BufferedImage(this.myFrameWidth, this.myFrameHeight, 2);
            Graphics2D g = composite.createGraphics();
            g.setColor(Gray.TRANSPARENT);
            g.fillRect(0, 0, composite.getWidth(), composite.getHeight());
            Graphics2D g2d = g;
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
            BufferedImage mask = this.getImage(descriptor.getMask(this.myOrientation));
            if (showEffects) {
                BufferedImage shadow = this.getImage(descriptor.getDropShadow(this.myOrientation));
                if (shadow != null) {
                    if (stretchable) {
                        shadow = DeviceArtPainter.stretchImage(shadow, this.myFrameWidth, this.myFrameHeight);
                    }
                    g.drawImage(shadow, 0, 0, this.myFrameWidth, this.myFrameHeight, cropX1, cropY1, cropX2, cropY2, null);
                }
                g.setColor(new Color(0, true));
                Composite prevComposite = g2d.getComposite();
                g2d.setComposite(AlphaComposite.getInstance(2, 1.0f));
                if (mask != null) {
                    g2d.setComposite(AlphaComposite.DstOut);
                    g2d.drawImage((Image)mask, -cropX1, -cropY1, null);
                } else {
                    g2d.fillRect(this.myX, this.myY, this.myWidth, this.myHeight);
                }
                g2d.setComposite(prevComposite);
            }
            if (mask != null) {
                BufferedImage maskedImage = new BufferedImage(background.getWidth(), background.getHeight(), 2);
                Graphics2D maskGraphics = maskedImage.createGraphics();
                maskGraphics.drawImage((Image)background, 0, 0, null);
                Composite prevComposite = g2d.getComposite();
                maskGraphics.setComposite(AlphaComposite.DstOut);
                maskGraphics.drawImage((Image)mask, 0, 0, null);
                maskGraphics.dispose();
                g2d.setComposite(prevComposite);
                g.drawImage(maskedImage, 0, 0, this.myFrameWidth, this.myFrameHeight, cropX1, cropY1, cropX2, cropY2, null);
            } else {
                int dax = 0;
                int day = 0;
                int dcy = this.myY;
                int dex = this.myX + this.myWidth;
                int dfx = this.myFrameWidth;
                int dgy = this.myY + this.myHeight;
                int dhx = this.myX;
                int dly = this.myFrameHeight;
                int ax = cropX1;
                int ay = cropY1;
                int cy = cropY1 + this.myY;
                int ex = cropX1 + this.myX + this.myWidth;
                int fx = cropX2;
                int gy = cropY1 + this.myY + this.myHeight;
                int hx = cropX1 + this.myX;
                int ly = cropY2;
                g.drawImage(background, dax, day, dfx, dcy, ax, ay, fx, cy, null);
                g.drawImage(background, dax, dgy, dfx, dly, ax, gy, fx, ly, null);
                g.drawImage(background, dax, dcy, dhx, dgy, ax, cy, hx, gy, null);
                g.drawImage(background, dex, dcy, dfx, dgy, ex, cy, fx, gy, null);
            }
            if (showEffects && (glare = this.getImage(descriptor.getReflectionOverlay(this.myOrientation))) != null) {
                if (stretchable) {
                    glare = DeviceArtPainter.stretchImage(glare, this.myFrameWidth, this.myFrameHeight);
                }
                g.drawImage(glare, 0, 0, this.myFrameWidth, this.myFrameHeight, cropX1, cropY1, cropX2, cropY2, null);
            }
            g.dispose();
            return composite;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deviceData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orientation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "large";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/device/DeviceArtPainter$FrameData";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putCachedImage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class DeviceData {
        @NotNull
        private final DeviceArtDescriptor myDescriptor;
        private final Device myDevice;
        @Nullable
        private FrameData myPortraitData;
        @Nullable
        private FrameData myLandscapeData;
        @Nullable
        private FrameData mySmallPortraitData;
        @Nullable
        private FrameData mySmallLandscapeData;

        @VisibleForTesting
        DeviceData(Device device, @NotNull DeviceArtDescriptor descriptor) {
            if (descriptor == null) {
                DeviceData.$$$reportNull$$$0(0);
            }
            this.myDevice = device;
            this.myDescriptor = descriptor;
        }

        @NotNull
        private FrameData getSmallFrameData(@NotNull FrameData large) {
            if (large == null) {
                DeviceData.$$$reportNull$$$0(1);
            }
            return new FrameData(this, large);
        }

        @NotNull
        public FrameData getFrameData(@NotNull ScreenOrientation orientation, int height) {
            if (orientation == null) {
                DeviceData.$$$reportNull$$$0(2);
            }
            return orientation == ScreenOrientation.PORTRAIT ? this.getPortraitData(height) : this.getLandscapeData(height);
        }

        @NotNull
        private FrameData getPortraitData(int height) {
            if (this.myPortraitData == null) {
                this.myPortraitData = new FrameData(this, ScreenOrientation.PORTRAIT);
            }
            if (height < this.myPortraitData.getScreenHeight() / 2) {
                if (this.mySmallPortraitData == null) {
                    this.mySmallPortraitData = this.getSmallFrameData(this.myPortraitData);
                }
                FrameData frameData = this.mySmallPortraitData;
                if (frameData == null) {
                    DeviceData.$$$reportNull$$$0(3);
                }
                return frameData;
            }
            FrameData frameData = this.myPortraitData;
            if (frameData == null) {
                DeviceData.$$$reportNull$$$0(4);
            }
            return frameData;
        }

        @NotNull
        private FrameData getLandscapeData(int height) {
            if (this.myLandscapeData == null) {
                this.myLandscapeData = new FrameData(this, ScreenOrientation.LANDSCAPE);
            }
            if (height < this.myLandscapeData.getScreenHeight() / 2) {
                if (this.mySmallLandscapeData == null) {
                    this.mySmallLandscapeData = this.getSmallFrameData(this.myLandscapeData);
                }
                FrameData frameData = this.mySmallLandscapeData;
                if (frameData == null) {
                    DeviceData.$$$reportNull$$$0(5);
                }
                return frameData;
            }
            FrameData frameData = this.myLandscapeData;
            if (frameData == null) {
                DeviceData.$$$reportNull$$$0(6);
            }
            return frameData;
        }

        @NotNull
        DeviceArtDescriptor getDescriptor() {
            DeviceArtDescriptor deviceArtDescriptor = this.myDescriptor;
            if (deviceArtDescriptor == null) {
                DeviceData.$$$reportNull$$$0(7);
            }
            return deviceArtDescriptor;
        }

        public Device getDevice() {
            return this.myDevice;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "large";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orientation";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/device/DeviceArtPainter$DeviceData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/device/DeviceArtPainter$DeviceData";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPortraitData";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLandscapeData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSmallFrameData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFrameData";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

