/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.android.tools.adtui.common.ColorPaletteManager$backgroundPalette$2$1;
import com.android.tools.adtui.common.ColorPaletteManager$foregroundPalette$2$1;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002+,B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0014J\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0014J\u001e\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bJ:\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0 H\u0002J:\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0 H\u0002J\u000e\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nJ\u000e\u0010#\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u0014J\u000e\u0010#\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\bJ*\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010%\u001a\u00020\u00042\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\b0'H\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010\"\u001a\u00020*RD\u0010\u0006\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fRD\u0010\u0010\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t`\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\r\u001a\u0004\b\u0012\u0010\u000fR\u001c\u0010\u0013\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006-"}, d2={"Lcom/android/tools/adtui/common/ColorPaletteManager;", "", "pallets", "", "Lcom/android/tools/adtui/common/ColorPaletteManager$ColorPalette;", "([Lcom/android/tools/adtui/common/ColorPaletteManager$ColorPalette;)V", "backgroundPalette", "Ljava/util/LinkedHashMap;", "", "", "Lcom/intellij/ui/JBColor;", "Lkotlin/collections/LinkedHashMap;", "getBackgroundPalette$annotations", "()V", "getBackgroundPalette", "()Ljava/util/LinkedHashMap;", "foregroundPalette", "getForegroundPalette$annotations", "getForegroundPalette", "numberOfTonesPerColor", "", "getNumberOfTonesPerColor$annotations", "getNumberOfTonesPerColor", "()I", "getBackgroundColor", "index", "isFocused", "", "toneIndex", "name", "getColorFromPalette", "palette", "", "getFocusColor", "color", "getForegroundColor", "loadColors", "it", "getColor", "Lkotlin/Function1;", "Lcom/android/tools/adtui/common/ColorPaletteManager$ColorDefinition;", "toGrayscale", "Ljava/awt/Color;", "ColorDefinition", "ColorPalette", "intellij.android.adt.ui"})
public final class ColorPaletteManager {
    @NotNull
    private final LinkedHashMap<String, List<JBColor>> foregroundPalette;
    @NotNull
    private final LinkedHashMap<String, List<JBColor>> backgroundPalette;
    private final int numberOfTonesPerColor;

    @VisibleForTesting
    public static /* synthetic */ void getForegroundPalette$annotations() {
    }

    @NotNull
    public final LinkedHashMap<String, List<JBColor>> getForegroundPalette() {
        return this.foregroundPalette;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBackgroundPalette$annotations() {
    }

    @NotNull
    public final LinkedHashMap<String, List<JBColor>> getBackgroundPalette() {
        return this.backgroundPalette;
    }

    @VisibleForTesting
    public static /* synthetic */ void getNumberOfTonesPerColor$annotations() {
    }

    public final int getNumberOfTonesPerColor() {
        return this.numberOfTonesPerColor;
    }

    @NotNull
    public final JBColor getBackgroundColor(int index) {
        return this.getBackgroundColor(index, false);
    }

    @NotNull
    public final JBColor getBackgroundColor(int index, boolean isFocused) {
        return this.getBackgroundColor(index, 0, isFocused);
    }

    @NotNull
    public final JBColor getBackgroundColor(int index, int toneIndex, boolean isFocused) {
        return this.getColorFromPalette(index, toneIndex, isFocused, (Map<String, ? extends List<? extends JBColor>>)this.backgroundPalette);
    }

    @NotNull
    public final JBColor getBackgroundColor(@NotNull String name, int toneIndex) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getBackgroundColor(name, toneIndex, false);
    }

    @NotNull
    public final JBColor getBackgroundColor(@NotNull String name, boolean isFocused) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getBackgroundColor(name, 0, isFocused);
    }

    @NotNull
    public final JBColor getBackgroundColor(@NotNull String name, int toneIndex, boolean isFocused) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getColorFromPalette(name, toneIndex, isFocused, (Map<String, ? extends List<? extends JBColor>>)this.backgroundPalette);
    }

    @NotNull
    public final JBColor getFocusColor(@NotNull JBColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return new JBColor(color.brighter(), color.darker());
    }

    @NotNull
    public final JBColor getForegroundColor(int index) {
        return this.getColorFromPalette(index, 0, false, (Map<String, ? extends List<? extends JBColor>>)this.foregroundPalette);
    }

    @NotNull
    public final JBColor getForegroundColor(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getColorFromPalette(name, 0, false, (Map<String, ? extends List<? extends JBColor>>)this.foregroundPalette);
    }

    @NotNull
    public final Color toGrayscale(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float avg = 0.3f * (float)color.getRed() / 255.0f + 0.59f * (float)color.getBlue() / 255.0f + 0.11f * (float)color.getGreen() / 255.0f;
        return new Color(avg, avg, avg);
    }

    private final JBColor getColorFromPalette(int index, int toneIndex, boolean isFocused, Map<String, ? extends List<? extends JBColor>> palette) {
        int n = index + this.numberOfTonesPerColor * toneIndex;
        int boundIndex = Math.abs(n) % (palette.size() * this.numberOfTonesPerColor);
        int colorIndex = boundIndex % palette.size();
        int boundToneIndex = boundIndex / palette.size() % this.numberOfTonesPerColor;
        JBColor color = (JBColor)((List)CollectionsKt.elementAt((Iterable)palette.values(), (int)colorIndex)).get(boundToneIndex);
        return isFocused ? this.getFocusColor(color) : color;
    }

    private final JBColor getColorFromPalette(String name, int toneIndex, boolean isFocused, Map<String, ? extends List<? extends JBColor>> palette) {
        boolean bl = palette.containsKey(name);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Palette does not contain specified key: " + name + ".";
            throw new AssertionError((Object)string);
        }
        List<? extends JBColor> list = palette.get(name);
        Intrinsics.checkNotNull(list);
        JBColor color = list.get(toneIndex);
        return isFocused ? this.getFocusColor(color) : color;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JBColor> loadColors(ColorPalette it, Function1<? super ColorDefinition, String> getColor) {
        void $this$mapIndexedTo$iv$iv;
        boolean bl;
        boolean bl2 = bl = it.getLight().size() == it.getDark().size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-ColorPaletteManager$loadColors$22 = false;
            String $i$a$-assert-ColorPaletteManager$loadColors$22 = "Expected light (" + it.getLight().size() + "), and dark (" + it.getDark().size() + ") palette to have same number of colors";
            throw new AssertionError((Object)$i$a$-assert-ColorPaletteManager$loadColors$22);
        }
        Iterable $this$mapIndexed$iv = it.getLight();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void color;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ColorDefinition colorDefinition = (ColorDefinition)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            JBColor jBColor = new JBColor(Integer.parseInt((String)getColor.invoke((Object)color), 16), Integer.parseInt((String)getColor.invoke((Object)it.getDark().get((int)index)), 16));
            collection.add(jBColor);
        }
        return (List)destination$iv$iv;
    }

    public ColorPaletteManager(@NotNull ColorPalette[] pallets) {
        List<JBColor> list;
        ColorPalette it;
        String string;
        ColorPalette receiver;
        boolean bl;
        Map map2;
        Map destination$iv;
        ColorPalette[] $this$associateByTo$iv;
        Intrinsics.checkNotNullParameter((Object)pallets, (String)"pallets");
        ColorPalette[] colorPaletteArray = pallets;
        Map map3 = new LinkedHashMap();
        ColorPaletteManager colorPaletteManager = this;
        boolean $i$f$associateByTo = false;
        for (ColorPalette element$iv : $this$associateByTo$iv) {
            void var8_9 = element$iv;
            map2 = destination$iv;
            bl = false;
            string = receiver.getName();
            receiver = element$iv;
            boolean bl2 = false;
            list = this.loadColors(it, (Function1<? super ColorDefinition, String>)((Function1)ColorPaletteManager$foregroundPalette$2$1.INSTANCE));
            map2.put(string, list);
        }
        map2 = destination$iv;
        colorPaletteManager.foregroundPalette = (LinkedHashMap)map2;
        $this$associateByTo$iv = pallets;
        destination$iv = new LinkedHashMap();
        colorPaletteManager = this;
        $i$f$associateByTo = false;
        int n = $this$associateByTo$iv.length;
        for (int i = 0; i < n; ++i) {
            ColorPalette element$iv;
            it = element$iv = $this$associateByTo$iv[i];
            map2 = destination$iv;
            bl = false;
            string = receiver.getName();
            receiver = element$iv;
            boolean bl3 = false;
            list = this.loadColors(it, (Function1<? super ColorDefinition, String>)((Function1)ColorPaletteManager$backgroundPalette$2$1.INSTANCE));
            map2.put(string, list);
        }
        map2 = map3;
        colorPaletteManager.backgroundPalette = (LinkedHashMap)map2;
        this.numberOfTonesPerColor = ((ColorPalette)ArraysKt.first((Object[])pallets)).getLight().size();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/adtui/common/ColorPaletteManager$ColorPalette;", "", "name", "", "light", "", "Lcom/android/tools/adtui/common/ColorPaletteManager$ColorDefinition;", "dark", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getDark", "()Ljava/util/List;", "getLight", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.adt.ui"})
    public static final class ColorPalette {
        @NotNull
        private final String name;
        @NotNull
        private final List<ColorDefinition> light;
        @NotNull
        private final List<ColorDefinition> dark;

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<ColorDefinition> getLight() {
            return this.light;
        }

        @NotNull
        public final List<ColorDefinition> getDark() {
            return this.dark;
        }

        public ColorPalette(@NotNull String name, @NotNull List<ColorDefinition> light, @NotNull List<ColorDefinition> dark) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(light, (String)"light");
            Intrinsics.checkNotNullParameter(dark, (String)"dark");
            this.name = name;
            this.light = light;
            this.dark = dark;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final List<ColorDefinition> component2() {
            return this.light;
        }

        @NotNull
        public final List<ColorDefinition> component3() {
            return this.dark;
        }

        @NotNull
        public final ColorPalette copy(@NotNull String name, @NotNull List<ColorDefinition> light, @NotNull List<ColorDefinition> dark) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(light, (String)"light");
            Intrinsics.checkNotNullParameter(dark, (String)"dark");
            return new ColorPalette(name, light, dark);
        }

        public static /* synthetic */ ColorPalette copy$default(ColorPalette colorPalette, String string, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = colorPalette.name;
            }
            if ((n & 2) != 0) {
                list = colorPalette.light;
            }
            if ((n & 4) != 0) {
                list2 = colorPalette.dark;
            }
            return colorPalette.copy(string, list, list2);
        }

        @NotNull
        public String toString() {
            return "ColorPalette(name=" + this.name + ", light=" + this.light + ", dark=" + this.dark + ")";
        }

        public int hashCode() {
            String string = this.name;
            List<ColorDefinition> list = this.light;
            List<ColorDefinition> list2 = this.dark;
            return ((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ColorPalette)) break block3;
                    ColorPalette colorPalette = (ColorPalette)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)colorPalette.name) || !Intrinsics.areEqual(this.light, colorPalette.light) || !Intrinsics.areEqual(this.dark, colorPalette.dark)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/adtui/common/ColorPaletteManager$ColorDefinition;", "", "foreground", "", "background", "(Ljava/lang/String;Ljava/lang/String;)V", "getBackground", "()Ljava/lang/String;", "getForeground", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.adt.ui"})
    public static final class ColorDefinition {
        @NotNull
        private final String foreground;
        @NotNull
        private final String background;

        @NotNull
        public final String getForeground() {
            return this.foreground;
        }

        @NotNull
        public final String getBackground() {
            return this.background;
        }

        public ColorDefinition(@NotNull String foreground, @NotNull String background) {
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            this.foreground = foreground;
            this.background = background;
        }

        @NotNull
        public final String component1() {
            return this.foreground;
        }

        @NotNull
        public final String component2() {
            return this.background;
        }

        @NotNull
        public final ColorDefinition copy(@NotNull String foreground, @NotNull String background) {
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            return new ColorDefinition(foreground, background);
        }

        public static /* synthetic */ ColorDefinition copy$default(ColorDefinition colorDefinition, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = colorDefinition.foreground;
            }
            if ((n & 2) != 0) {
                string2 = colorDefinition.background;
            }
            return colorDefinition.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ColorDefinition(foreground=" + this.foreground + ", background=" + this.background + ")";
        }

        public int hashCode() {
            String string = this.foreground;
            String string2 = this.background;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ColorDefinition)) break block3;
                    ColorDefinition colorDefinition = (ColorDefinition)object;
                    if (!Intrinsics.areEqual((Object)this.foreground, (Object)colorDefinition.foreground) || !Intrinsics.areEqual((Object)this.background, (Object)colorDefinition.background)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

