/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.chart.statechart;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.chart.statechart.DefaultStateChartReducer;
import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.chart.statechart.StateChartConfig;
import com.android.tools.adtui.chart.statechart.StateChartTextConverter;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.adtui.model.Stopwatch;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u0000 P*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001PB3\b\u0017\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tBA\b\u0017\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\fB)\b\u0017\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010B\u00a4\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u007f\u0010\u0011\u001a{\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u0012j\b\u0012\u0004\u0012\u00028\u0000`\u001f\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010 J\u0014\u0010;\u001a\u00020\u001e2\f\u0010<\u001a\b\u0012\u0004\u0012\u00028\u00000/J\u000e\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u000205J\u0018\u0010?\u001a\u00020\u001e2\u0006\u0010@\u001a\u00020\u00132\u0006\u0010A\u001a\u00020BH\u0014J\u0012\u0010C\u001a\u0004\u0018\u00010\u00172\u0006\u0010D\u001a\u000207H\u0002J\u0017\u0010E\u001a\u0004\u0018\u00018\u00002\u0006\u00106\u001a\u000207H\u0007\u00a2\u0006\u0002\u0010FJ\b\u0010G\u001a\u00020\u001eH\u0002J\u001a\u0010H\u001a\u00020\u001e2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u000207H\u0002J\u001e\u0010L\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)\u0018\u0001032\u0006\u00106\u001a\u000207H\u0002J\u0017\u0010M\u001a\u0004\u0018\u00010)2\u0006\u00106\u001a\u000207H\u0002\u00a2\u0006\u0002\u0010NJ\b\u0010O\u001a\u00020\u001eH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010#\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001e\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020)@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u00101\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001702\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u0000020302X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0087\u0001\u0010\u0011\u001a{\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\u001b\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001c\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e0\u0012j\b\u0012\u0004\u0012\u00028\u0000`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00108\u001a\u0004\u0018\u0001072\b\u00106\u001a\u0004\u0018\u000107@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b9\u0010:\u00a8\u0006Q"}, d2={"Lcom/android/tools/adtui/chart/statechart/StateChart;", "T", "Lcom/android/tools/adtui/AnimatedComponent;", "model", "Lcom/android/tools/adtui/model/StateChartModel;", "colorProvider", "Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;", "config", "Lcom/android/tools/adtui/chart/statechart/StateChartConfig;", "(Lcom/android/tools/adtui/model/StateChartModel;Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;Lcom/android/tools/adtui/chart/statechart/StateChartConfig;)V", "textConverter", "Lcom/android/tools/adtui/chart/statechart/StateChartTextConverter;", "(Lcom/android/tools/adtui/model/StateChartModel;Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;Lcom/android/tools/adtui/chart/statechart/StateChartTextConverter;Lcom/android/tools/adtui/chart/statechart/StateChartConfig;)V", "colors", "", "Ljava/awt/Color;", "(Lcom/android/tools/adtui/model/StateChartModel;Ljava/util/Map;)V", "render", "Lkotlin/Function5;", "Ljava/awt/Graphics2D;", "Lkotlin/ParameterName;", "name", "g", "Ljava/awt/geom/Rectangle2D$Float;", "boundary", "Ljava/awt/FontMetrics;", "defaultFontMetrics", "", "hoverred", "value", "", "Lcom/android/tools/adtui/chart/statechart/Renderer;", "(Lcom/android/tools/adtui/model/StateChartModel;Lkotlin/jvm/functions/Function5;Lcom/android/tools/adtui/chart/statechart/StateChartConfig;)V", "gap", "", "heightGap", "getHeightGap", "()F", "setHeightGap", "(F)V", "index", "", "hoveredSeriesIndex", "setHoveredSeriesIndex", "(I)V", "itemClickedListeners", "", "Ljava/util/function/Consumer;", "needsTransformToViewSpace", "rectangleCache", "", "Lkotlin/Pair;", "rowIndexChangeListeners", "Ljava/util/function/IntConsumer;", "point", "Ljava/awt/Point;", "rowPoint", "setRowPoint", "(Ljava/awt/Point;)V", "addItemClickedListener", "onClicked", "addRowIndexChangeListener", "onNewRowIndex", "draw", "g2d", "dim", "Ljava/awt/Dimension;", "getMouseRectanglesUnion", "mousePoint", "itemAtMouse", "(Ljava/awt/Point;)Ljava/lang/Object;", "registerMouseEvents", "renderUnion", "container", "", "containerOffset", "seriesIndexAtMouse", "seriesIndexAtPoint", "(Ljava/awt/Point;)Ljava/lang/Integer;", "transformToViewSpace", "Companion", "intellij.android.adt.ui"})
public final class StateChart<T>
extends AnimatedComponent {
    private float heightGap;
    private boolean needsTransformToViewSpace;
    private List<? extends Pair<? extends List<? extends Rectangle2D.Float>, ? extends List<? extends T>>> rectangleCache;
    private Point rowPoint;
    private int hoveredSeriesIndex;
    private final List<Consumer<T>> itemClickedListeners;
    private final List<IntConsumer> rowIndexChangeListeners;
    private final StateChartModel<T> model;
    private final Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> render;
    private final StateChartConfig<T> config;
    private static final int INVALID_INDEX = -1;
    private static final int TEXT_PADDING = 3;
    private static final int PREFERRED_ROW_HEIGHT = 27;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final float getHeightGap() {
        return this.heightGap;
    }

    public final void setHeightGap(float gap) {
        float f = 1.0f;
        f = Math.min(gap, f);
        float f2 = 0.0f;
        this.heightGap = Math.max(f, f2);
    }

    /*
     * Unable to fully structure code
     */
    private final void setRowPoint(Point point) {
        this.rowPoint = point;
        v0 = this;
        v1 = point;
        if (v1 == null) ** GOTO lbl-1000
        var2_2 = v1;
        var3_3 = this;
        var4_4 = var2_2;
        var6_5 = v0;
        $i$a$-unknown-StateChart$rowPoint$1 = false;
        var7_7 = var3_3.seriesIndexAtPoint((Point)p1);
        v0 = var6_5;
        v1 = var7_7;
        if (v1 != null) {
            v2 = v1.intValue();
        } else lbl-1000:
        // 2 sources

        {
            v2 = -1;
        }
        v0.setHoveredSeriesIndex(v2);
    }

    private final void setHoveredSeriesIndex(int index) {
        if (this.hoveredSeriesIndex != index) {
            this.hoveredSeriesIndex = index;
            Iterable $this$forEach$iv = this.rowIndexChangeListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IntConsumer it = (IntConsumer)element$iv;
                boolean bl = false;
                it.accept(index);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void transformToViewSpace() {
        Collection<Pair> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!this.needsTransformToViewSpace) {
            return;
        }
        this.needsTransformToViewSpace = false;
        List<RangedSeries<T>> series = this.model.getSeries();
        int seriesSize = series.size();
        if (seriesSize == 0) {
            return;
        }
        float rectHeight = 1.0f / (float)seriesSize;
        float gap = rectHeight * this.heightGap;
        float barHeight = rectHeight - gap;
        List<RangedSeries<T>> list = series;
        Intrinsics.checkNotNullExpressionValue(list, (String)"series");
        Iterable iterable = list;
        StateChart stateChart = this;
        boolean $i$f$mapIndexed = false;
        void var8_9 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void seriesIndex;
            void data;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RangedSeries rangedSeries = (RangedSeries)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            double min = data.getXRange().getMin();
            double max = data.getXRange().getMax();
            double invRange = 1.0 / (max - min);
            double startHeight = 1.0 - (double)(rectHeight * (float)(seriesIndex + true));
            double barY = startHeight + (double)(gap * 0.5f);
            List seriesDataList = data.getSeries();
            List rectangles = new ArrayList();
            List rectangleValues = new ArrayList();
            var $fun$addRectangleDelta$1 = new Function3<T, Double, Double, Unit>(rectangles, min, invRange, barY, rectangleValues, rectHeight, gap, barHeight){
                final /* synthetic */ List $rectangles;
                final /* synthetic */ double $min;
                final /* synthetic */ double $invRange;
                final /* synthetic */ double $barY;
                final /* synthetic */ List $rectangleValues;
                final /* synthetic */ float $rectHeight$inlined;
                final /* synthetic */ float $gap$inlined;
                final /* synthetic */ float $barHeight$inlined;
                {
                    this.$rectangles = list;
                    this.$min = d;
                    this.$invRange = d2;
                    this.$barY = d3;
                    this.$rectangleValues = list2;
                    this.$rectHeight$inlined = f;
                    this.$gap$inlined = f2;
                    this.$barHeight$inlined = f3;
                    super(3);
                }

                public final void invoke(T value, double previousX, double currentX) {
                    this.$rectangles.add(new Rectangle2D.Float((float)((previousX - this.$min) * this.$invRange), (float)this.$barY, (float)((currentX - previousX) * this.$invRange), this.$barHeight$inlined));
                    this.$rectangleValues.add(value);
                }
            };
            Collection collection2 = seriesDataList;
            if (!collection2.isEmpty()) {
                double previousX = seriesDataList.get((int)0).x;
                Object previousValue = seriesDataList.get((int)0).value;
                for (SeriesData seriesData : seriesDataList.subList(1, seriesDataList.size())) {
                    void x;
                    long l = seriesData.component1();
                    Object value = seriesData.component2();
                    if (!(Intrinsics.areEqual(value, previousValue) ^ true)) continue;
                    if ((double)x >= min) {
                        $fun$addRectangleDelta$1.invoke(previousValue, previousX, (double)x);
                    }
                    previousValue = value;
                    previousX = (double)x;
                    if (!(previousX >= max)) continue;
                    break;
                }
                if (previousX < max && previousValue != null) {
                    $fun$addRectangleDelta$1.invoke(previousValue, Math.max(min, previousX), max);
                }
            }
            Pair pair = TuplesKt.to((Object)rectangles, (Object)rectangleValues);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        stateChart.rectangleCache = collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void draw(@NotNull Graphics2D g2d, @NotNull Dimension dim) {
        Intrinsics.checkNotNullParameter((Object)g2d, (String)"g2d");
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        Stopwatch stopwatch = new Stopwatch().start();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"Stopwatch().start()");
        Stopwatch stopwatch2 = stopwatch;
        long scalingTime = 0L;
        long reducerTime = 0L;
        int transformedShapesCount = 0;
        this.transformToViewSpace();
        long transformTime = stopwatch2.getElapsedSinceLastDeltaNs();
        g2d.setFont(this.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        float scaleX = this.getWidth();
        float scaleY = this.getHeight();
        Rectangle clipRect = g2d.getClipBounds();
        Iterable $this$forEachIndexed$iv = this.rectangleCache;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            String destination$iv;
            void $this$mapTo$iv;
            Rectangle2D.Float float_;
            void var31_45;
            Iterable destination$iv2;
            Object item$iv22;
            void $this$mapTo$iv2;
            int n2;
            int n3;
            int it;
            void rectangles;
            void $dstr$rectangles$rectangleValues;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Pair pair = (Pair)item$iv;
            int seriesIndex = n4;
            boolean bl = false;
            List list = (List)$dstr$rectangles$rectangleValues.component1();
            List rectangleValues = (List)$dstr$rectangles$rectangleValues.component2();
            draw.1.1 $fun$searchByX$1 = draw.1.1.INSTANCE;
            if (clipRect != null && clipRect.x != 0) {
                int n5;
                it = n5 = $fun$searchByX$1.invoke((List<? extends Rectangle2D.Float>)rectangles, (float)clipRect.x / scaleX, 0.0f);
                boolean bl2 = false;
                n3 = it < 0 ? -(it + 1) : it;
            } else {
                n3 = 0;
            }
            int startIndexInclusive = n3;
            if (clipRect != null && clipRect.width != this.getWidth()) {
                int it2 = it = $fun$searchByX$1.invoke((List<? extends Rectangle2D.Float>)rectangles, (float)(clipRect.x + clipRect.width) / scaleX, 0.0f);
                boolean bl3 = false;
                n2 = it2 < 0 ? -(it2 + 1) : it2 + 1;
            } else {
                n2 = rectangles.size();
            }
            int endIndexExclusive = n2;
            Iterable it2 = rectangleValues.subList(startIndexInclusive, endIndexExclusive);
            Collection bl3 = new ArrayList();
            boolean $i$f$mapTo22 = false;
            for (Object item$iv22 : $this$mapTo$iv2) {
                void it3;
                Object t = item$iv22;
                var31_45 = destination$iv2;
                boolean bl4 = false;
                float_ = it3;
                var31_45.add(float_);
            }
            List transformedValues = (List)destination$iv2;
            destination$iv2 = rectangles.subList(startIndexInclusive, endIndexExclusive);
            Collection $i$f$mapTo22 = new ArrayList();
            boolean $i$f$mapTo = false;
            item$iv22 = $this$mapTo$iv.iterator();
            while (item$iv22.hasNext()) {
                void it4;
                Object item$iv3 = item$iv22.next();
                Rectangle2D.Float bl4 = (Rectangle2D.Float)item$iv3;
                var31_45 = destination$iv;
                boolean bl5 = false;
                float_ = new Rectangle2D.Float(it4.x * scaleX, it4.y * scaleY, it4.width * scaleX, it4.height * scaleY);
                var31_45.add(float_);
            }
            List transformedShapes = (List)((Object)destination$iv);
            transformedShapesCount += transformedShapes.size();
            scalingTime += stopwatch2.getElapsedSinceLastDeltaNs();
            this.config.getReducer().reduce(transformedShapes, transformedValues);
            boolean bl6 = $this$mapTo$iv = transformedShapes.size() == transformedValues.size();
            if (_Assertions.ENABLED && !$this$mapTo$iv) {
                destination$iv = "Assertion failed";
                throw new AssertionError((Object)destination$iv);
            }
            reducerTime += stopwatch2.getElapsedSinceLastDeltaNs();
            if (seriesIndex != this.hoveredSeriesIndex || this.rowPoint == null) {
                n = -1;
            } else {
                Point point = this.rowPoint;
                Intrinsics.checkNotNull((Object)point);
                float it5 = destination$iv = (float)point.x;
                boolean bl7 = false;
                n = draw.1.1.INSTANCE.invoke(transformedShapes, it5, 1.0f);
            }
            int hoverIndex = n;
            Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)transformedShapes);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Shape shape;
                int element$iv;
                int it6 = element$iv = ((IntIterator)iterator).nextInt();
                boolean bl8 = false;
                Rectangle2D.Float rect = (Rectangle2D.Float)transformedShapes.get(it6);
                if (0.0f <= rect.x && rect.x + rect.width <= (float)this.getWidth()) {
                    shape = rect;
                } else {
                    float f = 0.0f;
                    float f2 = rect.x;
                    float x = Math.max(f, f2);
                    f2 = scaleX - x;
                    float f3 = rect.width;
                    float w = Math.min(f2, f3);
                    shape = new Rectangle2D.Float(x, rect.y, w, rect.height);
                }
                g2d.setClip(shape);
                FontMetrics fontMetrics = this.mDefaultFontMetrics;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"mDefaultFontMetrics");
                this.render.invoke((Object)g2d, (Object)rect, (Object)fontMetrics, (Object)(it6 == hoverIndex ? 1 : 0), transformedValues.get(it6));
            }
        }
        long drawTime = stopwatch2.getElapsedSinceLastDeltaNs();
        this.addDebugInfo("XS ms: %.2fms, %.2fms", Float.valueOf((float)transformTime / 1000000.0f), Float.valueOf((float)scalingTime / 1000000.0f));
        this.addDebugInfo("RDT ms: %.2f, %.2f, %.2f", Float.valueOf((float)reducerTime / 1000000.0f), Float.valueOf((float)drawTime / 1000000.0f), Float.valueOf((float)(scalingTime + reducerTime + drawTime) / 1000000.0f));
        this.addDebugInfo("# of drawn rects: %d", transformedShapesCount);
    }

    public final void addItemClickedListener(@NotNull Consumer<T> onClicked) {
        Intrinsics.checkNotNullParameter(onClicked, (String)"onClicked");
        this.itemClickedListeners.add(onClicked);
    }

    public final void addRowIndexChangeListener(@NotNull IntConsumer onNewRowIndex) {
        Intrinsics.checkNotNullParameter((Object)onNewRowIndex, (String)"onNewRowIndex");
        this.rowIndexChangeListeners.add(onNewRowIndex);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerMouseEvents() {
        void mouseEventSource;
        void rowIndex;
        void mousePoint;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        MouseEventHandler handler2 = new MouseEventHandler(this, (Ref.ObjectRef)mousePoint, (Ref.IntRef)rowIndex, (Ref.ObjectRef)mouseEventSource){
            final /* synthetic */ StateChart this$0;
            final /* synthetic */ Ref.ObjectRef $mousePoint;
            final /* synthetic */ Ref.IntRef $rowIndex;
            final /* synthetic */ Ref.ObjectRef $mouseEventSource;

            /*
             * WARNING - void declaration
             */
            protected void handle(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getID() == 500) {
                    Point point = event.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"event.point");
                    T t = this.this$0.itemAtMouse(point);
                    if (t != null) {
                        T t2;
                        T it = t2 = t;
                        boolean bl = false;
                        Iterable $this$forEach$iv = StateChart.access$getItemClickedListeners$p(this.this$0);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Consumer handler2 = (Consumer)element$iv;
                            boolean bl2 = false;
                            handler2.accept(it);
                        }
                    }
                    return;
                }
                if (Intrinsics.areEqual((Object)event.getPoint(), (Object)((Point)this.$mousePoint.element))) {
                    return;
                }
                Object src = event.getSource();
                if (this.$rowIndex.element != -1) {
                    Point oldRowOriginInEventSpace;
                    Object bl = src;
                    Point point = oldRowOriginInEventSpace = bl instanceof JList ? ((JList)src).getUI().indexToLocation((JList)src, this.$rowIndex.element) : new Point(0, 0);
                    if (point != null) {
                        Object it = bl = point;
                        boolean bl3 = false;
                        StateChart.access$renderUnion(this.this$0, this.$mouseEventSource.element, (Point)it);
                    }
                }
                if (event.getID() == 505) {
                    this.$mousePoint.element = null;
                    StateChart.access$setRowPoint$p(this.this$0, null);
                    this.$mouseEventSource.element = null;
                    this.$rowIndex.element = -1;
                } else {
                    Point rowOrigin = new Point(0, 0);
                    Point eventPoint = event.getPoint();
                    this.$mousePoint.element = eventPoint;
                    this.$mouseEventSource.element = src;
                    Object object = src;
                    if (object instanceof JList) {
                        void $this$apply;
                        Point point;
                        this.$rowIndex.element = ((JList)src).getUI().locationToIndex((JList)src, eventPoint);
                        if (this.$rowIndex.element >= 0) {
                            Point point2 = ((JList)src).getUI().indexToLocation((JList)src, this.$rowIndex.element);
                            Intrinsics.checkNotNull((Object)point2);
                            rowOrigin = point2;
                        }
                        Point point3 = point = new Point(eventPoint);
                        StateChart stateChart = this.this$0;
                        boolean bl = false;
                        $this$apply.translate(-rowOrigin.x, -rowOrigin.y);
                        Unit unit = Unit.INSTANCE;
                        StateChart.access$setRowPoint$p(stateChart, point);
                    } else {
                        this.$rowIndex.element = 0;
                        StateChart.access$setRowPoint$p(this.this$0, eventPoint);
                    }
                    if (this.$rowIndex.element != -1) {
                        StateChart.access$renderUnion(this.this$0, this.$mouseEventSource.element, rowOrigin);
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$mousePoint = $captured_local_variable$1;
                this.$rowIndex = $captured_local_variable$2;
                this.$mouseEventSource = $captured_local_variable$3;
            }
        };
        this.addMouseListener((MouseListener)handler2);
        this.addMouseMotionListener((MouseMotionListener)handler2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @Nullable
    public final T itemAtMouse(@NotNull Point point) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Pair<Integer, Integer> pair = this.seriesIndexAtMouse(point);
        if (pair != null) {
            int j;
            int n;
            void seriesIndex;
            Pair<Integer, Integer> pair2;
            Pair<Integer, Integer> $dstr$seriesIndex$i = pair2 = pair;
            boolean bl = false;
            int n2 = ((Number)$dstr$seriesIndex$i.component1()).intValue();
            int i = ((Number)$dstr$seriesIndex$i.component2()).intValue();
            List<SeriesData<T>> seriesData = this.model.getSeries().get((int)seriesIndex).getSeries();
            int n3 = i;
            int n4 = n3;
            v1 = 0 <= n4 && ((Collection)seriesData).size() > n4 ? seriesData.get((int)i).value : (0 <= (n = (j = -i - 1 - 1)) && ((Collection)seriesData).size() > n ? seriesData.get((int)j).value : null);
        } else {
            v1 = null;
        }
        return v1;
    }

    private final Pair<Integer, Integer> seriesIndexAtMouse(Point point) {
        Pair pair;
        List<RangedSeries<T>> series = this.model.getSeries();
        if (series.isEmpty()) {
            return null;
        }
        double scaleX = this.getWidth();
        Integer n = this.seriesIndexAtPoint(point);
        if (n != null) {
            Integer n2 = n;
            int seriesIndex = ((Number)n2).intValue();
            boolean bl = false;
            RangedSeries<T> seriesAtMouse = series.get(seriesIndex);
            List<SeriesData<T>> seriesData = seriesAtMouse.getSeries();
            double min = seriesAtMouse.getXRange().getMin();
            double max = seriesAtMouse.getXRange().getMax();
            double range = max - min;
            double modelMouseX = (double)point.x / scaleX * range + min;
            pair = seriesData.isEmpty() ? null : TuplesKt.to((Object)seriesIndex, (Object)CollectionsKt.binarySearch$default(seriesData, (int)0, (int)0, (Function1)new Function1<SeriesData<T>, Integer>(modelMouseX){
                final /* synthetic */ double $modelMouseX;

                public final int invoke(@NotNull SeriesData<T> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return Double.compare(it.x, this.$modelMouseX);
                }
                {
                    this.$modelMouseX = d;
                    super(1);
                }
            }, (int)3, null));
        } else {
            pair = null;
        }
        return pair;
    }

    private final Integer seriesIndexAtPoint(Point point) {
        Integer n;
        float f;
        float normalizedY = f = 1.0f - (float)point.y / (float)this.getHeight();
        boolean bl = false;
        int n2 = this.model.getSeries().size();
        int i = (int)(normalizedY * (float)n2);
        int tolerancePixels = 2;
        int n3 = i;
        if (0 <= n3 && n2 > n3) {
            n = i;
        } else {
            n3 = point.y;
            n = this.getHeight() <= n3 && this.getHeight() + tolerancePixels >= n3 ? Integer.valueOf(0) : (-tolerancePixels <= (n3 = point.y) && 0 >= n3 ? Integer.valueOf(n2 - 1) : null);
        }
        return n;
    }

    private final void renderUnion(Object container, Point containerOffset) {
        block1: {
            if (this.rowPoint == null || !(container instanceof Component)) break block1;
            Point point = this.rowPoint;
            Intrinsics.checkNotNull((Object)point);
            Rectangle2D.Float float_ = this.getMouseRectanglesUnion(point);
            if (float_ != null) {
                Rectangle2D.Float float_2;
                Rectangle2D.Float union = float_2 = float_;
                boolean bl = false;
                float f = union.width;
                int n = (int)Math.ceil(f);
                f = union.height;
                ((Component)container).repaint((int)union.x + containerOffset.x, (int)union.y + containerOffset.y, n, (int)Math.ceil(f));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Rectangle2D.Float getMouseRectanglesUnion(Point mousePoint) {
        Rectangle2D.Float float_;
        Pair<Integer, Integer> pair = this.seriesIndexAtMouse(mousePoint);
        if (pair != null) {
            void leftIndex;
            Pair pair2;
            void seriesIndex;
            Pair<Integer, Integer> pair3;
            Pair<Integer, Integer> $dstr$seriesIndex$i = pair3 = pair;
            boolean bl = false;
            int n = ((Number)$dstr$seriesIndex$i.component1()).intValue();
            int i = ((Number)$dstr$seriesIndex$i.component2()).intValue();
            RangedSeries<T> series = this.model.getSeries().get((int)seriesIndex);
            List<SeriesData<T>> seriesDataList = series.getSeries();
            double min = series.getXRange().getMin();
            double max = series.getXRange().getMax();
            double range = max - min;
            int seriesSize = this.model.getSeries().size();
            double scaleX = this.getWidth();
            double scaleY = this.getHeight();
            int n2 = i;
            int n3 = n2;
            if (0 <= n3 && ((Collection)seriesDataList).size() > n3) {
                n3 = 0;
                int n4 = i - 2;
                Integer n5 = Math.max(n3, n4);
                n3 = i + 2;
                n4 = seriesDataList.size() - 1;
                pair2 = TuplesKt.to((Object)n5, (Object)Math.min(n3, n4));
            } else {
                int it = n3 = -i - 1;
                boolean bl2 = false;
                int n6 = 0;
                int n7 = it - 2;
                Integer n8 = Math.max(n6, n7);
                n6 = it + 2;
                n7 = seriesDataList.size() - 1;
                pair2 = TuplesKt.to((Object)n8, (Object)Math.min(n6, n7));
            }
            Pair pair4 = pair2;
            int n9 = ((Number)pair4.component1()).intValue();
            int rightIndex = ((Number)pair4.component2()).intValue();
            double d = seriesDataList.get((int)leftIndex).x;
            double modelXLeft = Math.max(min, d);
            double d2 = seriesDataList.get((int)rightIndex).x;
            double modelXRight = Math.min(max, d2);
            double d3 = (modelXLeft - min) * scaleX / range;
            double screenXLeft = Math.floor(d3);
            double d4 = scaleY - (double)(seriesIndex + true) * scaleY / (double)seriesSize;
            double screenYTop = Math.floor(d4);
            double d5 = (modelXRight - min) * scaleX / range;
            double screenXRight = Math.ceil(d5);
            double d6 = scaleY - (double)seriesIndex * scaleY / (double)seriesSize;
            double screenYBottom = Math.ceil(d6);
            double screenWidth = screenXRight - screenXLeft;
            double screenHeight = screenYBottom - screenYTop;
            float_ = new Rectangle2D.Float((float)screenXLeft, (float)screenYTop, (float)screenWidth, (float)screenHeight);
        } else {
            float_ = null;
        }
        return float_;
    }

    public StateChart(@NotNull StateChartModel<T> model2, @NotNull Function5<? super Graphics2D, ? super Rectangle2D.Float, ? super FontMetrics, ? super Boolean, ? super T, Unit> render, @NotNull StateChartConfig<T> config) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(render, (String)"render");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.model = model2;
        this.render = render;
        this.config = config;
        this.heightGap = this.config.getHeightGap();
        this.needsTransformToViewSpace = true;
        this.rectangleCache = CollectionsKt.emptyList();
        this.hoveredSeriesIndex = -1;
        this.itemClickedListeners = new ArrayList();
        this.rowIndexChangeListeners = new ArrayList();
        this.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        final var $fun$modelChanged$1 = new Function0<Unit>(){

            public final void invoke() {
                needsTransformToViewSpace = true;
                this.opaqueRepaint();
            }
        };
        Function0 function0 = (Function0)new Function0<Unit>(){

            public final void invoke() {
                $fun$modelChanged$1.invoke();
            }
        };
        this.model.addDependency(this.myAspectObserver).onChange((Enum)StateChartModel.Aspect.MODEL_CHANGED, new Runnable(function0){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        });
        $fun$modelChanged$1.invoke();
        this.registerMouseEvents();
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, JBUI.scale((int)27) * this.model.getSeries().size()));
    }

    public /* synthetic */ StateChart(StateChartModel stateChartModel, Function5 function5, StateChartConfig stateChartConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stateChartConfig = StateChart.Companion.defaultConfig();
        }
        this(stateChartModel, function5, stateChartConfig);
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider, @NotNull StateChartConfig<T> config) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colorProvider, (String)"colorProvider");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this(model2, StateChart.Companion.fillRectRenderer(colorProvider), config);
    }

    public /* synthetic */ StateChart(StateChartModel stateChartModel, StateChartColorProvider stateChartColorProvider, StateChartConfig stateChartConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            stateChartConfig = StateChart.Companion.defaultConfig();
        }
        this(stateChartModel, stateChartColorProvider, stateChartConfig);
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider) {
        this(model2, colorProvider, null, 4, null);
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider, @NotNull StateChartTextConverter<T> textConverter, @NotNull StateChartConfig<T> config) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colorProvider, (String)"colorProvider");
        Intrinsics.checkNotNullParameter(textConverter, (String)"textConverter");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this(model2, StateChart.Companion.fillRectAndTextRenderer(colorProvider, textConverter), config);
    }

    public /* synthetic */ StateChart(StateChartModel stateChartModel, StateChartColorProvider stateChartColorProvider, StateChartTextConverter stateChartTextConverter, StateChartConfig stateChartConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            stateChartConfig = StateChart.Companion.defaultConfig();
        }
        this(stateChartModel, stateChartColorProvider, stateChartTextConverter, stateChartConfig);
    }

    @JvmOverloads
    public StateChart(@NotNull StateChartModel<T> model2, @NotNull StateChartColorProvider<T> colorProvider, @NotNull StateChartTextConverter<T> textConverter) {
        this(model2, colorProvider, textConverter, null, 8, null);
    }

    @VisibleForTesting
    public StateChart(@NotNull StateChartModel<T> model2, final @NotNull Map<T, ? extends Color> colors) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this(model2, new StateChartColorProvider<T>(){

            @Override
            @NotNull
            public Color getColor(boolean isMouseOver, T value) {
                Object v = colors.get(value);
                Intrinsics.checkNotNull(v);
                Object v2 = v;
                Color it = (Color)v2;
                boolean bl = false;
                Color color = isMouseOver ? ColorUtil.brighter((Color)it, (int)2) : it;
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"colors[value]!!.let {\n  \u2026er(it, 2) else it\n      }");
                return color;
            }
        }, null, 4, null);
    }

    public static final /* synthetic */ List access$getItemClickedListeners$p(StateChart $this) {
        return $this.itemClickedListeners;
    }

    public static final /* synthetic */ void access$renderUnion(StateChart $this, Object container, Point containerOffset) {
        $this.renderUnion(container, containerOffset);
    }

    public static final /* synthetic */ Point access$getRowPoint$p(StateChart $this) {
        return $this.rowPoint;
    }

    public static final /* synthetic */ void access$setRowPoint$p(StateChart $this, Point point) {
        $this.setRowPoint(point);
    }

    public static final /* synthetic */ boolean access$getNeedsTransformToViewSpace$p(StateChart $this) {
        return $this.needsTransformToViewSpace;
    }

    @JvmStatic
    @NotNull
    public static final <T> StateChartTextConverter<T> defaultTextConverter() {
        return Companion.defaultTextConverter();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0001\u0010\tH\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b\"\u0004\b\u0001\u0010\tH\u0007J\u00a3\u0001\u0010\f\u001a{\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\rj\b\u0012\u0004\u0012\u0002H\t`\u001a\"\u0004\b\u0001\u0010\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\t0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0002J\u0095\u0001\u0010\u001e\u001a{\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0017\u0012\u0013\u0012\u0011H\t\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\rj\b\u0012\u0004\u0012\u0002H\t`\u001a\"\u0004\b\u0001\u0010\t2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\t0\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/adtui/chart/statechart/StateChart$Companion;", "", "()V", "INVALID_INDEX", "", "PREFERRED_ROW_HEIGHT", "TEXT_PADDING", "defaultConfig", "Lcom/android/tools/adtui/chart/statechart/StateChartConfig;", "T", "defaultTextConverter", "Lcom/android/tools/adtui/chart/statechart/StateChartTextConverter;", "fillRectAndTextRenderer", "Lkotlin/Function5;", "Ljava/awt/Graphics2D;", "Lkotlin/ParameterName;", "name", "g", "Ljava/awt/geom/Rectangle2D$Float;", "boundary", "Ljava/awt/FontMetrics;", "defaultFontMetrics", "", "hoverred", "value", "", "Lcom/android/tools/adtui/chart/statechart/Renderer;", "colorProvider", "Lcom/android/tools/adtui/chart/statechart/StateChartColorProvider;", "textConverter", "fillRectRenderer", "intellij.android.adt.ui"})
    public static final class Companion {
        private final <T> StateChartConfig<T> defaultConfig() {
            return new StateChartConfig(new DefaultStateChartReducer());
        }

        @JvmStatic
        @NotNull
        public final <T> StateChartTextConverter<T> defaultTextConverter() {
            Object object = defaultTextConverter.1.INSTANCE;
            if (object != null) {
                Function1 function1 = object;
                object = new StateChartTextConverter(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        this.function = function1;
                    }

                    @NotNull
                    public final /* synthetic */ String convertToString(@NotNull Object value) {
                        return (String)this.function.invoke(value);
                    }
                };
            }
            return (StateChartTextConverter)object;
        }

        private final <T> Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> fillRectRenderer(StateChartColorProvider<T> colorProvider) {
            return new Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit>(colorProvider){
                final /* synthetic */ StateChartColorProvider $colorProvider;

                public final void invoke(@NotNull Graphics2D g, @NotNull Rectangle2D.Float rect, @NotNull FontMetrics $noName_2, boolean hovered, T value) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                    Intrinsics.checkNotNullParameter((Object)$noName_2, (String)"<anonymous parameter 2>");
                    g.setColor(this.$colorProvider.getColor(hovered, value));
                    g.fill(rect);
                }
                {
                    this.$colorProvider = stateChartColorProvider;
                    super(5);
                }
            };
        }

        private final <T> Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> fillRectAndTextRenderer(StateChartColorProvider<T> colorProvider, StateChartTextConverter<T> textConverter) {
            Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> function5;
            Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit> fillRect = function5 = this.fillRectRenderer(colorProvider);
            boolean bl = false;
            return new Function5<Graphics2D, Rectangle2D.Float, FontMetrics, Boolean, T, Unit>(fillRect, textConverter, colorProvider){
                final /* synthetic */ Function5 $fillRect;
                final /* synthetic */ StateChartTextConverter $textConverter$inlined;
                final /* synthetic */ StateChartColorProvider $colorProvider$inlined;
                {
                    this.$fillRect = function5;
                    this.$textConverter$inlined = stateChartTextConverter;
                    this.$colorProvider$inlined = stateChartColorProvider;
                    super(5);
                }

                public final void invoke(@NotNull Graphics2D g, @NotNull Rectangle2D.Float rect, @NotNull FontMetrics fontMetrics, boolean hovered, T value) {
                    Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                    Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                    Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
                    this.$fillRect.invoke((Object)g, (Object)rect, (Object)fontMetrics, (Object)hovered, value);
                    String string = this.$textConverter$inlined.convertToString(value);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textConverter.convertToString(value)");
                    String text = AdtUiUtils.shrinkToFit(string, fontMetrics, rect.width - (float)6);
                    CharSequence charSequence = text;
                    if (charSequence.length() > 0) {
                        g.setColor(this.$colorProvider$inlined.getFontColor(hovered, value));
                        float textOffset = rect.y + (rect.height - (float)fontMetrics.getHeight()) * 0.5f + (float)fontMetrics.getAscent();
                        g.drawString(text, rect.x + (float)3, textOffset);
                    }
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

