/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.actions;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.SetZoomAction;
import com.android.tools.adtui.actions.ZoomType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import java.awt.event.InputEvent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/adtui/actions/ZoomInAction;", "Lcom/android/tools/adtui/actions/SetZoomAction;", "()V", "lastZoomInMs", "", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.android.adt.ui"})
public final class ZoomInAction
extends SetZoomAction {
    private long lastZoomInMs;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        Zoomable zoomable = (Zoomable)event.getData(ZoomableKt.ZOOMABLE_KEY);
        presentation.setEnabled(zoomable != null ? zoomable.canZoomIn() : false);
        String string = event.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.place");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Surface", (boolean)false, (int)2, null)) {
            Presentation presentation2 = event.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
            presentation2.setIcon(AllIcons.General.Add);
        }
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent event) {
        Long eventTimeMs;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InputEvent inputEvent = event.getInputEvent();
        Long l = eventTimeMs = inputEvent != null ? Long.valueOf(inputEvent.getWhen()) : null;
        if (eventTimeMs != null) {
            if (eventTimeMs - this.lastZoomInMs < 50L) {
                return;
            }
            this.lastZoomInMs = eventTimeMs;
        }
        super.actionPerformed(event);
    }

    public ZoomInAction() {
        super(ZoomType.IN);
    }

    @JvmStatic
    @NotNull
    public static final ZoomInAction getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/adtui/actions/ZoomInAction$Companion;", "", "()V", "getInstance", "Lcom/android/tools/adtui/actions/ZoomInAction;", "intellij.android.adt.ui"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ZoomInAction getInstance() {
            AnAction anAction = ActionManager.getInstance().getAction("Adtui.ZoomInAction");
            if (anAction == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.tools.adtui.actions.ZoomInAction");
            }
            return (ZoomInAction)anAction;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

