/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.HorizontalScrollView;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.CommonButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedToolbar
extends JPanel {
    private final JPanel myActionPanel;
    private final JPanel myTabsPanel;
    @Nullable
    private TabLabel myActiveTab;
    @Nullable
    private TabLabel myMouseOverTab;
    private final HorizontalScrollView myTabScrollView;
    private List<Runnable> mySelectionActions;

    public TabbedToolbar(@NotNull JComponent title) {
        if (title == null) {
            TabbedToolbar.$$$reportNull$$$0(0);
        }
        this.myActionPanel = new JPanel();
        this.myTabsPanel = new JPanel();
        this.myTabScrollView = new HorizontalScrollView(this.myTabsPanel);
        this.mySelectionActions = new ArrayList<Runnable>();
        this.myTabsPanel.setLayout(new FlowLayout(3, 0, 0));
        this.setLayout(new TabularLayout("Fit,5px,*,Fit", "*"));
        this.add((Component)title, new TabularLayout.Constraint(0, 0));
        this.add((Component)this.myTabScrollView, new TabularLayout.Constraint(0, 2));
        this.add((Component)this.myActionPanel, new TabularLayout.Constraint(0, 3));
    }

    public void addAction(@NotNull Icon actionIcon, @NotNull ActionListener actionListener) {
        if (actionIcon == null) {
            TabbedToolbar.$$$reportNull$$$0(1);
        }
        if (actionListener == null) {
            TabbedToolbar.$$$reportNull$$$0(2);
        }
        CommonButton action = new CommonButton(actionIcon);
        action.addActionListener(actionListener);
        this.myActionPanel.add(action);
    }

    public void addTab(String name, TabListener selectedListener) {
        this.addTab(name, selectedListener, null);
    }

    public void addTab(@NotNull String name, final @NotNull TabListener selectedListener, @Nullable TabListener closedListener) {
        if (name == null) {
            TabbedToolbar.$$$reportNull$$$0(3);
        }
        if (selectedListener == null) {
            TabbedToolbar.$$$reportNull$$$0(4);
        }
        final TabLabel tab = new TabLabel(name, closedListener);
        final Runnable selectTabAction = () -> {
            this.selectTab(tab, selectedListener);
            this.repaint();
        };
        tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                selectTabAction.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                TabbedToolbar.this.myMouseOverTab = tab;
                TabbedToolbar.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                TabbedToolbar.this.myMouseOverTab = null;
                TabbedToolbar.this.repaint();
            }
        });
        tab.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TabbedToolbar.this.myMouseOverTab = tab;
            }

            @Override
            public void focusLost(FocusEvent e) {
                TabbedToolbar.this.myMouseOverTab = null;
            }
        });
        tab.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TabbedToolbar.this.selectTab(tab, selectedListener);
                }
            }
        });
        this.myTabsPanel.add(tab);
        this.mySelectionActions.add(selectTabAction);
        this.selectTab(tab, selectedListener);
        this.myTabScrollView.scrollTo(this.myTabsPanel.getWidth());
    }

    public void clearTabs() {
        this.myTabsPanel.removeAll();
        this.mySelectionActions.clear();
    }

    public int countTabs() {
        return this.mySelectionActions.size();
    }

    public void selectTab(int tabIndex) {
        this.mySelectionActions.get(tabIndex).run();
    }

    private void selectTab(@NotNull TabLabel tab, @NotNull TabListener listener2) {
        if (listener2 == null) {
            TabbedToolbar.$$$reportNull$$$0(5);
        }
        if (tab == null) {
            TabbedToolbar.$$$reportNull$$$0(6);
        }
        this.myActiveTab = tab;
        listener2.doAction();
    }

    @NotNull
    @VisibleForTesting
    public JComponent getTabsPanel() {
        JPanel jPanel = this.myTabsPanel;
        if (jPanel == null) {
            TabbedToolbar.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionIcon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedListener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tab";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/TabbedToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/TabbedToolbar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addTab";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectTab";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TabListener {
        public void doAction();
    }

    private class TabLabel
    extends JPanel {
        private Color myFocusedColor = StudioColorsKt.getTabbedPaneFocus();
        private Color myHighlightColor = StudioColorsKt.getTabbedPaneHoverHighlight();

        TabLabel(@Nullable String name, final TabListener onClosed) {
            this.setLayout(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
            this.setFocusable(true);
            this.add((Component)new JLabel(name), "Center");
            if (onClosed != null) {
                CommonButton closeButton = new CommonButton(StudioIcons.Common.CLOSE);
                closeButton.addActionListener(e -> onClosed.doAction());
                this.add((Component)closeButton, "East");
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isMiddleMouseButton(e)) {
                            onClosed.doAction();
                        }
                    }
                });
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAAHintForSwingComponent());
            if (TabbedToolbar.this.myMouseOverTab == this) {
                this.setBackground(this.myHighlightColor);
            } else {
                this.setBackground(this.getParent().getBackground());
            }
            super.paintComponent(g);
            if (TabbedToolbar.this.myActiveTab == this) {
                Rectangle bounds = this.getBounds();
                int selectedHeight = JBUIScale.scale((int)2);
                g.setColor(this.myFocusedColor);
                g.fillRect(0, bounds.height - selectedHeight, bounds.width, selectedHeight);
            }
        }
    }
}

