/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class RangeSelectionComponent
extends AnimatedComponent {
    private static final Color DRAG_BAR_COLOR = new JBColor(new Color(637827290, true), new Color(863287295, true));
    private static final int DEFAULT_DRAG_BAR_HEIGHT = 26;
    private static final float HANDLE_WIDTH = 3.0f;
    @VisibleForTesting
    static final float HANDLE_HITBOX_WIDTH = 10.0f;
    private static final float MIN_HANDLE_DISTANCE = 2.0f;
    private static final double SELECTION_MOVE_PERCENT = 0.01;
    public static final double CLICK_RANGE_RATIO = 0.003;
    private int myMousePressed;
    private int myMouseMovedX;
    private Mode myMode;
    @NotNull
    private final RangeSelectionModel myModel;
    private boolean myIsMouseOverComponent;
    private boolean myIsPointSelectionReplaced;
    private int myDragBarHeight;
    @NotNull
    private BooleanSupplier myRangeOcclusionTest;

    public RangeSelectionComponent(@NotNull RangeSelectionModel model2) {
        if (model2 == null) {
            RangeSelectionComponent.$$$reportNull$$$0(0);
        }
        this(model2, false);
    }

    public RangeSelectionComponent(@NotNull RangeSelectionModel model2, boolean isPointSelectionReplaced) {
        if (model2 == null) {
            RangeSelectionComponent.$$$reportNull$$$0(1);
        }
        this.myDragBarHeight = 26;
        this.myRangeOcclusionTest = () -> false;
        this.myModel = model2;
        this.myMode = Mode.NONE;
        this.myIsPointSelectionReplaced = isPointSelectionReplaced;
        this.setFocusable(true);
        this.initListeners();
        this.myModel.addDependency(this.myAspectObserver).onChange(RangeSelectionModel.Aspect.SELECTION, this::opaqueRepaint);
        this.myModel.getViewRange().addDependency(this.myAspectObserver).onChange(Range.Aspect.RANGE, this::opaqueRepaint);
    }

    public void setRangeOcclusionTest(@NotNull BooleanSupplier rangeOcclusionTest) {
        if (rangeOcclusionTest == null) {
            RangeSelectionComponent.$$$reportNull$$$0(2);
        }
        this.myRangeOcclusionTest = rangeOcclusionTest;
    }

    protected void initListeners() {
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (!RangeSelectionComponent.this.isDisplayable() || !RangeSelectionComponent.this.isShowing()) {
                    RangeSelectionComponent.this.resetMouse();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.getClickCount() == 2 && !e.isConsumed()) {
                        RangeSelectionComponent.this.myModel.clear();
                        return;
                    }
                    RangeSelectionComponent.this.requestFocusInWindow();
                    RangeSelectionComponent.this.myMode = RangeSelectionComponent.this.getModeAtCurrentPosition(e.getX(), e.getY());
                    if (RangeSelectionComponent.this.myMode == Mode.CREATE) {
                        double value = RangeSelectionComponent.this.xToRange(e.getX());
                        RangeSelectionComponent.this.myModel.beginUpdate();
                        RangeSelectionComponent.this.myModel.clear();
                        RangeSelectionComponent.this.myModel.set(value, value);
                    }
                    RangeSelectionComponent.this.myMousePressed = e.getX();
                    RangeSelectionComponent.this.updateCursor(RangeSelectionComponent.this.myMode, RangeSelectionComponent.this.myMousePressed);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (RangeSelectionComponent.this.myIsPointSelectionReplaced && RangeSelectionComponent.this.myModel.getSelectionRange().getLength() == 0.0) {
                        Range range = RangeSelectionComponent.this.myModel.getSelectionRange();
                        double delta = RangeSelectionComponent.this.myModel.getViewRange().getLength() * 0.003;
                        RangeSelectionComponent.this.myModel.set(range.getMin() - delta, range.getMax() + delta);
                    }
                    if (RangeSelectionComponent.this.myMode == Mode.CREATE) {
                        RangeSelectionComponent.this.myModel.endUpdate();
                    }
                    RangeSelectionComponent.this.myMode = RangeSelectionComponent.this.getModeAtCurrentPosition(e.getX(), e.getY());
                    RangeSelectionComponent.this.myMousePressed = -1;
                    RangeSelectionComponent.this.updateCursor(RangeSelectionComponent.this.myMode, RangeSelectionComponent.this.myMousePressed);
                    RangeSelectionComponent.this.opaqueRepaint();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RangeSelectionComponent.this.resetMouse();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RangeSelectionComponent.this.myIsMouseOverComponent = true;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double pressed = RangeSelectionComponent.this.xToRange(RangeSelectionComponent.this.myMousePressed);
                double current = RangeSelectionComponent.this.xToRange(e.getX());
                double rangeDelta = current - pressed;
                double min = RangeSelectionComponent.this.myModel.getSelectionRange().getMin();
                double max = RangeSelectionComponent.this.myModel.getSelectionRange().getMax();
                RangeSelectionComponent.this.myMouseMovedX = e.getX();
                switch (RangeSelectionComponent.this.myMode) {
                    case ADJUST_MIN: {
                        if (min + rangeDelta > max) {
                            RangeSelectionComponent.this.myModel.set(max, min + rangeDelta);
                            RangeSelectionComponent.this.myMode = Mode.ADJUST_MAX;
                        } else {
                            RangeSelectionComponent.this.myModel.set(min + rangeDelta, max);
                        }
                        RangeSelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case ADJUST_MAX: {
                        if (max + rangeDelta < min) {
                            RangeSelectionComponent.this.myModel.set(max + rangeDelta, min);
                            RangeSelectionComponent.this.myMode = Mode.ADJUST_MIN;
                        } else {
                            RangeSelectionComponent.this.myModel.set(min, max + rangeDelta);
                        }
                        RangeSelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case MOVE: {
                        RangeSelectionComponent.this.myModel.set(min + rangeDelta, max + rangeDelta);
                        RangeSelectionComponent.this.myMousePressed = e.getX();
                        break;
                    }
                    case CREATE: {
                        RangeSelectionComponent.this.myModel.set(pressed < current ? pressed : current, pressed < current ? current : pressed);
                        break;
                    }
                }
                RangeSelectionComponent.this.updateCursor(RangeSelectionComponent.this.myMode, e.getX());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                RangeSelectionComponent.this.myMode = RangeSelectionComponent.this.getModeAtCurrentPosition(e.getX(), e.getY());
                RangeSelectionComponent.this.updateCursor(RangeSelectionComponent.this.myMode, e.getX());
                RangeSelectionComponent.this.myMouseMovedX = e.getX();
                RangeSelectionComponent.this.opaqueRepaint();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        if (RangeSelectionComponent.this.myModel.getSelectionRange().isEmpty()) break;
                        RangeSelectionComponent.this.myModel.getSelectionRange().clear();
                        e.consume();
                        break;
                    }
                    case 37: {
                        RangeSelectionComponent.this.shiftModel(ShiftDirection.LEFT, e.isAltDown(), e.isShiftDown());
                        break;
                    }
                    case 39: {
                        RangeSelectionComponent.this.shiftModel(ShiftDirection.RIGHT, e.isShiftDown(), e.isAltDown());
                    }
                }
                RangeSelectionComponent.this.myModel.endUpdate();
            }
        });
    }

    private void resetMouse() {
        this.setCursor(Cursor.getDefaultCursor());
        this.myIsMouseOverComponent = false;
    }

    private void shiftModel(ShiftDirection direction, boolean zeroMin, boolean zeroMax) {
        double maxDelta;
        double min = this.myModel.getSelectionRange().getMin();
        double max = this.myModel.getSelectionRange().getMax();
        double rangeDelta = this.myModel.getViewRange().getLength() * 0.01;
        rangeDelta = direction == ShiftDirection.LEFT ? rangeDelta * -1.0 : rangeDelta;
        double minDelta = zeroMin ? 0.0 : rangeDelta;
        double d = maxDelta = zeroMax ? 0.0 : rangeDelta;
        if (max < min) {
            max = min = this.myModel.getViewRange().getLength() / 2.0 + this.myModel.getViewRange().getMin();
        }
        this.myModel.beginUpdate();
        this.myModel.set(min + minDelta, max + maxDelta);
        this.myModel.endUpdate();
    }

    protected double xToRange(int x) {
        return (double)x / this.getSize().getWidth() * this.getModel().getViewRange().getLength() + this.getModel().getViewRange().getMin();
    }

    protected float rangeToX(double value, double width) {
        return (float)Math.min(Math.max(width * (value - this.getModel().getViewRange().getMin()) / (this.getModel().getViewRange().getMax() - this.getModel().getViewRange().getMin()), 0.0), width);
    }

    private Mode getModeAtCurrentPosition(int x, int y) {
        if (this.myModel.getSelectionRange().isEmpty()) {
            return Mode.CREATE;
        }
        double startXPos = this.rangeToX(this.myModel.getSelectionRange().getMin(), this.getWidth());
        double endXPos = this.rangeToX(this.myModel.getSelectionRange().getMax(), this.getWidth());
        if (startXPos - 10.0 < (double)x && (double)x < startXPos + 3.0) {
            return Mode.ADJUST_MIN;
        }
        if (endXPos - 3.0 < (double)x && (double)x < endXPos + 10.0) {
            return Mode.ADJUST_MAX;
        }
        if (startXPos + 3.0 <= (double)x && (double)x <= endXPos - 3.0 && y <= this.myDragBarHeight) {
            return Mode.MOVE;
        }
        return Mode.CREATE;
    }

    private void updateCursor(Mode newMode, int newX) {
        if (this.myRangeOcclusionTest.getAsBoolean()) {
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        switch (newMode) {
            case ADJUST_MIN: {
                this.setCursor(Cursor.getPredefinedCursor(11));
                break;
            }
            case ADJUST_MAX: {
                this.setCursor(Cursor.getPredefinedCursor(10));
                break;
            }
            case MOVE: {
                this.setCursor(AdtUiCursorsProvider.getInstance().getCursor(this.myMousePressed == -1 ? AdtUiCursorType.GRAB : AdtUiCursorType.GRABBING));
                break;
            }
            case CREATE: {
                double mouseRange = this.xToRange(newX);
                if (this.myMode == Mode.CREATE && this.myModel.canSelectRange(new Range(mouseRange, mouseRange))) {
                    if (this.myMousePressed < newX) {
                        this.setCursor(Cursor.getPredefinedCursor(10));
                        break;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(11));
                    break;
                }
                this.setCursor(Cursor.getDefaultCursor());
                break;
            }
        }
    }

    public void addSelectionUpdatedListener(final Consumer<Range> listener2) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    listener2.accept(RangeSelectionComponent.this.myModel.getSelectionRange());
                }
            }
        });
    }

    @NotNull
    public Mode getMode() {
        Mode mode = this.myMode;
        if (mode == null) {
            RangeSelectionComponent.$$$reportNull$$$0(3);
        }
        return mode;
    }

    @NotNull
    public RangeSelectionModel getModel() {
        RangeSelectionModel rangeSelectionModel = this.myModel;
        if (rangeSelectionModel == null) {
            RangeSelectionComponent.$$$reportNull$$$0(4);
        }
        return rangeSelectionModel;
    }

    public boolean shouldShowSeekComponent() {
        return this.myMode != Mode.MOVE && this.myMode != Mode.ADJUST_MIN && this.myMode != Mode.ADJUST_MAX;
    }

    public void setDragBarHeight(int dragBarHeight) {
        this.myDragBarHeight = dragBarHeight;
    }

    @Override
    protected void draw(Graphics2D g, Dimension dim) {
        Range selectionRange = this.myModel.getSelectionRange();
        if (selectionRange.isEmpty() || selectionRange.getMin() > this.myModel.getViewRange().getMax() || selectionRange.getMax() < this.myModel.getViewRange().getMin()) {
            return;
        }
        float startXPos = this.rangeToX(selectionRange.getMin(), dim.getWidth());
        float endXPos = this.rangeToX(selectionRange.getMax(), dim.getWidth());
        float handleDistance = endXPos - startXPos - 6.0f;
        if (handleDistance < 2.0f) {
            handleDistance = 2.0f;
            startXPos = (startXPos + endXPos) / 2.0f - 3.0f - 1.0f;
            endXPos = startXPos + 6.0f + 2.0f;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor((Color)StudioColorsKt.getSelectionOverlayBackground());
        Rectangle2D.Float rect = new Rectangle2D.Float(startXPos + 3.0f, 0.0f, handleDistance, dim.height);
        g.fill(rect);
        if ((float)this.myMouseMovedX > startXPos && (float)this.myMouseMovedX < endXPos && this.myIsMouseOverComponent) {
            g.setColor(DRAG_BAR_COLOR);
            g.fill(new Rectangle2D.Float(startXPos + 3.0f, 0.0f, handleDistance, this.myDragBarHeight));
        }
        g.setColor((Color)StudioColorsKt.getSelectionBackground());
        g.fill(new Rectangle2D.Float(startXPos, 0.0f, 3.0f, dim.height));
        g.fill(new Rectangle2D.Float(endXPos - 3.0f, 0.0f, 3.0f, dim.height));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeOcclusionTest";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/RangeSelectionComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/RangeSelectionComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setRangeOcclusionTest";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ShiftDirection {
        LEFT,
        RIGHT;

    }

    public static enum Mode {
        NONE,
        CREATE,
        MOVE,
        ADJUST_MIN,
        ADJUST_MAX;

    }
}

