/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.stdui.CommonButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.components.JBViewport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/adtui/HorizontalScrollView;", "Ljavax/swing/JPanel;", "content", "Ljavax/swing/JComponent;", "scrollSensitivity", "", "leftButton", "Ljavax/swing/AbstractButton;", "rightButton", "(Ljavax/swing/JComponent;ILjavax/swing/AbstractButton;Ljavax/swing/AbstractButton;)V", "getLeftButton", "()Ljavax/swing/AbstractButton;", "main", "Lcom/intellij/ui/components/JBViewport;", "getRightButton", "xMax", "getXMax", "()I", "clampX", "x", "refreshButtons", "", "scrollBy", "dx", "scrollTo", "newX", "intellij.android.adt.ui"})
public final class HorizontalScrollView
extends JPanel {
    private final JBViewport main;
    private final JComponent content;
    @NotNull
    private final AbstractButton leftButton;
    @NotNull
    private final AbstractButton rightButton;

    private final int getXMax() {
        int n = 0;
        int n2 = this.content.getWidth() - this.main.getWidth();
        return Math.max(n, n2);
    }

    private final int clampX(int x) {
        int n = this.getXMax();
        int n2 = 0;
        n2 = Math.max(n2, x);
        return Math.min(n, n2);
    }

    private final void scrollBy(int dx) {
        this.scrollTo(this.main.getViewPosition().x + dx);
    }

    /*
     * WARNING - void declaration
     */
    public final void scrollTo(int newX) {
        void $this$with;
        Point point;
        Point point2 = point = this.main.getViewPosition();
        JBViewport jBViewport = this.main;
        boolean bl = false;
        Point point3 = new Point(this.clampX(newX), $this$with.y);
        jBViewport.setViewPosition(point3);
        this.refreshButtons();
    }

    private final void refreshButtons() {
        boolean contentTooWide = this.content.getWidth() >= this.main.getWidth();
        this.leftButton.setVisible(contentTooWide && this.main.getViewPosition().x > 0);
        this.rightButton.setVisible(contentTooWide && this.main.getViewPosition().x < this.getXMax());
    }

    @NotNull
    public final AbstractButton getLeftButton() {
        return this.leftButton;
    }

    @NotNull
    public final AbstractButton getRightButton() {
        return this.rightButton;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content, final int scrollSensitivity, @VisibleForTesting @NotNull AbstractButton leftButton, @VisibleForTesting @NotNull AbstractButton rightButton) {
        void $this$apply;
        JBViewport jBViewport;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)leftButton, (String)"leftButton");
        Intrinsics.checkNotNullParameter((Object)rightButton, (String)"rightButton");
        super(new BorderLayout());
        this.content = content;
        this.leftButton = leftButton;
        this.rightButton = rightButton;
        JBViewport jBViewport2 = jBViewport = new JBViewport();
        HorizontalScrollView horizontalScrollView = this;
        boolean bl = false;
        $this$apply.setView((Component)this.content);
        Unit unit = Unit.INSTANCE;
        horizontalScrollView.main = jBViewport;
        this.leftButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.scrollBy(-scrollSensitivity);
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.scrollBy(scrollSensitivity);
            }
        });
        ComponentAdapter listener2 = new ComponentAdapter(this){
            final /* synthetic */ HorizontalScrollView this$0;

            public void componentResized(@NotNull ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                HorizontalScrollView.access$refreshButtons(this.this$0);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.content.addComponentListener(listener2);
        this.main.addComponentListener((ComponentListener)listener2);
        this.main.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public final void mouseWheelMoved(MouseWheelEvent it) {
                MouseWheelEvent mouseWheelEvent = it;
                Intrinsics.checkNotNullExpressionValue((Object)mouseWheelEvent, (String)"it");
                this.scrollBy(mouseWheelEvent.getScrollAmount() * it.getWheelRotation() * scrollSensitivity / 2);
            }
        });
        this.add((Component)this.main, "Center");
        this.add((Component)this.leftButton, "West");
        this.add((Component)this.rightButton, "East");
        this.refreshButtons();
    }

    public /* synthetic */ HorizontalScrollView(JComponent jComponent, int n, AbstractButton abstractButton, AbstractButton abstractButton2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 30;
        }
        if ((n2 & 4) != 0) {
            abstractButton = new CommonButton("\u2190");
        }
        if ((n2 & 8) != 0) {
            abstractButton2 = new CommonButton("\u2192");
        }
        this(jComponent, n, abstractButton, abstractButton2);
    }

    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content, int scrollSensitivity, @VisibleForTesting @NotNull AbstractButton leftButton) {
        this(content, scrollSensitivity, leftButton, null, 8, null);
    }

    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content, int scrollSensitivity) {
        this(content, scrollSensitivity, null, null, 12, null);
    }

    @JvmOverloads
    public HorizontalScrollView(@NotNull JComponent content) {
        this(content, 0, null, null, 14, null);
    }

    public static final /* synthetic */ void access$refreshButtons(HorizontalScrollView $this) {
        $this.refreshButtons();
    }
}

