/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.UISettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AnimatedComponent
extends JComponent {
    protected long mLastRenderTime;
    protected boolean mDrawDebugInfo;
    protected final FontMetrics mDefaultFontMetrics;
    protected final AspectObserver myAspectObserver;
    private BiFunction<Container, Cursor, Container> myCursorSetter;
    private Container myCursorSettingContainer;
    @NotNull
    private final List<String> mDebugInfo = new LinkedList<String>();
    private int mDrawCount;

    public AnimatedComponent() {
        this.mDefaultFontMetrics = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT);
        this.myAspectObserver = new AspectObserver();
    }

    public final boolean isDrawDebugInfo() {
        return this.mDrawDebugInfo;
    }

    public final void setDrawDebugInfo(boolean drawDebugInfo) {
        this.mDrawDebugInfo = drawDebugInfo;
    }

    public final void setCursorSetter(BiFunction<Container, Cursor, Container> cursorSetter) {
        this.myCursorSetter = cursorSetter;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.mLastRenderTime = System.nanoTime();
        Graphics2D g2d = (Graphics2D)g.create();
        UISettings.setupAntialiasing((Graphics)g2d);
        this.draw(g2d, this.getSize());
        ++this.mDrawCount;
        if (this.mDrawDebugInfo) {
            this.doDebugDraw(g2d);
        }
        g2d.dispose();
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.myCursorSettingContainer != null) {
            this.myCursorSettingContainer.setCursor(cursor);
        } else if (this.myCursorSetter != null) {
            this.myCursorSettingContainer = this.myCursorSetter.apply(this, cursor);
        } else {
            super.setCursor(cursor);
        }
    }

    protected final void addDebugInfo(String format, Object ... values) {
        if (this.mDrawDebugInfo) {
            this.mDebugInfo.add(String.format(format, values));
        }
    }

    private void doDebugDraw(Graphics2D g) {
        this.debugDraw(g);
        this.addDebugInfo("Draw Count: %d", this.mDrawCount);
        g.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        g.setColor(AdtUiUtils.DEFAULT_FONT_COLOR);
        int i = 0;
        for (String s : this.mDebugInfo) {
            g.drawString(s, this.getSize().width - 150, this.getSize().height - 10 * i++ - 5);
        }
        this.mDebugInfo.clear();
    }

    protected abstract void draw(Graphics2D var1, Dimension var2);

    protected void debugDraw(Graphics2D g) {
    }

    protected void eventSourceRepaint(ComponentEvent event) {
        Component source = event.getComponent();
        if (source != null) {
            source.repaint();
        }
    }

    protected void opaqueRepaint() {
        this.getOpaqueContainer().repaint();
    }

    protected void opaqueRepaint(int x, int y, int width, int height) {
        this.getOpaqueContainer().repaint(x, y, width, height);
    }

    @VisibleForTesting
    public FontMetrics getDefaultFontMetrics() {
        return this.mDefaultFontMetrics;
    }

    @NotNull
    private Container getOpaqueContainer() {
        Container c = this;
        while (!((Component)c).isOpaque() && c.getParent() != null) {
            c = c.getParent();
        }
        AnimatedComponent animatedComponent = c;
        if (animatedComponent == null) {
            AnimatedComponent.$$$reportNull$$$0(0);
        }
        return animatedComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/AnimatedComponent", "getOpaqueContainer"));
    }
}

