/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.JvmTestSuitePlugin;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.scala.ScalaBasePlugin;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.GenerateIdeaProject;
import org.gradle.plugins.ide.idea.GenerateIdeaWorkspace;
import org.gradle.plugins.ide.idea.internal.IdeaModuleMetadata;
import org.gradle.plugins.ide.idea.internal.IdeaScalaConfigurer;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaModuleIml;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.plugins.ide.idea.model.IdeaWorkspace;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.internal.GeneratedIdeaScope;
import org.gradle.plugins.ide.internal.IdeArtifactRegistry;
import org.gradle.plugins.ide.internal.IdePlugin;
import org.gradle.plugins.ide.internal.configurer.UniqueProjectNameProvider;
import org.gradle.testing.base.TestingExtension;

public class IdeaPlugin
extends IdePlugin {
    private static final Predicate<Project> HAS_IDEA_AND_JAVA_PLUGINS = new Predicate<Project>(){

        public boolean apply(Project project) {
            return project.getPlugins().hasPlugin(IdeaPlugin.class) && project.getPlugins().hasPlugin(JavaBasePlugin.class);
        }
    };
    public static final Function<Project, JavaVersion> SOURCE_COMPATIBILITY = new Function<Project, JavaVersion>(){

        public JavaVersion apply(Project p) {
            return p.getExtensions().getByType(JavaPluginExtension.class).getSourceCompatibility();
        }
    };
    public static final Function<Project, JavaVersion> TARGET_COMPATIBILITY = new Function<Project, JavaVersion>(){

        public JavaVersion apply(Project p) {
            return p.getExtensions().getByType(JavaPluginExtension.class).getTargetCompatibility();
        }
    };
    private static final String IDEA_MODULE_TASK_NAME = "ideaModule";
    private static final String IDEA_PROJECT_TASK_NAME = "ideaProject";
    private static final String IDEA_WORKSPACE_TASK_NAME = "ideaWorkspace";
    private final Instantiator instantiator;
    private IdeaModel ideaModel;
    private List<Project> allJavaProjects;
    private final UniqueProjectNameProvider uniqueProjectNameProvider;
    private final IdeArtifactRegistry artifactRegistry;
    private final ProjectStateRegistry projectPathRegistry;

    @Inject
    public IdeaPlugin(Instantiator instantiator, UniqueProjectNameProvider uniqueProjectNameProvider, IdeArtifactRegistry artifactRegistry, ProjectStateRegistry projectPathRegistry) {
        this.instantiator = instantiator;
        this.uniqueProjectNameProvider = uniqueProjectNameProvider;
        this.artifactRegistry = artifactRegistry;
        this.projectPathRegistry = projectPathRegistry;
    }

    public IdeaModel getModel() {
        return this.ideaModel;
    }

    @Override
    protected String getLifecycleTaskName() {
        return "idea";
    }

    @Override
    protected void onApply(Project project) {
        this.getLifecycleTask().configure(IdeaPlugin.withDescription("Generates IDEA project files (IML, IPR, IWS)"));
        this.getCleanTask().configure(IdeaPlugin.withDescription("Cleans IDEA project files (IML, IPR)"));
        this.ideaModel = project.getExtensions().create("idea", IdeaModel.class, new Object[0]);
        this.configureIdeaWorkspace(project);
        this.configureIdeaProject(project);
        this.configureIdeaModule((ProjectInternal)project);
        this.configureForJavaPlugin(project);
        this.configureForWarPlugin(project);
        this.configureForScalaPlugin();
        this.configureForTestSuitesPlugin(project);
        this.linkCompositeBuildDependencies((ProjectInternal)project);
    }

    private void configureIdeaWorkspace(final Project project) {
        if (this.isRoot()) {
            IdeaWorkspace workspace = project.getObjects().newInstance(IdeaWorkspace.class, new Object[0]);
            workspace.setIws(new XmlFileContentMerger(new XmlTransformer()));
            this.ideaModel.setWorkspace(workspace);
            TaskProvider<GenerateIdeaWorkspace> task = project.getTasks().register(IDEA_WORKSPACE_TASK_NAME, GenerateIdeaWorkspace.class, workspace);
            task.configure(new Action<GenerateIdeaWorkspace>(){

                @Override
                public void execute(GenerateIdeaWorkspace task) {
                    task.setDescription("Generates an IDEA workspace file (IWS)");
                    task.setOutputFile(new File(project.getProjectDir(), project.getName() + ".iws"));
                }
            });
            this.addWorker(task, IDEA_WORKSPACE_TASK_NAME, false);
        }
    }

    private void configureIdeaProject(final Project project) {
        if (this.isRoot()) {
            XmlFileContentMerger ipr = new XmlFileContentMerger(new XmlTransformer());
            IdeaProject ideaProject = this.instantiator.newInstance(IdeaProject.class, project, ipr);
            final TaskProvider<GenerateIdeaProject> projectTask = project.getTasks().register(IDEA_PROJECT_TASK_NAME, GenerateIdeaProject.class, ideaProject);
            projectTask.configure(new Action<GenerateIdeaProject>(){

                @Override
                public void execute(GenerateIdeaProject projectTask) {
                    projectTask.setDescription("Generates IDEA project file (IPR)");
                }
            });
            this.ideaModel.setProject(ideaProject);
            ideaProject.setOutputFile(new File(project.getProjectDir(), project.getName() + ".ipr"));
            ConventionMapping conventionMapping = ((IConventionAware)((Object)ideaProject)).getConventionMapping();
            conventionMapping.map("jdkName", new Callable<String>(){

                @Override
                public String call() {
                    return JavaVersion.current().toString();
                }
            });
            conventionMapping.map("languageLevel", new Callable<IdeaLanguageLevel>(){

                @Override
                public IdeaLanguageLevel call() {
                    JavaVersion maxSourceCompatibility = IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)SOURCE_COMPATIBILITY);
                    return new IdeaLanguageLevel((Object)maxSourceCompatibility);
                }
            });
            conventionMapping.map("targetBytecodeVersion", new Callable<JavaVersion>(){

                @Override
                public JavaVersion call() {
                    return IdeaPlugin.this.getMaxJavaModuleCompatibilityVersionFor((Function<Project, JavaVersion>)TARGET_COMPATIBILITY);
                }
            });
            ideaProject.getWildcards().addAll(Arrays.asList("!?*.class", "!?*.scala", "!?*.groovy", "!?*.java"));
            conventionMapping.map("modules", new Callable<List<IdeaModule>>(){

                @Override
                public List<IdeaModule> call() {
                    return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Sets.filter(project.getRootProject().getAllprojects(), (Predicate)new Predicate<Project>(){

                        public boolean apply(Project p) {
                            return p.getPlugins().hasPlugin(IdeaPlugin.class);
                        }
                    }), (Function)new Function<Project, IdeaModule>(){

                        public IdeaModule apply(Project p) {
                            return IdeaPlugin.ideaModelFor(p).getModule();
                        }
                    }));
                }
            });
            conventionMapping.map("pathFactory", new Callable<PathFactory>(){

                @Override
                public PathFactory call() {
                    return new PathFactory().addPathVariable("PROJECT_DIR", ((GenerateIdeaProject)projectTask.get()).getOutputFile().getParentFile());
                }
            });
            this.addWorker(projectTask, IDEA_PROJECT_TASK_NAME);
            this.addWorkspace(ideaProject);
        }
    }

    private static IdeaModel ideaModelFor(Project project) {
        return project.getExtensions().getByType(IdeaModel.class);
    }

    private JavaVersion getMaxJavaModuleCompatibilityVersionFor(Function<Project, JavaVersion> toJavaVersion) {
        List<Project> allJavaProjects = this.getAllJavaProjects();
        if (allJavaProjects.isEmpty()) {
            return JavaVersion.VERSION_1_6;
        }
        return (JavaVersion)((Object)Collections.max(Lists.transform(allJavaProjects, toJavaVersion)));
    }

    private List<Project> getAllJavaProjects() {
        if (this.allJavaProjects != null) {
            return this.allJavaProjects;
        }
        this.allJavaProjects = Lists.newArrayList((Iterable)Iterables.filter(this.project.getRootProject().getAllprojects(), HAS_IDEA_AND_JAVA_PLUGINS));
        return this.allJavaProjects;
    }

    private void configureIdeaModule(final ProjectInternal project) {
        IdeaModuleIml iml = new IdeaModuleIml(new XmlTransformer(), project.getProjectDir());
        final IdeaModule module = this.instantiator.newInstance(IdeaModule.class, project, iml);
        final TaskProvider<GenerateIdeaModule> task = project.getTasks().register(IDEA_MODULE_TASK_NAME, GenerateIdeaModule.class, module);
        task.configure(new Action<GenerateIdeaModule>(){

            @Override
            public void execute(GenerateIdeaModule task) {
                task.setDescription("Generates IDEA module files (IML)");
            }
        });
        this.ideaModel.setModule(module);
        String defaultModuleName = this.uniqueProjectNameProvider.getUniqueName(project);
        module.setName(defaultModuleName);
        ConventionMapping conventionMapping = ((IConventionAware)((Object)module)).getConventionMapping();
        final LinkedHashSet sourceDirs = Sets.newLinkedHashSet();
        conventionMapping.map("sourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return sourceDirs;
            }
        });
        conventionMapping.map("contentRoot", new Callable<File>(){

            @Override
            public File call() {
                return project.getProjectDir();
            }
        });
        final LinkedHashSet testSourceDirs = Sets.newLinkedHashSet();
        conventionMapping.map("testSourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                return testSourceDirs;
            }
        });
        final LinkedHashSet resourceDirs = Sets.newLinkedHashSet();
        conventionMapping.map("resourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return resourceDirs;
            }
        });
        final LinkedHashSet testResourceDirs = Sets.newLinkedHashSet();
        conventionMapping.map("testResourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() throws Exception {
                return testResourceDirs;
            }
        });
        final LinkedHashSet excludeDirs = Sets.newLinkedHashSet();
        conventionMapping.map("excludeDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                excludeDirs.add(project.file(".gradle"));
                excludeDirs.add(project.getBuildDir());
                return excludeDirs;
            }
        });
        conventionMapping.map("pathFactory", new Callable<PathFactory>(){

            @Override
            public PathFactory call() {
                PathFactory factory = new PathFactory();
                factory.addPathVariable("MODULE_DIR", ((GenerateIdeaModule)task.get()).getOutputFile().getParentFile());
                for (Map.Entry<String, File> entry : module.getPathVariables().entrySet()) {
                    factory.addPathVariable(entry.getKey(), entry.getValue());
                }
                return factory;
            }
        });
        this.artifactRegistry.registerIdeProject(new IdeaModuleMetadata(module, task));
        this.addWorker(task, IDEA_MODULE_TASK_NAME);
    }

    private void configureForJavaPlugin(final Project project) {
        project.getPlugins().withType(JavaPlugin.class, new Action<JavaPlugin>(){

            @Override
            public void execute(JavaPlugin javaPlugin) {
                IdeaPlugin.this.configureIdeaModuleForJava(project);
            }
        });
    }

    private void configureForWarPlugin(final Project project) {
        project.getPlugins().withType(WarPlugin.class, new Action<WarPlugin>(){

            @Override
            public void execute(WarPlugin warPlugin) {
                IdeaPlugin.this.configureIdeaModuleForWar(project);
            }
        });
    }

    private void configureForTestSuitesPlugin(final Project project) {
        project.getPlugins().withType(JvmTestSuitePlugin.class, new Action<JvmTestSuitePlugin>(){

            @Override
            public void execute(JvmTestSuitePlugin testSuitePlugin) {
                IdeaPlugin.this.configureIdeaModuleForTestSuites(project);
            }
        });
    }

    private void configureIdeaModuleForJava(final Project project) {
        project.getTasks().withType(GenerateIdeaModule.class).configureEach(new Action<GenerateIdeaModule>(){

            @Override
            public void execute(GenerateIdeaModule ideaModule) {
                ideaModule.dependsOn(new Callable<FileCollection>(){

                    @Override
                    public FileCollection call() {
                        SourceSetContainer sourceSets = project.getExtensions().getByType(JavaPluginExtension.class).getSourceSets();
                        return ((SourceSet)sourceSets.getByName("main")).getOutput().getDirs().plus(((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                    }
                });
            }
        });
        this.setupScopes(project);
        ConventionMapping convention = ((IConventionAware)((Object)this.ideaModel.getModule())).getConventionMapping();
        final LinkedHashSet sourceDirs = Sets.newLinkedHashSet();
        convention.map("sourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                SourceSetContainer sourceSets = project.getExtensions().getByType(JavaPluginExtension.class).getSourceSets();
                sourceDirs.addAll(((SourceSet)sourceSets.getByName("main")).getAllJava().getSrcDirs());
                return sourceDirs;
            }
        });
        final LinkedHashSet resourceDirs = Sets.newLinkedHashSet();
        convention.map("resourceDirs", new Callable<Set<File>>(){

            @Override
            public Set<File> call() {
                SourceSetContainer sourceSets = project.getExtensions().getByType(JavaPluginExtension.class).getSourceSets();
                resourceDirs.addAll(((SourceSet)sourceSets.getByName("main")).getResources().getSrcDirs());
                return resourceDirs;
            }
        });
        final LinkedHashMap singleEntryLibraries = new LinkedHashMap(2);
        convention.map("singleEntryLibraries", new Callable<Map<String, FileCollection>>(){

            @Override
            public Map<String, FileCollection> call() {
                SourceSetContainer sourceSets = project.getExtensions().getByType(JavaPluginExtension.class).getSourceSets();
                singleEntryLibraries.putIfAbsent("RUNTIME", ((SourceSet)sourceSets.getByName("main")).getOutput().getDirs());
                singleEntryLibraries.putIfAbsent("TEST", ((SourceSet)sourceSets.getByName("test")).getOutput().getDirs());
                return singleEntryLibraries;
            }
        });
        convention.map("targetBytecodeVersion", new Callable<JavaVersion>(){

            @Override
            public JavaVersion call() {
                JavaVersion moduleTargetBytecodeLevel = project.getExtensions().getByType(JavaPluginExtension.class).getTargetCompatibility();
                return IdeaPlugin.includeModuleBytecodeLevelOverride(project.getRootProject(), moduleTargetBytecodeLevel) ? moduleTargetBytecodeLevel : null;
            }
        });
        convention.map("languageLevel", new Callable<IdeaLanguageLevel>(){

            @Override
            public IdeaLanguageLevel call() {
                IdeaLanguageLevel moduleLanguageLevel = new IdeaLanguageLevel((Object)project.getExtensions().getByType(JavaPluginExtension.class).getSourceCompatibility());
                return IdeaPlugin.includeModuleLanguageLevelOverride(project.getRootProject(), moduleLanguageLevel) ? moduleLanguageLevel : null;
            }
        });
    }

    private void setupScopes(Project project) {
        LinkedHashMap scopes = Maps.newLinkedHashMap();
        for (GeneratedIdeaScope scope : GeneratedIdeaScope.values()) {
            LinkedHashMap plusMinus = Maps.newLinkedHashMap();
            plusMinus.put("plus", Lists.newArrayList());
            plusMinus.put("minus", Lists.newArrayList());
            scopes.put(scope.name(), plusMinus);
        }
        ConfigurationContainer configurations = project.getConfigurations();
        Collection provided = (Collection)((Map)scopes.get(GeneratedIdeaScope.PROVIDED.name())).get("plus");
        provided.add(configurations.getByName("compileClasspath"));
        Collection runtime = (Collection)((Map)scopes.get(GeneratedIdeaScope.RUNTIME.name())).get("plus");
        runtime.add(configurations.getByName("runtimeClasspath"));
        Collection test = (Collection)((Map)scopes.get(GeneratedIdeaScope.TEST.name())).get("plus");
        test.add(configurations.getByName("testCompileClasspath"));
        test.add(configurations.getByName("testRuntimeClasspath"));
        this.ideaModel.getModule().setScopes(scopes);
    }

    private void configureIdeaModuleForTestSuites(Project project) {
        TestingExtension testing = project.getExtensions().getByType(TestingExtension.class);
        IdeaModule ideaModule = IdeaPlugin.ideaModelFor(project).getModule();
        testing.getSuites().withType(JvmTestSuite.class).configureEach(suite -> {
            ideaModule.getTestSources().from(suite.getSources().getAllJava().getSourceDirectories());
            ideaModule.getTestResources().from(suite.getSources().getResources().getSourceDirectories());
        });
    }

    private void configureIdeaModuleForWar(final Project project) {
        project.getTasks().withType(GenerateIdeaModule.class).configureEach(new Action<GenerateIdeaModule>(){

            @Override
            public void execute(GenerateIdeaModule ideaModule) {
                ConfigurationContainer configurations = project.getConfigurations();
                Configuration providedRuntime = configurations.getByName("providedRuntime");
                Collection<Configuration> providedPlus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.PROVIDED.name()).get("plus");
                providedPlus.add(providedRuntime);
                Collection<Configuration> runtimeMinus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.RUNTIME.name()).get("minus");
                runtimeMinus.add(providedRuntime);
                Collection<Configuration> testMinus = ideaModule.getModule().getScopes().get(GeneratedIdeaScope.TEST.name()).get("minus");
                testMinus.add(providedRuntime);
            }
        });
    }

    private static boolean includeModuleBytecodeLevelOverride(Project rootProject, JavaVersion moduleTargetBytecodeLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleTargetBytecodeLevel.equals((Object)ideaProject.getTargetBytecodeVersion());
    }

    private static boolean includeModuleLanguageLevelOverride(Project rootProject, IdeaLanguageLevel moduleLanguageLevel) {
        if (!rootProject.getPlugins().hasPlugin(IdeaPlugin.class)) {
            return true;
        }
        IdeaProject ideaProject = IdeaPlugin.ideaModelFor(rootProject).getProject();
        return !moduleLanguageLevel.equals(ideaProject.getLanguageLevel());
    }

    private void configureForScalaPlugin() {
        this.project.getPlugins().withType(ScalaBasePlugin.class, new Action<ScalaBasePlugin>(){

            @Override
            public void execute(ScalaBasePlugin scalaBasePlugin) {
                IdeaPlugin.this.ideaModuleDependsOnRoot();
            }
        });
        if (this.isRoot()) {
            new IdeaScalaConfigurer(this.project).configure();
        }
    }

    private void ideaModuleDependsOnRoot() {
        this.project.getTasks().named(IDEA_MODULE_TASK_NAME, IdeaPlugin.dependsOn((TaskProvider<? extends Task>)this.project.getRootProject().getTasks().named(IDEA_PROJECT_TASK_NAME)));
    }

    private void linkCompositeBuildDependencies(ProjectInternal project) {
        if (this.isRoot()) {
            this.getLifecycleTask().configure(task -> task.dependsOn(context -> this.visitAllImlArtifactsInComposite(project, this.ideaModel.getProject(), context)));
        }
    }

    private void visitAllImlArtifactsInComposite(ProjectInternal project, IdeaProject ideaProject, TaskDependencyResolveContext context) {
        ProjectComponentIdentifier thisProjectId = this.projectPathRegistry.stateFor(project).getComponentIdentifier();
        for (IdeArtifactRegistry.Reference<IdeaModuleMetadata> reference : this.artifactRegistry.getIdeProjects(IdeaModuleMetadata.class)) {
            BuildIdentifier otherBuildId = reference.getOwningProject().getBuild();
            if (thisProjectId.getBuild().equals(otherBuildId)) {
                boolean found = false;
                for (IdeaModule ideaModule : ideaProject.getModules()) {
                    if (!reference.get().getFile().equals(ideaModule.getOutputFile())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            reference.visitDependencies(context);
        }
    }
}

