/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.RepositoryContentDescriptor;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.dsl.RepositoryHandlerInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.repositories.ArtifactRepositoryInternal;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.RepositoryContentDescriptorInternal;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.Factory;
import org.gradle.plugin.use.internal.PluginRepositoryHandlerProvider;
import org.gradle.plugin.use.resolve.internal.PluginRepositoriesProvider;

public class PluginDependencyResolutionServices
implements DependencyResolutionServices {
    private static final String REPOSITORY_NAME_PREFIX = "__plugin_repository__";
    private final Factory<DependencyResolutionServices> factory;
    private DependencyResolutionServices dependencyResolutionServices;

    public PluginDependencyResolutionServices(Factory<DependencyResolutionServices> factory) {
        this.factory = factory;
    }

    private DependencyResolutionServices getDependencyResolutionServices() {
        if (this.dependencyResolutionServices == null) {
            this.dependencyResolutionServices = this.factory.create();
        }
        return this.dependencyResolutionServices;
    }

    @Override
    public RepositoryHandler getResolveRepositoryHandler() {
        return this.getDependencyResolutionServices().getResolveRepositoryHandler();
    }

    @Override
    public ConfigurationContainer getConfigurationContainer() {
        return this.getDependencyResolutionServices().getConfigurationContainer();
    }

    @Override
    public DependencyHandler getDependencyHandler() {
        return this.getDependencyResolutionServices().getDependencyHandler();
    }

    @Override
    public DependencyLockingHandler getDependencyLockingHandler() {
        return this.getDependencyResolutionServices().getDependencyLockingHandler();
    }

    @Override
    public ImmutableAttributesFactory getAttributesFactory() {
        return this.getDependencyResolutionServices().getAttributesFactory();
    }

    @Override
    public AttributesSchema getAttributesSchema() {
        return this.getDependencyResolutionServices().getAttributesSchema();
    }

    public PluginRepositoryHandlerProvider getPluginRepositoryHandlerProvider() {
        return this::getResolveRepositoryHandler;
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.getDependencyResolutionServices().getObjectFactory();
    }

    public PluginRepositoriesProvider getPluginRepositoriesProvider() {
        return new DefaultPluginRepositoriesProvider();
    }

    private static class PluginArtifactRepository
    implements ArtifactRepositoryInternal,
    ContentFilteringRepository,
    ResolutionAwareRepository {
        private final ArtifactRepositoryInternal delegate;
        private final ResolutionAwareRepository resolutionAwareDelegate;
        private final RepositoryContentDescriptorInternal repositoryContentDescriptor;

        private PluginArtifactRepository(ArtifactRepository delegate) {
            this.delegate = (ArtifactRepositoryInternal)delegate;
            this.resolutionAwareDelegate = (ResolutionAwareRepository)((Object)delegate);
            this.repositoryContentDescriptor = this.delegate.getRepositoryDescriptorCopy();
        }

        @Override
        public String getName() {
            return PluginDependencyResolutionServices.REPOSITORY_NAME_PREFIX + this.delegate.getName();
        }

        @Override
        public void setName(String name) {
            this.delegate.setName(name);
        }

        @Override
        public void content(Action<? super RepositoryContentDescriptor> configureAction) {
            configureAction.execute(this.repositoryContentDescriptor);
        }

        @Override
        public Action<? super ArtifactResolutionDetails> getContentFilter() {
            return this.repositoryContentDescriptor.toContentFilter();
        }

        @Override
        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        @Override
        public ConfiguredModuleComponentRepository createResolver() {
            return this.resolutionAwareDelegate.createResolver();
        }

        @Override
        public RepositoryDescriptor getDescriptor() {
            return this.resolutionAwareDelegate.getDescriptor();
        }

        @Override
        public void onAddToContainer(NamedDomainObjectCollection<ArtifactRepository> container) {
            this.delegate.onAddToContainer(container);
        }

        @Override
        public RepositoryContentDescriptorInternal createRepositoryDescriptor() {
            return this.delegate.createRepositoryDescriptor();
        }

        @Override
        public RepositoryContentDescriptorInternal getRepositoryDescriptorCopy() {
            return this.repositoryContentDescriptor.asMutableCopy();
        }
    }

    private class DefaultPluginRepositoriesProvider
    implements PluginRepositoriesProvider {
        private final Object lock = new Object();
        private List<ArtifactRepository> repositories;

        private DefaultPluginRepositoriesProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void prepareForPluginResolution() {
            Object object = this.lock;
            synchronized (object) {
                if (this.repositories == null) {
                    DependencyResolutionServices dependencyResolutionServices = PluginDependencyResolutionServices.this.getDependencyResolutionServices();
                    RepositoryHandler repositories = PluginDependencyResolutionServices.this.getResolveRepositoryHandler();
                    if (repositories.isEmpty()) {
                        repositories.gradlePluginPortal();
                    }
                    JavaEcosystemSupport.configureSchema(dependencyResolutionServices.getAttributesSchema(), dependencyResolutionServices.getObjectFactory());
                    this.repositories = PluginDependencyResolutionServices.this.getResolveRepositoryHandler().stream().map(x$0 -> new PluginArtifactRepository((ArtifactRepository)x$0)).collect(Collectors.toList());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ArtifactRepository> getPluginRepositories() {
            Object object = this.lock;
            synchronized (object) {
                if (this.repositories == null) {
                    throw new IllegalStateException("Plugin repositories have not been prepared.");
                }
                return this.repositories;
            }
        }

        @Override
        public boolean isExclusiveContentInUse() {
            return ((RepositoryHandlerInternal)PluginDependencyResolutionServices.this.getResolveRepositoryHandler()).isExclusiveContentInUse();
        }
    }
}

