/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.metadata;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadata;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.AbstractMetadataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetadata;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerType;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadata;
import org.gradle.nativeplatform.toolchain.internal.swift.metadata.SwiftcMetadataProvider;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.process.internal.ExecActionFactory;

public class CompilerMetaDataProviderFactory {
    private final CachingCompilerMetaDataProvider<GccMetadata> gcc;
    private final CachingCompilerMetaDataProvider<GccMetadata> clang;
    private final CachingCompilerMetaDataProvider<SwiftcMetadata> swiftc;

    public CompilerMetaDataProviderFactory(ExecActionFactory execActionFactory) {
        this.gcc = new CachingCompilerMetaDataProvider(GccMetadataProvider.forGcc(execActionFactory));
        this.clang = new CachingCompilerMetaDataProvider(GccMetadataProvider.forClang(execActionFactory));
        this.swiftc = new CachingCompilerMetaDataProvider(new SwiftcMetadataProvider(execActionFactory));
    }

    public CompilerMetaDataProvider<GccMetadata> gcc() {
        return this.gcc;
    }

    public CompilerMetaDataProvider<GccMetadata> clang() {
        return this.clang;
    }

    public CompilerMetaDataProvider<SwiftcMetadata> swiftc() {
        return this.swiftc;
    }

    private static class Key {
        final File gccBinary;
        final List<String> args;
        final List<File> path;
        private final Map<String, ?> environmentVariables;

        private Key(File gccBinary, List<String> args, List<File> path, Map<String, ?> environmentVariables) {
            this.gccBinary = gccBinary;
            this.args = args;
            this.path = path;
            this.environmentVariables = environmentVariables;
        }

        public boolean equals(Object obj) {
            Key other = (Key)obj;
            return other.gccBinary.equals(this.gccBinary) && other.args.equals(this.args) && other.path.equals(this.path) && other.environmentVariables.equals(this.environmentVariables);
        }

        public int hashCode() {
            return this.gccBinary.hashCode() ^ this.args.hashCode() ^ this.path.hashCode() ^ this.environmentVariables.hashCode();
        }
    }

    private static class CachingCompilerMetaDataProvider<T extends CompilerMetadata>
    implements CompilerMetaDataProvider<T> {
        private final CompilerMetaDataProvider<T> delegate;
        private final Map<Key, SearchResult<T>> resultMap = new HashMap<Key, SearchResult<T>>();

        private CachingCompilerMetaDataProvider(CompilerMetaDataProvider<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public SearchResult<T> getCompilerMetaData(List<File> path, Action<? super CompilerMetaDataProvider.CompilerExecSpec> configureAction) {
            AbstractMetadataProvider.DefaultCompilerExecSpec execSpec = new AbstractMetadataProvider.DefaultCompilerExecSpec();
            configureAction.execute(execSpec);
            Key key = new Key(execSpec.executable, execSpec.args, path, execSpec.environments);
            SearchResult<T> result2 = this.resultMap.get(key);
            if (result2 == null) {
                result2 = this.delegate.getCompilerMetaData(path, configureAction);
                this.resultMap.put(key, result2);
            }
            return result2;
        }

        @Override
        public CompilerType getCompilerType() {
            return this.delegate.getCompilerType();
        }
    }
}

