/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.model.internal.type.ClassTypeWrapper;
import org.gradle.model.internal.type.TypeVariableTypeWrapper;
import org.gradle.model.internal.type.TypeWrapper;
import org.gradle.model.internal.type.WildcardWrapper;

class ParameterizedTypeWrapper
implements TypeWrapper {
    private final TypeWrapper[] actualTypeArguments;
    private final ClassTypeWrapper rawType;
    private final TypeWrapper ownerType;
    private final int hashCode;

    public ParameterizedTypeWrapper(TypeWrapper[] actualTypeArguments, ClassTypeWrapper rawType, @Nullable TypeWrapper ownerType) {
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
        this.ownerType = ownerType;
        this.hashCode = this.hashCode(actualTypeArguments, rawType, ownerType);
    }

    private int hashCode(TypeWrapper[] actualTypeArguments, ClassTypeWrapper rawType, TypeWrapper ownerType) {
        int hashCode = rawType.hashCode();
        for (TypeWrapper actualTypeArgument : actualTypeArguments) {
            hashCode ^= actualTypeArgument.hashCode();
        }
        if (ownerType != null) {
            hashCode ^= ownerType.hashCode();
        }
        return hashCode;
    }

    public TypeWrapper getRawType() {
        return this.rawType;
    }

    @Override
    public Class<?> getRawClass() {
        return this.rawType.unwrap();
    }

    @Override
    public boolean isAssignableFrom(TypeWrapper wrapper) {
        if (wrapper instanceof ParameterizedTypeWrapper) {
            ParameterizedTypeWrapper parameterizedTypeWrapper = (ParameterizedTypeWrapper)wrapper;
            if (!this.rawType.isAssignableFrom(parameterizedTypeWrapper.rawType)) {
                return false;
            }
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                if (ParameterizedTypeWrapper.contains(this.actualTypeArguments[i], parameterizedTypeWrapper.actualTypeArguments[i])) continue;
                return false;
            }
            return true;
        }
        if (wrapper instanceof ClassTypeWrapper) {
            if (!this.rawType.equals(wrapper)) {
                return false;
            }
            for (TypeWrapper typeArgument : this.actualTypeArguments) {
                if (!(typeArgument instanceof WildcardWrapper)) {
                    return false;
                }
                WildcardWrapper wildcard = (WildcardWrapper)typeArgument;
                if (wildcard.getLowerBound() == null && wildcard.getUpperBound().getRawClass().equals(Object.class)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean contains(TypeWrapper type1, TypeWrapper type2) {
        if (type1 instanceof WildcardWrapper) {
            WildcardWrapper wildcardType1 = (WildcardWrapper)type1;
            TypeWrapper bound1 = wildcardType1.getLowerBound();
            if (bound1 != null) {
                TypeWrapper bound2;
                if (type2 instanceof WildcardWrapper) {
                    bound2 = ((WildcardWrapper)type2).getLowerBound();
                    if (bound2 == null) {
                        return false;
                    }
                } else {
                    bound2 = type2;
                }
                return bound2.isAssignableFrom(bound1);
            }
            bound1 = wildcardType1.getUpperBound();
            TypeWrapper bound2 = type2 instanceof WildcardWrapper ? ((WildcardWrapper)type2).getUpperBound() : type2;
            return bound1.isAssignableFrom(bound2);
        }
        return type1.equals(type2);
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        this.rawType.collectClasses(builder);
        for (TypeWrapper actualTypeArgument : this.actualTypeArguments) {
            actualTypeArgument.collectClasses(builder);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof ParameterizedTypeWrapper) {
            ParameterizedTypeWrapper that = (ParameterizedTypeWrapper)o;
            if (this == that) {
                return true;
            }
            return (this.ownerType == null ? that.ownerType == null : this.ownerType.equals(that.ownerType)) && (this.rawType == null ? that.rawType == null : this.rawType.equals(that.rawType)) && Arrays.equals(this.actualTypeArguments, that.actualTypeArguments);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getRepresentation(true);
    }

    @Override
    public String getRepresentation(boolean full) {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            sb.append(this.ownerType.getRepresentation(full));
            sb.append('.');
            sb.append(this.rawType.unwrap().getSimpleName());
        } else {
            sb.append(this.rawType.getRepresentation(full));
        }
        if (this.actualTypeArguments != null && this.actualTypeArguments.length > 0) {
            sb.append("<");
            boolean first = true;
            for (TypeWrapper t : this.actualTypeArguments) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(t.getRepresentation(full));
                first = false;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public ParameterizedTypeWrapper substitute(TypeVariable<?> typeVariable, TypeWrapper type) {
        TypeWrapper[] newArguments = new TypeWrapper[this.actualTypeArguments.length];
        for (int i = 0; i < newArguments.length; ++i) {
            TypeVariableTypeWrapper candidate;
            TypeWrapper argument = this.actualTypeArguments[i];
            newArguments[i] = argument instanceof TypeVariableTypeWrapper && (candidate = (TypeVariableTypeWrapper)argument).getName().equals(typeVariable.getName()) ? type : argument;
        }
        return new ParameterizedTypeWrapper(newArguments, this.rawType, this.ownerType);
    }

    ParameterizedTypeWrapper substituteAll(TypeWrapper[] newArguments) {
        if (this.actualTypeArguments.length != newArguments.length) {
            throw new IllegalArgumentException("Expecting " + this.actualTypeArguments.length + " type arguments but got " + newArguments.length + ".");
        }
        return new ParameterizedTypeWrapper(newArguments, this.rawType, this.ownerType);
    }

    public TypeWrapper[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }
}

