/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.LinkedHashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.ModelListener;
import org.gradle.model.internal.registry.ModelNodeInternal;

class ModelGraph {
    private final ModelNodeInternal root;
    private final Map<ModelPath, ModelNodeInternal> flattened = Maps.newTreeMap();
    private final SetMultimap<ModelPath, ModelListener> pathListeners = LinkedHashMultimap.create();
    private final SetMultimap<ModelPath, ModelListener> parentListeners = LinkedHashMultimap.create();
    private final SetMultimap<ModelPath, ModelListener> ancestorListeners = LinkedHashMultimap.create();
    private final Set<ModelListener> listeners = new LinkedHashSet<ModelListener>();
    private boolean notifying;
    private final Deque<ModelListener> pendingListeners = new ArrayDeque<ModelListener>();
    private final Map<ModelNodeInternal, PendingState> pendingNodes = Maps.newLinkedHashMap();

    public ModelGraph(ModelNodeInternal rootNode) {
        this.root = rootNode;
        this.flattened.put(this.root.getPath(), this.root);
    }

    public ModelNodeInternal getRoot() {
        return this.root;
    }

    public Map<ModelPath, ModelNodeInternal> getFlattened() {
        return Collections.unmodifiableMap(this.flattened);
    }

    public void add(ModelNodeInternal node) {
        if (this.notifying) {
            this.pendingNodes.put(node, PendingState.ADD);
            return;
        }
        this.doAdd(node);
        this.flush();
    }

    public void nodeDiscovered(ModelNodeInternal node) {
        if (this.notifying) {
            if (!this.pendingNodes.containsKey(node)) {
                this.pendingNodes.put(node, PendingState.NOTIFY);
            }
            return;
        }
        this.doNotify(node);
        this.flush();
    }

    private void doAdd(ModelNodeInternal node) {
        this.flattened.put(node.getPath(), node);
        if (node.isAtLeast(ModelNode.State.Discovered)) {
            this.doNotify(node);
        }
    }

    private void doNotify(ModelNodeInternal node) {
        this.notifying = true;
        try {
            this.notifyListeners(node, this.pathListeners.get((Object)node.getPath()));
            this.notifyListeners(node, this.parentListeners.get((Object)node.getPath().getParent()));
            this.notifyListeners(node, this.listeners);
            if (!this.ancestorListeners.isEmpty()) {
                for (ModelPath path = node.getPath().getParent(); path != null; path = path.getParent()) {
                    this.notifyListeners(node, this.ancestorListeners.get((Object)path));
                }
            }
        }
        finally {
            this.notifying = false;
        }
    }

    private void notifyListeners(ModelNodeInternal node, Iterable<ModelListener> listeners) {
        for (ModelListener listener2 : listeners) {
            this.maybeNotify(node, listener2);
        }
    }

    public void addListener(ModelListener listener2) {
        if (this.notifying) {
            this.pendingListeners.add(listener2);
            return;
        }
        this.doAddListener(listener2);
        this.flush();
    }

    private void doAddListener(ModelListener listener2) {
        this.notifying = true;
        try {
            if (listener2.getPath() != null) {
                this.addPathListener(listener2);
                return;
            }
            if (listener2.getParent() != null) {
                this.addParentListener(listener2);
                return;
            }
            if (listener2.getAncestor() != null) {
                this.addAncestorListener(listener2);
                return;
            }
            this.addEverythingListener(listener2);
        }
        finally {
            this.notifying = false;
        }
    }

    private void addEverythingListener(ModelListener listener2) {
        for (ModelNodeInternal node : this.flattened.values()) {
            this.maybeNotify(node, listener2);
        }
        this.listeners.add(listener2);
    }

    private void addAncestorListener(ModelListener listener2) {
        if (ModelPath.ROOT.equals(listener2.getAncestor())) {
            this.addEverythingListener(listener2);
            return;
        }
        ModelNodeInternal ancestor = this.flattened.get(listener2.getAncestor());
        if (ancestor != null) {
            ArrayDeque<ModelNodeInternal> queue = new ArrayDeque<ModelNodeInternal>();
            queue.add(ancestor);
            while (!queue.isEmpty()) {
                ModelNodeInternal parent = (ModelNodeInternal)queue.removeFirst();
                for (ModelNodeInternal modelNodeInternal : parent.getLinks()) {
                    this.maybeNotify(modelNodeInternal, listener2);
                    queue.addFirst(modelNodeInternal);
                }
            }
        }
        this.ancestorListeners.put((Object)listener2.getAncestor(), (Object)listener2);
    }

    private void addParentListener(ModelListener listener2) {
        ModelNodeInternal parent = this.flattened.get(listener2.getParent());
        if (parent != null) {
            for (ModelNodeInternal modelNodeInternal : parent.getLinks()) {
                this.maybeNotify(modelNodeInternal, listener2);
            }
        }
        this.parentListeners.put((Object)listener2.getParent(), (Object)listener2);
    }

    private void addPathListener(ModelListener listener2) {
        ModelNodeInternal node = this.flattened.get(listener2.getPath());
        if (node != null) {
            this.maybeNotify(node, listener2);
        }
        this.pathListeners.put((Object)listener2.getPath(), (Object)listener2);
    }

    private void flush() {
        while (!this.pendingListeners.isEmpty()) {
            this.doAddListener(this.pendingListeners.removeFirst());
        }
        while (!this.pendingNodes.isEmpty()) {
            Iterator<Map.Entry<ModelNodeInternal, PendingState>> iPendingNodes = this.pendingNodes.entrySet().iterator();
            Map.Entry<ModelNodeInternal, PendingState> entry = iPendingNodes.next();
            iPendingNodes.remove();
            ModelNodeInternal pendingNode = entry.getKey();
            switch (entry.getValue()) {
                case ADD: {
                    this.doAdd(pendingNode);
                    break;
                }
                case NOTIFY: {
                    this.doNotify(pendingNode);
                }
            }
        }
    }

    private void maybeNotify(ModelNodeInternal node, ModelListener listener2) {
        if (!node.isAtLeast(ModelNode.State.Discovered)) {
            return;
        }
        listener2.onDiscovered(node);
    }

    @Nullable
    public ModelNodeInternal find(ModelPath path) {
        return this.flattened.get(path);
    }

    public ModelNodeInternal get(ModelPath path) {
        ModelNodeInternal found = this.find(path);
        if (found == null) {
            throw new IllegalStateException("Expected model node @ '" + path + "' but none was found");
        }
        return found;
    }

    @Nullable
    public ModelNodeInternal remove(ModelNode node) {
        ModelNodeInternal parentNode = this.find(node.getPath().getParent());
        if (parentNode != null) {
            parentNode.removeLink(node.getPath().getName());
        }
        return this.flattened.remove(node.getPath());
    }

    private static enum PendingState {
        ADD,
        NOTIFY;

    }
}

