/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.model.internal.manage.schema.extract.ModelPropertyExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspect;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionResult;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaAspectExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;

public class ModelSchemaAspectExtractor {
    private final List<ModelSchemaAspectExtractionStrategy> strategies;

    public ModelSchemaAspectExtractor() {
        this(Collections.emptyList());
    }

    public ModelSchemaAspectExtractor(Collection<ModelSchemaAspectExtractionStrategy> strategies) {
        this.strategies = ImmutableList.copyOf(strategies);
    }

    public <T> List<ModelSchemaAspect> extract(ModelSchemaExtractionContext<T> extractionContext, List<ModelPropertyExtractionResult<?>> propertyResults) {
        ArrayList aspects = Lists.newArrayList();
        for (ModelSchemaAspectExtractionStrategy strategy : this.strategies) {
            ModelSchemaAspectExtractionResult result2 = strategy.extract(extractionContext, propertyResults);
            if (result2 == null) continue;
            aspects.add(result2.getAspect());
        }
        return aspects;
    }
}

