/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public class LocationListInstallationSupplier
implements InstallationSupplier {
    private static final String PROPERTY_NAME = "org.gradle.java.installations.paths";
    private final ProviderFactory factory;

    @Inject
    public LocationListInstallationSupplier(ProviderFactory factory) {
        this.factory = factory;
    }

    @Override
    public Set<InstallationLocation> get() {
        Provider<String> property = this.factory.gradleProperty(PROPERTY_NAME);
        return property.map(paths -> this.asInstallations((String)paths)).orElse(Collections.emptySet()).get();
    }

    private Set<InstallationLocation> asInstallations(String listOfDirectories) {
        return Arrays.stream(listOfDirectories.split(",")).filter(path -> !path.trim().isEmpty()).map(path -> new InstallationLocation(new File((String)path), "system property 'org.gradle.java.installations.paths'")).collect(Collectors.toSet());
    }
}

