/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Collection;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;

public class CompositeFileSystemSnapshot
implements FileSystemSnapshot {
    private final ImmutableList<FileSystemSnapshot> snapshots;

    private CompositeFileSystemSnapshot(Collection<? extends FileSystemSnapshot> snapshots) {
        this.snapshots = ImmutableList.copyOf(snapshots);
    }

    public static FileSystemSnapshot of(List<? extends FileSystemSnapshot> snapshots) {
        switch (snapshots.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return snapshots.get(0);
            }
        }
        return new CompositeFileSystemSnapshot(snapshots);
    }

    @Override
    public SnapshotVisitResult accept(FileSystemSnapshotHierarchyVisitor visitor) {
        for (FileSystemSnapshot snapshot : this.snapshots) {
            SnapshotVisitResult result2 = snapshot.accept(visitor);
            if (result2 != SnapshotVisitResult.TERMINATE) continue;
            return SnapshotVisitResult.TERMINATE;
        }
        return SnapshotVisitResult.CONTINUE;
    }

    @Override
    public SnapshotVisitResult accept(RelativePathTracker pathTracker, RelativePathTrackingFileSystemSnapshotHierarchyVisitor visitor) {
        for (FileSystemSnapshot snapshot : this.snapshots) {
            SnapshotVisitResult result2 = snapshot.accept(pathTracker, visitor);
            if (result2 != SnapshotVisitResult.TERMINATE) continue;
            return SnapshotVisitResult.TERMINATE;
        }
        return SnapshotVisitResult.CONTINUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeFileSystemSnapshot that = (CompositeFileSystemSnapshot)o;
        return this.snapshots.equals(that.snapshots);
    }

    public int hashCode() {
        return this.snapshots.hashCode();
    }

    public String toString() {
        return this.snapshots.toString();
    }
}

