/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.gradle.internal.IoActions;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectMetadata;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3Object;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3ObjectInputStream;
import org.gradle.internal.impldep.com.google.common.io.ByteStreams;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.aws.s3.S3Client;
import org.gradle.internal.resource.transport.aws.s3.S3Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ResourceConnector
extends AbstractExternalResourceAccessor
implements ExternalResourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3ResourceConnector.class);
    private final S3Client s3Client;

    public S3ResourceConnector(S3Client s3Client) {
        this.s3Client = s3Client;
    }

    @Override
    public List<String> list(ExternalResourceName parent) {
        LOGGER.debug("Listing parent resources: {}", (Object)parent);
        return this.s3Client.listDirectChildren(parent.getUri());
    }

    @Override
    public ExternalResourceReadResponse openResource(ExternalResourceName location, boolean revalidate) {
        LOGGER.debug("Attempting to get resource: {}", (Object)location);
        S3Object s3Object = this.s3Client.getResource(location.getUri());
        if (s3Object == null) {
            return null;
        }
        return new S3Resource(s3Object, location.getUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) {
        LOGGER.debug("Attempting to get resource metadata: {}", (Object)location);
        S3Object s3Object = this.s3Client.getMetaData(location.getUri());
        if (s3Object == null) {
            return null;
        }
        try {
            ObjectMetadata objectMetadata = s3Object.getObjectMetadata();
            DefaultExternalResourceMetaData defaultExternalResourceMetaData = new DefaultExternalResourceMetaData(location.getUri(), objectMetadata.getLastModified().getTime(), objectMetadata.getContentLength(), objectMetadata.getContentType(), objectMetadata.getETag(), null);
            return defaultExternalResourceMetaData;
        }
        finally {
            S3ResourceConnector.discardEmptyContentAndClose(s3Object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void discardEmptyContentAndClose(S3Object s3Object) {
        try {
            S3ObjectInputStream objectContent = s3Object.getObjectContent();
            if (objectContent == null) {
                return;
            }
            long downloadedContentLength = ByteStreams.exhaust((InputStream)objectContent);
            if (downloadedContentLength > 1L) {
                LOGGER.debug("Downloaded {} bytes of the object content for metadata request which is too much.", (Object)downloadedContentLength);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Exception while consuming empty object content from metadata request", (Throwable)e);
        }
        finally {
            IoActions.closeQuietly((Closeable)s3Object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(ReadableContent resource, ExternalResourceName destination) throws IOException {
        LOGGER.debug("Attempting to upload stream to : {}", (Object)destination);
        try (InputStream inputStream = resource.open();){
            this.s3Client.put(inputStream, resource.getContentLength(), destination.getUri());
        }
    }
}

