/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import java.time.Duration;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.scopes.GlobalScopedCache;
import org.gradle.internal.resolve.caching.CrossBuildCachingRuleExecutor;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class ComponentMetadataSupplierRuleExecutor
extends CrossBuildCachingRuleExecutor<ModuleVersionIdentifier, ComponentMetadataSupplierDetails, ComponentMetadata> {
    private static final Transformer<String, ModuleVersionIdentifier> KEY_TO_SNAPSHOTTABLE = Object::toString;

    public ComponentMetadataSupplierRuleExecutor(GlobalScopedCache globalScopedCache, InMemoryCacheDecoratorFactory cacheDecoratorFactory, ValueSnapshotter snapshotter, BuildCommencedTimeProvider timeProvider, Serializer<ComponentMetadata> componentMetadataSerializer) {
        super("md-supplier", globalScopedCache, cacheDecoratorFactory, snapshotter, timeProvider, ComponentMetadataSupplierRuleExecutor.createValidator(timeProvider), KEY_TO_SNAPSHOTTABLE, componentMetadataSerializer);
    }

    public static CrossBuildCachingRuleExecutor.EntryValidator<ComponentMetadata> createValidator(BuildCommencedTimeProvider timeProvider) {
        return (policy, entry) -> {
            Duration age = Duration.ofMillis(timeProvider.getCurrentTime() - entry.getTimestamp());
            ComponentMetadata result2 = (ComponentMetadata)entry.getResult();
            return !policy.moduleExpiry(new SimpleResolvedModuleVersion(result2), age, result2.isChanging()).isMustCheck();
        };
    }

    private static class SimpleResolvedModuleVersion
    implements ResolvedModuleVersion {
        private final ComponentMetadata result;

        public SimpleResolvedModuleVersion(ComponentMetadata result2) {
            this.result = result2;
        }

        @Override
        public ModuleVersionIdentifier getId() {
            return this.result.getId();
        }
    }
}

