/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;
import org.gradle.internal.operations.trace.StrictMap;

public final class BuildOperationRecord {
    public static final Ordering<BuildOperationRecord> ORDERING = Ordering.natural().onResultOf(input -> Long.valueOf(input.startTime)).compound((Comparator)Ordering.natural().onResultOf(input -> input.id));
    public final Long id;
    public final Long parentId;
    public final String displayName;
    public final long startTime;
    public final long endTime;
    public final Map<String, ?> details;
    private final String detailsClassName;
    public final Map<String, ?> result;
    private final String resultClassName;
    public final String failure;
    public final List<Progress> progress;
    public final List<BuildOperationRecord> children;

    BuildOperationRecord(Long id, Long parentId, String displayName, long startTime, long endTime, Map<String, ?> details, String detailsClassName, Map<String, ?> result2, String resultClassName, String failure, List<Progress> progress, List<BuildOperationRecord> children) {
        this.id = id;
        this.parentId = parentId;
        this.displayName = displayName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.details = details == null ? null : new StrictMap(details);
        this.detailsClassName = detailsClassName;
        this.result = result2 == null ? null : new StrictMap(result2);
        this.resultClassName = resultClassName;
        this.failure = failure;
        this.progress = progress;
        this.children = children;
    }

    Map<String, ?> toSerializable() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("displayName", this.displayName);
        map.put("id", this.id);
        if (this.parentId != null) {
            map.put("parentId", this.parentId);
        }
        map.put("startTime", this.startTime);
        map.put("endTime", this.endTime);
        map.put("duration", this.endTime - this.startTime);
        if (this.details != null) {
            map.put("details", this.details);
            map.put("detailsClassName", this.detailsClassName);
        }
        if (this.result != null) {
            map.put("result", this.result);
            map.put("resultClassName", this.resultClassName);
        }
        if (this.failure != null) {
            map.put("failure", this.failure);
        }
        if (!this.progress.isEmpty()) {
            map.put("progress", Lists.transform(this.progress, Progress::toSerializable));
        }
        if (!this.children.isEmpty()) {
            map.put("children", Lists.transform(this.children, BuildOperationRecord::toSerializable));
        }
        return map;
    }

    public boolean hasDetailsOfType(Class<?> clazz) throws ClassNotFoundException {
        Class<?> detailsType = this.getDetailsType();
        return detailsType != null && clazz.isAssignableFrom(detailsType);
    }

    public Class<?> getDetailsType() throws ClassNotFoundException {
        return this.detailsClassName == null ? null : this.getClass().getClassLoader().loadClass(this.detailsClassName);
    }

    public Class<?> getResultType() throws ClassNotFoundException {
        return this.resultClassName == null ? null : this.getClass().getClassLoader().loadClass(this.resultClassName);
    }

    public String toString() {
        return "BuildOperationRecord{" + this.id + "->" + this.displayName + '}';
    }

    public static class Progress {
        public final long time;
        public final Map<String, ?> details;
        public final String detailsClassName;

        public Progress(long time, Map<String, ?> details, String detailsClassName) {
            this.time = time;
            this.details = details == null ? null : new StrictMap(details);
            this.detailsClassName = detailsClassName;
        }

        Map<String, ?> toSerializable() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("time", this.time);
            if (this.details != null) {
                map.put("details", this.details);
                map.put("detailsClassName", this.detailsClassName);
            }
            return map;
        }

        public Class<?> getDetailsType() throws ClassNotFoundException {
            return this.detailsClassName == null ? null : this.getClass().getClassLoader().loadClass(this.detailsClassName);
        }

        public boolean hasDetailsOfType(Class<?> clazz) throws ClassNotFoundException {
            Class<?> detailsType = this.getDetailsType();
            return detailsType != null && clazz.isAssignableFrom(detailsType);
        }

        public String toString() {
            return "Progress{details=" + this.details + ", detailsClassName='" + this.detailsClassName + '\'' + '}';
        }
    }
}

