/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import java.util.function.Supplier;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.LockMode;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public class DefaultDependencyLockingHandler
implements DependencyLockingHandler {
    private static final Action<Configuration> ACTIVATE_LOCKING = configuration2 -> configuration2.getResolutionStrategy().activateDependencyLocking();
    private static final Action<Configuration> DEACTIVATE_LOCKING = configuration2 -> configuration2.getResolutionStrategy().deactivateDependencyLocking();
    private final Supplier<ConfigurationContainer> configurationContainer;
    private final DependencyLockingProvider dependencyLockingProvider;

    public DefaultDependencyLockingHandler(Supplier<ConfigurationContainer> configurationContainer, DependencyLockingProvider dependencyLockingProvider) {
        this.configurationContainer = configurationContainer;
        this.dependencyLockingProvider = dependencyLockingProvider;
    }

    @Override
    public void lockAllConfigurations() {
        this.configurationContainer.get().all(ACTIVATE_LOCKING);
    }

    @Override
    public void unlockAllConfigurations() {
        this.configurationContainer.get().all(DEACTIVATE_LOCKING);
    }

    @Override
    public Property<LockMode> getLockMode() {
        return this.dependencyLockingProvider.getLockMode();
    }

    @Override
    public RegularFileProperty getLockFile() {
        return this.dependencyLockingProvider.getLockFile();
    }

    @Override
    public ListProperty<String> getIgnoredDependencies() {
        return this.dependencyLockingProvider.getIgnoredDependencies();
    }
}

