/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.collect.ForwardingSet;

class AccessTrackingSet<E>
extends ForwardingSet<E> {
    private final Set<? extends E> delegate;
    private final Consumer<Object> onAccess;
    private final Runnable onAggregatingAccess;

    public AccessTrackingSet(Set<? extends E> delegate, Consumer<Object> onAccess2, Runnable onAggregatingAccess) {
        this.delegate = delegate;
        this.onAccess = onAccess2;
        this.onAggregatingAccess = onAggregatingAccess;
    }

    public boolean contains(@Nullable Object o) {
        boolean result2 = this.delegate.contains(o);
        this.onAccess.accept(o);
        return result2;
    }

    public boolean containsAll(@Nonnull Collection<?> collection) {
        boolean result2 = this.delegate.containsAll(collection);
        for (Object o : collection) {
            this.onAccess.accept(o);
        }
        return result2;
    }

    public boolean remove(Object o) {
        this.onAccess.accept(o);
        return this.delegate.remove(o);
    }

    public boolean removeAll(Collection<?> collection) {
        for (Object o : collection) {
            this.onAccess.accept(o);
        }
        return this.delegate.removeAll(collection);
    }

    public Iterator<E> iterator() {
        this.reportAggregatingAccess();
        return this.delegate().iterator();
    }

    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    public boolean equals(@Nullable Object object) {
        this.reportAggregatingAccess();
        return super.equals(object);
    }

    public int hashCode() {
        this.reportAggregatingAccess();
        return super.hashCode();
    }

    public Object[] toArray() {
        this.reportAggregatingAccess();
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] array) {
        this.reportAggregatingAccess();
        return this.delegate.toArray(array);
    }

    protected Set<E> delegate() {
        return this.delegate;
    }

    private void reportAggregatingAccess() {
        this.onAggregatingAccess.run();
    }
}

