/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.internal.classpath.AccessTrackingSet;
import org.gradle.internal.classpath.AccessTrackingUtils;

class AccessTrackingProperties
extends Properties {
    private final Properties delegate;
    private final BiConsumer<? super String, ? super String> onAccess;

    public AccessTrackingProperties(Properties delegate, BiConsumer<? super String, ? super String> onAccess2) {
        this.delegate = delegate;
        this.onAccess = onAccess2;
    }

    @Override
    public Enumeration<?> propertyNames() {
        this.reportAggregatingAccess();
        return this.delegate.propertyNames();
    }

    @Override
    public Set<String> stringPropertyNames() {
        return new AccessTrackingSet<String>(this.delegate.stringPropertyNames(), this::getAndReport, this::reportAggregatingAccess);
    }

    @Override
    public int size() {
        this.reportAggregatingAccess();
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.reportAggregatingAccess();
        return this.delegate.isEmpty();
    }

    @Override
    public Enumeration<Object> keys() {
        this.reportAggregatingAccess();
        return this.delegate.keys();
    }

    @Override
    public Enumeration<Object> elements() {
        this.reportAggregatingAccess();
        return this.delegate.elements();
    }

    @Override
    public Set<Object> keySet() {
        return new AccessTrackingSet<Object>(this.delegate.keySet(), this::getAndReport, this::reportAggregatingAccess);
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return new AccessTrackingSet<Map.Entry<Object, Object>>(this.delegate.entrySet(), this::onAccessEntrySetElement, this::reportAggregatingAccess);
    }

    private void onAccessEntrySetElement(@Nullable Object potentialEntry) {
        Map.Entry<String, String> entry = AccessTrackingUtils.tryConvertingToTrackableEntry(potentialEntry);
        if (entry != null) {
            this.getAndReport(entry.getKey());
        }
    }

    @Override
    public void forEach(BiConsumer<? super Object, ? super Object> action) {
        this.reportAggregatingAccess();
        this.delegate.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super Object, ? super Object, ?> function) {
        this.reportAggregatingAccess();
        this.delegate.replaceAll(function);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.delegate.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.delegate.remove(key, value);
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        return this.delegate.replace(key, oldValue, newValue);
    }

    @Override
    public Object replace(Object key, Object value) {
        return this.delegate.replace(key, value);
    }

    @Override
    public Object computeIfAbsent(Object key, Function<? super Object, ?> mappingFunction) {
        return this.delegate.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Object computeIfPresent(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.delegate.computeIfPresent(key, remappingFunction);
    }

    @Override
    public Object compute(Object key, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.delegate.compute(key, remappingFunction);
    }

    @Override
    public Object merge(Object key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return this.delegate.merge(key, value, remappingFunction);
    }

    @Override
    public boolean contains(Object value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getAndReport(key) != null;
    }

    @Override
    public Object put(Object key, Object value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Object setProperty(String key, String value) {
        return this.delegate.setProperty(key, value);
    }

    @Override
    public Object remove(Object key) {
        Object result2 = this.delegate.remove(key);
        this.reportKeyAndValue(key, result2);
        return result2;
    }

    @Override
    public void putAll(Map<?, ?> t) {
        this.delegate.putAll(t);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        Object oValue = this.getAndReport(key);
        String value = oValue instanceof String ? (String)oValue : null;
        return value != null ? value : defaultValue;
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        Object value = this.getAndReport(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public Object get(Object key) {
        return this.getAndReport(key);
    }

    @Override
    public void load(Reader reader2) throws IOException {
        this.delegate.load(reader2);
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        this.delegate.load(inStream);
    }

    @Override
    @Deprecated
    public void save(OutputStream out, String comments) {
        this.reportAggregatingAccess();
        this.delegate.save(out, comments);
    }

    @Override
    public void store(Writer writer2, String comments) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.store(writer2, comments);
    }

    @Override
    public void store(OutputStream out, @Nullable String comments) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.store(out, comments);
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException {
        this.delegate.loadFromXML(in);
    }

    @Override
    public void storeToXML(OutputStream os, String comment) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.storeToXML(os, comment);
    }

    @Override
    public void storeToXML(OutputStream os, String comment, String encoding) throws IOException {
        this.reportAggregatingAccess();
        this.delegate.storeToXML(os, comment, encoding);
    }

    @Override
    public void list(PrintStream out) {
        this.reportAggregatingAccess();
        this.delegate.list(out);
    }

    @Override
    public void list(PrintWriter out) {
        this.reportAggregatingAccess();
        this.delegate.list(out);
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        this.reportAggregatingAccess();
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        this.reportAggregatingAccess();
        return this.delegate.hashCode();
    }

    private Object getAndReport(Object key) {
        Object value = this.delegate.get(key);
        this.reportKeyAndValue(key, value);
        return value;
    }

    private void reportKeyAndValue(Object key, Object value) {
        if (key instanceof String && (value == null || value instanceof String)) {
            this.onAccess.accept((String)key, (String)value);
        }
    }

    private void reportAggregatingAccess() {
        this.delegate.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)this::reportKeyAndValue));
    }
}

