/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.Supplier;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.specs.Spec;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.ValuedVfsHierarchy;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.collect.PersistentList;
import org.gradle.internal.file.Stat;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.EmptyChildMap;
import org.gradle.internal.snapshot.VfsRelativePath;

public class ExecutionNodeAccessHierarchy {
    private volatile ValuedVfsHierarchy<NodeAccess> root;
    private final Stat stat;

    public ExecutionNodeAccessHierarchy(CaseSensitivity caseSensitivity, Stat stat) {
        this.root = new ValuedVfsHierarchy(PersistentList.of(), EmptyChildMap.getInstance(), caseSensitivity);
        this.stat = stat;
    }

    public ImmutableSet<Node> getNodesAccessing(String location) {
        return this.visitValues(location, new AbstractNodeAccessVisitor(){

            @Override
            public void visitChildren(PersistentList<NodeAccess> values, Supplier<String> relativePathSupplier) {
                values.forEach(this::addNode);
            }
        });
    }

    public ImmutableSet<Node> getNodesAccessing(final String location, final Spec<FileTreeElement> filter) {
        return this.visitValues(location, new AbstractNodeAccessVisitor(){

            @Override
            public void visitChildren(PersistentList<NodeAccess> values, Supplier<String> relativePathSupplier) {
                String relativePathFromLocation = relativePathSupplier.get();
                if (ExecutionNodeAccessHierarchy.this.relativePathMatchesSpec(filter, new File(location, relativePathFromLocation), relativePathFromLocation)) {
                    values.forEach(this::addNode);
                }
            }
        });
    }

    private boolean relativePathMatchesSpec(Spec<FileTreeElement> filter, File element, String relativePathString) {
        boolean elementIsFile = !element.isDirectory();
        RelativePath relativePath = RelativePath.parse(elementIsFile, relativePathString);
        if (!filter.isSatisfiedBy(new ReadOnlyFileTreeElement(element, relativePath, this.stat))) {
            return false;
        }
        RelativePath parentRelativePath = relativePath.getParent();
        File parentFile = element.getParentFile();
        while (parentRelativePath != null && parentRelativePath != RelativePath.EMPTY_ROOT) {
            if (!filter.isSatisfiedBy(new ReadOnlyFileTreeElement(parentFile, parentRelativePath, this.stat))) {
                return false;
            }
            parentRelativePath = parentRelativePath.getParent();
            parentFile = parentFile.getParentFile();
        }
        return true;
    }

    public synchronized void recordNodeAccessingLocations(Node node, Iterable<String> accessedLocations) {
        for (String location : accessedLocations) {
            VfsRelativePath relativePath = VfsRelativePath.of(location);
            this.root = this.root.recordValue(relativePath, new DefaultNodeAccess(node));
        }
    }

    public synchronized void recordNodeAccessingFileTree(Node node, String fileTreeRoot, Spec<FileTreeElement> filter) {
        VfsRelativePath relativePath = VfsRelativePath.of(fileTreeRoot);
        this.root = this.root.recordValue(relativePath, new FilteredNodeAccess(node, filter));
    }

    public synchronized void clear() {
        this.root = this.root.empty();
    }

    private ImmutableSet<Node> visitValues(String location, AbstractNodeAccessVisitor visitor) {
        VfsRelativePath relativePath = VfsRelativePath.of(location);
        if (relativePath.length() == 0) {
            this.root.visitAllValues(visitor);
        } else {
            this.root.visitValuesRelatedTo(relativePath, visitor);
        }
        return visitor.getResult();
    }

    private static class ReadOnlyFileTreeElement
    implements FileTreeElement {
        private final File file;
        private final RelativePath relativePath;
        private final Stat stat;

        public ReadOnlyFileTreeElement(File file, RelativePath relativePath, Stat stat) {
            this.file = file;
            this.relativePath = relativePath;
            this.stat = stat;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public boolean isDirectory() {
            return !this.relativePath.isFile();
        }

        @Override
        public long getLastModified() {
            return this.file.lastModified();
        }

        @Override
        public long getSize() {
            return this.file.length();
        }

        @Override
        public InputStream open() {
            try {
                return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getPath() {
            return this.relativePath.getPathString();
        }

        @Override
        public RelativePath getRelativePath() {
            return this.relativePath;
        }

        @Override
        public int getMode() {
            return this.stat.getUnixMode(this.file);
        }
    }

    private class FilteredNodeAccess
    implements NodeAccess {
        private final Node node;
        private final Spec<FileTreeElement> spec;

        public FilteredNodeAccess(Node node, Spec<FileTreeElement> spec) {
            this.node = node;
            this.spec = spec;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return ExecutionNodeAccessHierarchy.this.relativePathMatchesSpec(this.spec, new File(childPath.getAbsolutePath()), childPath.getAsString());
        }
    }

    private static class DefaultNodeAccess
    implements NodeAccess {
        private final Node node;

        public DefaultNodeAccess(Node node) {
            this.node = node;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public boolean accessesChild(VfsRelativePath childPath) {
            return true;
        }
    }

    private static interface NodeAccess {
        public Node getNode();

        public boolean accessesChild(VfsRelativePath var1);
    }

    private static abstract class AbstractNodeAccessVisitor
    implements ValuedVfsHierarchy.ValueVisitor<NodeAccess> {
        private final ImmutableSet.Builder<Node> builder = ImmutableSet.builder();

        private AbstractNodeAccessVisitor() {
        }

        public void addNode(NodeAccess value) {
            this.builder.add((Object)value.getNode());
        }

        @Override
        public void visitExact(NodeAccess value) {
            this.addNode(value);
        }

        @Override
        public void visitAncestor(NodeAccess value, VfsRelativePath pathToVisitedLocation) {
            if (value.accessesChild(pathToVisitedLocation)) {
                this.addNode(value);
            }
        }

        public ImmutableSet<Node> getResult() {
            return this.builder.build();
        }
    }
}

