/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.streams;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.gradle.cache.internal.streams.BlockAddress;
import org.gradle.cache.internal.streams.ValueStore;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class DefaultValueStore<T>
implements ValueStore<T>,
Closeable {
    private final File dir;
    private final String baseName;
    private final ValueStore.Writer<T> writer;
    private final ValueStore.Reader<T> reader;
    private final AtomicInteger counter = new AtomicInteger();
    private final List<Sink<T>> sinks = new CopyOnWriteArrayList<Sink<T>>();
    private final BlockingQueue<Sink<T>> availableSinks = new LinkedBlockingDeque<Sink<T>>();
    private final ConcurrentMap<Integer, Source<T>> availableSources = new ConcurrentHashMap<Integer, Source<T>>();

    public DefaultValueStore(File dir, String baseName, ValueStore.Writer<T> writer2, ValueStore.Reader<T> reader2) {
        this.dir = dir;
        this.baseName = baseName;
        this.writer = writer2;
        this.reader = reader2;
        try {
            Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static <T> DefaultValueStore<T> encoding(File dir, String baseName, Serializer<T> serializer) {
        return new DefaultValueStore<Object>(dir, baseName, serializer::write, serializer::read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockAddress write(T value) {
        Sink<T> sink = this.allocateSink();
        try {
            BlockAddress blockAddress = sink.write(value);
            return blockAddress;
        }
        finally {
            this.releaseSink(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T read(BlockAddress blockAddress) {
        try {
            Source<T> source = (Source<T>)this.availableSources.remove(blockAddress.fileId);
            if (source == null) {
                source = new Source<T>(this.file(blockAddress.fileId), this.reader);
            }
            try {
                Object t = source.read(blockAddress);
                return t;
            }
            finally {
                if (this.availableSources.putIfAbsent(blockAddress.fileId, source) != null) {
                    source.close();
                }
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            CompositeStoppable.stoppable(new Object[0]).add(this.sinks).add(this.availableSources.values()).stop();
        }
        finally {
            this.sinks.clear();
            this.availableSinks.clear();
            this.availableSources.clear();
        }
    }

    private Sink<T> allocateSink() {
        Sink<T> sink = (Sink<T>)this.availableSinks.poll();
        if (sink != null) {
            return sink;
        }
        int id = this.counter.incrementAndGet();
        File file = this.file(id);
        sink = new Sink<T>(id, this.writer, file);
        this.sinks.add(sink);
        return sink;
    }

    void releaseSink(Sink<T> sink) {
        if (!this.availableSinks.offer(sink)) {
            try {
                sink.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private File file(int id) {
        return new File(this.dir, this.baseName + "-" + id + ".bin");
    }

    private static class Sink<T>
    implements Closeable {
        final int id;
        final ValueStore.Writer<T> writer;
        final long startOffset;
        final OutputStream outputStream;
        final KryoBackedEncoder encoder;

        public Sink(int id, ValueStore.Writer<T> writer2, File file) {
            this.id = id;
            this.writer = writer2;
            this.startOffset = file.length();
            try {
                this.outputStream = new FileOutputStream(file, true);
            }
            catch (FileNotFoundException e) {
                throw new UncheckedIOException(e);
            }
            this.encoder = new KryoBackedEncoder(this.outputStream);
        }

        BlockAddress write(T value) {
            long startPos = this.encoder.getWritePosition();
            try {
                this.writer.write(this.encoder, value);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
            this.encoder.flush();
            long length = this.encoder.getWritePosition() - startPos;
            return new BlockAddress(this.id, startPos + this.startOffset, length);
        }

        @Override
        public void close() throws IOException {
            this.encoder.flush();
            this.outputStream.close();
        }
    }

    private static class Source<T>
    implements Closeable {
        private final RandomAccessFile file;
        private final ValueStore.Reader<T> reader;
        private final KryoBackedDecoder decoder;

        public Source(File file, ValueStore.Reader<T> reader2) throws FileNotFoundException {
            this.file = new RandomAccessFile(file, "r");
            this.reader = reader2;
            this.decoder = new KryoBackedDecoder(new BlockInputStream(this.file, 0L));
        }

        public T read(BlockAddress blockAddress) throws Exception {
            this.file.seek(blockAddress.pos);
            this.decoder.restart(new BlockInputStream(this.file, blockAddress.length));
            return this.reader.read(this.decoder);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }

    private static class BlockInputStream
    extends InputStream {
        private final RandomAccessFile file;
        private long remaining;

        public BlockInputStream(RandomAccessFile file, long remaining) {
            this.file = file;
            this.remaining = remaining;
        }

        @Override
        public long skip(long count) throws IOException {
            int toSkip = (int)Math.min(count, this.remaining);
            if (toSkip > 0) {
                this.file.seek(this.file.getFilePointer() + (long)toSkip);
                this.remaining -= (long)toSkip;
            }
            return toSkip;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("Should be using buffering.");
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            if (this.remaining == 0L) {
                return -1;
            }
            int toRead = (int)Math.min((long)length, this.remaining);
            if (toRead == 0) {
                return 0;
            }
            int read2 = this.file.read(buffer, offset, toRead);
            if (read2 < 0) {
                throw new IllegalStateException("Unexpected file length.");
            }
            this.remaining -= (long)read2;
            return read2;
        }
    }
}

