/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;
import org.gradle.buildinit.plugins.internal.modifiers.Language;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.logging.text.TreeFormatter;

public class ProjectLayoutSetupRegistry {
    private final Map<String, BuildInitializer> registeredProjectDescriptors = new TreeMap<String, BuildInitializer>();
    private final BuildInitializer defaultType;
    private final BuildConverter converter;
    private final TemplateOperationFactory templateOperationFactory;

    public ProjectLayoutSetupRegistry(BuildInitializer defaultType, BuildConverter converter, TemplateOperationFactory templateOperationFactory) {
        this.defaultType = defaultType;
        this.converter = converter;
        this.templateOperationFactory = templateOperationFactory;
        this.add(defaultType);
        this.add(converter);
    }

    public void add(BuildInitializer descriptor) {
        if (this.registeredProjectDescriptors.containsKey(descriptor.getId())) {
            throw new GradleException(String.format("ProjectDescriptor with ID '%s' already registered.", descriptor.getId()));
        }
        this.registeredProjectDescriptors.put(descriptor.getId(), descriptor);
    }

    public TemplateOperationFactory getTemplateOperationFactory() {
        return this.templateOperationFactory;
    }

    public List<ComponentType> getComponentTypes() {
        return ImmutableList.copyOf((Object[])ComponentType.values());
    }

    public BuildConverter getBuildConverter() {
        return this.converter;
    }

    public BuildInitializer getDefault() {
        return this.defaultType;
    }

    public BuildInitializer get(String type) {
        if (!this.registeredProjectDescriptors.containsKey(type)) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("The requested build type '" + type + "' is not supported. Supported types");
            formatter.startChildren();
            for (String candidate : this.getAllTypes()) {
                formatter.node("'" + candidate + "'");
            }
            formatter.endChildren();
            throw new GradleException(formatter.toString());
        }
        return this.registeredProjectDescriptors.get(type);
    }

    public List<Language> getLanguagesFor(ComponentType componentType) {
        ArrayList<Language> result2 = new ArrayList<Language>(this.registeredProjectDescriptors.size());
        for (BuildInitializer initializer : this.registeredProjectDescriptors.values()) {
            if (initializer == this.converter || !initializer.getComponentType().equals((Object)componentType)) continue;
            result2.add(initializer.getLanguage());
        }
        return result2;
    }

    public BuildInitializer get(ComponentType componentType, Language language) {
        for (BuildInitializer initializer : this.registeredProjectDescriptors.values()) {
            if (initializer == this.converter || !initializer.getComponentType().equals((Object)componentType) || !initializer.getLanguage().equals(language)) continue;
            return initializer;
        }
        throw new IllegalArgumentException("No initializer with component type " + (Object)((Object)componentType) + " and language " + language);
    }

    public List<String> getAllTypes() {
        ArrayList<String> result2 = new ArrayList<String>(this.registeredProjectDescriptors.size());
        for (BuildInitializer initDescriptor : this.registeredProjectDescriptors.values()) {
            result2.add(initDescriptor.getId());
        }
        return result2;
    }
}

