/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.ResolutionErrorRenderer;
import org.gradle.api.tasks.diagnostics.internal.ConfigurationFinder;
import org.gradle.api.tasks.diagnostics.internal.dsl.DependencyResultSpecNotationConverter;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphsRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.Section;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Produces only non-cacheable console output")
public class DependencyInsightReportTask
extends DefaultTask {
    private Configuration configuration;
    private Spec<DependencyResult> dependencySpec;
    private boolean showSinglePathToDependency;

    @Internal
    public Spec<DependencyResult> getDependencySpec() {
        return this.dependencySpec;
    }

    public void setDependencySpec(Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    @Option(option="dependency", description="Shows the details of given dependency.")
    public void setDependencySpec(Object dependencyInsightNotation) {
        NotationParser<Object, Spec<DependencyResult>> parser = DependencyResultSpecNotationConverter.parser();
        this.dependencySpec = parser.parseNotation(dependencyInsightNotation);
    }

    @Internal
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration2) {
        this.configuration = configuration2;
    }

    @Option(option="configuration", description="Looks for the dependency in given configuration.")
    public void setConfiguration(String configurationName) {
        this.configuration = ConfigurationFinder.find(this.getProject().getConfigurations(), configurationName);
    }

    @Internal
    public boolean isShowSinglePathToDependency() {
        return this.showSinglePathToDependency;
    }

    @Option(option="singlepath", description="Show at most one path to each dependency")
    public void setShowSinglePathToDependency(boolean showSinglePathToDependency) {
        this.showSinglePathToDependency = showSinglePathToDependency;
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionSelectorScheme getVersionSelectorScheme() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionComparator getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionParser getVersionParser() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ImmutableAttributesFactory getAttributesFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        Configuration configuration2 = this.getConfiguration();
        this.assertValidTaskConfiguration(configuration2);
        StyledTextOutput output = this.getTextOutputFactory().create(this.getClass());
        ResolutionErrorRenderer errorHandler = new ResolutionErrorRenderer(this.dependencySpec);
        Set<DependencyResult> selectedDependencies = this.selectDependencies(configuration2, errorHandler);
        if (selectedDependencies.isEmpty()) {
            output.println("No dependencies matching given input were found in " + configuration2);
            return;
        }
        errorHandler.renderErrors(output);
        this.renderSelectedDependencies(configuration2, output, selectedDependencies);
        this.renderBuildScanHint(output);
    }

    private void renderSelectedDependencies(Configuration configuration2, StyledTextOutput output, Set<DependencyResult> selectedDependencies) {
        GraphRenderer renderer = new GraphRenderer(output);
        DependencyInsightReporter reporter = new DependencyInsightReporter(this.getVersionSelectorScheme(), this.getVersionComparator(), this.getVersionParser());
        Collection<RenderableDependency> itemsToRender = reporter.convertToRenderableItems(selectedDependencies, this.isShowSinglePathToDependency());
        RootDependencyRenderer rootRenderer = new RootDependencyRenderer(configuration2, this.getAttributesFactory());
        ReplaceProjectWithConfigurationNameRenderer dependenciesRenderer = new ReplaceProjectWithConfigurationNameRenderer(configuration2);
        DependencyGraphsRenderer dependencyGraphRenderer = new DependencyGraphsRenderer(output, renderer, rootRenderer, dependenciesRenderer);
        dependencyGraphRenderer.setShowSinglePath(this.showSinglePathToDependency);
        dependencyGraphRenderer.render(itemsToRender);
        dependencyGraphRenderer.complete();
    }

    private void renderBuildScanHint(StyledTextOutput output) {
        output.println();
        output.text("A web-based, searchable dependency report is available by adding the ");
        output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "scan");
        output.println(" option.");
    }

    private void assertValidTaskConfiguration(@Nullable Configuration configuration2) {
        if (configuration2 == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the input configuration was not specified. \nIt can be specified from the command line, e.g: '" + this.getPath() + " --configuration someConf --dependency someDep'");
        }
        if (this.dependencySpec == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the dependency to show was not specified.\nIt can be specified from the command line, e.g: '" + this.getPath() + " --dependency someDep'");
        }
    }

    private Set<DependencyResult> selectDependencies(Configuration configuration2, ResolutionErrorRenderer errorHandler) {
        ResolvableDependenciesInternal incoming = (ResolvableDependenciesInternal)configuration2.getIncoming();
        ResolutionResult result2 = incoming.getResolutionResult(errorHandler);
        LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        result2.allDependencies(dependencyResult -> {
            if (this.dependencySpec.isSatisfiedBy((DependencyResult)dependencyResult)) {
                selectedDependencies.add((DependencyResult)dependencyResult);
            }
        });
        return selectedDependencies;
    }

    private static AttributeMatchDetails match(Attribute<?> actualAttribute, Object actualValue, AttributeContainer requestedAttributes) {
        for (Attribute<?> requested : requestedAttributes.keySet()) {
            Object requestedValue = requestedAttributes.getAttribute(requested);
            if (!requested.getName().equals(actualAttribute.getName())) continue;
            if (requested.equals(actualAttribute) ? actualValue.equals(requestedValue) : actualValue.toString().equals(requestedValue.toString())) {
                return new AttributeMatchDetails(MatchType.requested, requested, requestedValue);
            }
            return new AttributeMatchDetails(MatchType.different_value, requested, requestedValue);
        }
        return new AttributeMatchDetails(MatchType.not_requested, null, null);
    }

    private static class ReplaceProjectWithConfigurationNameRenderer
    implements NodeRenderer {
        private final Configuration configuration;

        public ReplaceProjectWithConfigurationNameRenderer(Configuration configuration2) {
            this.configuration = configuration2;
        }

        @Override
        public void renderNode(StyledTextOutput target, RenderableDependency node, boolean alreadyRendered) {
            boolean leaf = node.getChildren().isEmpty();
            target.text(leaf ? this.configuration.getName() : node.getName());
            if (node.getDescription() != null) {
                target.text(" ").withStyle(StyledTextOutput.Style.Description).text(node.getDescription());
            }
            if (alreadyRendered && !leaf) {
                target.withStyle(StyledTextOutput.Style.Info).text(" (*)");
            }
        }
    }

    private static class RootDependencyRenderer
    implements NodeRenderer {
        private final Configuration configuration;
        private final ImmutableAttributesFactory attributesFactory;

        public RootDependencyRenderer(Configuration configuration2, ImmutableAttributesFactory attributesFactory) {
            this.configuration = configuration2;
            this.attributesFactory = attributesFactory;
        }

        @Override
        public void renderNode(StyledTextOutput out, RenderableDependency dependency, boolean alreadyRendered) {
            out.withStyle(StyledTextOutput.Style.Identifier).text(dependency.getName());
            if (StringUtils.isNotEmpty((String)dependency.getDescription())) {
                out.withStyle(StyledTextOutput.Style.Description).text(" (" + dependency.getDescription() + ")");
            }
            switch (dependency.getResolutionState()) {
                case FAILED: {
                    out.withStyle(StyledTextOutput.Style.Failure).text(" FAILED");
                    break;
                }
                case RESOLVED: 
                case RESOLVED_CONSTRAINT: {
                    break;
                }
                case UNRESOLVED: {
                    out.withStyle(StyledTextOutput.Style.Failure).text(" (n)");
                }
            }
            this.printVariantDetails(out, dependency);
            this.printExtraDetails(out, dependency);
        }

        private void printExtraDetails(StyledTextOutput out, RenderableDependency dependency) {
            List<Section> extraDetails = dependency.getExtraDetails();
            if (!extraDetails.isEmpty()) {
                this.printSections(out, extraDetails, 1);
            }
        }

        private void printSections(StyledTextOutput out, List<Section> extraDetails, int depth) {
            for (Section extraDetail : extraDetails) {
                this.printSection(out, extraDetail, depth);
                this.printSections(out, extraDetail.getChildren(), depth + 1);
            }
        }

        private void printSection(StyledTextOutput out, Section extraDetail, int depth) {
            out.println();
            String indent = StringUtils.leftPad((String)"", (int)(3 * depth)) + (depth > 1 ? "- " : "");
            String appendix = extraDetail.getChildren().isEmpty() ? "" : ":";
            String description = StringUtils.trim((String)extraDetail.getDescription());
            String padding = "\n" + StringUtils.leftPad((String)"", (int)indent.length());
            description = description.replaceAll("(?m)(\r?\n)", padding);
            out.withStyle(StyledTextOutput.Style.Description).text(indent + description + appendix);
        }

        private void printVariantDetails(StyledTextOutput out, RenderableDependency dependency) {
            List<ResolvedVariantResult> resolvedVariants = dependency.getResolvedVariants();
            for (ResolvedVariantResult resolvedVariant : resolvedVariants) {
                out.println();
                out.withStyle(StyledTextOutput.Style.Description).text("   variant \"" + resolvedVariant.getDisplayName() + "\"");
                AttributeContainer attributes = resolvedVariant.getAttributes();
                AttributeContainer requested = this.getRequestedAttributes(this.configuration, dependency);
                if (attributes.isEmpty() && requested.isEmpty()) continue;
                this.writeAttributeBlock(out, attributes, requested);
            }
        }

        private AttributeContainer getRequestedAttributes(Configuration configuration2, RenderableDependency dependency) {
            if (dependency instanceof HasAttributes) {
                AttributeContainer dependencyAttributes = ((HasAttributes)((Object)dependency)).getAttributes();
                return this.concat(configuration2.getAttributes(), dependencyAttributes);
            }
            return configuration2.getAttributes();
        }

        private AttributeContainer concat(AttributeContainer configAttributes, AttributeContainer dependencyAttributes) {
            return this.attributesFactory.concat(((AttributeContainerInternal)configAttributes).asImmutable(), ((AttributeContainerInternal)dependencyAttributes).asImmutable());
        }

        private void writeAttributeBlock(StyledTextOutput out, AttributeContainer attributes, AttributeContainer requested) {
            out.withStyle(StyledTextOutput.Style.Description).text(" [");
            out.println();
            int maxAttributeLen = this.computeAttributePadding(attributes, requested);
            LinkedHashSet matchedAttributes = Sets.newLinkedHashSet();
            this.writeFoundAttributes(out, attributes, requested, maxAttributeLen, matchedAttributes);
            Sets.SetView missing = Sets.difference(requested.keySet(), (Set)matchedAttributes);
            if (!missing.isEmpty()) {
                this.writeMissingAttributes(out, requested, maxAttributeLen, missing);
            }
            out.withStyle(StyledTextOutput.Style.Description).text("   ]");
        }

        private void writeMissingAttributes(StyledTextOutput out, AttributeContainer requested, int maxAttributeLen, Sets.SetView<Attribute<?>> missing) {
            if (missing.size() != requested.keySet().size()) {
                out.println();
            }
            out.withStyle(StyledTextOutput.Style.Description).text("      Requested attributes not found in the selected variant:");
            out.println();
            for (Attribute missingAttribute : missing) {
                out.withStyle(StyledTextOutput.Style.Description).text("         " + StringUtils.rightPad((String)missingAttribute.getName(), (int)maxAttributeLen) + " = " + requested.getAttribute(missingAttribute));
                out.println();
            }
        }

        private void writeFoundAttributes(StyledTextOutput out, AttributeContainer attributes, AttributeContainer requested, int maxAttributeLen, Set<Attribute<?>> matchedAttributes) {
            for (Attribute<?> attribute : attributes.keySet()) {
                Object actualValue = attributes.getAttribute(attribute);
                AttributeMatchDetails match = DependencyInsightReportTask.match(attribute, actualValue, requested);
                out.withStyle(StyledTextOutput.Style.Description).text("      " + StringUtils.rightPad((String)attribute.getName(), (int)maxAttributeLen) + " = " + actualValue);
                Attribute requestedAttribute = match.requested;
                if (requestedAttribute != null) {
                    matchedAttributes.add(requestedAttribute);
                }
                switch (match.matchType) {
                    case requested: {
                        break;
                    }
                    case different_value: {
                        out.withStyle(StyledTextOutput.Style.Info).text(" (compatible with: " + match.requestedValue + ")");
                        break;
                    }
                    case not_requested: {
                        out.withStyle(StyledTextOutput.Style.Info).text(" (not requested)");
                    }
                }
                out.println();
            }
        }

        private int computeAttributePadding(AttributeContainer attributes, AttributeContainer requested) {
            int maxAttributeLen = 0;
            for (Attribute<?> attribute : requested.keySet()) {
                maxAttributeLen = Math.max(maxAttributeLen, attribute.getName().length());
            }
            for (Attribute<?> attribute : attributes.keySet()) {
                maxAttributeLen = Math.max(maxAttributeLen, attribute.getName().length());
            }
            return maxAttributeLen;
        }
    }

    private static enum MatchType {
        requested,
        different_value,
        not_requested;

    }

    private static class AttributeMatchDetails {
        private final MatchType matchType;
        @Nullable
        private final Attribute<?> requested;
        @Nullable
        private final Object requestedValue;

        private AttributeMatchDetails(MatchType matchType, @Nullable Attribute<?> requested, @Nullable Object requestedValue) {
            this.matchType = matchType;
            this.requested = requested;
            this.requestedValue = requestedValue;
        }
    }
}

