/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.util.concurrent.Callable;
import org.gradle.api.ExtensiblePolymorphicDomainObjectContainer;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.TestSuiteType;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.tasks.testing.DefaultAggregateTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.testing.AggregateTestReport;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;

@Incubating
public abstract class TestReportAggregationPlugin
implements Plugin<Project> {
    public static final String TEST_REPORT_AGGREGATION_CONFIGURATION_NAME = "testReportAggregation";

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply("org.gradle.reporting-base");
        Configuration testAggregation = (Configuration)project.getConfigurations().create(TEST_REPORT_AGGREGATION_CONFIGURATION_NAME);
        testAggregation.setDescription("A configuration to collect test execution results");
        testAggregation.setVisible(false);
        testAggregation.setCanBeConsumed(false);
        testAggregation.setCanBeResolved(false);
        ReportingExtension reporting = project.getExtensions().getByType(ReportingExtension.class);
        reporting.getReports().registerBinding(AggregateTestReport.class, DefaultAggregateTestReport.class);
        ObjectFactory objects = project.getObjects();
        Property testReportDirectory = objects.directoryProperty().convention(reporting.getBaseDirectory().dir("tests"));
        project.getPlugins().withId("java-base", arg_0 -> TestReportAggregationPlugin.lambda$apply$0(project, (DirectoryProperty)testReportDirectory, arg_0));
        reporting.getReports().withType(AggregateTestReport.class).configureEach(arg_0 -> TestReportAggregationPlugin.lambda$apply$8(project, testAggregation, objects, (DirectoryProperty)testReportDirectory, arg_0));
        project.getPlugins().withId("jvm-test-suite", plugin -> {
            project.getDependencies().add(TEST_REPORT_AGGREGATION_CONFIGURATION_NAME, project);
            TestingExtension testing = project.getExtensions().getByType(TestingExtension.class);
            ExtensiblePolymorphicDomainObjectContainer<TestSuite> testSuites = testing.getSuites();
            testSuites.withType(JvmTestSuite.class).configureEach(testSuite -> reporting.getReports().create(testSuite.getName() + "AggregateTestReport", AggregateTestReport.class, report2 -> report2.getTestType().convention(testSuite.getTestType())));
        });
    }

    private static /* synthetic */ void lambda$apply$8(Project project, Configuration testAggregation, ObjectFactory objects, DirectoryProperty testReportDirectory, AggregateTestReport report2) {
        Configuration testResultsConf = (Configuration)project.getConfigurations().create(report2.getName() + "Results");
        testResultsConf.extendsFrom(testAggregation);
        testResultsConf.setDescription(String.format("Supplies test result data to the %s.  External library dependencies may appear as resolution failures, but this is expected behavior.", report2.getName()));
        testResultsConf.setVisible(false);
        testResultsConf.setCanBeConsumed(false);
        testResultsConf.setCanBeResolved(true);
        testResultsConf.attributes(attributes -> {
            attributes.attribute(Category.CATEGORY_ATTRIBUTE, objects.named(Category.class, "verification"));
            attributes.attributeProvider(TestSuiteType.TEST_SUITE_TYPE_ATTRIBUTE, report2.getTestType().map(tt -> objects.named(TestSuiteType.class, (String)tt)));
            attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, objects.named(VerificationType.class, "test-results"));
        });
        report2.getReportTask().configure(task -> {
            Callable<FileCollection> testResults = () -> testResultsConf.getIncoming().artifactView(view -> {
                view.componentFilter(id -> id instanceof ProjectComponentIdentifier);
                view.lenient(true);
            }).getFiles();
            task.getTestResults().from(testResults);
            task.getDestinationDirectory().convention(testReportDirectory.dir(report2.getTestType().map(tt -> tt + "/aggregated-results")));
        });
    }

    private static /* synthetic */ void lambda$apply$0(Project project, DirectoryProperty testReportDirectory, Plugin plugin) {
        JavaPluginExtension javaPluginExtension = project.getExtensions().getByType(JavaPluginExtension.class);
        testReportDirectory.convention((Provider)javaPluginExtension.getTestReportDir());
    }
}

