/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.DefaultClassLoaderScope;
import org.gradle.api.internal.initialization.ImmutableClassLoaderScope;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;

public abstract class AbstractClassLoaderScope
implements ClassLoaderScope {
    protected final ClassLoaderScopeIdentifier id;
    protected final ClassLoaderCache classLoaderCache;
    protected final ClassLoaderScopeRegistryListener listener;

    protected AbstractClassLoaderScope(ClassLoaderScopeIdentifier id, ClassLoaderCache classLoaderCache, ClassLoaderScopeRegistryListener listener2) {
        this.id = id;
        this.classLoaderCache = classLoaderCache;
        this.listener = listener2;
    }

    @Override
    public ClassLoaderScopeId getId() {
        return this.id;
    }

    public String getPath() {
        return this.id.getPath();
    }

    @Override
    public ClassLoaderScope local(ClassPath classPath) {
        return this.immutable();
    }

    @Override
    public ClassLoaderScope export(ClassPath classPath) {
        return this.immutable();
    }

    @Override
    public ClassLoaderScope export(ClassLoader classLoader) {
        return this.immutable();
    }

    private ClassLoaderScope immutable() {
        throw new UnsupportedOperationException(String.format("Class loader scope %s is immutable", this.id));
    }

    @Override
    public ClassLoaderScope createChild(String name) {
        return new DefaultClassLoaderScope(this.id.child(name), this, this.classLoaderCache, this.listener);
    }

    @Override
    public ClassLoaderScope createLockedChild(String name, ClassPath localClasspath, @Nullable HashCode classpathImplementationHash, Function<ClassLoader, ClassLoader> localClassLoaderFactory) {
        return new ImmutableClassLoaderScope(this.id.child(name), this, localClasspath, classpathImplementationHash, localClassLoaderFactory, this.classLoaderCache, this.listener);
    }
}

